/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.cleanup.HideUtilityClassConstructor;
import org.openrewrite.java.cleanup.HideUtilityClassConstructorStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.style.NamedStyles;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\r\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\u001b\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000eH\u0017R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u001c"}, d2={"Lorg/openrewrite/java/cleanup/HideUtilityClassConstructorTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "addPrivateConstructorWhenOnlyDefaultConstructor", "", "jp", "Lorg/openrewrite/java/JavaParser;", "changePackagePrivateConstructorToPrivate", "changePublicConstructorToPrivate", "changeUtilityClassesWithMixedExposedConstructors", "dontChangeSuppressedUtilityClasses", "Lorg/openrewrite/java/JavaParser$Builder;", "identifyNonUtilityClassesMixedFields", "identifyNonUtilityClassesMixedMethods", "identifyNonUtilityClassesOnlyPublicConstructor", "identifyNonUtilityClassesTotallyEmpty", "identifyNonUtilityClassesWhenExtendsClass", "identifyNonUtilityClassesWhenImplementsInterface", "identifyUtilityClassesInnerStaticClasses", "identifyUtilityClassesOnlyStaticFields", "identifyUtilityClassesOnlyStaticMethods", "identifyUtilityClassesOnlyStaticMethodsAndAbstractClass", "identifyUtilityClassesWithProtectedConstructor", "ignoreClassesWithMainMethod", "suppressedUtilityClassWithDifferentArgument", "rewrite-test"})
public interface HideUtilityClassConstructorTest
extends JavaRecipeTest {
    @Override
    @Nullable
    public Recipe getRecipe();

    @Test
    public void changePublicConstructorToPrivate(@NotNull JavaParser var1);

    @Test
    public void changePackagePrivateConstructorToPrivate(@NotNull JavaParser var1);

    @Test
    public void identifyUtilityClassesWithProtectedConstructor(@NotNull JavaParser var1);

    @Test
    public void changeUtilityClassesWithMixedExposedConstructors(@NotNull JavaParser var1);

    @Test
    public void addPrivateConstructorWhenOnlyDefaultConstructor(@NotNull JavaParser var1);

    @Test
    public void ignoreClassesWithMainMethod(@NotNull JavaParser var1);

    @Test
    public void identifyUtilityClassesOnlyStaticFields(@NotNull JavaParser var1);

    @Test
    public void identifyNonUtilityClassesWhenImplementsInterface(@NotNull JavaParser var1);

    @Test
    public void identifyNonUtilityClassesWhenExtendsClass(@NotNull JavaParser var1);

    @Test
    public void identifyNonUtilityClassesMixedFields(@NotNull JavaParser var1);

    @Test
    public void identifyUtilityClassesOnlyStaticMethods(@NotNull JavaParser var1);

    @Test
    public void identifyUtilityClassesInnerStaticClasses(@NotNull JavaParser var1);

    @Test
    public void identifyNonUtilityClassesMixedMethods(@NotNull JavaParser var1);

    @Test
    public void identifyUtilityClassesOnlyStaticMethodsAndAbstractClass(@NotNull JavaParser var1);

    @Test
    public void identifyNonUtilityClassesOnlyPublicConstructor(@NotNull JavaParser var1);

    @Test
    public void identifyNonUtilityClassesTotallyEmpty(@NotNull JavaParser var1);

    @Test
    public void dontChangeSuppressedUtilityClasses(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void suppressedUtilityClassWithDifferentArgument(@NotNull JavaParser.Builder<?, ?> var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Nullable
        public static Recipe getRecipe(@NotNull HideUtilityClassConstructorTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return (Recipe)new HideUtilityClassConstructor();
        }

        @Test
        public static void changePublicConstructorToPrivate(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            public class A {\n                public A() {\n                }\n\n                public static void utility() {\n                }\n            }\n        ", null, "\n            public class A {\n                private A() {\n                }\n\n                public static void utility() {\n                }\n            }\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void changePackagePrivateConstructorToPrivate(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            public class A {\n                A() {\n                }\n\n                public static void utility() {\n                }\n            }\n        ", null, "\n            public class A {\n                private A() {\n                }\n\n                public static void utility() {\n                }\n            }\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void identifyUtilityClassesWithProtectedConstructor(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            public class A {\n                protected A() {\n                }\n\n                public static void utility() {\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void changeUtilityClassesWithMixedExposedConstructors(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            public class A {\n                protected A() {\n                }\n\n                public A(String a) {\n                }\n\n                A(String a, String b) {\n                }\n\n                private A(String a, String b, String c) {\n                }\n\n                public static void utility() {\n                }\n            }\n        ", null, "\n            public class A {\n                protected A() {\n                }\n\n                private A(String a) {\n                }\n\n                private A(String a, String b) {\n                }\n\n                private A(String a, String b, String c) {\n                }\n\n                public static void utility() {\n                }\n            }\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void addPrivateConstructorWhenOnlyDefaultConstructor(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            public class Math {\n                public static final int TWO = 2;\n\n                public static int addTwo(int a) {\n                    return a + TWO;\n                }\n            }\n        ", null, "\n            public class Math {\n                public static final int TWO = 2;\n\n                public static int addTwo(int a) {\n                    return a + TWO;\n                }\n\n                private Math() {\n                }\n            }\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void ignoreClassesWithMainMethod(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            package a;\n\n            public class A {\n                public static void main(String[] args) {\n                    // SpringApplication.run(A.class, args);\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void identifyUtilityClassesOnlyStaticFields(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            public class A {\n                public A() {\n                }\n\n                public static int a;\n            }\n        ", null, "\n            public class A {\n                private A() {\n                }\n\n                public static int a;\n            }\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void identifyNonUtilityClassesWhenImplementsInterface(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            public interface B {\n                static void utility() {\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            public class A implements B {\n                public A() {\n                }\n\n                public static void utility() {\n                    B.utility();\n                }\n            }\n        ", stringArray2, 2, null);
        }

        @Test
        public static void identifyNonUtilityClassesWhenExtendsClass(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            public class B {\n                public static void utility() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            public class A extends B {\n                public A() {\n                }\n\n                public static void doSomething() {\n                }\n            }\n        ", stringArray2, 2, null);
        }

        @Test
        public static void identifyNonUtilityClassesMixedFields(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            public class A {\n                public A() {\n                }\n\n                public int a;\n\n                public static int b;\n            }\n        ", null, 10, null);
        }

        @Test
        public static void identifyUtilityClassesOnlyStaticMethods(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            public class A {\n                public A() {\n                }\n\n                public static void utility() {\n                }\n\n                public static void utility(String[] args) {\n                    utility();\n                }\n            }\n        ", null, "\n            public class A {\n                private A() {\n                }\n\n                public static void utility() {\n                }\n\n                public static void utility(String[] args) {\n                    utility();\n                }\n            }\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void identifyUtilityClassesInnerStaticClasses(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            public class A {\n\n                static class Inner {\n                    public Inner() {\n                    }\n\n                    public static void utility() {\n                    }\n                }\n\n                public void utility() {\n                }\n            }\n        ", null, "\n            public class A {\n\n                static class Inner {\n                    private Inner() {\n                    }\n\n                    public static void utility() {\n                    }\n                }\n\n                public void utility() {\n                }\n            }\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void identifyNonUtilityClassesMixedMethods(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            public class A {\n                public A() {\n                }\n\n                public static void someStatic() {\n                }\n\n                public void notStatic() {\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void identifyUtilityClassesOnlyStaticMethodsAndAbstractClass(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            public abstract class A {\n                public A() {\n                }\n\n                public static void someStatic1() {\n                }\n\n                public static void someStatic2() {\n                }\n            }\n        ", null, "\n            public abstract class A {\n                private A() {\n                }\n\n                public static void someStatic1() {\n                }\n\n                public static void someStatic2() {\n                }\n            }\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void identifyNonUtilityClassesOnlyPublicConstructor(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            public class A {\n                public A() {\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void identifyNonUtilityClassesTotallyEmpty(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            public class A {\n            }\n        ", null, 10, null);
        }

        @Test
        public static void dontChangeSuppressedUtilityClasses(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            Object[] objectArray = new String[]{"@lombok.experimental.UtilityClass", "@lombok.Data", "@java.lang.SuppressWarnings(\"checkstyle:HideUtilityClassConstructor\")"};
            JavaParser javaParser = jp.styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)new HideUtilityClassConstructorStyle((Collection)CollectionsKt.listOf((Object[])objectArray)))))).build();
            String[] stringArray = new String[]{"\n            package lombok.experimental;\n            public @interface UtilityClass {}\n        "};
            objectArray = stringArray;
            JavaRecipeTest javaRecipeTest = this_;
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"build()");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(javaRecipeTest, javaParser, null, "\n            import lombok.experimental.UtilityClass;\n            \n            @UtilityClass\n            public class DoNotChangeMeA {\n                public static void utility() {\n                }\n            }\n\n            @SuppressWarnings(\"checkstyle:HideUtilityClassConstructor\")\n            class DoNotChangeMeB {\n                public static void utility() {\n                }\n            }\n        ", (String[])objectArray, 2, null);
        }

        @Test
        public static void suppressedUtilityClassWithDifferentArgument(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)new HideUtilityClassConstructorStyle((Collection)CollectionsKt.listOf((Object)"@java.lang.SuppressWarnings(\"checkstyle:HideUtilityClassConstructor\")")))))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(\n            listOf(\n                NamedStyles(\n                    randomId(), \"test\", \"test\", \"test\", emptySet(), listOf(\n                        HideUtilityClassConstructorStyle(\n                            listOf(\"\"\"@java.lang.SuppressWarnings(\"checkstyle:HideUtilityClassConstructor\")\"\"\")\n                        )\n                    )\n                )\n            )\n        ).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, "\n            @SuppressWarnings(\"rewrite:I-can-change\")\n            class ChangeMeA {\n                public static void utility() {\n                }\n            }\n        ", null, "\n            @SuppressWarnings(\"rewrite:I-can-change\")\n            class ChangeMeA {\n                public static void utility() {\n                }\n\n                private ChangeMeA() {\n                }\n            }\n        ", 0, 0, false, null, 490, null);
        }

        public static void assertChangedBase(@NotNull HideUtilityClassConstructorTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull HideUtilityClassConstructorTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull HideUtilityClassConstructorTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        @NotNull
        public static String apiTokenFromUserHome(@NotNull HideUtilityClassConstructorTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.apiTokenFromUserHome(this_);
        }

        public static void assertChanged(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, boolean skipEnhancedTypeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, skipEnhancedTypeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, boolean skipEnhancedTypeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, skipEnhancedTypeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull HideUtilityClassConstructorTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchanged(@NotNull HideUtilityClassConstructorTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull HideUtilityClassConstructorTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, moderneAstLink, moderneApiBearerToken);
        }

        public static void assertUnchangedBase(@NotNull HideUtilityClassConstructorTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull HideUtilityClassConstructorTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull HideUtilityClassConstructorTest this_, @NotNull TreeVisitor<?, ExecutionContext> receiver) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(receiver, (String)"receiver");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, receiver);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull HideUtilityClassConstructorTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @NotNull
        public static JavaParser getParser(@NotNull HideUtilityClassConstructorTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull HideUtilityClassConstructorTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

