/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeSerializer;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaParserTest;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0007H\u0017\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/tree/JavaParserTest;", "", "dependsOn", "", "jp", "Lorg/openrewrite/java/JavaParser$Builder;", "relativeSourcePath", "Lorg/openrewrite/java/JavaParser;", "rewrite-test"})
public interface JavaParserTest {
    @Test
    public void relativeSourcePath(@NotNull JavaParser var1);

    @Test
    public void dependsOn(@NotNull JavaParser.Builder<?, ?> var1);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void relativeSourcePath(@NotNull JavaParserTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Path projectDir = Paths.get("/Users/jon/Projects/github/Netflix/eureka", new String[0]);
            Path sourcePath = Paths.get("/Users/jon/Projects/github/Netflix/eureka/eureka-client-archaius2/src/main/java/com/netflix/discovery/EurekaArchaius2ClientConfig.java", new String[0]);
            J.CompilationUnit cu2 = (J.CompilationUnit)jp.parseInputs((Iterable)CollectionsKt.listOf((Object)new Parser.Input(sourcePath, (Supplier)relativeSourcePath.cu.1.INSTANCE)), projectDir, (ExecutionContext)new InMemoryExecutionContext()).get(0);
            Assertions.assertThat((Path)cu2.getSourcePath()).isEqualTo((Object)Paths.get("eureka-client-archaius2/src/main/java/com/netflix/discovery/EurekaArchaius2ClientConfig.java", new String[0]));
            TreeSerializer serializer = new TreeSerializer();
            J.CompilationUnit cu22 = (J.CompilationUnit)serializer.read(serializer.write((SourceFile)cu2));
            Assertions.assertThat((Path)cu22.getSourcePath()).isEqualTo((Object)Paths.get("eureka-client-archaius2/src/main/java/com/netflix/discovery/EurekaArchaius2ClientConfig.java", new String[0]));
        }

        @Test
        public static void dependsOn(@NotNull JavaParserTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {\n    A a;\n}"};
            List cu2 = jp.dependsOn((Collection)Collections.singletonList(Parser.Input.fromString((String)"class A {}"))).build().parse(stringArray);
            Object e = ((J.ClassDeclaration)((J.CompilationUnit)cu2.get(0)).getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            stringArray = ((J.VariableDeclarations)e).getTypeAsClass();
            Assertions.assertThat((String)(stringArray == null ? null : stringArray.getFullyQualifiedName())).isEqualTo("A");
        }
    }
}

