/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeLiteral;
import org.openrewrite.java.ChangeLiteralTest;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.TestRecipe;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bJ\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\f"}, d2={"Lorg/openrewrite/java/ChangeLiteralTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "changeStringLiteralArgument", "", "jp", "Lorg/openrewrite/java/JavaParser;", "changeStringLiteralArgumentWithEscapableCharacters", "Companion", "rewrite-test"})
public interface ChangeLiteralTest
extends JavaRecipeTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.ChangeLiteralTest$Companion.$$INSTANCE;

    @Override
    @NotNull
    public Recipe getRecipe();

    @Test
    public void changeStringLiteralArgument(@NotNull JavaParser var1);

    @Test
    public void changeStringLiteralArgumentWithEscapableCharacters(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/openrewrite/java/ChangeLiteralTest$Companion;", "", "()V", "b", "", "rewrite-test"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final String b;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
            b = "package b;\npublic class B {\n   public void singleArg(String s) {}\n}";
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getRecipe(@NotNull ChangeLiteralTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return new TestRecipe(){

                @NotNull
                protected TreeVisitor<?, ExecutionContext> getVisitor() {
                    return (TreeVisitor)new JavaVisitor<ExecutionContext>(){

                        @NotNull
                        public J visitLiteral(@NotNull J.Literal literal, @NotNull ExecutionContext p) {
                            Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
                            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                            this.doAfterVisit((TreeVisitor)new ChangeLiteral((Expression)literal, (Function)recipe.getVisitor.visitLiteral.1.INSTANCE));
                            J j = super.visitLiteral(literal, (Object)p);
                            Intrinsics.checkNotNullExpressionValue((Object)j, (String)"super.visitLiteral(literal, p)");
                            return j;
                        }
                    };
                }
            };
        }

        @Test
        public static void changeStringLiteralArgument(@NotNull ChangeLiteralTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeLiteralTest$Companion.b};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n                import b.*;\n                class A {\n                   public void test() {\n                       String s = \"bar\";\n                       new B().singleArg(\"foo (%s)\" + s + 0L);\n                   }\n                }\n            ", stringArray2, "\n                import b.*;\n                class A {\n                   public void test() {\n                       String s = \"bar\";\n                       new B().singleArg(\"foo ({})\" + s + 0L);\n                   }\n                }\n            ", 0, 34, null);
        }

        @Test
        public static void changeStringLiteralArgumentWithEscapableCharacters(@NotNull ChangeLiteralTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeLiteralTest$Companion.b};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n                import b.*;\n                public class A {\n                    B b;\n                    public void test() {\n                        b.singleArg(\"mystring '%s'\");\n                    }\n                }\n            ", stringArray2, "\n                import b.*;\n                public class A {\n                    B b;\n                    public void test() {\n                        b.singleArg(\"mystring '{}'\");\n                    }\n                }\n            ", 0, 34, null);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull ChangeLiteralTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull ChangeLiteralTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull ChangeLiteralTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull ChangeLiteralTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after) {
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, after);
        }

        public static void assertChanged(@NotNull ChangeLiteralTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after) {
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, dependsOn, after);
        }

        public static void assertChanged(@NotNull ChangeLiteralTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull ChangeLiteralTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull ChangeLiteralTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull ChangeLiteralTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull ChangeLiteralTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull ChangeLiteralTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertUnchanged(@NotNull ChangeLiteralTest this_, @Language(value="java") @NotNull String before) {
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, before);
        }

        public static void assertUnchanged(@NotNull ChangeLiteralTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ChangeLiteralTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ChangeLiteralTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ChangeLiteralTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before);
        }

        public static void assertUnchanged(@NotNull ChangeLiteralTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, before);
        }

        public static void assertUnchanged(@NotNull ChangeLiteralTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull ChangeLiteralTest this_, @NotNull TreeVisitor<?, ExecutionContext> receiver) {
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, receiver);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull ChangeLiteralTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull ChangeLiteralTest this_) {
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

