/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.AddImportTest;
import org.openrewrite.java.ChangeFieldNameTest;
import org.openrewrite.java.ChangeFieldTypeTest;
import org.openrewrite.java.ChangeLiteralTest;
import org.openrewrite.java.ChangeMethodNameTest;
import org.openrewrite.java.ChangeMethodTargetToStaticTest;
import org.openrewrite.java.ChangeMethodTargetToVariableTest;
import org.openrewrite.java.ChangePackageTest;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.ChangeTypeTest;
import org.openrewrite.java.DeleteMethodArgumentTest;
import org.openrewrite.java.DeleteStatementTest;
import org.openrewrite.java.ImplementInterfaceTest;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaParserResolver;
import org.openrewrite.java.JavaTemplateTest;
import org.openrewrite.java.OrderImports;
import org.openrewrite.java.OrderImportsTest;
import org.openrewrite.java.RemoveUnusedImportsTest;
import org.openrewrite.java.RenameVariableTest;
import org.openrewrite.java.ReorderMethodArgumentsTest;
import org.openrewrite.java.UnwrapParenthesesTest;
import org.openrewrite.java.UseStaticImportTest;
import org.openrewrite.java.cleanup.CovariantEqualsTest;
import org.openrewrite.java.cleanup.FinalizeLocalVariablesTest;
import org.openrewrite.java.cleanup.HideUtilityClassConstructorTest;
import org.openrewrite.java.cleanup.SimplifyBooleanExpressionTest;
import org.openrewrite.java.cleanup.SimplifyBooleanReturnTest;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesTest;
import org.openrewrite.java.format.BlankLinesTest;
import org.openrewrite.java.format.MinimumViableSpacingTest;
import org.openrewrite.java.format.NormalizeFormatTest;
import org.openrewrite.java.format.RemoveTrailingWhitespaceTest;
import org.openrewrite.java.format.SpacesTest;
import org.openrewrite.java.format.TabsAndIndentsTest;
import org.openrewrite.java.format.WrappingAndBracesTest;
import org.openrewrite.java.search.FindAnnotationsTest;
import org.openrewrite.java.search.FindFieldsTest;
import org.openrewrite.java.search.FindInheritedFieldsTest;
import org.openrewrite.java.search.FindMethodsTest;
import org.openrewrite.java.search.FindTypes;
import org.openrewrite.java.search.FindTypesTest;
import org.openrewrite.java.search.SemanticallyEqualTest;
import org.openrewrite.java.style.BlankLinesStyle;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.style.UnnecessaryParenthesesStyle;
import org.openrewrite.java.tree.TypeTreeTest;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

@ExtendWith(value={JavaParserResolver.class})
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b(\b'\u0018\u00002\u00020\u0001:'\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004H&\u00a8\u0006,"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit;", "", "()V", "javaParser", "Lorg/openrewrite/java/JavaParser$Builder;", "AddImportTck", "BlankLinesTck", "ChangeFieldNameTck", "ChangeFieldTypeTck", "ChangeLiteralTck", "ChangeMethodNameTck", "ChangeMethodTargetToStaticTck", "ChangeMethodTargetToVariableTck", "ChangePackage", "ChangeTypeTck", "CovariantEqualsTck", "DeleteMethodArgumentTck", "DeleteStatementTck", "FinalizeLocalVariablesTck", "FindAnnotationsTck", "FindFieldsTck", "FindInheritedFieldsTck", "FindMethodsTck", "FindTypesTck", "HideUtilityClassConstructorTck", "ImplementInterfaceTck", "JavaTemplateTck", "MinimumViableSpacingTck", "NormalizeFormatTck", "OrderImportsTck", "RemoveTrailingWhitespaceTck", "RemoveUnusedImportsTck", "RenameVariableTck", "ReorderMethodArgumentsTck", "SemanticallyEqualTck", "SimplifyBooleanExpressionTck", "SimplifyBooleanReturnTck", "SpacesTck", "TabsAndIndentsTck", "TypeTreeTck", "UnnecessaryParenthesesTck", "UnwrapParenthesesTck", "UseStaticImportTck", "WrappingAndBracesTck", "rewrite-test"})
public abstract class JavaVisitorCompatibilityKit {
    @NotNull
    public abstract JavaParser.Builder<?, ?> javaParser();

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$AddImportTck;", "Lorg/openrewrite/java/AddImportTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class AddImportTck
    implements AddImportTest {
        @Override
        @NotNull
        public Recipe addImports(AddImport<ExecutionContext> ... adds) {
            Intrinsics.checkNotNullParameter(adds, (String)"adds");
            return AddImportTest.DefaultImpls.addImports(this, adds);
        }

        @Override
        @Test
        public void addMultipleImports(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImportTest.DefaultImpls.addMultipleImports(this, jp);
        }

        @Override
        @Test
        public void addNamedImport(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImportTest.DefaultImpls.addNamedImport(this, jp);
        }

        @Override
        @Test
        public void doNotAddImportIfNotReferenced(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImportTest.DefaultImpls.doNotAddImportIfNotReferenced(this, jp);
        }

        @Override
        @Test
        public void doNotAddWildcardImportIfNotReferenced(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImportTest.DefaultImpls.doNotAddWildcardImportIfNotReferenced(this, jp);
        }

        @Override
        @Test
        public void lastImportWhenFirstClassDeclarationHasJavadoc(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImportTest.DefaultImpls.lastImportWhenFirstClassDeclarationHasJavadoc(this, jp);
        }

        @Override
        @Test
        public void namedImportAddedAfterPackageDeclaration(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImportTest.DefaultImpls.namedImportAddedAfterPackageDeclaration(this, jp);
        }

        @Override
        @Test
        public void importsAddedInAlphabeticalOrder(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImportTest.DefaultImpls.importsAddedInAlphabeticalOrder(this, jp);
        }

        @Override
        @Test
        public void doNotAddImportIfAlreadyExists(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImportTest.DefaultImpls.doNotAddImportIfAlreadyExists(this, jp);
        }

        @Override
        @Test
        public void doNotAddImportIfCoveredByStarImport(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImportTest.DefaultImpls.doNotAddImportIfCoveredByStarImport(this, jp);
        }

        @Override
        @Test
        public void dontAddImportWhenClassHasNoPackage(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImportTest.DefaultImpls.dontAddImportWhenClassHasNoPackage(this, jp);
        }

        @Override
        @Test
        public void dontAddImportForPrimitive(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImportTest.DefaultImpls.dontAddImportForPrimitive(this, jp);
        }

        @Override
        @Test
        public void addNamedImportIfStarStaticImportExists(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImportTest.DefaultImpls.addNamedImportIfStarStaticImportExists(this, jp);
        }

        @Override
        @Test
        public void addNamedStaticImport(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImportTest.DefaultImpls.addNamedStaticImport(this, jp);
        }

        @Override
        @Test
        public void addStaticImportField(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImportTest.DefaultImpls.addStaticImportField(this, jp);
        }

        @Override
        @Test
        public void dontAddStaticWildcardImportIfNotReferenced(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImportTest.DefaultImpls.dontAddStaticWildcardImportIfNotReferenced(this, jp);
        }

        @Override
        @Test
        public void addNamedStaticImportWhenReferenced(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImportTest.DefaultImpls.addNamedStaticImportWhenReferenced(this, jp);
        }

        @Override
        @Test
        public void doNotAddNamedStaticImportIfNotReferenced(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImportTest.DefaultImpls.doNotAddNamedStaticImportIfNotReferenced(this, jp);
        }

        @Override
        @Test
        public void addStaticWildcardImportWhenReferenced(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImportTest.DefaultImpls.addStaticWildcardImportWhenReferenced(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return AddImportTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            AddImportTest.DefaultImpls.assertChanged((AddImportTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            AddImportTest.DefaultImpls.assertChanged((AddImportTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            AddImportTest.DefaultImpls.assertChanged((AddImportTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            AddImportTest.DefaultImpls.assertChanged((AddImportTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            AddImportTest.DefaultImpls.assertUnchanged((AddImportTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            AddImportTest.DefaultImpls.assertUnchanged((AddImportTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Recipe getRecipe() {
            return AddImportTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return AddImportTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return AddImportTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$BlankLinesTck;", "Lorg/openrewrite/java/format/BlankLinesTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class BlankLinesTck
    implements BlankLinesTest {
        @Override
        @Nullable
        public Recipe getRecipe() {
            return BlankLinesTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @NotNull
        public List<NamedStyles> blankLines(@NotNull Function1<? super BlankLinesStyle, ? extends BlankLinesStyle> with) {
            Intrinsics.checkNotNullParameter(with, (String)"with");
            return BlankLinesTest.DefaultImpls.blankLines(this, with);
        }

        @Override
        @Test
        public void eachMethodOnItsOwnLine(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.eachMethodOnItsOwnLine(this, jp);
        }

        @Override
        @Test
        public void keepMaximumInDeclarations(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.keepMaximumInDeclarations(this, jp);
        }

        @Override
        @Test
        public void keepMaximumInCode(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.keepMaximumInCode(this, jp);
        }

        @Override
        @Test
        public void keepMaximumBeforeEndOfBlock(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.keepMaximumBeforeEndOfBlock(this, jp);
        }

        @Override
        @Test
        public void keepMaximumBetweenHeaderAndPackage(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.keepMaximumBetweenHeaderAndPackage(this, jp);
        }

        @Override
        @Test
        public void minimumPackageWithComment(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.minimumPackageWithComment(this, jp);
        }

        @Override
        @Test
        public void minimumBeforePackage(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.minimumBeforePackage(this, jp);
        }

        @Override
        @Test
        public void minimumBeforePackageWithComment(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.minimumBeforePackageWithComment(this, jp);
        }

        @Override
        @Test
        public void minimumBeforeImportsWithPackage(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.minimumBeforeImportsWithPackage(this, jp);
        }

        @Override
        @Test
        public void minimumBeforeImports(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.minimumBeforeImports(this, jp);
        }

        @Override
        @Test
        public void minimumBeforeImportsWithComment(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.minimumBeforeImportsWithComment(this, jp);
        }

        @Override
        @Test
        public void minimumAfterPackageWithImport(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.minimumAfterPackageWithImport(this, jp);
        }

        @Override
        @Test
        public void minimumAfterPackage(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.minimumAfterPackage(this, jp);
        }

        @Override
        @Test
        public void minimumAfterImports(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.minimumAfterImports(this, jp);
        }

        @Override
        @Test
        public void noImportsNoPackage(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            BlankLinesTest.DefaultImpls.noImportsNoPackage(this, jp);
        }

        @Override
        @Test
        public void minimumAroundClass(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.minimumAroundClass(this, jp);
        }

        @Override
        @Test
        public void minimumAfterClassHeader(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.minimumAfterClassHeader(this, jp);
        }

        @Override
        @Test
        public void minimumBeforeClassEnd(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.minimumBeforeClassEnd(this, jp);
        }

        @Override
        @Test
        public void minimumAfterAnonymousClassHeader(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.minimumAfterAnonymousClassHeader(this, jp);
        }

        @Override
        @Test
        public void minimumAroundFieldInInterface(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.minimumAroundFieldInInterface(this, jp);
        }

        @Override
        @Test
        public void minimumAroundField(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.minimumAroundField(this, jp);
        }

        @Override
        @Test
        public void minimumAroundMethodInInterface(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.minimumAroundMethodInInterface(this, jp);
        }

        @Override
        @Test
        public void minimumAroundMethod(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.minimumAroundMethod(this, jp);
        }

        @Override
        @Test
        public void beforeMethodBody(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.beforeMethodBody(this, jp);
        }

        @Override
        @Test
        public void aroundInitializer(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.aroundInitializer(this, jp);
        }

        @Override
        @Test
        public void unchanged(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            BlankLinesTest.DefaultImpls.unchanged(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return BlankLinesTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            BlankLinesTest.DefaultImpls.assertChanged((BlankLinesTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            BlankLinesTest.DefaultImpls.assertChanged((BlankLinesTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            BlankLinesTest.DefaultImpls.assertChanged((BlankLinesTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            BlankLinesTest.DefaultImpls.assertChanged((BlankLinesTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            BlankLinesTest.DefaultImpls.assertUnchanged((BlankLinesTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            BlankLinesTest.DefaultImpls.assertUnchanged((BlankLinesTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return BlankLinesTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return BlankLinesTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$ChangeFieldNameTck;", "Lorg/openrewrite/java/ChangeFieldNameTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class ChangeFieldNameTck
    implements ChangeFieldNameTest {
        @Override
        @NotNull
        public RecipeTest.AdHocRecipe changeFieldName(@NotNull String from, @NotNull String to) {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            return ChangeFieldNameTest.DefaultImpls.changeFieldName(this, from, to);
        }

        @Override
        @Test
        public void changeFieldName(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeFieldNameTest.DefaultImpls.changeFieldName(this, jp);
        }

        @Override
        @Test
        public void changeFieldNameReferences(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeFieldNameTest.DefaultImpls.changeFieldNameReferences(this, jp);
        }

        @Override
        @Test
        public void changeFieldNameReferencesInOtherClass(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeFieldNameTest.DefaultImpls.changeFieldNameReferencesInOtherClass(this, jp);
        }

        @Override
        @Test
        public void dontChangeNestedFieldsWithSameName(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeFieldNameTest.DefaultImpls.dontChangeNestedFieldsWithSameName(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return ChangeFieldNameTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            ChangeFieldNameTest.DefaultImpls.assertChanged((ChangeFieldNameTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            ChangeFieldNameTest.DefaultImpls.assertChanged((ChangeFieldNameTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            ChangeFieldNameTest.DefaultImpls.assertChanged((ChangeFieldNameTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            ChangeFieldNameTest.DefaultImpls.assertChanged((ChangeFieldNameTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            ChangeFieldNameTest.DefaultImpls.assertUnchanged((ChangeFieldNameTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            ChangeFieldNameTest.DefaultImpls.assertUnchanged((ChangeFieldNameTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Recipe getRecipe() {
            return ChangeFieldNameTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return ChangeFieldNameTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return ChangeFieldNameTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$ChangeFieldTypeTck;", "Lorg/openrewrite/java/ChangeFieldTypeTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class ChangeFieldTypeTck
    implements ChangeFieldTypeTest {
        @Override
        @NotNull
        public RecipeTest.AdHocRecipe changeFieldType(@NotNull String from, @NotNull String to) {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            return ChangeFieldTypeTest.DefaultImpls.changeFieldType(this, from, to);
        }

        @Override
        @Test
        public void changeFieldTypeDeclarative(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeFieldTypeTest.DefaultImpls.changeFieldTypeDeclarative(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return ChangeFieldTypeTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            ChangeFieldTypeTest.DefaultImpls.assertChanged((ChangeFieldTypeTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            ChangeFieldTypeTest.DefaultImpls.assertChanged((ChangeFieldTypeTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            ChangeFieldTypeTest.DefaultImpls.assertChanged((ChangeFieldTypeTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            ChangeFieldTypeTest.DefaultImpls.assertChanged((ChangeFieldTypeTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            ChangeFieldTypeTest.DefaultImpls.assertUnchanged((ChangeFieldTypeTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            ChangeFieldTypeTest.DefaultImpls.assertUnchanged((ChangeFieldTypeTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Recipe getRecipe() {
            return ChangeFieldTypeTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return ChangeFieldTypeTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return ChangeFieldTypeTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$ChangeLiteralTck;", "Lorg/openrewrite/java/ChangeLiteralTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class ChangeLiteralTck
    implements ChangeLiteralTest {
        @Override
        @NotNull
        public Recipe getRecipe() {
            return ChangeLiteralTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Test
        public void changeStringLiteralArgument(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeLiteralTest.DefaultImpls.changeStringLiteralArgument(this, jp);
        }

        @Override
        @Test
        public void changeStringLiteralArgumentWithEscapableCharacters(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeLiteralTest.DefaultImpls.changeStringLiteralArgumentWithEscapableCharacters(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return ChangeLiteralTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            ChangeLiteralTest.DefaultImpls.assertChanged((ChangeLiteralTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            ChangeLiteralTest.DefaultImpls.assertChanged((ChangeLiteralTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            ChangeLiteralTest.DefaultImpls.assertChanged((ChangeLiteralTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            ChangeLiteralTest.DefaultImpls.assertChanged((ChangeLiteralTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            ChangeLiteralTest.DefaultImpls.assertUnchanged((ChangeLiteralTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            ChangeLiteralTest.DefaultImpls.assertUnchanged((ChangeLiteralTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return ChangeLiteralTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return ChangeLiteralTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$ChangeMethodNameTck;", "Lorg/openrewrite/java/ChangeMethodNameTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class ChangeMethodNameTck
    implements ChangeMethodNameTest {
        @Override
        @Test
        public void changeMethodNameForOverridenMethod(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeMethodNameTest.DefaultImpls.changeMethodNameForOverridenMethod(this, jp);
        }

        @Override
        @Test
        public void changeMethodNameForMethodWithSingleArgDeclarative(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeMethodNameTest.DefaultImpls.changeMethodNameForMethodWithSingleArgDeclarative(this, jp);
        }

        @Override
        @Test
        public void changeMethodNameForMethodWithSingleArg(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeMethodNameTest.DefaultImpls.changeMethodNameForMethodWithSingleArg(this, jp);
        }

        @Override
        @Test
        public void changeMethodNameForMethodWithArrayArg(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeMethodNameTest.DefaultImpls.changeMethodNameForMethodWithArrayArg(this, jp);
        }

        @Override
        @Test
        public void changeMethodNameForMethodWithVarargArg(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeMethodNameTest.DefaultImpls.changeMethodNameForMethodWithVarargArg(this, jp);
        }

        @Override
        @Test
        public void changeMethodNameWhenMatchingAgainstMethodWithNameThatIsAnAspectjToken(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeMethodNameTest.DefaultImpls.changeMethodNameWhenMatchingAgainstMethodWithNameThatIsAnAspectjToken(this, jp);
        }

        @Override
        @Test
        public void changeMethodDeclarationForMethodWithSingleArg(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeMethodNameTest.DefaultImpls.changeMethodDeclarationForMethodWithSingleArg(this, jp);
        }

        @Override
        @Test
        public void changeStaticMethodTest(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeMethodNameTest.DefaultImpls.changeStaticMethodTest(this, jp);
        }

        @Override
        @Test
        public void changeStaticImportTest(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeMethodNameTest.DefaultImpls.changeStaticImportTest(this, jp);
        }

        @Override
        @Test
        public void checkValidation() {
            ChangeMethodNameTest.DefaultImpls.checkValidation(this);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return ChangeMethodNameTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            ChangeMethodNameTest.DefaultImpls.assertChanged((ChangeMethodNameTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            ChangeMethodNameTest.DefaultImpls.assertChanged((ChangeMethodNameTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            ChangeMethodNameTest.DefaultImpls.assertChanged((ChangeMethodNameTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            ChangeMethodNameTest.DefaultImpls.assertChanged((ChangeMethodNameTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            ChangeMethodNameTest.DefaultImpls.assertUnchanged((ChangeMethodNameTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            ChangeMethodNameTest.DefaultImpls.assertUnchanged((ChangeMethodNameTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Recipe getRecipe() {
            return ChangeMethodNameTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return ChangeMethodNameTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return ChangeMethodNameTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$ChangeMethodTargetToStaticTck;", "Lorg/openrewrite/java/ChangeMethodTargetToStaticTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class ChangeMethodTargetToStaticTck
    implements ChangeMethodTargetToStaticTest {
        @Override
        @Test
        public void targetToStatic(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeMethodTargetToStaticTest.DefaultImpls.targetToStatic(this, jp);
        }

        @Override
        @Test
        public void staticTargetToStatic(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeMethodTargetToStaticTest.DefaultImpls.staticTargetToStatic(this, jp);
        }

        @Override
        @Test
        public void checkValidation() {
            ChangeMethodTargetToStaticTest.DefaultImpls.checkValidation(this);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return ChangeMethodTargetToStaticTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            ChangeMethodTargetToStaticTest.DefaultImpls.assertChanged((ChangeMethodTargetToStaticTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            ChangeMethodTargetToStaticTest.DefaultImpls.assertChanged((ChangeMethodTargetToStaticTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            ChangeMethodTargetToStaticTest.DefaultImpls.assertChanged((ChangeMethodTargetToStaticTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            ChangeMethodTargetToStaticTest.DefaultImpls.assertChanged((ChangeMethodTargetToStaticTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            ChangeMethodTargetToStaticTest.DefaultImpls.assertUnchanged((ChangeMethodTargetToStaticTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            ChangeMethodTargetToStaticTest.DefaultImpls.assertUnchanged((ChangeMethodTargetToStaticTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Recipe getRecipe() {
            return ChangeMethodTargetToStaticTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return ChangeMethodTargetToStaticTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return ChangeMethodTargetToStaticTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$ChangeMethodTargetToVariableTck;", "Lorg/openrewrite/java/ChangeMethodTargetToVariableTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class ChangeMethodTargetToVariableTck
    implements ChangeMethodTargetToVariableTest {
        @Override
        @Test
        public void explicitStaticToVariable(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeMethodTargetToVariableTest.DefaultImpls.explicitStaticToVariable(this, jp);
        }

        @Override
        @Test
        public void staticImportToVariable(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeMethodTargetToVariableTest.DefaultImpls.staticImportToVariable(this, jp);
        }

        @Override
        @Test
        public void checkValidation() {
            ChangeMethodTargetToVariableTest.DefaultImpls.checkValidation(this);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return ChangeMethodTargetToVariableTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            ChangeMethodTargetToVariableTest.DefaultImpls.assertChanged((ChangeMethodTargetToVariableTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            ChangeMethodTargetToVariableTest.DefaultImpls.assertChanged((ChangeMethodTargetToVariableTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            ChangeMethodTargetToVariableTest.DefaultImpls.assertChanged((ChangeMethodTargetToVariableTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            ChangeMethodTargetToVariableTest.DefaultImpls.assertChanged((ChangeMethodTargetToVariableTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            ChangeMethodTargetToVariableTest.DefaultImpls.assertUnchanged((ChangeMethodTargetToVariableTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            ChangeMethodTargetToVariableTest.DefaultImpls.assertUnchanged((ChangeMethodTargetToVariableTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Recipe getRecipe() {
            return ChangeMethodTargetToVariableTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return ChangeMethodTargetToVariableTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return ChangeMethodTargetToVariableTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$ChangePackage;", "Lorg/openrewrite/java/ChangePackageTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class ChangePackage
    implements ChangePackageTest {
        @Override
        @Test
        public void changePackage(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangePackageTest.DefaultImpls.changePackage(this, jp);
        }

        @Override
        @Test
        public void changePackageRecursive(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangePackageTest.DefaultImpls.changePackageRecursive(this, jp);
        }

        @Override
        @Test
        public void changePackageNonRecursive(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangePackageTest.DefaultImpls.changePackageNonRecursive(this, jp);
        }

        @Override
        @Test
        public void changePackageReferences(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangePackageTest.DefaultImpls.changePackageReferences(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return ChangePackageTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            ChangePackageTest.DefaultImpls.assertChanged((ChangePackageTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            ChangePackageTest.DefaultImpls.assertChanged((ChangePackageTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            ChangePackageTest.DefaultImpls.assertChanged((ChangePackageTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            ChangePackageTest.DefaultImpls.assertChanged((ChangePackageTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            ChangePackageTest.DefaultImpls.assertUnchanged((ChangePackageTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            ChangePackageTest.DefaultImpls.assertUnchanged((ChangePackageTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Recipe getRecipe() {
            return ChangePackageTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return ChangePackageTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return ChangePackageTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$ChangeTypeTck;", "Lorg/openrewrite/java/ChangeTypeTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class ChangeTypeTck
    implements ChangeTypeTest {
        @Override
        @NotNull
        public ChangeType getRecipe() {
            return ChangeTypeTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Test
        public void dontAddImportWhenNoChangesWereMade(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeTypeTest.DefaultImpls.dontAddImportWhenNoChangesWereMade(this, jp);
        }

        @Override
        @Test
        public void simpleName(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeTypeTest.DefaultImpls.simpleName(this, jp);
        }

        @Override
        @Test
        public void fullyQualifiedName(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeTypeTest.DefaultImpls.fullyQualifiedName(this, jp);
        }

        @Override
        @Test
        public void annotation(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeTypeTest.DefaultImpls.annotation(this, jp);
        }

        @Override
        @Test
        public void array(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeTypeTest.DefaultImpls.array(this, jp);
        }

        @Override
        @Test
        public void classDecl(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeTypeTest.DefaultImpls.classDecl(this, jp);
        }

        @Override
        @Test
        public void method(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeTypeTest.DefaultImpls.method(this, jp);
        }

        @Override
        @Test
        public void methodInvocationTypeParametersAndWildcard(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeTypeTest.DefaultImpls.methodInvocationTypeParametersAndWildcard(this, jp);
        }

        @Override
        @Test
        public void multiCatch(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeTypeTest.DefaultImpls.multiCatch(this, jp);
        }

        @Override
        @Test
        public void multiVariable(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeTypeTest.DefaultImpls.multiVariable(this, jp);
        }

        @Override
        @Test
        public void newClass(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeTypeTest.DefaultImpls.newClass(this, jp);
        }

        @Override
        @Test
        public void parameterizedType(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeTypeTest.DefaultImpls.parameterizedType(this, jp);
        }

        @Override
        @Test
        public void typeCast(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeTypeTest.DefaultImpls.typeCast(this, jp);
        }

        @Override
        @Test
        public void classReference(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeTypeTest.DefaultImpls.classReference(this, jp);
        }

        @Override
        @Test
        public void methodSelect(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeTypeTest.DefaultImpls.methodSelect(this, jp);
        }

        @Override
        @Test
        public void staticImport(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeTypeTest.DefaultImpls.staticImport(this, jp);
        }

        @Override
        @Disabled(value="https://github.com/openrewrite/rewrite/issues/62")
        @Test
        public void primitiveToClass(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeTypeTest.DefaultImpls.primitiveToClass(this, jp);
        }

        @Override
        @Test
        public void classToPrimitive(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeTypeTest.DefaultImpls.classToPrimitive(this, jp);
        }

        @Override
        @Test
        public void checkValidation() {
            ChangeTypeTest.DefaultImpls.checkValidation(this);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return ChangeTypeTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            ChangeTypeTest.DefaultImpls.assertChanged((ChangeTypeTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            ChangeTypeTest.DefaultImpls.assertChanged((ChangeTypeTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            ChangeTypeTest.DefaultImpls.assertChanged((ChangeTypeTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            ChangeTypeTest.DefaultImpls.assertChanged((ChangeTypeTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            ChangeTypeTest.DefaultImpls.assertUnchanged((ChangeTypeTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            ChangeTypeTest.DefaultImpls.assertUnchanged((ChangeTypeTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return ChangeTypeTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return ChangeTypeTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$CovariantEqualsTck;", "Lorg/openrewrite/java/cleanup/CovariantEqualsTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class CovariantEqualsTck
    implements CovariantEqualsTest {
        @Override
        @Nullable
        public Recipe getRecipe() {
            return CovariantEqualsTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Test
        public void replaceWithNonCovariantEquals(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            CovariantEqualsTest.DefaultImpls.replaceWithNonCovariantEquals(this, jp);
        }

        @Override
        @Test
        public void replaceMultiStatementReturnBody(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            CovariantEqualsTest.DefaultImpls.replaceMultiStatementReturnBody(this, jp);
        }

        @Override
        @Test
        public void replaceEqualsBasedOnTypeSignature(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            CovariantEqualsTest.DefaultImpls.replaceEqualsBasedOnTypeSignature(this, jp);
        }

        @Override
        @Test
        public void replaceEqualsMaintainsExistingAnnotations(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            CovariantEqualsTest.DefaultImpls.replaceEqualsMaintainsExistingAnnotations(this, jp);
        }

        @Override
        @Test
        public void replaceWithNonCovariantEqualsWhenNested(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            CovariantEqualsTest.DefaultImpls.replaceWithNonCovariantEqualsWhenNested(this, jp);
        }

        @Override
        @Test
        public void renameExistingParameterNameWhenParameterNameIsDefaultTemplateName(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            CovariantEqualsTest.DefaultImpls.renameExistingParameterNameWhenParameterNameIsDefaultTemplateName(this, jp);
        }

        @Override
        @Test
        public void ignoreIfAtLeastOneExistingNonCovariantEqualsMethod(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            CovariantEqualsTest.DefaultImpls.ignoreIfAtLeastOneExistingNonCovariantEqualsMethod(this, jp);
        }

        @Override
        @Test
        public void ignoreIfNoExistingEqualsMethod(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            CovariantEqualsTest.DefaultImpls.ignoreIfNoExistingEqualsMethod(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return CovariantEqualsTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            CovariantEqualsTest.DefaultImpls.assertChanged((CovariantEqualsTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            CovariantEqualsTest.DefaultImpls.assertChanged((CovariantEqualsTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            CovariantEqualsTest.DefaultImpls.assertChanged((CovariantEqualsTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            CovariantEqualsTest.DefaultImpls.assertChanged((CovariantEqualsTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            CovariantEqualsTest.DefaultImpls.assertUnchanged((CovariantEqualsTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            CovariantEqualsTest.DefaultImpls.assertUnchanged((CovariantEqualsTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return CovariantEqualsTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return CovariantEqualsTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$DeleteMethodArgumentTck;", "Lorg/openrewrite/java/DeleteMethodArgumentTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class DeleteMethodArgumentTck
    implements DeleteMethodArgumentTest {
        @Override
        @Test
        public void deleteMiddleArgumentDeclarative(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            DeleteMethodArgumentTest.DefaultImpls.deleteMiddleArgumentDeclarative(this, jp);
        }

        @Override
        @Test
        public void deleteMiddleArgument(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            DeleteMethodArgumentTest.DefaultImpls.deleteMiddleArgument(this, jp);
        }

        @Override
        @Test
        public void deleteArgumentsConsecutively(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            DeleteMethodArgumentTest.DefaultImpls.deleteArgumentsConsecutively(this, jp);
        }

        @Override
        @Test
        public void doNotDeleteEmptyContainingFormatting(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            DeleteMethodArgumentTest.DefaultImpls.doNotDeleteEmptyContainingFormatting(this, jp);
        }

        @Override
        @Test
        public void insertEmptyWhenLastArgumentIsDeleted(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            DeleteMethodArgumentTest.DefaultImpls.insertEmptyWhenLastArgumentIsDeleted(this, jp);
        }

        @Override
        @Test
        public void checkValidation() {
            DeleteMethodArgumentTest.DefaultImpls.checkValidation(this);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return DeleteMethodArgumentTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            DeleteMethodArgumentTest.DefaultImpls.assertChanged((DeleteMethodArgumentTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            DeleteMethodArgumentTest.DefaultImpls.assertChanged((DeleteMethodArgumentTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            DeleteMethodArgumentTest.DefaultImpls.assertChanged((DeleteMethodArgumentTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            DeleteMethodArgumentTest.DefaultImpls.assertChanged((DeleteMethodArgumentTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            DeleteMethodArgumentTest.DefaultImpls.assertUnchanged((DeleteMethodArgumentTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            DeleteMethodArgumentTest.DefaultImpls.assertUnchanged((DeleteMethodArgumentTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Recipe getRecipe() {
            return DeleteMethodArgumentTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return DeleteMethodArgumentTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return DeleteMethodArgumentTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$DeleteStatementTck;", "Lorg/openrewrite/java/DeleteStatementTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class DeleteStatementTck
    implements DeleteStatementTest {
        @Override
        @Test
        public void deleteField(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            DeleteStatementTest.DefaultImpls.deleteField(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return DeleteStatementTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            DeleteStatementTest.DefaultImpls.assertChanged((DeleteStatementTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            DeleteStatementTest.DefaultImpls.assertChanged((DeleteStatementTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            DeleteStatementTest.DefaultImpls.assertChanged((DeleteStatementTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            DeleteStatementTest.DefaultImpls.assertChanged((DeleteStatementTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            DeleteStatementTest.DefaultImpls.assertUnchanged((DeleteStatementTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            DeleteStatementTest.DefaultImpls.assertUnchanged((DeleteStatementTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Recipe getRecipe() {
            return DeleteStatementTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return DeleteStatementTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return DeleteStatementTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$FinalizeLocalVariablesTck;", "Lorg/openrewrite/java/cleanup/FinalizeLocalVariablesTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class FinalizeLocalVariablesTck
    implements FinalizeLocalVariablesTest {
        @Override
        @Nullable
        public Recipe getRecipe() {
            return FinalizeLocalVariablesTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Test
        public void localVariablesAreMadeFinal(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FinalizeLocalVariablesTest.DefaultImpls.localVariablesAreMadeFinal(this, jp);
        }

        @Override
        @Test
        public void identifyReassignedLocalVariables(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FinalizeLocalVariablesTest.DefaultImpls.identifyReassignedLocalVariables(this, jp);
        }

        @Override
        @Test
        public void multipleVariablesDeclarationOnSingleLine(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FinalizeLocalVariablesTest.DefaultImpls.multipleVariablesDeclarationOnSingleLine(this, jp);
        }

        @Override
        @Test
        public void calculateLocalVariablesInitializerOffset(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FinalizeLocalVariablesTest.DefaultImpls.calculateLocalVariablesInitializerOffset(this, jp);
        }

        @Override
        @Test
        @Disabled
        public void calculateLocalVariablesInitializerBranching(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FinalizeLocalVariablesTest.DefaultImpls.calculateLocalVariablesInitializerBranching(this, jp);
        }

        @Override
        @Test
        public void forEachLoopAssignmentMadeFinal(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FinalizeLocalVariablesTest.DefaultImpls.forEachLoopAssignmentMadeFinal(this, jp);
        }

        @Override
        @Test
        public void localVariableScopeAwareness(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FinalizeLocalVariablesTest.DefaultImpls.localVariableScopeAwareness(this, jp);
        }

        @Override
        @Test
        public void forEachLoopScopeAwareness(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FinalizeLocalVariablesTest.DefaultImpls.forEachLoopScopeAwareness(this, jp);
        }

        @Override
        @Test
        public void instanceVariablesIgnored(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FinalizeLocalVariablesTest.DefaultImpls.instanceVariablesIgnored(this, jp);
        }

        @Override
        @Test
        public void classVariablesIgnored(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FinalizeLocalVariablesTest.DefaultImpls.classVariablesIgnored(this, jp);
        }

        @Override
        @Test
        public void classInitializersIgnored(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FinalizeLocalVariablesTest.DefaultImpls.classInitializersIgnored(this, jp);
        }

        @Override
        @Test
        public void methodParameterVariablesIgnored(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FinalizeLocalVariablesTest.DefaultImpls.methodParameterVariablesIgnored(this, jp);
        }

        @Override
        @Test
        public void lambdaVariablesIgnored(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FinalizeLocalVariablesTest.DefaultImpls.lambdaVariablesIgnored(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return FinalizeLocalVariablesTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            FinalizeLocalVariablesTest.DefaultImpls.assertChanged((FinalizeLocalVariablesTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            FinalizeLocalVariablesTest.DefaultImpls.assertChanged((FinalizeLocalVariablesTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            FinalizeLocalVariablesTest.DefaultImpls.assertChanged((FinalizeLocalVariablesTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            FinalizeLocalVariablesTest.DefaultImpls.assertChanged((FinalizeLocalVariablesTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            FinalizeLocalVariablesTest.DefaultImpls.assertUnchanged((FinalizeLocalVariablesTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            FinalizeLocalVariablesTest.DefaultImpls.assertUnchanged((FinalizeLocalVariablesTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return FinalizeLocalVariablesTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return FinalizeLocalVariablesTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$FindAnnotationsTck;", "Lorg/openrewrite/java/search/FindAnnotationsTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class FindAnnotationsTck
    implements FindAnnotationsTest {
        @Override
        @Test
        public void matchesSimpleFullyQualifiedAnnotation(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindAnnotationsTest.DefaultImpls.matchesSimpleFullyQualifiedAnnotation(this, jp);
        }

        @Override
        @Test
        public void matchesAnnotationOnMethod(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindAnnotationsTest.DefaultImpls.matchesAnnotationOnMethod(this, jp);
        }

        @Override
        @Test
        public void matchesAnnotationOnField(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindAnnotationsTest.DefaultImpls.matchesAnnotationOnField(this, jp);
        }

        @Override
        @Test
        public void doesNotMatchNotFullyQualifiedAnnotations(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindAnnotationsTest.DefaultImpls.doesNotMatchNotFullyQualifiedAnnotations(this, jp);
        }

        @Override
        @Test
        public void matchesSingleAnnotationParameter(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindAnnotationsTest.DefaultImpls.matchesSingleAnnotationParameter(this, jp);
        }

        @Override
        @Test
        public void doesNotMatchDifferentSingleAnnotationParameter(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindAnnotationsTest.DefaultImpls.doesNotMatchDifferentSingleAnnotationParameter(this, jp);
        }

        @Override
        @Test
        public void matchesNamedParameters(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindAnnotationsTest.DefaultImpls.matchesNamedParameters(this, jp);
        }

        @Override
        @Test
        public void doesNotMatchDifferentNamedParameters(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindAnnotationsTest.DefaultImpls.doesNotMatchDifferentNamedParameters(this, jp);
        }

        @Override
        @Test
        public void matchesNamedParametersRegardlessOfOrder(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindAnnotationsTest.DefaultImpls.matchesNamedParametersRegardlessOfOrder(this, jp);
        }

        @Override
        @Test
        public void checkValidation() {
            FindAnnotationsTest.DefaultImpls.checkValidation(this);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return FindAnnotationsTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            FindAnnotationsTest.DefaultImpls.assertChanged((FindAnnotationsTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            FindAnnotationsTest.DefaultImpls.assertChanged((FindAnnotationsTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            FindAnnotationsTest.DefaultImpls.assertChanged((FindAnnotationsTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            FindAnnotationsTest.DefaultImpls.assertChanged((FindAnnotationsTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            FindAnnotationsTest.DefaultImpls.assertUnchanged((FindAnnotationsTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            FindAnnotationsTest.DefaultImpls.assertUnchanged((FindAnnotationsTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Recipe getRecipe() {
            return FindAnnotationsTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return FindAnnotationsTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return FindAnnotationsTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$FindFieldsTck;", "Lorg/openrewrite/java/search/FindFieldsTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class FindFieldsTck
    implements FindFieldsTest {
        @Override
        @Test
        public void findPrivateNonInheritedField(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindFieldsTest.DefaultImpls.findPrivateNonInheritedField(this, jp);
        }

        @Override
        @Test
        public void findArrayOfType(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindFieldsTest.DefaultImpls.findArrayOfType(this, jp);
        }

        @Override
        @Test
        public void skipsMultiCatches(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindFieldsTest.DefaultImpls.skipsMultiCatches(this, jp);
        }

        @Override
        @Test
        public void checkValidation() {
            FindFieldsTest.DefaultImpls.checkValidation(this);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return FindFieldsTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            FindFieldsTest.DefaultImpls.assertChanged((FindFieldsTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            FindFieldsTest.DefaultImpls.assertChanged((FindFieldsTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            FindFieldsTest.DefaultImpls.assertChanged((FindFieldsTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            FindFieldsTest.DefaultImpls.assertChanged((FindFieldsTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            FindFieldsTest.DefaultImpls.assertUnchanged((FindFieldsTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            FindFieldsTest.DefaultImpls.assertUnchanged((FindFieldsTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Recipe getRecipe() {
            return FindFieldsTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return FindFieldsTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return FindFieldsTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$FindInheritedFieldsTck;", "Lorg/openrewrite/java/search/FindInheritedFieldsTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class FindInheritedFieldsTck
    implements FindInheritedFieldsTest {
        @Override
        @Test
        public void findInheritedField(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindInheritedFieldsTest.DefaultImpls.findInheritedField(this, jp);
        }

        @Override
        @Test
        public void findArrayOfType(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindInheritedFieldsTest.DefaultImpls.findArrayOfType(this, jp);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$FindMethodsTck;", "Lorg/openrewrite/java/search/FindMethodsTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class FindMethodsTck
    implements FindMethodsTest {
        @Override
        @Test
        public void findMethodReferences(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindMethodsTest.DefaultImpls.findMethodReferences(this, jp);
        }

        @Override
        @Test
        public void findStaticMethodCalls(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindMethodsTest.DefaultImpls.findStaticMethodCalls(this, jp);
        }

        @Override
        @Test
        public void findStaticallyImportedMethodCalls(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindMethodsTest.DefaultImpls.findStaticallyImportedMethodCalls(this, jp);
        }

        @Override
        @Test
        public void matchVarargs(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindMethodsTest.DefaultImpls.matchVarargs(this, jp);
        }

        @Override
        @Test
        public void matchOnInnerClass(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindMethodsTest.DefaultImpls.matchOnInnerClass(this, jp);
        }

        @Override
        @Test
        public void checkValidation() {
            FindMethodsTest.DefaultImpls.checkValidation(this);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return FindMethodsTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            FindMethodsTest.DefaultImpls.assertChanged((FindMethodsTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            FindMethodsTest.DefaultImpls.assertChanged((FindMethodsTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            FindMethodsTest.DefaultImpls.assertChanged((FindMethodsTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            FindMethodsTest.DefaultImpls.assertChanged((FindMethodsTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            FindMethodsTest.DefaultImpls.assertUnchanged((FindMethodsTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            FindMethodsTest.DefaultImpls.assertUnchanged((FindMethodsTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Recipe getRecipe() {
            return FindMethodsTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return FindMethodsTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return FindMethodsTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$FindTypesTck;", "Lorg/openrewrite/java/search/FindTypesTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class FindTypesTck
    implements FindTypesTest {
        @Override
        @NotNull
        public FindTypes getRecipe() {
            return FindTypesTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Test
        public void simpleName(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindTypesTest.DefaultImpls.simpleName(this, jp);
        }

        @Override
        @Test
        public void fullyQualifiedName(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindTypesTest.DefaultImpls.fullyQualifiedName(this, jp);
        }

        @Override
        @Test
        public void annotation(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindTypesTest.DefaultImpls.annotation(this, jp);
        }

        @Override
        @Test
        public void array(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindTypesTest.DefaultImpls.array(this, jp);
        }

        @Override
        @Test
        public void classDecl(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindTypesTest.DefaultImpls.classDecl(this, jp);
        }

        @Override
        @Test
        public void method(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindTypesTest.DefaultImpls.method(this, jp);
        }

        @Override
        @Test
        public void methodInvocationTypeParametersAndWildcard(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindTypesTest.DefaultImpls.methodInvocationTypeParametersAndWildcard(this, jp);
        }

        @Override
        @Test
        public void multiCatch(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindTypesTest.DefaultImpls.multiCatch(this, jp);
        }

        @Override
        @Test
        public void multiVariable(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindTypesTest.DefaultImpls.multiVariable(this, jp);
        }

        @Override
        @Test
        public void newClass(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindTypesTest.DefaultImpls.newClass(this, jp);
        }

        @Override
        @Test
        public void parameterizedType(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindTypesTest.DefaultImpls.parameterizedType(this, jp);
        }

        @Override
        @Test
        public void typeCast(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindTypesTest.DefaultImpls.typeCast(this, jp);
        }

        @Override
        @Test
        public void classReference(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindTypesTest.DefaultImpls.classReference(this, jp);
        }

        @Override
        @Test
        public void checkValidation() {
            FindTypesTest.DefaultImpls.checkValidation(this);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return FindTypesTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            FindTypesTest.DefaultImpls.assertChanged((FindTypesTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            FindTypesTest.DefaultImpls.assertChanged((FindTypesTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            FindTypesTest.DefaultImpls.assertChanged((FindTypesTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            FindTypesTest.DefaultImpls.assertChanged((FindTypesTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            FindTypesTest.DefaultImpls.assertUnchanged((FindTypesTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            FindTypesTest.DefaultImpls.assertUnchanged((FindTypesTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return FindTypesTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return FindTypesTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$HideUtilityClassConstructorTck;", "Lorg/openrewrite/java/cleanup/HideUtilityClassConstructorTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class HideUtilityClassConstructorTck
    implements HideUtilityClassConstructorTest {
        @Override
        @Nullable
        public Recipe getRecipe() {
            return HideUtilityClassConstructorTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Test
        public void changePublicConstructorToPrivate(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            HideUtilityClassConstructorTest.DefaultImpls.changePublicConstructorToPrivate(this, jp);
        }

        @Override
        @Test
        public void changePackagePrivateConstructorToPrivate(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            HideUtilityClassConstructorTest.DefaultImpls.changePackagePrivateConstructorToPrivate(this, jp);
        }

        @Override
        @Test
        public void identifyUtilityClassesWithProtectedConstructor(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            HideUtilityClassConstructorTest.DefaultImpls.identifyUtilityClassesWithProtectedConstructor(this, jp);
        }

        @Override
        @Test
        public void changeUtilityClassesWithMixedExposedConstructors(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            HideUtilityClassConstructorTest.DefaultImpls.changeUtilityClassesWithMixedExposedConstructors(this, jp);
        }

        @Override
        @Test
        public void addPrivateConstructorWhenOnlyDefaultConstructor(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            HideUtilityClassConstructorTest.DefaultImpls.addPrivateConstructorWhenOnlyDefaultConstructor(this, jp);
        }

        @Override
        @Test
        public void ignoreClassesWithMainMethod(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            HideUtilityClassConstructorTest.DefaultImpls.ignoreClassesWithMainMethod(this, jp);
        }

        @Override
        @Test
        public void identifyUtilityClassesOnlyStaticFields(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            HideUtilityClassConstructorTest.DefaultImpls.identifyUtilityClassesOnlyStaticFields(this, jp);
        }

        @Override
        @Test
        public void identifyNonUtilityClassesWhenImplementsInterface(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            HideUtilityClassConstructorTest.DefaultImpls.identifyNonUtilityClassesWhenImplementsInterface(this, jp);
        }

        @Override
        @Test
        public void identifyNonUtilityClassesWhenExtendsClass(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            HideUtilityClassConstructorTest.DefaultImpls.identifyNonUtilityClassesWhenExtendsClass(this, jp);
        }

        @Override
        @Test
        public void identifyNonUtilityClassesMixedFields(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            HideUtilityClassConstructorTest.DefaultImpls.identifyNonUtilityClassesMixedFields(this, jp);
        }

        @Override
        @Test
        public void identifyUtilityClassesOnlyStaticMethods(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            HideUtilityClassConstructorTest.DefaultImpls.identifyUtilityClassesOnlyStaticMethods(this, jp);
        }

        @Override
        @Test
        public void identifyUtilityClassesInnerStaticClasses(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            HideUtilityClassConstructorTest.DefaultImpls.identifyUtilityClassesInnerStaticClasses(this, jp);
        }

        @Override
        @Test
        public void identifyNonUtilityClassesMixedMethods(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            HideUtilityClassConstructorTest.DefaultImpls.identifyNonUtilityClassesMixedMethods(this, jp);
        }

        @Override
        @Test
        public void identifyUtilityClassesOnlyStaticMethodsAndAbstractClass(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            HideUtilityClassConstructorTest.DefaultImpls.identifyUtilityClassesOnlyStaticMethodsAndAbstractClass(this, jp);
        }

        @Override
        @Test
        public void identifyNonUtilityClassesOnlyPublicConstructor(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            HideUtilityClassConstructorTest.DefaultImpls.identifyNonUtilityClassesOnlyPublicConstructor(this, jp);
        }

        @Override
        @Test
        public void identifyNonUtilityClassesTotallyEmpty(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            HideUtilityClassConstructorTest.DefaultImpls.identifyNonUtilityClassesTotallyEmpty(this, jp);
        }

        @Override
        @Test
        public void identifySuppressedUtilityClasses(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            HideUtilityClassConstructorTest.DefaultImpls.identifySuppressedUtilityClasses(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return HideUtilityClassConstructorTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            HideUtilityClassConstructorTest.DefaultImpls.assertChanged((HideUtilityClassConstructorTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            HideUtilityClassConstructorTest.DefaultImpls.assertChanged((HideUtilityClassConstructorTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            HideUtilityClassConstructorTest.DefaultImpls.assertChanged((HideUtilityClassConstructorTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            HideUtilityClassConstructorTest.DefaultImpls.assertChanged((HideUtilityClassConstructorTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            HideUtilityClassConstructorTest.DefaultImpls.assertUnchanged((HideUtilityClassConstructorTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            HideUtilityClassConstructorTest.DefaultImpls.assertUnchanged((HideUtilityClassConstructorTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return HideUtilityClassConstructorTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return HideUtilityClassConstructorTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$ImplementInterfaceTck;", "Lorg/openrewrite/java/ImplementInterfaceTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class ImplementInterfaceTck
    implements ImplementInterfaceTest {
        @Override
        @Nullable
        public Recipe getRecipe() {
            return ImplementInterfaceTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Test
        public void firstImplementedInterface(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ImplementInterfaceTest.DefaultImpls.firstImplementedInterface(this, jp);
        }

        @Override
        @Test
        public void addAnImplementedInterface(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ImplementInterfaceTest.DefaultImpls.addAnImplementedInterface(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return ImplementInterfaceTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            ImplementInterfaceTest.DefaultImpls.assertChanged((ImplementInterfaceTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            ImplementInterfaceTest.DefaultImpls.assertChanged((ImplementInterfaceTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            ImplementInterfaceTest.DefaultImpls.assertChanged((ImplementInterfaceTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            ImplementInterfaceTest.DefaultImpls.assertChanged((ImplementInterfaceTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            ImplementInterfaceTest.DefaultImpls.assertUnchanged((ImplementInterfaceTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            ImplementInterfaceTest.DefaultImpls.assertUnchanged((ImplementInterfaceTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return ImplementInterfaceTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return ImplementInterfaceTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$JavaTemplateTck;", "Lorg/openrewrite/java/JavaTemplateTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class JavaTemplateTck
    implements JavaTemplateTest {
        @Override
        @Test
        public void addMethodAnnotationTest(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.addMethodAnnotationTest(this, jp);
        }

        @Override
        @Test
        public void replaceMethodArgumentsTest(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.replaceMethodArgumentsTest(this, jp);
        }

        @Override
        @Test
        public void addStatementBeforeAnotherStatement(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.addStatementBeforeAnotherStatement(this, jp);
        }

        @Override
        @Test
        public void beforeStatements(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.beforeStatements(this, jp);
        }

        @Override
        @Test
        public void lastInMethodBodyStatement(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.lastInMethodBodyStatement(this, jp);
        }

        @Override
        @Test
        public void addToEmptyMethodBody(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.addToEmptyMethodBody(this, jp);
        }

        @Override
        @Test
        public void addMethodToClass(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.addMethodToClass(this, jp);
        }

        @Override
        @Test
        public void addImportToTemplate(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.addImportToTemplate(this, jp);
        }

        @Override
        @Test
        public void addStaticImportToTemplate(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.addStaticImportToTemplate(this, jp);
        }

        @Override
        @Test
        public void addStaticMethodToClass(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.addStaticMethodToClass(this, jp);
        }

        @Override
        @Test
        public void changeMethodInvocations(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.changeMethodInvocations(this, jp);
        }

        @Override
        @Test
        public void addAnnotationToMethod(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.addAnnotationToMethod(this, jp);
        }

        @Override
        @Test
        public void replaceAnnotation(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.replaceAnnotation(this, jp);
        }

        @Override
        @Test
        public void replaceAnnotationOnClass(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.replaceAnnotationOnClass(this, jp);
        }

        @Override
        @Test
        public void replaceAnnotationOnClassWithCommentsAndAnnotations(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.replaceAnnotationOnClassWithCommentsAndAnnotations(this, jp);
        }

        @Override
        @Test
        public void addAnnotationToClass(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.addAnnotationToClass(this, jp);
        }

        @Override
        @Test
        public void addAnnotationToClassWithImports(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.addAnnotationToClassWithImports(this, jp);
        }

        @Override
        @Test
        public void templateWithLocalMethodReference(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.templateWithLocalMethodReference(this, jp);
        }

        @Override
        @Test
        public void templateWithSiblingClassMethodReference(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.templateWithSiblingClassMethodReference(this, jp);
        }

        @Override
        @Test
        public void templateMethodIntoClass(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.templateMethodIntoClass(this, jp);
        }

        @Override
        @Test
        public void replaceClassTypeParameters(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.replaceClassTypeParameters(this, jp);
        }

        @Override
        @Test
        public void replaceClassExtends(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.replaceClassExtends(this, jp);
        }

        @Override
        @Test
        public void replaceClassImplements(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.replaceClassImplements(this, jp);
        }

        @Override
        @Test
        public void replaceClassBody(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.replaceClassBody(this, jp);
        }

        @Override
        @Test
        public void replaceMethodDeclarationTypeParameters(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.replaceMethodDeclarationTypeParameters(this, jp);
        }

        @Override
        @Test
        public void replaceMethodDeclarationParameters(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.replaceMethodDeclarationParameters(this, jp);
        }

        @Override
        @Test
        public void addMethodDeclarationParameters(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.addMethodDeclarationParameters(this, jp);
        }

        @Override
        @Test
        public void replaceMethodDeclarationThrows(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.replaceMethodDeclarationThrows(this, jp);
        }

        @Override
        @Test
        public void replaceMethodInvocationArguments(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaTemplateTest.DefaultImpls.replaceMethodInvocationArguments(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return JavaTemplateTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaTemplateTest.DefaultImpls.assertChanged((JavaTemplateTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaTemplateTest.DefaultImpls.assertChanged((JavaTemplateTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaTemplateTest.DefaultImpls.assertChanged((JavaTemplateTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaTemplateTest.DefaultImpls.assertChanged((JavaTemplateTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaTemplateTest.DefaultImpls.assertUnchanged((JavaTemplateTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaTemplateTest.DefaultImpls.assertUnchanged((JavaTemplateTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Recipe getRecipe() {
            return JavaTemplateTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return JavaTemplateTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return JavaTemplateTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$MinimumViableSpacingTck;", "Lorg/openrewrite/java/format/MinimumViableSpacingTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class MinimumViableSpacingTck
    implements MinimumViableSpacingTest {
        @Override
        @NotNull
        public Recipe getRecipe() {
            return MinimumViableSpacingTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Test
        public void method(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            MinimumViableSpacingTest.DefaultImpls.method(this, jp);
        }

        @Override
        @Test
        public void returnExpression(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            MinimumViableSpacingTest.DefaultImpls.returnExpression(this, jp);
        }

        @Override
        @Test
        public void variableDeclarationsInClass(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            MinimumViableSpacingTest.DefaultImpls.variableDeclarationsInClass(this, jp);
        }

        @Override
        @Test
        public void variableDeclarationsInMethod(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            MinimumViableSpacingTest.DefaultImpls.variableDeclarationsInMethod(this, jp);
        }

        @Override
        @Test
        public void variableDeclarationsInForLoops(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            MinimumViableSpacingTest.DefaultImpls.variableDeclarationsInForLoops(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return MinimumViableSpacingTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            MinimumViableSpacingTest.DefaultImpls.assertChanged((MinimumViableSpacingTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            MinimumViableSpacingTest.DefaultImpls.assertChanged((MinimumViableSpacingTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            MinimumViableSpacingTest.DefaultImpls.assertChanged((MinimumViableSpacingTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            MinimumViableSpacingTest.DefaultImpls.assertChanged((MinimumViableSpacingTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            MinimumViableSpacingTest.DefaultImpls.assertUnchanged((MinimumViableSpacingTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            MinimumViableSpacingTest.DefaultImpls.assertUnchanged((MinimumViableSpacingTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return MinimumViableSpacingTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return MinimumViableSpacingTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$NormalizeFormatTck;", "Lorg/openrewrite/java/format/NormalizeFormatTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class NormalizeFormatTck
    implements NormalizeFormatTest {
        @Override
        @Test
        public void removeAnnotationFromMethod(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            NormalizeFormatTest.DefaultImpls.removeAnnotationFromMethod(this, jp);
        }

        @Override
        @Test
        public void removeAnnotationFromClass(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            NormalizeFormatTest.DefaultImpls.removeAnnotationFromClass(this, jp);
        }

        @Override
        @Test
        public void removeAnnotationFromVariable(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            NormalizeFormatTest.DefaultImpls.removeAnnotationFromVariable(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return NormalizeFormatTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            NormalizeFormatTest.DefaultImpls.assertChanged((NormalizeFormatTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            NormalizeFormatTest.DefaultImpls.assertChanged((NormalizeFormatTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            NormalizeFormatTest.DefaultImpls.assertChanged((NormalizeFormatTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            NormalizeFormatTest.DefaultImpls.assertChanged((NormalizeFormatTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            NormalizeFormatTest.DefaultImpls.assertUnchanged((NormalizeFormatTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            NormalizeFormatTest.DefaultImpls.assertUnchanged((NormalizeFormatTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Recipe getRecipe() {
            return NormalizeFormatTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return NormalizeFormatTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return NormalizeFormatTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$OrderImportsTck;", "Lorg/openrewrite/java/OrderImportsTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class OrderImportsTck
    implements OrderImportsTest {
        @Override
        @NotNull
        public OrderImports getRecipe() {
            return OrderImportsTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Test
        public void orderImports(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImportsTest.DefaultImpls.orderImports(this, jp);
        }

        @Override
        @Test
        public void blankLineThenEmptyBlockThenNonEmptyBlock(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImportsTest.DefaultImpls.blankLineThenEmptyBlockThenNonEmptyBlock(this, jp);
        }

        @Override
        @Test
        public void foldIntoStar(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImportsTest.DefaultImpls.foldIntoStar(this, jp);
        }

        @Override
        @Test
        public void blankLinesNotFollowedByBlockArentAdded(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImportsTest.DefaultImpls.blankLinesNotFollowedByBlockArentAdded(this, jp);
        }

        @Override
        @Test
        public void foldIntoExistingStar(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImportsTest.DefaultImpls.foldIntoExistingStar(this, jp);
        }

        @Override
        @Test
        public void idempotence(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImportsTest.DefaultImpls.idempotence(this, jp);
        }

        @Override
        @Test
        public void unfoldStar(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImportsTest.DefaultImpls.unfoldStar(this, jp);
        }

        @Override
        @Test
        public void unfoldStarMultiple(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImportsTest.DefaultImpls.unfoldStarMultiple(this, jp);
        }

        @Override
        @Test
        public void removeUnused(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImportsTest.DefaultImpls.removeUnused(this, jp);
        }

        @Override
        @Test
        public void unfoldStaticStar(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImportsTest.DefaultImpls.unfoldStaticStar(this, jp);
        }

        @Override
        @Test
        public void packagePatternEscapesDots(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImportsTest.DefaultImpls.packagePatternEscapesDots(this, jp);
        }

        @Override
        @Test
        public void twoImportsFollowedByStar(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImportsTest.DefaultImpls.twoImportsFollowedByStar(this, jp);
        }

        @Override
        @Test
        public void springCloudFormat() {
            OrderImportsTest.DefaultImpls.springCloudFormat(this);
        }

        @Override
        @Test
        public void importSorting(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImportsTest.DefaultImpls.importSorting(this, jp);
        }

        @Override
        @Test
        public void foldGroupOfStaticImportsThatAppearLast(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImportsTest.DefaultImpls.foldGroupOfStaticImportsThatAppearLast(this, jp);
        }

        @Override
        @Test
        public void preservesStaticStarImportWhenRemovingUnused(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImportsTest.DefaultImpls.preservesStaticStarImportWhenRemovingUnused(this, jp);
        }

        @Override
        @Test
        public void preservesStaticInheritanceImport(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImportsTest.DefaultImpls.preservesStaticInheritanceImport(this, jp);
        }

        @Override
        @Test
        public void preservesStaticMethodArguments(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImportsTest.DefaultImpls.preservesStaticMethodArguments(this, jp);
        }

        @Override
        @Test
        public void preservesDifferentStaticImportsFromSamePackage(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImportsTest.DefaultImpls.preservesDifferentStaticImportsFromSamePackage(this, jp);
        }

        @Override
        @Test
        public void collapsesDifferentStaticImportsFromSamePackage(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImportsTest.DefaultImpls.collapsesDifferentStaticImportsFromSamePackage(this, jp);
        }

        @Override
        @Test
        public void removesRedundantImports(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImportsTest.DefaultImpls.removesRedundantImports(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return OrderImportsTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            OrderImportsTest.DefaultImpls.assertChanged((OrderImportsTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            OrderImportsTest.DefaultImpls.assertChanged((OrderImportsTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            OrderImportsTest.DefaultImpls.assertChanged((OrderImportsTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            OrderImportsTest.DefaultImpls.assertChanged((OrderImportsTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            OrderImportsTest.DefaultImpls.assertUnchanged((OrderImportsTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            OrderImportsTest.DefaultImpls.assertUnchanged((OrderImportsTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return OrderImportsTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return OrderImportsTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$RemoveUnusedImportsTck;", "Lorg/openrewrite/java/RemoveUnusedImportsTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class RemoveUnusedImportsTck
    implements RemoveUnusedImportsTest {
        @Override
        @NotNull
        public RecipeTest.AdHocRecipe removeImport(@NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return RemoveUnusedImportsTest.DefaultImpls.removeImport(this, type);
        }

        @Override
        @Test
        public void removeNamedImport(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveUnusedImportsTest.DefaultImpls.removeNamedImport(this, jp);
        }

        @Override
        @Test
        public void leaveImportIfRemovedTypeIsStillReferredTo(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveUnusedImportsTest.DefaultImpls.leaveImportIfRemovedTypeIsStillReferredTo(this, jp);
        }

        @Override
        @Test
        public void removeStarImportIfNoTypesReferredTo(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveUnusedImportsTest.DefaultImpls.removeStarImportIfNoTypesReferredTo(this, jp);
        }

        @Override
        @Test
        public void replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveUnusedImportsTest.DefaultImpls.replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains(this, jp);
        }

        @Override
        @Test
        public void leaveStarImportInPlaceIfTwoOrMoreTypesStillReferredTo(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveUnusedImportsTest.DefaultImpls.leaveStarImportInPlaceIfTwoOrMoreTypesStillReferredTo(this, jp);
        }

        @Override
        @Test
        public void removeStarStaticImport(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveUnusedImportsTest.DefaultImpls.removeStarStaticImport(this, jp);
        }

        @Override
        @Test
        public void leaveStarStaticImportIfReferenceStillExists(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveUnusedImportsTest.DefaultImpls.leaveStarStaticImportIfReferenceStillExists(this, jp);
        }

        @Override
        @Test
        public void removeStaticImportIfNotReferenced(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveUnusedImportsTest.DefaultImpls.removeStaticImportIfNotReferenced(this, jp);
        }

        @Override
        @Test
        public void leaveNamedStaticImportIfReferenceStillExists(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveUnusedImportsTest.DefaultImpls.leaveNamedStaticImportIfReferenceStillExists(this, jp);
        }

        @Override
        @Test
        public void leaveNamedStaticImportOnFieldIfReferenceStillExists(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveUnusedImportsTest.DefaultImpls.leaveNamedStaticImportOnFieldIfReferenceStillExists(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return RemoveUnusedImportsTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RemoveUnusedImportsTest.DefaultImpls.assertChanged((RemoveUnusedImportsTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RemoveUnusedImportsTest.DefaultImpls.assertChanged((RemoveUnusedImportsTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RemoveUnusedImportsTest.DefaultImpls.assertChanged((RemoveUnusedImportsTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RemoveUnusedImportsTest.DefaultImpls.assertChanged((RemoveUnusedImportsTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RemoveUnusedImportsTest.DefaultImpls.assertUnchanged((RemoveUnusedImportsTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RemoveUnusedImportsTest.DefaultImpls.assertUnchanged((RemoveUnusedImportsTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Recipe getRecipe() {
            return RemoveUnusedImportsTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return RemoveUnusedImportsTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return RemoveUnusedImportsTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$RenameVariableTck;", "Lorg/openrewrite/java/RenameVariableTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class RenameVariableTck
    implements RenameVariableTest {
        @Override
        @Test
        public void renameVariable(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RenameVariableTest.DefaultImpls.renameVariable(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return RenameVariableTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RenameVariableTest.DefaultImpls.assertChanged((RenameVariableTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RenameVariableTest.DefaultImpls.assertChanged((RenameVariableTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RenameVariableTest.DefaultImpls.assertChanged((RenameVariableTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RenameVariableTest.DefaultImpls.assertChanged((RenameVariableTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RenameVariableTest.DefaultImpls.assertUnchanged((RenameVariableTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RenameVariableTest.DefaultImpls.assertUnchanged((RenameVariableTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Recipe getRecipe() {
            return RenameVariableTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return RenameVariableTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return RenameVariableTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$ReorderMethodArgumentsTck;", "Lorg/openrewrite/java/ReorderMethodArgumentsTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class ReorderMethodArgumentsTck
    implements ReorderMethodArgumentsTest {
        @Override
        @Test
        public void reorderArguments(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ReorderMethodArgumentsTest.DefaultImpls.reorderArguments(this, jp);
        }

        @Override
        @Test
        public void reorderArgumentsWithNoSourceAttachment(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ReorderMethodArgumentsTest.DefaultImpls.reorderArgumentsWithNoSourceAttachment(this, jp);
        }

        @Override
        @Test
        public void reorderArgumentsWhereOneOfTheOriginalArgumentsIsVararg(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ReorderMethodArgumentsTest.DefaultImpls.reorderArgumentsWhereOneOfTheOriginalArgumentsIsVararg(this, jp);
        }

        @Override
        @Test
        public void reorderArgumentsWhereTheLastArgumentIsVarargAndNotPresentInInvocation(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ReorderMethodArgumentsTest.DefaultImpls.reorderArgumentsWhereTheLastArgumentIsVarargAndNotPresentInInvocation(this, jp);
        }

        @Override
        @Test
        public void checkValidation() {
            ReorderMethodArgumentsTest.DefaultImpls.checkValidation(this);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return ReorderMethodArgumentsTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            ReorderMethodArgumentsTest.DefaultImpls.assertChanged((ReorderMethodArgumentsTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            ReorderMethodArgumentsTest.DefaultImpls.assertChanged((ReorderMethodArgumentsTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            ReorderMethodArgumentsTest.DefaultImpls.assertChanged((ReorderMethodArgumentsTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            ReorderMethodArgumentsTest.DefaultImpls.assertChanged((ReorderMethodArgumentsTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            ReorderMethodArgumentsTest.DefaultImpls.assertUnchanged((ReorderMethodArgumentsTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            ReorderMethodArgumentsTest.DefaultImpls.assertUnchanged((ReorderMethodArgumentsTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Recipe getRecipe() {
            return ReorderMethodArgumentsTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return ReorderMethodArgumentsTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return ReorderMethodArgumentsTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$RemoveTrailingWhitespaceTck;", "Lorg/openrewrite/java/format/RemoveTrailingWhitespaceTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class RemoveTrailingWhitespaceTck
    implements RemoveTrailingWhitespaceTest {
        @Override
        @Test
        public void removeTrailing(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveTrailingWhitespaceTest.DefaultImpls.removeTrailing(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return RemoveTrailingWhitespaceTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RemoveTrailingWhitespaceTest.DefaultImpls.assertChanged((RemoveTrailingWhitespaceTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RemoveTrailingWhitespaceTest.DefaultImpls.assertChanged((RemoveTrailingWhitespaceTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RemoveTrailingWhitespaceTest.DefaultImpls.assertChanged((RemoveTrailingWhitespaceTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RemoveTrailingWhitespaceTest.DefaultImpls.assertChanged((RemoveTrailingWhitespaceTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RemoveTrailingWhitespaceTest.DefaultImpls.assertUnchanged((RemoveTrailingWhitespaceTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RemoveTrailingWhitespaceTest.DefaultImpls.assertUnchanged((RemoveTrailingWhitespaceTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Recipe getRecipe() {
            return RemoveTrailingWhitespaceTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return RemoveTrailingWhitespaceTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return RemoveTrailingWhitespaceTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$SemanticallyEqualTck;", "Lorg/openrewrite/java/search/SemanticallyEqualTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class SemanticallyEqualTck
    implements SemanticallyEqualTest {
        @Override
        @Disabled
        @Test
        public void fullyQualifiedReference(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SemanticallyEqualTest.DefaultImpls.fullyQualifiedReference(this, jp);
        }

        @Override
        @Test
        public void noArgumentsTest(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SemanticallyEqualTest.DefaultImpls.noArgumentsTest(this, jp);
        }

        @Override
        @Test
        public void tagAnnotationEquality(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SemanticallyEqualTest.DefaultImpls.tagAnnotationEquality(this, jp);
        }

        @Override
        @Test
        public void annotationEquality(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SemanticallyEqualTest.DefaultImpls.annotationEquality(this, jp);
        }

        @Override
        @Test
        public void identEquality(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SemanticallyEqualTest.DefaultImpls.identEquality(this, jp);
        }

        @Override
        @Test
        public void fieldAccessEquality(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SemanticallyEqualTest.DefaultImpls.fieldAccessEquality(this, jp);
        }

        @Override
        @Test
        public void assignEquality(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SemanticallyEqualTest.DefaultImpls.assignEquality(this, jp);
        }

        @Override
        @Test
        public void literalEquality(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SemanticallyEqualTest.DefaultImpls.literalEquality(this, jp);
        }

        @Override
        @Test
        public void typeEqualityDependsOnlyOnFqn(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SemanticallyEqualTest.DefaultImpls.typeEqualityDependsOnlyOnFqn(this, jp);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$SimplifyBooleanExpressionTck;", "Lorg/openrewrite/java/cleanup/SimplifyBooleanExpressionTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class SimplifyBooleanExpressionTck
    implements SimplifyBooleanExpressionTest {
        @Override
        @Nullable
        public Recipe getRecipe() {
            return SimplifyBooleanExpressionTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Test
        public void simplifyBooleanExpressionComprehensive(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SimplifyBooleanExpressionTest.DefaultImpls.simplifyBooleanExpressionComprehensive(this, jp);
        }

        @Override
        @Test
        public void simplifyInvertedBooleanLiteral(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SimplifyBooleanExpressionTest.DefaultImpls.simplifyInvertedBooleanLiteral(this, jp);
        }

        @Override
        @Test
        public void simplifyEqualsLiteralTrue(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SimplifyBooleanExpressionTest.DefaultImpls.simplifyEqualsLiteralTrue(this, jp);
        }

        @Override
        @Test
        public void simplifyOrLiteralTrue(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SimplifyBooleanExpressionTest.DefaultImpls.simplifyOrLiteralTrue(this, jp);
        }

        @Override
        @Test
        public void simplifyOrAlwaysTrue(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SimplifyBooleanExpressionTest.DefaultImpls.simplifyOrAlwaysTrue(this, jp);
        }

        @Override
        @Test
        public void simplifyAndAlwaysTrue(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SimplifyBooleanExpressionTest.DefaultImpls.simplifyAndAlwaysTrue(this, jp);
        }

        @Override
        @Test
        public void simplifyEqualsLiteralTrueAlwaysTrue(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SimplifyBooleanExpressionTest.DefaultImpls.simplifyEqualsLiteralTrueAlwaysTrue(this, jp);
        }

        @Override
        @Test
        public void simplifyLiteralFalseAlwaysFalse(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SimplifyBooleanExpressionTest.DefaultImpls.simplifyLiteralFalseAlwaysFalse(this, jp);
        }

        @Override
        @Test
        public void simplifyDoubleNegation(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SimplifyBooleanExpressionTest.DefaultImpls.simplifyDoubleNegation(this, jp);
        }

        @Override
        @Test
        public void simplifyNotEqualsFalse(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SimplifyBooleanExpressionTest.DefaultImpls.simplifyNotEqualsFalse(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return SimplifyBooleanExpressionTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            SimplifyBooleanExpressionTest.DefaultImpls.assertChanged((SimplifyBooleanExpressionTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            SimplifyBooleanExpressionTest.DefaultImpls.assertChanged((SimplifyBooleanExpressionTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            SimplifyBooleanExpressionTest.DefaultImpls.assertChanged((SimplifyBooleanExpressionTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            SimplifyBooleanExpressionTest.DefaultImpls.assertChanged((SimplifyBooleanExpressionTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            SimplifyBooleanExpressionTest.DefaultImpls.assertUnchanged((SimplifyBooleanExpressionTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            SimplifyBooleanExpressionTest.DefaultImpls.assertUnchanged((SimplifyBooleanExpressionTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return SimplifyBooleanExpressionTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return SimplifyBooleanExpressionTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$SimplifyBooleanReturnTck;", "Lorg/openrewrite/java/cleanup/SimplifyBooleanReturnTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class SimplifyBooleanReturnTck
    implements SimplifyBooleanReturnTest {
        @Override
        @Nullable
        public Recipe getRecipe() {
            return SimplifyBooleanReturnTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Test
        public void simplifyBooleanReturn(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SimplifyBooleanReturnTest.DefaultImpls.simplifyBooleanReturn(this, jp);
        }

        @Override
        @Test
        public void dontSimplifyToReturnUnlessLastStatement(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SimplifyBooleanReturnTest.DefaultImpls.dontSimplifyToReturnUnlessLastStatement(this, jp);
        }

        @Override
        @Test
        public void nestedIfsWithNoBlock(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SimplifyBooleanReturnTest.DefaultImpls.nestedIfsWithNoBlock(this, jp);
        }

        @Override
        @Test
        public void dontAlterWhenElseIfPresent(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SimplifyBooleanReturnTest.DefaultImpls.dontAlterWhenElseIfPresent(this, jp);
        }

        @Override
        @Test
        public void dontAlterWhenElseContainsSomethingOtherThanReturn(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SimplifyBooleanReturnTest.DefaultImpls.dontAlterWhenElseContainsSomethingOtherThanReturn(this, jp);
        }

        @Override
        @Test
        public void onlySimplifyToReturnWhenLastStatement(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SimplifyBooleanReturnTest.DefaultImpls.onlySimplifyToReturnWhenLastStatement(this, jp);
        }

        @Override
        @Test
        public void wrapNotReturnsOfTernaryIfConditionsInParentheses(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SimplifyBooleanReturnTest.DefaultImpls.wrapNotReturnsOfTernaryIfConditionsInParentheses(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return SimplifyBooleanReturnTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            SimplifyBooleanReturnTest.DefaultImpls.assertChanged((SimplifyBooleanReturnTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            SimplifyBooleanReturnTest.DefaultImpls.assertChanged((SimplifyBooleanReturnTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            SimplifyBooleanReturnTest.DefaultImpls.assertChanged((SimplifyBooleanReturnTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            SimplifyBooleanReturnTest.DefaultImpls.assertChanged((SimplifyBooleanReturnTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            SimplifyBooleanReturnTest.DefaultImpls.assertUnchanged((SimplifyBooleanReturnTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            SimplifyBooleanReturnTest.DefaultImpls.assertUnchanged((SimplifyBooleanReturnTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return SimplifyBooleanReturnTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return SimplifyBooleanReturnTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$SpacesTck;", "Lorg/openrewrite/java/format/SpacesTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class SpacesTck
    implements SpacesTest {
        @Override
        @Nullable
        public Recipe getRecipe() {
            return SpacesTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @NotNull
        public Iterable<NamedStyles> namedStyles(@NotNull Collection<? extends Style> styles) {
            Intrinsics.checkNotNullParameter(styles, (String)"styles");
            return SpacesTest.DefaultImpls.namedStyles(this, styles);
        }

        @Override
        @Test
        public void beforeParensMethodDeclarationTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeParensMethodDeclarationTrue(this, jp);
        }

        @Override
        @Test
        public void beforeClassBody(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeClassBody(this, jp);
        }

        @Override
        @Test
        public void beforeParensMethodDeclarationFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeParensMethodDeclarationFalse(this, jp);
        }

        @Override
        @Test
        public void beforeParensMethodCallTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeParensMethodCallTrue(this, jp);
        }

        @Override
        @Test
        public void beforeParensMethodCallFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeParensMethodCallFalse(this, jp);
        }

        @Override
        @Test
        public void beforeParensIfParenthesesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeParensIfParenthesesFalse(this, jp);
        }

        @Override
        @Test
        public void beforeParensIfParenthesesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeParensIfParenthesesTrue(this, jp);
        }

        @Override
        @Test
        public void beforeParensForParenthesesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeParensForParenthesesFalse(this, jp);
        }

        @Override
        @Test
        public void beforeParensForParenthesesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeParensForParenthesesTrue(this, jp);
        }

        @Override
        @Test
        public void beforeParensWhileParenthesesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeParensWhileParenthesesFalse(this, jp);
        }

        @Override
        @Test
        public void beforeParensWhileParenthesesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeParensWhileParenthesesTrue(this, jp);
        }

        @Override
        @Test
        public void beforeParensSwitchParenthesesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeParensSwitchParenthesesFalse(this, jp);
        }

        @Override
        @Test
        public void beforeParensSwitchParenthesesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeParensSwitchParenthesesTrue(this, jp);
        }

        @Override
        @NotNull
        public String[] getTryResource() {
            return SpacesTest.DefaultImpls.getTryResource(this);
        }

        @Override
        @Test
        public void beforeParensTryParenthesesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeParensTryParenthesesFalse(this, jp);
        }

        @Override
        @Test
        public void beforeParensTryParenthesesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeParensTryParenthesesTrue(this, jp);
        }

        @Override
        @Test
        public void beforeParensCatchParenthesesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeParensCatchParenthesesFalse(this, jp);
        }

        @Override
        @Test
        public void beforeParensCatchParenthesesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeParensCatchParenthesesTrue(this, jp);
        }

        @Override
        @Test
        public void beforeParensSynchronizedParenthesesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeParensSynchronizedParenthesesFalse(this, jp);
        }

        @Override
        @Test
        public void beforeParensSynchronizedParenthesesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeParensSynchronizedParenthesesTrue(this, jp);
        }

        @Override
        @Test
        public void beforeParensAnnotationParametersTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeParensAnnotationParametersTrue(this, jp);
        }

        @Override
        @Test
        public void beforeParensAnnotationParametersFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeParensAnnotationParametersFalse(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsAssignmentFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsAssignmentFalse(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsAssignmentTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsAssignmentTrue(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsLogicalFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsLogicalFalse(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsLogicalTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsLogicalTrue(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsEqualityFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsEqualityFalse(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsEqualityTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsEqualityTrue(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsRelationalFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsRelationalFalse(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsRelationalTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsRelationalTrue(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsBitwiseFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsBitwiseFalse(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsBitwiseTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsBitwiseTrue(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsAdditiveFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsAdditiveFalse(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsAdditiveTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsAdditiveTrue(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsMultiplicativeFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsMultiplicativeFalse(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsMultiplicativeTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsMultiplicativeTrue(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsShiftFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsShiftFalse(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsShiftTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsShiftTrue(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsUnaryTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsUnaryTrue(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsUnaryFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsUnaryFalse(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsLambdaArrowFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsLambdaArrowFalse(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsLambdaArrowTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsLambdaArrowTrue(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsMethodReferenceDoubleColonTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsMethodReferenceDoubleColonTrue(this, jp);
        }

        @Override
        @Test
        public void aroundOperatorsMethodReferenceDoubleColonFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.aroundOperatorsMethodReferenceDoubleColonFalse(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceClassLeftBraceFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceClassLeftBraceFalse(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceClassLeftBraceTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceClassLeftBraceTrue(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceMethodLeftBraceFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceMethodLeftBraceFalse(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceMethodLeftBraceTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceMethodLeftBraceTrue(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceIfLeftBraceFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceIfLeftBraceFalse(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceIfLeftBraceTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceIfLeftBraceTrue(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceElseLeftBraceFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceElseLeftBraceFalse(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceElseLeftBraceTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceElseLeftBraceTrue(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceForLeftBraceFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceForLeftBraceFalse(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceForLeftBraceTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceForLeftBraceTrue(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceWhileLeftBraceFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceWhileLeftBraceFalse(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceWhileLeftBraceTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceWhileLeftBraceTrue(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceDoLeftBraceFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceDoLeftBraceFalse(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceDoLeftBraceTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceDoLeftBraceTrue(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceSwitchLeftBraceFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceSwitchLeftBraceFalse(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceSwitchLeftBraceTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceSwitchLeftBraceTrue(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceTryLeftBraceFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceTryLeftBraceFalse(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceTryLeftBraceTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceTryLeftBraceTrue(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceCatchLeftBraceFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceCatchLeftBraceFalse(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceCatchLeftBraceTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceCatchLeftBraceTrue(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceFinallyLeftBraceFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceFinallyLeftBraceFalse(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceFinallyLeftBraceTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceFinallyLeftBraceTrue(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceSynchronizedLeftBraceFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceSynchronizedLeftBraceFalse(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceSynchronizedLeftBraceTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceSynchronizedLeftBraceTrue(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceArrayInitializerLeftBraceTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceArrayInitializerLeftBraceTrue(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceArrayInitializerLeftBraceFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceArrayInitializerLeftBraceFalse(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceAnnotationArrayInitializerLeftBraceTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceAnnotationArrayInitializerLeftBraceTrue(this, jp);
        }

        @Override
        @Test
        public void beforeLeftBraceAnnotationArrayInitializerLeftBraceFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeLeftBraceAnnotationArrayInitializerLeftBraceFalse(this, jp);
        }

        @Override
        @Test
        public void beforeKeywordsElseKeywordFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeKeywordsElseKeywordFalse(this, jp);
        }

        @Override
        @Test
        public void beforeKeywordsElseKeywordTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeKeywordsElseKeywordTrue(this, jp);
        }

        @Override
        @Test
        public void beforeKeywordsWhileKeywordFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeKeywordsWhileKeywordFalse(this, jp);
        }

        @Override
        @Test
        public void beforeKeywordsWhileKeywordTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeKeywordsWhileKeywordTrue(this, jp);
        }

        @Override
        @Test
        public void beforeKeywordsCatchKeywordFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeKeywordsCatchKeywordFalse(this, jp);
        }

        @Override
        @Test
        public void beforeKeywordsCatchKeywordTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeKeywordsCatchKeywordTrue(this, jp);
        }

        @Override
        @Test
        public void beforeKeywordsFinallyKeywordFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeKeywordsFinallyKeywordFalse(this, jp);
        }

        @Override
        @Test
        public void beforeKeywordsFinallyKeywordTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.beforeKeywordsFinallyKeywordTrue(this, jp);
        }

        @Override
        @Test
        public void withinCodeBracesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinCodeBracesTrue(this, jp);
        }

        @Override
        @Test
        public void withinCodeBracesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinCodeBracesFalse(this, jp);
        }

        @Override
        @Test
        public void withinBracketsTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinBracketsTrue(this, jp);
        }

        @Override
        @Test
        public void withinBracketsFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinBracketsFalse(this, jp);
        }

        @Override
        @Test
        public void withinArrayInitializerBracesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinArrayInitializerBracesTrue(this, jp);
        }

        @Override
        @Test
        public void withinArrayInitializerBracesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinArrayInitializerBracesFalse(this, jp);
        }

        @Override
        @Test
        public void withinEmptyArrayInitializerBracesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinEmptyArrayInitializerBracesTrue(this, jp);
        }

        @Override
        @Test
        public void withinEmptyArrayInitializerBracesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinEmptyArrayInitializerBracesFalse(this, jp);
        }

        @Override
        @Test
        public void withinGroupingParenthesesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinGroupingParenthesesTrue(this, jp);
        }

        @Override
        @Test
        public void withinGroupingParenthesesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinGroupingParenthesesFalse(this, jp);
        }

        @Override
        @Test
        public void withinMethodDeclarationParenthesesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinMethodDeclarationParenthesesTrue(this, jp);
        }

        @Override
        @Test
        public void withinMethodDeclarationParenthesesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinMethodDeclarationParenthesesFalse(this, jp);
        }

        @Override
        @Test
        public void withinEmptyMethodDeclarationParenthesesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinEmptyMethodDeclarationParenthesesTrue(this, jp);
        }

        @Override
        @Test
        public void withinEmptyMethodDeclarationParenthesesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinEmptyMethodDeclarationParenthesesFalse(this, jp);
        }

        @Override
        @Test
        public void withinMethodCallParenthesesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinMethodCallParenthesesTrue(this, jp);
        }

        @Override
        @Test
        public void withinMethodCallParenthesesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinMethodCallParenthesesFalse(this, jp);
        }

        @Override
        @Test
        public void withinEmptyMethodCallParenthesesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinEmptyMethodCallParenthesesTrue(this, jp);
        }

        @Override
        @Test
        public void withinEmptyMethodCallParenthesesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinEmptyMethodCallParenthesesFalse(this, jp);
        }

        @Override
        @Test
        public void withinIfParenthesesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinIfParenthesesTrue(this, jp);
        }

        @Override
        @Test
        public void withinIfParenthesesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinIfParenthesesFalse(this, jp);
        }

        @Override
        @Test
        public void withinForParenthesesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinForParenthesesTrue(this, jp);
        }

        @Override
        @Test
        public void withinForParenthesesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinForParenthesesFalse(this, jp);
        }

        @Override
        @Test
        public void withinWhileParenthesesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinWhileParenthesesTrue(this, jp);
        }

        @Override
        @Test
        public void withinWhileParenthesesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinWhileParenthesesFalse(this, jp);
        }

        @Override
        @Test
        public void withinSwitchParenthesesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinSwitchParenthesesTrue(this, jp);
        }

        @Override
        @Test
        public void withinSwitchParenthesesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinSwitchParenthesesFalse(this, jp);
        }

        @Override
        @Test
        public void withinTryParenthesesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinTryParenthesesTrue(this, jp);
        }

        @Override
        @Test
        public void withinTryParenthesesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinTryParenthesesFalse(this, jp);
        }

        @Override
        @Test
        public void withinCatchParenthesesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinCatchParenthesesTrue(this, jp);
        }

        @Override
        @Test
        public void withinCatchParenthesesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinCatchParenthesesFalse(this, jp);
        }

        @Override
        @Test
        public void withinSynchronizedParenthesesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinSynchronizedParenthesesTrue(this, jp);
        }

        @Override
        @Test
        public void withinSynchronizedParenthesesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinSynchronizedParenthesesFalse(this, jp);
        }

        @Override
        @Test
        public void withinTypeCastParenthesesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinTypeCastParenthesesTrue(this, jp);
        }

        @Override
        @Test
        public void withinTypeCastParenthesesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinTypeCastParenthesesFalse(this, jp);
        }

        @Override
        @Test
        public void withinAnnotationParenthesesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinAnnotationParenthesesTrue(this, jp);
        }

        @Override
        @Test
        public void withinAnnotationParenthesesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinAnnotationParenthesesFalse(this, jp);
        }

        @Override
        @Test
        public void withinAngleBracketsTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinAngleBracketsTrue(this, jp);
        }

        @Override
        @Test
        public void withinAngleBracketsFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.withinAngleBracketsFalse(this, jp);
        }

        @Override
        @Test
        public void ternaryOperatorBeforeQuestionMarkFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.ternaryOperatorBeforeQuestionMarkFalse(this, jp);
        }

        @Override
        @Test
        public void ternaryOperatorBeforeQuestionMarkTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.ternaryOperatorBeforeQuestionMarkTrue(this, jp);
        }

        @Override
        @Test
        public void ternaryOperatorAfterQuestionMarkFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.ternaryOperatorAfterQuestionMarkFalse(this, jp);
        }

        @Override
        @Test
        public void ternaryOperatorAfterQuestionMarkTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.ternaryOperatorAfterQuestionMarkTrue(this, jp);
        }

        @Override
        @Test
        public void ternaryOperatorBeforeColonFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.ternaryOperatorBeforeColonFalse(this, jp);
        }

        @Override
        @Test
        public void ternaryOperatorBeforeColonTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.ternaryOperatorBeforeColonTrue(this, jp);
        }

        @Override
        @Test
        public void ternaryOperatorAfterColonFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.ternaryOperatorAfterColonFalse(this, jp);
        }

        @Override
        @Test
        public void ternaryOperatorAfterColonTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.ternaryOperatorAfterColonTrue(this, jp);
        }

        @Override
        @Test
        public void typeArgumentsAfterCommaFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.typeArgumentsAfterCommaFalse(this, jp);
        }

        @Override
        @Test
        public void typeArgumentsAfterCommaTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.typeArgumentsAfterCommaTrue(this, jp);
        }

        @Override
        @Test
        public void typeArgumentsBeforeOpeningAngleBracketTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.typeArgumentsBeforeOpeningAngleBracketTrue(this, jp);
        }

        @Override
        @Test
        public void typeArgumentsBeforeOpeningAngleBracketFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.typeArgumentsBeforeOpeningAngleBracketFalse(this, jp);
        }

        @Override
        @Test
        public void typeArgumentsAfterClosingAngleBracketTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.typeArgumentsAfterClosingAngleBracketTrue(this, jp);
        }

        @Override
        @Test
        public void typeArgumentsAfterClosingAngleBracketFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.typeArgumentsAfterClosingAngleBracketFalse(this, jp);
        }

        @Override
        @Test
        public void otherBeforeCommaTrueNewArrayInitializer(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherBeforeCommaTrueNewArrayInitializer(this, jp);
        }

        @Override
        @Test
        public void otherBeforeCommaFalseNewArrayInitializer(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherBeforeCommaFalseNewArrayInitializer(this, jp);
        }

        @Override
        @Test
        public void otherAfterCommaFalseNewArrayInitializer(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherAfterCommaFalseNewArrayInitializer(this, jp);
        }

        @Override
        @Test
        public void otherAfterCommaTrueNewArrayInitializer(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherAfterCommaTrueNewArrayInitializer(this, jp);
        }

        @Override
        @Test
        public void otherBeforeCommaTrueMethodDeclArgs(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherBeforeCommaTrueMethodDeclArgs(this, jp);
        }

        @Override
        @Test
        public void otherBeforeCommaFalseMethodDeclArgs(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherBeforeCommaFalseMethodDeclArgs(this, jp);
        }

        @Override
        @Test
        public void otherAfterCommaFalseMethodDeclArgs(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherAfterCommaFalseMethodDeclArgs(this, jp);
        }

        @Override
        @Test
        public void otherAfterCommaTrueMethodDeclArgs(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherAfterCommaTrueMethodDeclArgs(this, jp);
        }

        @Override
        @NotNull
        public String[] getMethodInvocationDependsOn() {
            return SpacesTest.DefaultImpls.getMethodInvocationDependsOn(this);
        }

        @Override
        @Test
        public void otherBeforeCommaTrueMethodInvocationParams(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherBeforeCommaTrueMethodInvocationParams(this, jp);
        }

        @Override
        @Test
        public void otherBeforeCommaFalseMethodInvocationParams(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherBeforeCommaFalseMethodInvocationParams(this, jp);
        }

        @Override
        @Test
        public void otherAfterCommaFalseMethodInvocationParams(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherAfterCommaFalseMethodInvocationParams(this, jp);
        }

        @Override
        @Test
        public void otherAfterCommaTrueMethodInvocationParams(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherAfterCommaTrueMethodInvocationParams(this, jp);
        }

        @Override
        @NotNull
        public String[] getNewClassArgsDependsOn() {
            return SpacesTest.DefaultImpls.getNewClassArgsDependsOn(this);
        }

        @Override
        @Test
        public void otherBeforeCommaTrueNewClassArgs(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherBeforeCommaTrueNewClassArgs(this, jp);
        }

        @Override
        @Test
        public void otherBeforeCommaFalseNewClassArgs(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherBeforeCommaFalseNewClassArgs(this, jp);
        }

        @Override
        @Test
        public void otherAfterCommaFalseNewClassArgs(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherAfterCommaFalseNewClassArgs(this, jp);
        }

        @Override
        @Test
        public void otherAfterCommaTrueNewClassArgs(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherAfterCommaTrueNewClassArgs(this, jp);
        }

        @Override
        @Test
        public void otherBeforeCommaTrueLambdaParameters(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherBeforeCommaTrueLambdaParameters(this, jp);
        }

        @Override
        @Test
        public void otherBeforeCommaFalseLambdaParameters(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherBeforeCommaFalseLambdaParameters(this, jp);
        }

        @Override
        @Test
        public void otherAfterCommaFalseLambdaParameters(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherAfterCommaFalseLambdaParameters(this, jp);
        }

        @Override
        @Test
        public void otherAfterCommaTrueLambdaParameters(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherAfterCommaTrueLambdaParameters(this, jp);
        }

        @Override
        @Test
        public void otherBeforeCommaTrueForLoopUpdate(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherBeforeCommaTrueForLoopUpdate(this, jp);
        }

        @Override
        @Test
        public void otherBeforeCommaFalseForLoopUpdate(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherBeforeCommaFalseForLoopUpdate(this, jp);
        }

        @Override
        @Test
        public void otherAfterCommaFalseForLoopUpdate(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherAfterCommaFalseForLoopUpdate(this, jp);
        }

        @Override
        @Test
        public void otherAfterCommaTrueForLoopUpdate(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherAfterCommaTrueForLoopUpdate(this, jp);
        }

        @Override
        @Test
        public void otherBeforeCommaTrueEnumValueInitArgs(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherBeforeCommaTrueEnumValueInitArgs(this, jp);
        }

        @Override
        @Test
        public void otherBeforeCommaFalseEnumValueInitArgs(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherBeforeCommaFalseEnumValueInitArgs(this, jp);
        }

        @Override
        @Test
        public void otherAfterCommaFalseEnumValueInitArgs(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherAfterCommaFalseEnumValueInitArgs(this, jp);
        }

        @Override
        @Test
        public void otherAfterCommaTrueEnumValueInitArgs(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherAfterCommaTrueEnumValueInitArgs(this, jp);
        }

        @Override
        @Test
        public void otherBeforeForSemicolonTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherBeforeForSemicolonTrue(this, jp);
        }

        @Override
        @Test
        public void otherBeforeForSemicolonFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherBeforeForSemicolonFalse(this, jp);
        }

        @Override
        @Test
        public void otherAfterForSemicolonFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherAfterForSemicolonFalse(this, jp);
        }

        @Override
        @Test
        public void otherAfterForSemicolonTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherAfterForSemicolonTrue(this, jp);
        }

        @Override
        @Test
        public void otherAfterTypeCastFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherAfterTypeCastFalse(this, jp);
        }

        @Override
        @Test
        public void otherAfterTypeCastTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherAfterTypeCastTrue(this, jp);
        }

        @Override
        @Test
        public void otherBeforeColonInForEachFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherBeforeColonInForEachFalse(this, jp);
        }

        @Override
        @Test
        public void otherBeforeColonInForEachTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherBeforeColonInForEachTrue(this, jp);
        }

        @Override
        @Test
        public void otherInsideOneLineEnumBracesTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherInsideOneLineEnumBracesTrue(this, jp);
        }

        @Override
        @Test
        public void otherInsideOneLineEnumBracesFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.otherInsideOneLineEnumBracesFalse(this, jp);
        }

        @Override
        @Test
        public void typeParametersBeforeOpeningAngleBracketTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.typeParametersBeforeOpeningAngleBracketTrue(this, jp);
        }

        @Override
        @Test
        public void typeParametersBeforeOpeningAngleBracketFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.typeParametersBeforeOpeningAngleBracketFalse(this, jp);
        }

        @Override
        @Test
        public void typeParametersAroundTypeBoundsFalse(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.typeParametersAroundTypeBoundsFalse(this, jp);
        }

        @Override
        @Test
        public void typeParametersAroundTypeBoundsTrue(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            SpacesTest.DefaultImpls.typeParametersAroundTypeBoundsTrue(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return SpacesTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            SpacesTest.DefaultImpls.assertChanged((SpacesTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            SpacesTest.DefaultImpls.assertChanged((SpacesTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            SpacesTest.DefaultImpls.assertChanged((SpacesTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            SpacesTest.DefaultImpls.assertChanged((SpacesTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            SpacesTest.DefaultImpls.assertUnchanged((SpacesTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            SpacesTest.DefaultImpls.assertUnchanged((SpacesTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return SpacesTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return SpacesTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$TabsAndIndentsTck;", "Lorg/openrewrite/java/format/TabsAndIndentsTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class TabsAndIndentsTck
    implements TabsAndIndentsTest {
        @Override
        @NotNull
        public Recipe getRecipe() {
            return TabsAndIndentsTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @NotNull
        public List<NamedStyles> tabsAndIndents(@NotNull Function1<? super TabsAndIndentsStyle, ? extends TabsAndIndentsStyle> with) {
            Intrinsics.checkNotNullParameter(with, (String)"with");
            return TabsAndIndentsTest.DefaultImpls.tabsAndIndents((TabsAndIndentsTest)this, with);
        }

        @Override
        @Test
        public void tabsAndIndents(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.tabsAndIndents((TabsAndIndentsTest)this, jp);
        }

        @Override
        @Test
        public void methodChain(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.methodChain(this, jp);
        }

        @Override
        @Test
        public void tryCatchFinally(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.tryCatchFinally(this, jp);
        }

        @Override
        @Test
        public void doWhile(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.doWhile(this, jp);
        }

        @Override
        @Test
        public void elseBody(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.elseBody(this, jp);
        }

        @Override
        @Test
        @Disabled
        public void forLoop(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.forLoop(this, jp);
        }

        @Override
        @Test
        public void methodDeclaration(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.methodDeclaration(this, jp);
        }

        @Override
        @Test
        public void lineComment(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.lineComment(this, jp);
        }

        @Override
        @Test
        public void blockComment(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.blockComment(this, jp);
        }

        @Override
        @Test
        public void initBlocks(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.initBlocks(this, jp);
        }

        @Override
        @Test
        public void moreAnnotations(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.moreAnnotations(this, jp);
        }

        @Override
        @Test
        public void annotations(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.annotations(this, jp);
        }

        @Override
        @Test
        public void javadoc(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.javadoc(this, jp);
        }

        @Override
        @Test
        public void tabs(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.tabs(this, jp);
        }

        @Override
        @Test
        public void shiftRight(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.shiftRight(this, jp);
        }

        @Override
        @Test
        public void shiftRightTabs(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.shiftRightTabs(this, jp);
        }

        @Override
        @Test
        public void shiftLeft(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.shiftLeft(this, jp);
        }

        @Override
        @Test
        public void shiftLeftTabs(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.shiftLeftTabs(this, jp);
        }

        @Override
        @Test
        public void nestedIfElse(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.nestedIfElse(this, jp);
        }

        @Override
        @Test
        public void annotationOnSameLine(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.annotationOnSameLine(this, jp);
        }

        @Override
        @Test
        public void newClassAsMethodArgument(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.newClassAsMethodArgument(this, jp);
        }

        @Override
        @Test
        public void methodArgumentsThatDontStartOnNewLine(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.methodArgumentsThatDontStartOnNewLine(this, jp);
        }

        @Override
        @Test
        public void methodArgumentsThatDontStartOnNewLine2(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.methodArgumentsThatDontStartOnNewLine2(this, jp);
        }

        @Override
        @Test
        public void identAndFieldAccess(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.identAndFieldAccess(this, jp);
        }

        @Override
        @Test
        public void lambda(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.lambda(this, jp);
        }

        @Override
        @Test
        public void lambdaWithBlock(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.lambdaWithBlock(this, jp);
        }

        @Override
        @Test
        public void enums(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.enums(this, jp);
        }

        @Override
        @Test
        public void twoThrows(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.twoThrows(this, jp);
        }

        @Override
        @Test
        public void twoTypeParameters(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.twoTypeParameters(this, jp);
        }

        @Override
        @Test
        public void twoImplements(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.twoImplements(this, jp);
        }

        @Override
        @Test
        public void fieldsWhereClassHasAnnotation(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.fieldsWhereClassHasAnnotation(this, jp);
        }

        @Override
        @Test
        public void methodWithAnnotation(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.methodWithAnnotation(this, jp);
        }

        @Override
        @Test
        public void containers(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.containers(this, jp);
        }

        @Override
        @Test
        public void methodInvocations(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.methodInvocations(this, jp);
        }

        @Override
        @Test
        public void ternaries(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.ternaries(this, jp);
        }

        @Override
        @Test
        public void newClassAsArgument(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.newClassAsArgument(this, jp);
        }

        @Override
        @Test
        public void variableWithAnnotation(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.variableWithAnnotation(this, jp);
        }

        @Override
        @Test
        public void lambdaMethodParameter2(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.lambdaMethodParameter2(this, jp);
        }

        @Override
        @Test
        public void lambdaMethodParameter(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.lambdaMethodParameter(this, jp);
        }

        @Override
        @Test
        public void failure1(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.failure1(this, jp);
        }

        @Override
        @Test
        public void methodInvocationsNotContinuationIndentedWhenPartOfBinaryExpression(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.methodInvocationsNotContinuationIndentedWhenPartOfBinaryExpression(this, jp);
        }

        @Override
        @Test
        public void punctuation(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.punctuation(this, jp);
        }

        @Override
        @Test
        public void newClass(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.newClass(this, jp);
        }

        @Override
        @Test
        public void tabsFileWithSpacesFormat(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.tabsFileWithSpacesFormat(this, jp);
        }

        @Override
        @Test
        public void mixedTabsSpacesFileWithSpacesFormat(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TabsAndIndentsTest.DefaultImpls.mixedTabsSpacesFileWithSpacesFormat(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return TabsAndIndentsTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            TabsAndIndentsTest.DefaultImpls.assertChanged((TabsAndIndentsTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            TabsAndIndentsTest.DefaultImpls.assertChanged((TabsAndIndentsTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            TabsAndIndentsTest.DefaultImpls.assertChanged((TabsAndIndentsTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            TabsAndIndentsTest.DefaultImpls.assertChanged((TabsAndIndentsTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            TabsAndIndentsTest.DefaultImpls.assertUnchanged((TabsAndIndentsTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            TabsAndIndentsTest.DefaultImpls.assertUnchanged((TabsAndIndentsTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return TabsAndIndentsTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return TabsAndIndentsTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$TypeTreeTck;", "Lorg/openrewrite/java/tree/TypeTreeTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class TypeTreeTck
    implements TypeTreeTest {
        @Override
        @Test
        public void buildFullyQualifiedClassName(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TypeTreeTest.DefaultImpls.buildFullyQualifiedClassName(this, jp);
        }

        @Override
        @Test
        public void buildFullyQualifiedClassNameWithSpacing(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TypeTreeTest.DefaultImpls.buildFullyQualifiedClassNameWithSpacing(this, jp);
        }

        @Override
        @Test
        public void buildFullyQualifiedInnerClassName(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TypeTreeTest.DefaultImpls.buildFullyQualifiedInnerClassName(this, jp);
        }

        @Override
        @Test
        public void buildStaticImport(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TypeTreeTest.DefaultImpls.buildStaticImport(this, jp);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$UnnecessaryParenthesesTck;", "Lorg/openrewrite/java/cleanup/UnnecessaryParenthesesTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class UnnecessaryParenthesesTck
    implements UnnecessaryParenthesesTest {
        @Override
        @Nullable
        public Recipe getRecipe() {
            return UnnecessaryParenthesesTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @NotNull
        public List<NamedStyles> unnecessaryParentheses(@NotNull Function1<? super UnnecessaryParenthesesStyle, ? extends UnnecessaryParenthesesStyle> with) {
            Intrinsics.checkNotNullParameter(with, (String)"with");
            return UnnecessaryParenthesesTest.DefaultImpls.unnecessaryParentheses(this, with);
        }

        @Override
        @Test
        public void fullUnwrappingDefault(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            UnnecessaryParenthesesTest.DefaultImpls.fullUnwrappingDefault(this, jp);
        }

        @Override
        @Test
        @Disabled
        public void unwrapExpr(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            UnnecessaryParenthesesTest.DefaultImpls.unwrapExpr(this, jp);
        }

        @Override
        @Test
        public void unwrapIdent(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            UnnecessaryParenthesesTest.DefaultImpls.unwrapIdent(this, jp);
        }

        @Override
        @Test
        public void unwrapNum(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            UnnecessaryParenthesesTest.DefaultImpls.unwrapNum(this, jp);
        }

        @Override
        @Test
        public void unwrapLiteral(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            UnnecessaryParenthesesTest.DefaultImpls.unwrapLiteral(this, jp);
        }

        @Override
        @Test
        public void unwrapAssignment(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            UnnecessaryParenthesesTest.DefaultImpls.unwrapAssignment(this, jp);
        }

        @Override
        @Test
        public void unwrapBandAssign(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            UnnecessaryParenthesesTest.DefaultImpls.unwrapBandAssign(this, jp);
        }

        @Override
        @Test
        public void unwrapBorAssign(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            UnnecessaryParenthesesTest.DefaultImpls.unwrapBorAssign(this, jp);
        }

        @Override
        @Test
        public void unwrapBsrAssign(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            UnnecessaryParenthesesTest.DefaultImpls.unwrapBsrAssign(this, jp);
        }

        @Override
        @Test
        public void unwrapBxorAssign(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            UnnecessaryParenthesesTest.DefaultImpls.unwrapBxorAssign(this, jp);
        }

        @Override
        @Test
        public void unwrapDivAssign(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            UnnecessaryParenthesesTest.DefaultImpls.unwrapDivAssign(this, jp);
        }

        @Override
        @Test
        public void unwrapMinusAssign(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            UnnecessaryParenthesesTest.DefaultImpls.unwrapMinusAssign(this, jp);
        }

        @Override
        @Test
        public void unwrapModAssign(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            UnnecessaryParenthesesTest.DefaultImpls.unwrapModAssign(this, jp);
        }

        @Override
        @Test
        public void unwrapPlusAssign(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            UnnecessaryParenthesesTest.DefaultImpls.unwrapPlusAssign(this, jp);
        }

        @Override
        @Test
        public void unwrapSlAssign(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            UnnecessaryParenthesesTest.DefaultImpls.unwrapSlAssign(this, jp);
        }

        @Override
        @Test
        public void unwrapSrAssign(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            UnnecessaryParenthesesTest.DefaultImpls.unwrapSrAssign(this, jp);
        }

        @Override
        @Test
        public void unwrapStarAssign(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            UnnecessaryParenthesesTest.DefaultImpls.unwrapStarAssign(this, jp);
        }

        @Override
        @Test
        public void unwrapLambda(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            UnnecessaryParenthesesTest.DefaultImpls.unwrapLambda(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return UnnecessaryParenthesesTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            UnnecessaryParenthesesTest.DefaultImpls.assertChanged((UnnecessaryParenthesesTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            UnnecessaryParenthesesTest.DefaultImpls.assertChanged((UnnecessaryParenthesesTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            UnnecessaryParenthesesTest.DefaultImpls.assertChanged((UnnecessaryParenthesesTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            UnnecessaryParenthesesTest.DefaultImpls.assertChanged((UnnecessaryParenthesesTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            UnnecessaryParenthesesTest.DefaultImpls.assertUnchanged((UnnecessaryParenthesesTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            UnnecessaryParenthesesTest.DefaultImpls.assertUnchanged((UnnecessaryParenthesesTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return UnnecessaryParenthesesTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return UnnecessaryParenthesesTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$UnwrapParenthesesTck;", "Lorg/openrewrite/java/UnwrapParenthesesTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class UnwrapParenthesesTck
    implements UnwrapParenthesesTest {
        @Override
        @Nullable
        public Recipe getRecipe() {
            return UnwrapParenthesesTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Test
        public void unwrapAssignment(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            UnwrapParenthesesTest.DefaultImpls.unwrapAssignment(this, jp);
        }

        @Override
        @Test
        public void unwrapIfCondition(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            UnwrapParenthesesTest.DefaultImpls.unwrapIfCondition(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return UnwrapParenthesesTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            UnwrapParenthesesTest.DefaultImpls.assertChanged((UnwrapParenthesesTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            UnwrapParenthesesTest.DefaultImpls.assertChanged((UnwrapParenthesesTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            UnwrapParenthesesTest.DefaultImpls.assertChanged((UnwrapParenthesesTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            UnwrapParenthesesTest.DefaultImpls.assertChanged((UnwrapParenthesesTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            UnwrapParenthesesTest.DefaultImpls.assertUnchanged((UnwrapParenthesesTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            UnwrapParenthesesTest.DefaultImpls.assertUnchanged((UnwrapParenthesesTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return UnwrapParenthesesTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return UnwrapParenthesesTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$UseStaticImportTck;", "Lorg/openrewrite/java/UseStaticImportTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class UseStaticImportTck
    implements UseStaticImportTest {
        @Override
        @Test
        public void replaceWithStaticImports(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            UseStaticImportTest.DefaultImpls.replaceWithStaticImports(this, jp);
        }

        @Override
        @Test
        public void junit5Assertions(@NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            UseStaticImportTest.DefaultImpls.junit5Assertions(this, jp);
        }

        @Override
        @Test
        public void checkValidation() {
            UseStaticImportTest.DefaultImpls.checkValidation(this);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return UseStaticImportTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            UseStaticImportTest.DefaultImpls.assertChanged((UseStaticImportTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            UseStaticImportTest.DefaultImpls.assertChanged((UseStaticImportTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            UseStaticImportTest.DefaultImpls.assertChanged((UseStaticImportTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            UseStaticImportTest.DefaultImpls.assertChanged((UseStaticImportTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            UseStaticImportTest.DefaultImpls.assertUnchanged((UseStaticImportTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            UseStaticImportTest.DefaultImpls.assertUnchanged((UseStaticImportTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Recipe getRecipe() {
            return UseStaticImportTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return UseStaticImportTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return UseStaticImportTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }

    @Nested
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/openrewrite/java/JavaVisitorCompatibilityKit$WrappingAndBracesTck;", "Lorg/openrewrite/java/format/WrappingAndBracesTest;", "(Lorg/openrewrite/java/JavaVisitorCompatibilityKit;)V", "rewrite-test"})
    public final class WrappingAndBracesTck
    implements WrappingAndBracesTest {
        @Override
        @NotNull
        public Recipe getRecipe() {
            return WrappingAndBracesTest.DefaultImpls.getRecipe(this);
        }

        @Override
        @Test
        public void blockLevelStatements(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            WrappingAndBracesTest.DefaultImpls.blockLevelStatements(this, jp);
        }

        @Override
        @Test
        public void blockEndOnOwnLine(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            WrappingAndBracesTest.DefaultImpls.blockEndOnOwnLine(this, jp);
        }

        @Override
        @Test
        public void annotatedMethod(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            WrappingAndBracesTest.DefaultImpls.annotatedMethod(this, jp);
        }

        @Override
        @Test
        public void annotatedMethodWithModifier(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            WrappingAndBracesTest.DefaultImpls.annotatedMethodWithModifier(this, jp);
        }

        @Override
        @Test
        public void annotatedMethodWithModifiers(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            WrappingAndBracesTest.DefaultImpls.annotatedMethodWithModifiers(this, jp);
        }

        @Override
        @Test
        public void annotatedMethodWithTypeParameter(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            WrappingAndBracesTest.DefaultImpls.annotatedMethodWithTypeParameter(this, jp);
        }

        @Override
        @Test
        public void multipleAnnotatedMethod(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            WrappingAndBracesTest.DefaultImpls.multipleAnnotatedMethod(this, jp);
        }

        @Override
        @Test
        public void annotatedConstructor(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            WrappingAndBracesTest.DefaultImpls.annotatedConstructor(this, jp);
        }

        @Override
        @Test
        public void annotatedClassDecl(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            WrappingAndBracesTest.DefaultImpls.annotatedClassDecl(this, jp);
        }

        @Override
        @Test
        public void annotatedClassDeclAlreadyCorrect(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            WrappingAndBracesTest.DefaultImpls.annotatedClassDeclAlreadyCorrect(this, jp);
        }

        @Override
        @Test
        public void annotatedClassDeclWithModifiers(@NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            WrappingAndBracesTest.DefaultImpls.annotatedClassDeclWithModifiers(this, jp);
        }

        @Override
        @Nullable
        public TreePrinter<?> getTreePrinter() {
            return WrappingAndBracesTest.DefaultImpls.getTreePrinter(this);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            WrappingAndBracesTest.DefaultImpls.assertChanged((WrappingAndBracesTest)this, parser, recipe2, before, dependsOn, cycles, after);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            WrappingAndBracesTest.DefaultImpls.assertChanged((WrappingAndBracesTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertChanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            WrappingAndBracesTest.DefaultImpls.assertChanged((WrappingAndBracesTest)this, parser, recipe2, before, dependsOn, after, cycles);
        }

        @Override
        public <T extends SourceFile> void assertChanged(@Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            WrappingAndBracesTest.DefaultImpls.assertChanged((WrappingAndBracesTest)this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            WrappingAndBracesTest.DefaultImpls.assertUnchanged((WrappingAndBracesTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        public void assertUnchanged(@Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            WrappingAndBracesTest.DefaultImpls.assertUnchanged((WrappingAndBracesTest)this, parser, recipe2, before, dependsOn);
        }

        @Override
        @Nullable
        public Parser<?> getParser() {
            return WrappingAndBracesTest.DefaultImpls.getParser(this);
        }

        @Override
        @NotNull
        public RecipeTest.AdHocRecipe toRecipe(@NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return WrappingAndBracesTest.DefaultImpls.toRecipe(this, $this$toRecipe);
        }
    }
}

