/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTreeTest;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\f"}, d2={"Lorg/openrewrite/java/tree/EnumTest;", "Lorg/openrewrite/java/JavaTreeTest;", "anonymousClassInitializer", "", "jp", "Lorg/openrewrite/java/JavaParser;", "enumConstructor", "enumUnnecessarilyTerminatedWithSemicolon", "enumWithEmptyParameters", "enumWithParameters", "enumWithoutParameters", "noArguments", "rewrite-test"})
public interface EnumTest
extends JavaTreeTest {
    @Test
    public void anonymousClassInitializer(@NotNull JavaParser var1);

    @Test
    public void enumConstructor(@NotNull JavaParser var1);

    @Test
    public void noArguments(@NotNull JavaParser var1);

    @Test
    public void enumWithParameters(@NotNull JavaParser var1);

    @Test
    public void enumWithoutParameters(@NotNull JavaParser var1);

    @Test
    public void enumUnnecessarilyTerminatedWithSemicolon(@NotNull JavaParser var1);

    @Test
    public void enumWithEmptyParameters(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void anonymousClassInitializer(@NotNull EnumTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            public enum A {\n                A1(1) {\n                    @Override\n                    void foo() {}\n                },\n\n                A2 {\n                    @Override\n                    void foo() {}\n                };\n                \n                A() {}\n                A(int n) {}\n                \n                abstract void foo();\n            }\n        ", new String[0]);
        }

        @Test
        public static void enumConstructor(@NotNull EnumTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            public class Outer {\n                public enum A {\n                    A1(1);\n    \n                    A(int n) {}\n                }\n                \n                private static final class ContextFailedToStart {\n                    private static Object[] combineArguments(String context, Throwable ex, Object[] arguments) {\n                        return new Object[arguments.length + 2];\n                    }\n                }\n            }\n        ", new String[0]);
        }

        @Test
        public static void noArguments(@NotNull EnumTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            public enum A {\n                A1, A2();\n            }\n        ", new String[0]);
        }

        @Test
        public static void enumWithParameters(@NotNull EnumTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            public enum A {\n                ONE(1),\n                TWO(2);\n            \n                A(int n) {}\n            }\n        ", new String[0]);
        }

        @Test
        public static void enumWithoutParameters(@NotNull EnumTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "public enum A { ONE, TWO }", new String[0]);
        }

        @Test
        public static void enumUnnecessarilyTerminatedWithSemicolon(@NotNull EnumTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "public enum A { ONE ; }", new String[0]);
        }

        @Test
        public static void enumWithEmptyParameters(@NotNull EnumTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "public enum A { ONE ( ), TWO ( ) }", new String[0]);
        }
    }
}

