/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\bf\u0018\u0000 \r2\u00020\u0001:\u0001\rJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000e"}, d2={"Lorg/openrewrite/java/search/SemanticallyEqualTest;", "", "annotationEquality", "", "jp", "Lorg/openrewrite/java/JavaParser;", "assignEquality", "fieldAccessEquality", "identEquality", "literalEquality", "noArgumentsTest", "tagAnnotationEquality", "typeEqualityDependsOnlyOnFqn", "Companion", "rewrite-test"})
public interface SemanticallyEqualTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.search.SemanticallyEqualTest$Companion.$$INSTANCE;

    @Test
    public void noArgumentsTest(@NotNull JavaParser var1);

    @Test
    public void tagAnnotationEquality(@NotNull JavaParser var1);

    @Test
    public void annotationEquality(@NotNull JavaParser var1);

    @Test
    public void identEquality(@NotNull JavaParser var1);

    @Test
    public void fieldAccessEquality(@NotNull JavaParser var1);

    @Test
    public void assignEquality(@NotNull JavaParser var1);

    @Test
    public void literalEquality(@NotNull JavaParser var1);

    @Test
    public void typeEqualityDependsOnlyOnFqn(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void noArgumentsTest(@NotNull SemanticallyEqualTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List cu = jp.parse(new String[]{"\n                @NoArgAnnotation1\n                class A {}\n            ", "\n            @interface MyAnnotation { \n                boolean value();\n                String srcValue(); \n            }\n            @interface NoArgAnnotation1{}\n            @interface NoArgAnnotation2{}\n        "});
            Object e = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"cu[0]");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"cu[0].classes[0]");
            J.Annotation firstAnnot = (J.Annotation)((J.ClassDeclaration)e2).getLeadingAnnotations().get(0);
            jp.reset();
            Object e3 = jp.parse(new String[]{"\n                @NoArgAnnotation2\n                class B {}\n            ", "\n            @interface MyAnnotation { \n                boolean value();\n                String srcValue(); \n            }\n            @interface NoArgAnnotation1{}\n            @interface NoArgAnnotation2{}\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"jp.parse(\n            \"\"\u2026notInterface\n        )[0]");
            Object e4 = ((J.CompilationUnit)e3).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e4, (String)"jp.parse(\n            \"\"\u2026e\n        )[0].classes[0]");
            J.Annotation secondAnnot = (J.Annotation)((J.ClassDeclaration)e4).getLeadingAnnotations().get(0);
            jp.reset();
            Object e5 = jp.parse(new String[]{"\n                @NoArgAnnotation2\n                class B {}\n            ", "\n            @interface MyAnnotation { \n                boolean value();\n                String srcValue(); \n            }\n            @interface NoArgAnnotation1{}\n            @interface NoArgAnnotation2{}\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue(e5, (String)"jp.parse(\n            \"\"\u2026notInterface\n        )[0]");
            Object e6 = ((J.CompilationUnit)e5).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e6, (String)"jp.parse(\n            \"\"\u2026e\n        )[0].classes[0]");
            J.Annotation thirdAnnot = (J.Annotation)((J.ClassDeclaration)e6).getLeadingAnnotations().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstAnnot), (J)((J)secondAnnot))).isFalse();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)secondAnnot), (J)((J)thirdAnnot))).isTrue();
        }

        @Test
        public static void tagAnnotationEquality(@NotNull SemanticallyEqualTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List cu = jp.parse(new String[]{"\n                @Tag(FastTests.class)\n                @Tag(FastTests.class)\n                @Tag(SlowTests.class)\n                class A {}\n            ", "\n                @interface Tags {\n                    Tag[] value();\n                }\n            ", "\n                @java.lang.annotation.Repeatable(Tags.class)\n                @interface Tag {\n                    Class value();\n                }\n            ", "public interface FastTests {}", "public interface SlowTests {}"});
            Object e = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"cu[0]");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"cu[0].classes[0]");
            J.Annotation fastTest = (J.Annotation)((J.ClassDeclaration)e2).getLeadingAnnotations().get(0);
            Object e3 = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"cu[0]");
            Object e4 = ((J.CompilationUnit)e3).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e4, (String)"cu[0].classes[0]");
            J.Annotation fastTest2 = (J.Annotation)((J.ClassDeclaration)e4).getLeadingAnnotations().get(1);
            Object e5 = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e5, (String)"cu[0]");
            Object e6 = ((J.CompilationUnit)e5).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e6, (String)"cu[0].classes[0]");
            J.Annotation slowTest = (J.Annotation)((J.ClassDeclaration)e6).getLeadingAnnotations().get(2);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)fastTest), (J)((J)fastTest2))).isTrue();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)fastTest), (J)((J)slowTest))).isFalse();
        }

        @Test
        public static void annotationEquality(@NotNull SemanticallyEqualTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List cu = jp.parse(new String[]{"\n                @MyAnnotation(value = true, srcValue = \"true\")\n                class A {}\n            ", "\n            @interface MyAnnotation { \n                boolean value();\n                String srcValue(); \n            }\n            @interface NoArgAnnotation1{}\n            @interface NoArgAnnotation2{}\n        "});
            Object e = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"cu[0]");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"cu[0].classes[0]");
            J.Annotation firstAnnot = (J.Annotation)((J.ClassDeclaration)e2).getLeadingAnnotations().get(0);
            jp.reset();
            Object e3 = jp.parse(new String[]{"\n                @MyAnnotation(value = true, srcValue = \"true\")\n                class B {}\n            ", "\n            @interface MyAnnotation { \n                boolean value();\n                String srcValue(); \n            }\n            @interface NoArgAnnotation1{}\n            @interface NoArgAnnotation2{}\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"jp.parse(\n            \"\"\u2026notInterface\n        )[0]");
            Object e4 = ((J.CompilationUnit)e3).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e4, (String)"jp.parse(\n            \"\"\u2026e\n        )[0].classes[0]");
            J.Annotation secondAnnot = (J.Annotation)((J.ClassDeclaration)e4).getLeadingAnnotations().get(0);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstAnnot), (J)((J)secondAnnot))).isTrue();
        }

        @Test
        public static void identEquality(@NotNull SemanticallyEqualTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List cu = jp.parse(new String[]{"\n                @MyAnnotation(value = true)\n                class A {}\n            ", "@interface MyAnnotation { boolean value(); }"});
            Object e = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"cu[0]");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"cu[0].classes[0]");
            Object e3 = ((J.ClassDeclaration)e2).getLeadingAnnotations().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"cu[0].classes[0].leadingAnnotations[0]");
            NameTree firstIdent = ((J.Annotation)e3).getAnnotationType();
            J.Identifier secondIdent = J.Identifier.build((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY, (String)"MyAnnotation", (JavaType)JavaType.buildType((String)"MyAnnotation"));
            J.Identifier thirdIdent = J.Identifier.build((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY, (String)"YourAnnotation", (JavaType)JavaType.buildType((String)"YourAnnotation"));
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstIdent), (J)((J)secondIdent))).isTrue();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstIdent), (J)((J)thirdIdent))).isFalse();
        }

        @Test
        public static void fieldAccessEquality(@NotNull SemanticallyEqualTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List cu = jp.parse(new String[]{"\n                @Category(FastTest.class)\n                @Category(SlowTest.class)\n                class A {\n                }\n            ", "\n                @interface Categories {\n                    Category[] value();\n                }\n            ", "\n                @java.lang.annotation.Repeatable(Categories.class)\n                @interface Category {\n                    Class value();\n                }\n            ", "class FastTest {}", "class SlowTest {}"});
            Object e = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"cu[0]");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"cu[0].classes[0]");
            Object e3 = ((J.ClassDeclaration)e2).getLeadingAnnotations().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"cu[0].classes[0].leadingAnnotations[0]");
            List list = ((J.Annotation)e3).getArguments();
            Intrinsics.checkNotNull((Object)list);
            Expression firstFieldAccess = (Expression)CollectionsKt.first((List)list);
            J.FieldAccess secondFieldAccess = new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Expression)J.Identifier.build((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY, (String)"FastTest", (JavaType)((JavaType)JavaType.Class.build((String)"FastTest"))), new JLeftPadded(Space.EMPTY, (Object)J.Identifier.build((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY, (String)"class", null), Markers.EMPTY), (JavaType)JavaType.Class.build((String)"java.lang.Class"));
            Object e4 = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e4, (String)"cu[0]");
            Object e5 = ((J.CompilationUnit)e4).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e5, (String)"cu[0].classes[0]");
            Object e6 = ((J.ClassDeclaration)e5).getLeadingAnnotations().get(1);
            Intrinsics.checkNotNullExpressionValue(e6, (String)"cu[0].classes[0].leadingAnnotations[1]");
            List list2 = ((J.Annotation)e6).getArguments();
            Intrinsics.checkNotNull((Object)list2);
            Expression thirdFieldAccess = (Expression)CollectionsKt.first((List)list2);
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstFieldAccess), (J)((J)secondFieldAccess))).isTrue();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstFieldAccess), (J)((J)thirdFieldAccess))).isFalse();
        }

        @Test
        public static void assignEquality(@NotNull SemanticallyEqualTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List cu = jp.parse(new String[]{"\n                @MyAnnotation(value = true)\n                class A {}\n            ", "@interface MyAnnotation { boolean value(); }"});
            Object e = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"cu[0]");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"cu[0].classes[0]");
            Object e3 = ((J.ClassDeclaration)e2).getLeadingAnnotations().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"cu[0].classes[0].leadingAnnotations[0]");
            List list = ((J.Annotation)e3).getArguments();
            Intrinsics.checkNotNull((Object)list);
            Expression firstAssign = (Expression)CollectionsKt.first((List)list);
            J.Assignment secondAssign = new J.Assignment(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Expression)J.Identifier.build((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY, (String)"value", null), new JLeftPadded(Space.format((String)" "), (Object)new J.Literal(Tree.randomId(), Space.format((String)" "), Markers.EMPTY, (Object)true, "true", JavaType.Primitive.Boolean), Markers.EMPTY), (JavaType)JavaType.Primitive.Boolean);
            Expression expression = secondAssign.getVariable();
            if (expression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Identifier");
            }
            J.Assignment thirdAssign = secondAssign.withVariable((Expression)((J.Identifier)expression).withName("otherValue"));
            Expression expression2 = secondAssign.getAssignment();
            if (expression2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Literal");
            }
            J.Assignment fourthAssign = secondAssign.withAssignment((Expression)((J.Literal)expression2).withValue((Object)false));
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstAssign), (J)((J)secondAssign))).isTrue();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstAssign), (J)((J)thirdAssign))).isFalse();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)firstAssign), (J)((J)fourthAssign))).isFalse();
        }

        @Test
        public static void literalEquality(@NotNull SemanticallyEqualTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List cu = jp.parse(new String[]{"\n                class A {\n                    int i = 0;\n                    String str = \"thisString\";\n                    String str2 = null;\n                }\n            "});
            Object e = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"cu[0]");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"cu[0].classes[0]");
            J.Block block = ((J.ClassDeclaration)e2).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"cu[0].classes[0].body");
            Object e3 = block.getStatements().get(0);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Object e4 = ((J.VariableDeclarations)e3).getVariables().get(0);
            Intrinsics.checkNotNullExpressionValue(e4, (String)"(cu[0].classes[0].body.s\u2026eclarations).variables[0]");
            Expression intLiteral = ((J.VariableDeclarations.NamedVariable)e4).getInitializer();
            Object e5 = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e5, (String)"cu[0]");
            Object e6 = ((J.CompilationUnit)e5).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e6, (String)"cu[0].classes[0]");
            J.Block block2 = ((J.ClassDeclaration)e6).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"cu[0].classes[0].body");
            Object e7 = block2.getStatements().get(1);
            if (e7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Object e8 = ((J.VariableDeclarations)e7).getVariables().get(0);
            Intrinsics.checkNotNullExpressionValue(e8, (String)"(cu[0].classes[0].body.s\u2026eclarations).variables[0]");
            Expression strLiteral = ((J.VariableDeclarations.NamedVariable)e8).getInitializer();
            Object e9 = cu.get(0);
            Intrinsics.checkNotNullExpressionValue(e9, (String)"cu[0]");
            Object e10 = ((J.CompilationUnit)e9).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e10, (String)"cu[0].classes[0]");
            J.Block block3 = ((J.ClassDeclaration)e10).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block3, (String)"cu[0].classes[0].body");
            Object e11 = block3.getStatements().get(2);
            if (e11 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            Object e12 = ((J.VariableDeclarations)e11).getVariables().get(0);
            Intrinsics.checkNotNullExpressionValue(e12, (String)"(cu[0].classes[0].body.s\u2026eclarations).variables[0]");
            Expression nullLiteral = ((J.VariableDeclarations.NamedVariable)e12).getInitializer();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)intLiteral), (J)((J)new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)0, "0", JavaType.Primitive.Int)))).isTrue();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)strLiteral), (J)((J)new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)"thisString", "thisString", JavaType.Primitive.String)))).isTrue();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)nullLiteral), (J)((J)new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, "null", JavaType.Primitive.String)))).isTrue();
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)strLiteral), (J)((J)new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)0, "0", JavaType.Primitive.Int)))).isFalse();
        }

        @Test
        public static void typeEqualityDependsOnlyOnFqn(@NotNull SemanticallyEqualTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.Identifier nameA = J.Identifier.build((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY, (String)"name", (JavaType)((JavaType)JavaType.Class.build((String)"org.foo.Bar")));
            boolean bl = false;
            bl = false;
            bl = false;
            J.Identifier nameB = J.Identifier.build((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY, (String)"name", (JavaType)((JavaType)JavaType.Class.build((String)"org.foo.Bar", (List)CollectionsKt.emptyList(), (List)CollectionsKt.emptyList(), (List)CollectionsKt.listOf((Object)JavaType.Class.build((String)"org.foo.Baz")), (List)CollectionsKt.emptyList(), null)));
            Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)nameA), (J)((J)nameB))).isTrue();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/openrewrite/java/search/SemanticallyEqualTest$Companion;", "", "()V", "annotInterface", "", "rewrite-test"})
    public static final class Companion {
        private static final String annotInterface = "\n            @interface MyAnnotation { \n                boolean value();\n                String srcValue(); \n            }\n            @interface NoArgAnnotation1{}\n            @interface NoArgAnnotation2{}\n        ";
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

