/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.search.FindAnnotations;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\bf\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fJ\b\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\u0010"}, d2={"Lorg/openrewrite/java/search/FindAnnotationsTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "checkValidation", "", "doesNotMatchDifferentNamedParameters", "jp", "Lorg/openrewrite/java/JavaParser;", "doesNotMatchDifferentSingleAnnotationParameter", "doesNotMatchNotFullyQualifiedAnnotations", "matchesAnnotationOnField", "matchesAnnotationOnMethod", "matchesNamedParameters", "matchesNamedParametersRegardlessOfOrder", "matchesSimpleFullyQualifiedAnnotation", "matchesSingleAnnotationParameter", "Companion", "rewrite-test"})
public interface FindAnnotationsTest
extends JavaRecipeTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.search.FindAnnotationsTest$Companion.$$INSTANCE;
    @NotNull
    public static final String foo = "\n            package com.netflix.foo;\n            public @interface Foo {\n                String bar();\n                String baz();\n            }\n        ";

    @Test
    public void matchesSimpleFullyQualifiedAnnotation(@NotNull JavaParser var1);

    @Test
    public void matchesAnnotationOnMethod(@NotNull JavaParser var1);

    @Test
    public void matchesAnnotationOnField(@NotNull JavaParser var1);

    @Test
    public void doesNotMatchNotFullyQualifiedAnnotations(@NotNull JavaParser var1);

    @Test
    public void matchesSingleAnnotationParameter(@NotNull JavaParser var1);

    @Test
    public void doesNotMatchDifferentSingleAnnotationParameter(@NotNull JavaParser var1);

    @Test
    public void matchesNamedParameters(@NotNull JavaParser var1);

    @Test
    public void doesNotMatchDifferentNamedParameters(@NotNull JavaParser var1);

    @Test
    public void matchesNamedParametersRegardlessOfOrder(@NotNull JavaParser var1);

    @Test
    public void checkValidation();

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void matchesSimpleFullyQualifiedAnnotation(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, (Recipe)new FindAnnotations("@java.lang.Deprecated"), "@Deprecated public class A {}", null, 0, "/*~~>*/@Deprecated public class A {}", 24, null);
        }

        @Test
        public static void matchesAnnotationOnMethod(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, (Recipe)new FindAnnotations("@java.lang.Deprecated"), "\n            public class A {\n                @Deprecated\n                public void foo() {}\n            }\n        ", null, 0, "\n            public class A {\n                /*~~>*/@Deprecated\n                public void foo() {}\n            }\n        ", 24, null);
        }

        @Test
        public static void matchesAnnotationOnField(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, (Recipe)new FindAnnotations("@java.lang.Deprecated"), "\n            public class A {\n                @Deprecated String s;\n            }\n        ", null, 0, "\n            public class A {\n                /*~~>*/@Deprecated String s;\n            }\n        ", 24, null);
        }

        @Test
        public static void doesNotMatchNotFullyQualifiedAnnotations(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, (Recipe)new FindAnnotations("@Deprecated"), "@Deprecated public class A {}", null, 8, null);
        }

        @Test
        public static void matchesSingleAnnotationParameter(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, (Recipe)new FindAnnotations("@java.lang.SuppressWarnings(\"deprecation\")"), "@SuppressWarnings(\"deprecation\") public class A {}", null, 0, "/*~~>*/@SuppressWarnings(\"deprecation\") public class A {}", 24, null);
        }

        @Test
        public static void doesNotMatchDifferentSingleAnnotationParameter(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, (Recipe)new FindAnnotations("@java.lang.SuppressWarnings(\"foo\")"), "@SuppressWarnings(\"deprecation\") public class A {}", null, 8, null);
        }

        @Test
        public static void matchesNamedParameters(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{FindAnnotationsTest.foo};
            int n = 0;
            String string = "\n            import com.netflix.foo.Foo;\n            /*~~>*/@Foo(bar=\"quux\", baz=\"bar\")\n            public class A {}\n        ";
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, (Recipe)new FindAnnotations("@com.netflix.foo.Foo(bar=\"quux\",baz=\"bar\")"), "\n            import com.netflix.foo.Foo;\n            @Foo(bar=\"quux\", baz=\"bar\")\n            public class A {}\n        ", stringArray, n, string, 16, null);
        }

        @Test
        public static void doesNotMatchDifferentNamedParameters(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertUnchanged((Parser)jp, (Recipe)new FindAnnotations("@com.netflix.foo.Foo(bar=\"qux\",baz=\"baz\")"), "\n            import com.netflix.foo.Foo;\n            @Foo(bar=\"quux\", baz=\"bar\")\n            public class A {} \n        ", new String[]{FindAnnotationsTest.foo});
        }

        @Test
        public static void matchesNamedParametersRegardlessOfOrder(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{FindAnnotationsTest.foo};
            int n = 0;
            String string = "\n            import com.netflix.foo.Foo;\n            /*~~>*/@Foo(bar=\"quux\", baz=\"bar\")\n            public class A {}\n        ";
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, (Recipe)new FindAnnotations("@com.netflix.foo.Foo(baz=\"bar\",bar=\"quux\")"), "\n            import com.netflix.foo.Foo;\n            @Foo(bar=\"quux\", baz=\"bar\")\n            public class A {}\n        ", stringArray, n, string, 16, null);
        }

        @Test
        public static void checkValidation(@NotNull FindAnnotationsTest $this) {
            Validated valid;
            FindAnnotations recipe2 = new FindAnnotations(null);
            Validated validated = valid = recipe2.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated, (String)"valid");
            Assertions.assertThat((boolean)validated.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Object e = valid.failures().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"valid.failures()[0]");
            Assertions.assertThat((String)((Validated.Invalid)e).getProperty()).isEqualTo("annotationPattern");
            recipe2 = new FindAnnotations("@com.netflix.foo.Foo(baz=\"bar\",bar=\"quux\")");
            Validated validated2 = valid = recipe2.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated2, (String)"valid");
            Assertions.assertThat((boolean)validated2.isValid()).isTrue();
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull FindAnnotationsTest $this) {
            return JavaRecipeTest.DefaultImpls.getTreePrinter($this);
        }

        public static void assertChanged(@NotNull FindAnnotationsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, cycles, after);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull FindAnnotationsTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertChanged(@NotNull FindAnnotationsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull FindAnnotationsTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertUnchanged(@NotNull FindAnnotationsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull FindAnnotationsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull FindAnnotationsTest $this) {
            return JavaRecipeTest.DefaultImpls.getRecipe($this);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull FindAnnotationsTest $this) {
            return JavaRecipeTest.DefaultImpls.getParser($this);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull FindAnnotationsTest $this, @NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return JavaRecipeTest.DefaultImpls.toRecipe($this, $this$toRecipe);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/openrewrite/java/search/FindAnnotationsTest$Companion;", "", "()V", "foo", "", "rewrite-test"})
    public static final class Companion {
        @NotNull
        public static final String foo = "\n            package com.netflix.foo;\n            public @interface Foo {\n                String bar();\n                String baz();\n            }\n        ";
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

