/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.OrderImports;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.style.NamedStyles;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\bf\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eJ\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\b\u0010\u0019\u001a\u00020\u0007H\u0017J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u001f"}, d2={"Lorg/openrewrite/java/OrderImportsTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/java/OrderImports;", "getRecipe", "()Lorg/openrewrite/java/OrderImports;", "blankLineThenEmptyBlockThenNonEmptyBlock", "", "jp", "Lorg/openrewrite/java/JavaParser;", "blankLinesNotFollowedByBlockArentAdded", "collapsesDifferentStaticImportsFromSamePackage", "foldGroupOfStaticImportsThatAppearLast", "foldIntoExistingStar", "foldIntoStar", "idempotence", "importSorting", "orderImports", "packagePatternEscapesDots", "preservesDifferentStaticImportsFromSamePackage", "preservesStaticInheritanceImport", "preservesStaticMethodArguments", "preservesStaticStarImportWhenRemovingUnused", "removeUnused", "removesRedundantImports", "springCloudFormat", "twoImportsFollowedByStar", "unfoldStar", "unfoldStarMultiple", "unfoldStaticStar", "Companion", "rewrite-test"})
public interface OrderImportsTest
extends JavaRecipeTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.OrderImportsTest$Companion.$$INSTANCE;
    @NotNull
    public static final String a = "\n            package com.foo;\n            \n            public class A {\n                public static int one() { return 1;}\n                public static int plusOne(int n) { return n + 1; }\n                public static int three() { return 3; }\n            }\n        ";
    @NotNull
    public static final String b = "\n            package com.foo;\n            \n            public class B {\n                public static int two() { return 2; }\n                public static int multiply(int n, int n2) { return n * n2; }\n                public static int four() { return 4; }\n            }    \n        ";

    @NotNull
    public OrderImports getRecipe();

    @Test
    public void orderImports(@NotNull JavaParser var1);

    @Test
    public void blankLineThenEmptyBlockThenNonEmptyBlock(@NotNull JavaParser var1);

    @Test
    public void foldIntoStar(@NotNull JavaParser var1);

    @Test
    public void blankLinesNotFollowedByBlockArentAdded(@NotNull JavaParser var1);

    @Test
    public void foldIntoExistingStar(@NotNull JavaParser var1);

    @Test
    public void idempotence(@NotNull JavaParser var1);

    @Test
    public void unfoldStar(@NotNull JavaParser var1);

    @Test
    public void unfoldStarMultiple(@NotNull JavaParser var1);

    @Test
    public void removeUnused(@NotNull JavaParser var1);

    @Test
    public void unfoldStaticStar(@NotNull JavaParser var1);

    @Test
    public void packagePatternEscapesDots(@NotNull JavaParser var1);

    @Test
    public void twoImportsFollowedByStar(@NotNull JavaParser var1);

    @Test
    public void springCloudFormat();

    @Test
    public void importSorting(@NotNull JavaParser var1);

    @Test
    public void foldGroupOfStaticImportsThatAppearLast(@NotNull JavaParser var1);

    @Test
    public void preservesStaticStarImportWhenRemovingUnused(@NotNull JavaParser var1);

    @Test
    public void preservesStaticInheritanceImport(@NotNull JavaParser var1);

    @Test
    public void preservesStaticMethodArguments(@NotNull JavaParser var1);

    @Test
    public void preservesDifferentStaticImportsFromSamePackage(@NotNull JavaParser var1);

    @Test
    public void collapsesDifferentStaticImportsFromSamePackage(@NotNull JavaParser var1);

    @Test
    public void removesRedundantImports(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static OrderImports getRecipe(@NotNull OrderImportsTest $this) {
            OrderImports orderImports = new OrderImports();
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = orderImports;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(false);
            return orderImports;
        }

        @Test
        public static void orderImports(@NotNull OrderImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            import static java.util.stream.Collectors.joining;\n            import java.util.ArrayList;\n            import java.util.regex.Pattern;\n            import java.util.Objects;\n            import java.util.Set;\n            import org.openrewrite.java.tree.JavaType;\n            import org.openrewrite.java.tree.TypeUtils;\n            \n            class A {}\n        ", null, 0, "\n            import org.openrewrite.java.tree.JavaType;\n            import org.openrewrite.java.tree.TypeUtils;\n            \n            import java.util.ArrayList;\n            import java.util.Objects;\n            import java.util.Set;\n            import java.util.regex.Pattern;\n            \n            import static java.util.stream.Collectors.joining;\n            \n            class A {}\n        ", 26, null);
        }

        @Test
        public static void blankLineThenEmptyBlockThenNonEmptyBlock(@NotNull OrderImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            import java.util.ArrayList;\n            import java.util.Objects;\n\n            import org.openrewrite.java.tree.JavaType;\n            \n            class A {}\n        ", null, 0, "\n            import org.openrewrite.java.tree.JavaType;\n            \n            import java.util.ArrayList;\n            import java.util.Objects;\n            \n            class A {}\n        ", 26, null);
        }

        @Test
        public static void foldIntoStar(@NotNull OrderImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            import java.util.List;\n            import java.util.ArrayList;\n            import java.util.regex.Pattern;\n            import java.util.Objects;\n            import java.util.Set;\n            import java.util.Map;\n            \n            class A {}\n        ", null, 0, "\n            import java.util.*;\n            import java.util.regex.Pattern;\n            \n            class A {}\n        ", 26, null);
        }

        @Test
        public static void blankLinesNotFollowedByBlockArentAdded(@NotNull OrderImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, null, "\n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            class A {}\n        ", null, 10, null);
        }

        @Test
        public static void foldIntoExistingStar(@NotNull OrderImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            import java.util.*;\n            import java.util.ArrayList;\n            import java.util.regex.Pattern;\n            import java.util.Objects;\n            \n            class A {}\n        ", null, 0, "\n            import java.util.*;\n            import java.util.regex.Pattern;\n            \n            class A {}\n        ", 26, null);
        }

        @Test
        public static void idempotence(@NotNull OrderImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, null, "\n            import java.util.*;\n            import java.util.regex.Pattern;\n\n            class A {}\n        ", null, 10, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void unfoldStar(@NotNull OrderImportsTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImports orderImports = $this.getRecipe();
            boolean bl = false;
            boolean bl2 = false;
            OrderImports orderImports2 = orderImports;
            Parser parser = (Parser)jp;
            RecipeTest recipeTest = $this;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(true);
            Unit unit = Unit.INSTANCE;
            RecipeTest.DefaultImpls.assertChanged$default(recipeTest, parser, (Recipe)orderImports, "\n            import java.util.*;\n            \n            class A {\n                List list;\n                List list2;\n            }\n        ", null, 0, "\n            import java.util.List;\n            \n            class A {\n                List list;\n                List list2;\n            }\n        ", 24, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void unfoldStarMultiple(@NotNull OrderImportsTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImports orderImports = $this.getRecipe();
            boolean bl = false;
            boolean bl2 = false;
            OrderImports orderImports2 = orderImports;
            Parser parser = (Parser)jp;
            RecipeTest recipeTest = $this;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(true);
            Unit unit = Unit.INSTANCE;
            RecipeTest.DefaultImpls.assertChanged$default(recipeTest, parser, (Recipe)orderImports, "\n            import java.util.*;\n            \n            class A {\n                List list;\n                List list2;\n                Map map;\n            }\n        ", null, 0, "\n            import java.util.List;\n            import java.util.Map;\n            \n            class A {\n                List list;\n                List list2;\n                Map map;\n            }\n        ", 24, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void removeUnused(@NotNull OrderImportsTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImports orderImports = $this.getRecipe();
            boolean bl = false;
            boolean bl2 = false;
            OrderImports orderImports2 = orderImports;
            Parser parser = (Parser)jp;
            RecipeTest recipeTest = $this;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(true);
            Unit unit = Unit.INSTANCE;
            RecipeTest.DefaultImpls.assertChanged$default(recipeTest, parser, (Recipe)orderImports, "\n            import java.util.*;\n            \n            class A {\n            }\n        ", null, 0, "\n            class A {\n            }\n        ", 24, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void unfoldStaticStar(@NotNull OrderImportsTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImports orderImports = $this.getRecipe();
            boolean bl = false;
            boolean bl2 = false;
            OrderImports orderImports2 = orderImports;
            Parser parser = (Parser)jp;
            RecipeTest recipeTest = $this;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(true);
            Unit unit = Unit.INSTANCE;
            RecipeTest.DefaultImpls.assertChanged$default(recipeTest, parser, (Recipe)orderImports, "\n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            class A {\n                List list = emptyList();\n            }\n        ", null, 0, "\n            import java.util.List;\n            \n            import static java.util.Collections.emptyList;\n            \n            class A {\n                List list = emptyList();\n            }\n        ", 24, null);
        }

        @Test
        public static void packagePatternEscapesDots(@NotNull OrderImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, null, "\n            import javax.annotation.Nonnull;\n            \n            class A {}\n        ", null, 10, null);
        }

        @Test
        public static void twoImportsFollowedByStar(@NotNull OrderImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, null, "\n            import java.io.IOException;\n            import java.io.UncheckedIOException;\n            import java.nio.files.*;\n            \n            class A {}\n        ", null, 10, null);
        }

        @Test
        public static void springCloudFormat(@NotNull OrderImportsTest $this) {
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles("spring", (Collection)CollectionsKt.listOf((Object)ImportLayoutStyle.builder().classCountToUseStarImport(999).nameCountToUseStarImport(999).importPackage("java.*").blankLine().importPackage("javax.*").blankLine().importAllOthers().blankLine().importPackage("org.springframework.*").blankLine().importStaticAllOthers().build())))).build(), null, "\n            import java.io.ByteArrayOutputStream;\n            import java.nio.charset.StandardCharsets;\n            import java.util.Collections;\n            import java.util.zip.GZIPOutputStream;\n            \n            import javax.servlet.ReadListener;\n            import javax.servlet.ServletInputStream;\n            import javax.servlet.ServletOutputStream;\n            \n            import com.fasterxml.jackson.databind.ObjectMapper;\n            import org.apache.commons.logging.Log;\n            import reactor.core.publisher.Mono;\n            \n            import org.springframework.core.io.buffer.DataBuffer;\n            import org.springframework.core.io.buffer.DataBufferFactory;\n            import org.springframework.http.HttpHeaders;\n            import org.springframework.util.MultiValueMap;\n            import org.springframework.web.bind.annotation.PathVariable;\n            import org.springframework.web.server.ServerWebExchange;\n            \n            import static java.util.Arrays.stream;\n            import static org.springframework.cloud.gateway.support.ServerWebExchangeUtils.toAsyncPredicate;\n            \n            class A {}\n        ", null, 10, null);
        }

        @Test
        public static void importSorting(@NotNull OrderImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            import r.core.Flux;\n            import s.core.Flux;\n            import com.fasterxml.jackson.databind.ObjectMapper;\n            import org.apache.commons.logging.Log;\n            import reactor.core.publisher.Mono;\n            \n            class A {}\n        ", null, 0, "\n            import com.fasterxml.jackson.databind.ObjectMapper;\n            import org.apache.commons.logging.Log;\n            import r.core.Flux;\n            import reactor.core.publisher.Mono;\n            import s.core.Flux;\n            \n            class A {}\n        ", 26, null);
        }

        @Test
        public static void foldGroupOfStaticImportsThatAppearLast(@NotNull OrderImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            import static java.util.stream.Collectors.toList;\n            import static java.util.stream.Collectors.toMap;\n            import static java.util.stream.Collectors.toSet;\n            \n            class A {}\n        ", null, 0, "\n            import static java.util.stream.Collectors.*;\n            \n            class A {}\n        ", 26, null);
        }

        @Test
        public static void preservesStaticStarImportWhenRemovingUnused(@NotNull OrderImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            package org.bar;\n            \n            import static com.foo.A.*;\n            \n            class B {\n                void bar() {\n                    foo();\n                    bar();\n                    baz();\n                    foo2();\n                    bar2();\n                    baz2();\n                }\n            }\n        ";
            String[] stringArray = new String[]{"\n                package com.foo;\n                \n                public class A {\n                    public static void foo() {}\n                    public static void bar() {}\n                    public static void baz() {}\n                    public static void foo2() {}\n                    public static void bar2() {}\n                    public static void baz2() {}\n                }\n            "};
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, null, string, stringArray, 2, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void preservesStaticInheritanceImport(@NotNull OrderImportsTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = $this.getRecipe();
            boolean bl = false;
            boolean bl2 = false;
            OrderImports orderImports = object;
            Parser parser = (Parser)jp;
            OrderImportsTest orderImportsTest = $this;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(true);
            Unit unit = Unit.INSTANCE;
            Recipe recipe2 = (Recipe)object;
            object = "\n            package org.bar;\n            \n            import static com.foo.B.*;\n            \n            class C {\n                void bar() {\n                    foo();\n                    bar();\n                    baz();\n                    foo2();\n                    bar2();\n                    baz2();\n                }\n            }\n        ";
            String[] stringArray = new String[]{"\n                package com.baz;\n                \n                public class A {\n                    public static void foo() {}\n                    public static void bar() {}\n                    public static void baz() {}\n                    public static void foo2() {}\n                    public static void bar2() {}\n                    public static void baz2() {}\n                }\n            ", "\n                package com.foo;\n                \n                import com.baz.A; \n                \n                public class B extends A { }\n            "};
            orderImportsTest.assertUnchanged(parser, recipe2, (String)object, stringArray);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void preservesStaticMethodArguments(@NotNull OrderImportsTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = $this.getRecipe();
            boolean bl = false;
            boolean bl2 = false;
            OrderImports orderImports = object;
            Parser parser = (Parser)jp;
            OrderImportsTest orderImportsTest = $this;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(true);
            Unit unit = Unit.INSTANCE;
            Recipe recipe2 = (Recipe)object;
            object = "\n            package org.bar;\n            \n            import static com.foo.A.*;\n            \n            class B {\n                void bar() {\n                    foo(stringify(numberOne()));\n                    timesTwo(plusOne(numberTwo()));\n                }\n            }\n        ";
            String[] stringArray = new String[]{"\n                package com.foo;\n                \n                public class A {\n                    public static void foo(String bar) {}\n                    public static String stringify(Integer baz) { return baz.toString(); }\n                    public static Integer numberOne() { return 1; }\n                    public static Integer plusOne(Integer n) { return n + 1; }\n                    public static Integer timesTwo(Integer n) { return n * 2; }\n                    public static Integer numberTwo() { return 2; }\n                }\n            "};
            orderImportsTest.assertUnchanged(parser, recipe2, (String)object, stringArray);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void preservesDifferentStaticImportsFromSamePackage(@NotNull OrderImportsTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = $this.getRecipe();
            boolean bl = false;
            boolean bl2 = false;
            OrderImports orderImports = object;
            Parser parser = (Parser)jp;
            OrderImportsTest orderImportsTest = $this;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(true);
            Unit unit = Unit.INSTANCE;
            Recipe recipe2 = (Recipe)object;
            object = "\n            package org.bar;\n            \n            import static com.foo.A.one;\n            import static com.foo.A.plusOne;\n            import static com.foo.B.multiply;\n            import static com.foo.B.two;\n            \n            public class C {\n                void c() {\n                    multiply(plusOne(one()), two());\n                }\n            }\n        ";
            String[] stringArray = new String[]{OrderImportsTest.a, OrderImportsTest.b};
            orderImportsTest.assertUnchanged(parser, recipe2, (String)object, stringArray);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void collapsesDifferentStaticImportsFromSamePackage(@NotNull OrderImportsTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = $this.getRecipe();
            int n = 0;
            boolean bl = false;
            String[] stringArray = object;
            Parser parser = (Parser)jp;
            RecipeTest recipeTest = $this;
            boolean bl2 = false;
            $this$apply.setRemoveUnused(true);
            Unit unit = Unit.INSTANCE;
            Recipe recipe2 = (Recipe)object;
            object = "\n            package org.bar;\n            \n            import static com.foo.A.*;\n            import static com.foo.B.*;\n            \n            public class C {\n                void c() {\n                    multiply(plusOne(one()), two());\n                    three();\n                    four();\n                }\n            }\n        ";
            n = 0;
            String string = "\n            package org.bar;\n            \n            import static com.foo.A.one;\n            import static com.foo.A.plusOne;\n            import static com.foo.A.three;\n            import static com.foo.B.multiply;\n            import static com.foo.B.two;\n            import static com.foo.B.four;\n            \n            public class C {\n                void c() {\n                    multiply(plusOne(one()), two());\n                    three();\n                    four();\n                }\n            }\n        ";
            stringArray = new String[]{OrderImportsTest.a, OrderImportsTest.b};
            RecipeTest.DefaultImpls.assertChanged$default(recipeTest, parser, recipe2, string, stringArray, n, (String)object, 16, null);
        }

        @Test
        public static void removesRedundantImports(@NotNull OrderImportsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            package org.bar;\n            \n            import com.foo.B;\n            \n            import static com.foo.A.one;\n            \n            public class C {\n                void c() {\n                    one();\n                    B.two();\n                }\n            }\n        ";
            int n = 0;
            String string2 = "\n            package org.bar;\n            \n            import com.foo.B;\n            import com.foo.B;\n            \n            import static com.foo.A.one;\n            import static com.foo.A.one;\n            \n            public class C {\n                void c() {\n                    one();\n                    B.two();\n                }\n            }\n        ";
            String[] stringArray = new String[]{OrderImportsTest.a, OrderImportsTest.b};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, string2, stringArray, n, string, 18, null);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull OrderImportsTest $this) {
            return JavaRecipeTest.DefaultImpls.getTreePrinter($this);
        }

        public static void assertChanged(@NotNull OrderImportsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, cycles, after);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull OrderImportsTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertChanged(@NotNull OrderImportsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull OrderImportsTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertUnchanged(@NotNull OrderImportsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull OrderImportsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull OrderImportsTest $this) {
            return JavaRecipeTest.DefaultImpls.getParser($this);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull OrderImportsTest $this, @NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return JavaRecipeTest.DefaultImpls.toRecipe($this, $this$toRecipe);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/openrewrite/java/OrderImportsTest$Companion;", "", "()V", "a", "", "b", "rewrite-test"})
    public static final class Companion {
        @NotNull
        public static final String a = "\n            package com.foo;\n            \n            public class A {\n                public static int one() { return 1;}\n                public static int plusOne(int n) { return n + 1; }\n                public static int three() { return 3; }\n            }\n        ";
        @NotNull
        public static final String b = "\n            package com.foo;\n            \n            public class B {\n                public static int two() { return 2; }\n                public static int multiply(int n, int n2) { return n * n2; }\n                public static int four() { return 4; }\n            }    \n        ";
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

