/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.search.FindInheritedFields;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0007"}, d2={"Lorg/openrewrite/java/search/FindInheritedFieldsTest;", "", "findArrayOfType", "", "jp", "Lorg/openrewrite/java/JavaParser;", "findInheritedField", "rewrite-test"})
public interface FindInheritedFieldsTest {
    @Test
    public void findInheritedField(@NotNull JavaParser var1);

    @Test
    public void findArrayOfType(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void findInheritedField(@NotNull FindInheritedFieldsTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit b;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String a = "\n            import java.util.*;\n            public class A {\n               protected List list;\n               private Set set;\n            }\n        ";
            J.CompilationUnit compilationUnit = b = (J.CompilationUnit)jp.parse(new String[]{"public class B extends A { }", a}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"b");
            Set set = FindInheritedFields.find((J)((J)compilationUnit.getClasses().get(0)), (String)"java.util.List");
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"FindInheritedFields.find\u2026ses[0], \"java.util.List\")");
            JavaType.Var var = (JavaType.Var)CollectionsKt.firstOrNull((Iterable)set);
            Assertions.assertThat((String)(var != null ? var.getName() : null)).isEqualTo("list");
            Assertions.assertThat((Iterable)FindInheritedFields.find((J)((J)b.getClasses().get(0)), (String)"java.util.Set")).isEmpty();
        }

        @Test
        public static void findArrayOfType(@NotNull FindInheritedFieldsTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit b;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String a = "\n            public class A {\n               String[] s;\n            }\n        ";
            J.CompilationUnit compilationUnit = b = (J.CompilationUnit)jp.parse(new String[]{"public class B extends A { }", a}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"b");
            Set set = FindInheritedFields.find((J)((J)compilationUnit.getClasses().get(0)), (String)"java.lang.String");
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"FindInheritedFields.find\u2026s[0], \"java.lang.String\")");
            JavaType.Var var = (JavaType.Var)CollectionsKt.firstOrNull((Iterable)set);
            Assertions.assertThat((String)(var != null ? var.getName() : null)).isEqualTo("s");
            Assertions.assertThat((Iterable)FindInheritedFields.find((J)((J)b.getClasses().get(0)), (String)"java.util.Set")).isEmpty();
        }
    }
}

