/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.cleanup.HideUtilityClassConstructor;
import org.openrewrite.java.cleanup.HideUtilityClassConstructorStyle;
import org.openrewrite.style.NamedStyles;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\u0013\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0014H\u0017J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u001b"}, d2={"Lorg/openrewrite/java/cleanup/HideUtilityClassConstructorTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "addPrivateConstructorWhenOnlyDefaultConstructor", "", "jp", "Lorg/openrewrite/java/JavaParser;", "changePackagePrivateConstructorToPrivate", "changePublicConstructorToPrivate", "changeUtilityClassesWithMixedExposedConstructors", "identifyNonUtilityClassesMixedFields", "identifyNonUtilityClassesMixedMethods", "identifyNonUtilityClassesOnlyPublicConstructor", "identifyNonUtilityClassesTotallyEmpty", "identifyNonUtilityClassesWhenExtendsClass", "identifyNonUtilityClassesWhenImplementsInterface", "identifySuppressedUtilityClasses", "Lorg/openrewrite/java/JavaParser$Builder;", "identifyUtilityClassesInnerStaticClasses", "identifyUtilityClassesOnlyStaticFields", "identifyUtilityClassesOnlyStaticMethods", "identifyUtilityClassesOnlyStaticMethodsAndAbstractClass", "identifyUtilityClassesWithProtectedConstructor", "ignoreClassesWithMainMethod", "rewrite-test"})
public interface HideUtilityClassConstructorTest
extends JavaRecipeTest {
    @Override
    @Nullable
    public Recipe getRecipe();

    @Test
    public void changePublicConstructorToPrivate(@NotNull JavaParser var1);

    @Test
    public void changePackagePrivateConstructorToPrivate(@NotNull JavaParser var1);

    @Test
    public void identifyUtilityClassesWithProtectedConstructor(@NotNull JavaParser var1);

    @Test
    public void changeUtilityClassesWithMixedExposedConstructors(@NotNull JavaParser var1);

    @Test
    public void addPrivateConstructorWhenOnlyDefaultConstructor(@NotNull JavaParser var1);

    @Test
    public void ignoreClassesWithMainMethod(@NotNull JavaParser var1);

    @Test
    public void identifyUtilityClassesOnlyStaticFields(@NotNull JavaParser var1);

    @Test
    public void identifyNonUtilityClassesWhenImplementsInterface(@NotNull JavaParser var1);

    @Test
    public void identifyNonUtilityClassesWhenExtendsClass(@NotNull JavaParser var1);

    @Test
    public void identifyNonUtilityClassesMixedFields(@NotNull JavaParser var1);

    @Test
    public void identifyUtilityClassesOnlyStaticMethods(@NotNull JavaParser var1);

    @Test
    public void identifyUtilityClassesInnerStaticClasses(@NotNull JavaParser var1);

    @Test
    public void identifyNonUtilityClassesMixedMethods(@NotNull JavaParser var1);

    @Test
    public void identifyUtilityClassesOnlyStaticMethodsAndAbstractClass(@NotNull JavaParser var1);

    @Test
    public void identifyNonUtilityClassesOnlyPublicConstructor(@NotNull JavaParser var1);

    @Test
    public void identifyNonUtilityClassesTotallyEmpty(@NotNull JavaParser var1);

    @Test
    public void identifySuppressedUtilityClasses(@NotNull JavaParser.Builder<?, ?> var1);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Nullable
        public static Recipe getRecipe(@NotNull HideUtilityClassConstructorTest $this) {
            return (Recipe)new HideUtilityClassConstructor();
        }

        @Test
        public static void changePublicConstructorToPrivate(@NotNull HideUtilityClassConstructorTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                public A() {\n                }\n\n                public static void utility() {\n                }\n            }\n        ", null, 0, "\n            public class A {\n                private A() {\n                }\n\n                public static void utility() {\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void changePackagePrivateConstructorToPrivate(@NotNull HideUtilityClassConstructorTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                A() {\n                }\n\n                public static void utility() {\n                }\n            }\n        ", null, 0, "\n            public class A {\n                private A() {\n                }\n\n                public static void utility() {\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void identifyUtilityClassesWithProtectedConstructor(@NotNull HideUtilityClassConstructorTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                protected A() {\n                }\n\n                public static void utility() {\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void changeUtilityClassesWithMixedExposedConstructors(@NotNull HideUtilityClassConstructorTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                protected A() {\n                }\n\n                public A(String a) {\n                }\n\n                A(String a, String b) {\n                }\n\n                private A(String a, String b, String c) {\n                }\n\n                public static void utility() {\n                }\n            }\n        ", null, 0, "\n            public class A {\n                protected A() {\n                }\n\n                private A(String a) {\n                }\n\n                private A(String a, String b) {\n                }\n\n                private A(String a, String b, String c) {\n                }\n\n                public static void utility() {\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void addPrivateConstructorWhenOnlyDefaultConstructor(@NotNull HideUtilityClassConstructorTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class Math {\n                public static final int TWO = 2;\n\n                public static int addTwo(int a) {\n                    return a + TWO;\n                }\n            }\n        ", null, 0, "\n            public class Math {\n                public static final int TWO = 2;\n\n                public static int addTwo(int a) {\n                    return a + TWO;\n                }\n\n                private Math() {\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void ignoreClassesWithMainMethod(@NotNull HideUtilityClassConstructorTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                public static final int SOME_NUMBER = 0;\n\n                public static void utility() {\n                }\n\n                public static void main(String[] args) {\n                    // SpringApplication.run(A.class, args);\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void identifyUtilityClassesOnlyStaticFields(@NotNull HideUtilityClassConstructorTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                public A() {\n                }\n\n                public static int a;\n            }\n        ", null, 0, "\n            public class A {\n                private A() {\n                }\n\n                public static int a;\n            }\n        ", 26, null);
        }

        @Test
        public static void identifyNonUtilityClassesWhenImplementsInterface(@NotNull HideUtilityClassConstructorTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            public class A implements B {\n                public A() {\n                }\n\n                public static void utility() {\n                    B.utility();\n                }\n            }\n        ";
            String[] stringArray = new String[]{"\n            public interface B {\n                static void utility() {\n                }\n            }\n        "};
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, null, string, stringArray, 2, null);
        }

        @Test
        public static void identifyNonUtilityClassesWhenExtendsClass(@NotNull HideUtilityClassConstructorTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            public class A extends B {\n                public A() {\n                }\n\n                public static void doSomething() {\n                }\n            }\n        ";
            String[] stringArray = new String[]{"\n            public class B {\n                public static void utility() {}\n            }\n        "};
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, null, string, stringArray, 2, null);
        }

        @Test
        public static void identifyNonUtilityClassesMixedFields(@NotNull HideUtilityClassConstructorTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                public A() {\n                }\n\n                public int a;\n\n                public static int b;\n            }\n        ", null, 10, null);
        }

        @Test
        public static void identifyUtilityClassesOnlyStaticMethods(@NotNull HideUtilityClassConstructorTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                public A() {\n                }\n\n                public static void utility() {\n                }\n\n                public static void utility(String[] args) {\n                    utility();\n                }\n            }\n        ", null, 0, "\n            public class A {\n                private A() {\n                }\n\n                public static void utility() {\n                }\n\n                public static void utility(String[] args) {\n                    utility();\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void identifyUtilityClassesInnerStaticClasses(@NotNull HideUtilityClassConstructorTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n\n                static class Inner {\n                    public Inner() {\n                    }\n\n                    public static void utility() {\n                    }\n                }\n\n                public void utility() {\n                }\n            }\n        ", null, 0, "\n            public class A {\n\n                static class Inner {\n                    private Inner() {\n                    }\n\n                    public static void utility() {\n                    }\n                }\n\n                public void utility() {\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void identifyNonUtilityClassesMixedMethods(@NotNull HideUtilityClassConstructorTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                public A() {\n                }\n\n                public static void someStatic() {\n                }\n\n                public void notStatic() {\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void identifyUtilityClassesOnlyStaticMethodsAndAbstractClass(@NotNull HideUtilityClassConstructorTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public abstract class A {\n                public A() {\n                }\n\n                public static void someStatic1() {\n                }\n\n                public static void someStatic2() {\n                }\n            }\n        ", null, 0, "\n            public abstract class A {\n                private A() {\n                }\n\n                public static void someStatic1() {\n                }\n\n                public static void someStatic2() {\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void identifyNonUtilityClassesOnlyPublicConstructor(@NotNull HideUtilityClassConstructorTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                public A() {\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void identifyNonUtilityClassesTotallyEmpty(@NotNull HideUtilityClassConstructorTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n            }\n        ", null, 10, null);
        }

        @Test
        public static void identifySuppressedUtilityClasses(@NotNull HideUtilityClassConstructorTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            String string = "\n            import lombok.experimental.UtilityClass;\n            \n            @UtilityClass\n            public class DoNotChangeMeA {\n                public static void utility() {\n                }\n            }\n\n            @SuppressWarnings(\"checkstyle:HideUtilityClassConstructor\")\n            class DoNotChangeMeB {\n                public static void utility() {\n                }\n            }\n\n            @SuppressWarnings(\"rewrite:I-can-change\")\n            class ChangeMeA {\n                public static void utility() {\n                }\n\n                private ChangeMeA() {\n                }\n            }\n        ";
            int n = 0;
            String string2 = "\n            import lombok.experimental.UtilityClass;\n            \n            @UtilityClass\n            public class DoNotChangeMeA {\n                public static void utility() {\n                }\n            }\n\n            @SuppressWarnings(\"checkstyle:HideUtilityClassConstructor\")\n            class DoNotChangeMeB {\n                public static void utility() {\n                }\n            }\n\n            @SuppressWarnings(\"rewrite:I-can-change\")\n            class ChangeMeA {\n                public static void utility() {\n                }\n            }\n        ";
            String[] stringArray = new String[]{"\n            package lombok.experimental;\n            public @interface UtilityClass {}\n        "};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp.styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles("test", (Collection)CollectionsKt.listOf((Object)new HideUtilityClassConstructorStyle((Collection)CollectionsKt.listOf((Object[])new String[]{"@lombok.experimental.UtilityClass", "@lombok.Data", "@java.lang.SuppressWarnings(\"checkstyle:HideUtilityClassConstructor\")"})))))).build(), null, string2, stringArray, n, string, 18, null);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull HideUtilityClassConstructorTest $this) {
            return JavaRecipeTest.DefaultImpls.getTreePrinter($this);
        }

        public static void assertChanged(@NotNull HideUtilityClassConstructorTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, cycles, after);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull HideUtilityClassConstructorTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertChanged(@NotNull HideUtilityClassConstructorTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull HideUtilityClassConstructorTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertUnchanged(@NotNull HideUtilityClassConstructorTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull HideUtilityClassConstructorTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull HideUtilityClassConstructorTest $this) {
            return JavaRecipeTest.DefaultImpls.getParser($this);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull HideUtilityClassConstructorTest $this, @NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return JavaRecipeTest.DefaultImpls.toRecipe($this, $this$toRecipe);
        }
    }
}

