/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0012\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/openrewrite/java/tree/MethodInvocationTest;", "", "genericMethodInvocation", "", "jp", "Lorg/openrewrite/java/JavaParser;", "methodInvocation", "methodThatDoesNotExist", "staticMethodInvocation", "allInvs", "", "Lorg/openrewrite/java/tree/J$MethodInvocation;", "Lorg/openrewrite/java/tree/J$CompilationUnit;", "rewrite-test"})
public interface MethodInvocationTest {
    @Test
    public void methodInvocation(@NotNull JavaParser var1);

    @Test
    public void genericMethodInvocation(@NotNull JavaParser var1);

    @Test
    public void staticMethodInvocation(@NotNull JavaParser var1);

    @Test
    public void methodThatDoesNotExist(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        private static List<J.MethodInvocation> allInvs(MethodInvocationTest $this, J.CompilationUnit $this$allInvs) {
            void $this$mapTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Object e = $this$allInvs.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"classes[0]");
            J.Block block = ((J.ClassDeclaration)e).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"classes[0].body");
            List list = block.getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"classes[0].body\n        .statements");
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof J.VariableDeclarations)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                J.VariableDeclarations variableDeclarations = (J.VariableDeclarations)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object e2 = it.getVariables().get(0);
                Intrinsics.checkNotNullExpressionValue(e2, (String)"it.variables[0]");
                Expression expression = ((J.VariableDeclarations.NamedVariable)e2).getInitializer();
                if (expression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
                }
                J.MethodInvocation methodInvocation = (J.MethodInvocation)expression;
                collection.add(methodInvocation);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void methodInvocation(@NotNull MethodInvocationTest $this, @NotNull JavaParser jp) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Iterable<Object> iterable;
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                Integer m = foo ( 0, 1, 2 );\n    \n                public Integer foo(Integer n, Integer... ns) { return n; }\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            List<J.MethodInvocation> list = iterable = DefaultImpls.allInvs($this, compilationUnit);
            boolean bl = false;
            J.MethodInvocation inv = list.get(0);
            Assertions.assertEquals((Object)"foo", (Object)inv.getName().printTrimmed());
            JavaType.Class clazz = TestKt.asClass(inv.getReturnType());
            Assertions.assertEquals((Object)"java.lang.Integer", (Object)(clazz != null ? clazz.getFullyQualifiedName() : null));
            List list2 = CollectionsKt.listOf((Object[])new JavaType.Primitive[]{JavaType.Primitive.Int, JavaType.Primitive.Int, JavaType.Primitive.Int});
            List list3 = inv.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"inv.arguments");
            iterable = list3;
            List list4 = list2;
            boolean $i$f$filterIsInstance = false;
            void var6_7 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof J.Literal)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection<JavaType.Primitive> collection = (List)destination$iv$iv;
            $this$filterIsInstance$iv = collection;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                J.Literal literal = (J.Literal)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                JavaType.Primitive primitive = it.getType();
                collection.add(primitive);
            }
            collection = (List)destination$iv$iv;
            Assertions.assertEquals((Object)list4, (Object)collection);
            JavaType.Method method = inv.getType();
            Intrinsics.checkNotNull((Object)method);
            JavaType.Method.Signature signature = method.getResolvedSignature();
            Intrinsics.checkNotNullExpressionValue((Object)signature, (String)"inv.type!!.resolvedSignature");
            List effectParams = signature.getParamTypes();
            JavaType.Class clazz2 = TestKt.asClass((JavaType)effectParams.get(0));
            Assertions.assertEquals((Object)"java.lang.Integer", (Object)(clazz2 != null ? clazz2.getFullyQualifiedName() : null));
            Assertions.assertTrue((boolean)TestKt.hasElementType((JavaType)effectParams.get(1), "java.lang.Integer"));
            JavaType.Method method2 = inv.getType();
            Intrinsics.checkNotNull((Object)method2);
            JavaType.Method.Signature signature2 = method2.getResolvedSignature();
            JavaType.Method method3 = inv.getType();
            Intrinsics.checkNotNull((Object)method3);
            Assertions.assertEquals((Object)signature2, (Object)method3.getGenericSignature());
            JavaType.Method method4 = inv.getType();
            Assertions.assertEquals((Object)"A", method4 != null && (method4 = method4.getDeclaringType()) != null ? method4.getFullyQualifiedName() : null);
            Assertions.assertEquals((Object)"foo ( 0, 1, 2 )", (Object)inv.printTrimmed());
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void genericMethodInvocation(@NotNull MethodInvocationTest $this, @NotNull JavaParser jp) {
            void genericInv;
            List<J.MethodInvocation> list;
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                Integer o = generic ( 0, 1, 2 );\n                Integer p = this . < Integer > generic ( 0, 1, 2 );\n    \n                public <T> T generic(T n, T... ns) { return n; }\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            List<J.MethodInvocation> list2 = list = DefaultImpls.allInvs($this, compilationUnit);
            boolean bl = false;
            J.MethodInvocation methodInvocation = list2.get(0);
            list2 = list;
            bl = false;
            J.MethodInvocation explicitGenericInv = list2.get(1);
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])new J.MethodInvocation[]{genericInv, explicitGenericInv});
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JavaType.Method.Signature methType;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                J.MethodInvocation test = (J.MethodInvocation)element$iv;
                boolean bl2 = false;
                JavaType.Class clazz = TestKt.asClass(test.getReturnType());
                Assertions.assertEquals((Object)"java.lang.Integer", (Object)(clazz != null ? clazz.getFullyQualifiedName() : null));
                List list3 = CollectionsKt.listOf((Object[])new JavaType.Primitive[]{JavaType.Primitive.Int, JavaType.Primitive.Int, JavaType.Primitive.Int});
                List list4 = test.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"test.arguments");
                Iterable iterable = list4;
                List list5 = list3;
                boolean $i$f$filterIsInstance = false;
                void var14_17 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof J.Literal)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Collection<JavaType.Primitive> collection = (List)destination$iv$iv;
                $this$filterIsInstance$iv = collection;
                boolean $i$f$map = false;
                $this$filterIsInstanceTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    J.Literal literal = (J.Literal)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    JavaType.Primitive primitive = it.getType();
                    collection.add(primitive);
                }
                collection = (List)destination$iv$iv;
                Assertions.assertEquals((Object)list5, (Object)collection);
                JavaType.Method method = test.getType();
                Intrinsics.checkNotNull((Object)method);
                JavaType.Method.Signature signature = method.getResolvedSignature();
                Intrinsics.checkNotNullExpressionValue((Object)signature, (String)"test.type!!.resolvedSignature");
                List effectiveParams = signature.getParamTypes();
                JavaType.Class clazz2 = TestKt.asClass((JavaType)effectiveParams.get(0));
                Assertions.assertEquals((Object)"java.lang.Integer", (Object)(clazz2 != null ? clazz2.getFullyQualifiedName() : null));
                Assertions.assertTrue((boolean)TestKt.hasElementType((JavaType)effectiveParams.get(1), "java.lang.Integer"));
                JavaType.Method method2 = test.getType();
                Intrinsics.checkNotNull((Object)method2);
                JavaType.Method.Signature signature2 = methType = method2.getGenericSignature();
                Intrinsics.checkNotNullExpressionValue((Object)signature2, (String)"methType");
                JavaType.GenericTypeVariable genericTypeVariable = TestKt.asGeneric(signature2.getReturnType());
                Assertions.assertEquals((Object)"T", (Object)(genericTypeVariable != null ? genericTypeVariable.getFullyQualifiedName() : null));
                JavaType.GenericTypeVariable genericTypeVariable2 = TestKt.asGeneric((JavaType)methType.getParamTypes().get(0));
                Assertions.assertEquals((Object)"T", (Object)(genericTypeVariable2 != null ? genericTypeVariable2.getFullyQualifiedName() : null));
                Assertions.assertTrue((boolean)TestKt.hasElementType((JavaType)methType.getParamTypes().get(1), "T"));
            }
            Assertions.assertEquals((Object)"this . < Integer > generic ( 0, 1, 2 )", (Object)explicitGenericInv.printTrimmed());
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void staticMethodInvocation(@NotNull MethodInvocationTest $this, @NotNull JavaParser jp) {
            void staticInv;
            List<J.MethodInvocation> list;
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                Integer n = staticFoo ( 0 );\n                Integer o = staticFoo ( );\n    \n                public static int staticFoo(int... args) { return 0; }\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            List<J.MethodInvocation> list2 = list = DefaultImpls.allInvs($this, compilationUnit);
            boolean bl = false;
            J.MethodInvocation methodInvocation = list2.get(0);
            list2 = list;
            bl = false;
            J.MethodInvocation parameterlessStaticInv = list2.get(1);
            Assertions.assertEquals((Object)"staticFoo", (Object)staticInv.getName().printTrimmed());
            JavaType.Method method = staticInv.getType();
            Assertions.assertEquals((Object)"A", method != null && (method = method.getDeclaringType()) != null ? method.getFullyQualifiedName() : null);
            Assertions.assertEquals((Object)"staticFoo ( 0 )", (Object)staticInv.printTrimmed());
            Assertions.assertEquals((Object)"staticFoo ( )", (Object)parameterlessStaticInv.printTrimmed());
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void methodThatDoesNotExist(@NotNull MethodInvocationTest $this, @NotNull JavaParser jp) {
            void $this$filterIsInstanceTo$iv$iv;
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                Integer n = doesNotExist();\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            J.Block block = ((J.ClassDeclaration)e).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"a.classes[0].body");
            List list = block.getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"a.classes[0].body.statements");
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof J.VariableDeclarations)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Object e2 = ((J.VariableDeclarations)CollectionsKt.first((List)((List)destination$iv$iv))).getVariables().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0].body.statem\u2026s>().first().variables[0]");
            Expression expression = ((J.VariableDeclarations.NamedVariable)e2).getInitializer();
            if (expression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            J.MethodInvocation inv = (J.MethodInvocation)expression;
            JavaType.Method method = inv.getType();
            Assertions.assertNull((Object)(method != null ? method.getDeclaringType() : null));
            Assertions.assertNull((Object)inv.getType());
            Assertions.assertNull((Object)inv.getType());
        }
    }
}

