/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.java.ChangeLiteral;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.ReorderMethodArguments;
import org.openrewrite.java.ReorderMethodArgumentsTest;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\n"}, d2={"Lorg/openrewrite/java/ReorderMethodArgumentsTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "checkValidation", "", "reorderArguments", "jp", "Lorg/openrewrite/java/JavaParser;", "reorderArgumentsWhereOneOfTheOriginalArgumentsIsVararg", "reorderArgumentsWhereTheLastArgumentIsVarargAndNotPresentInInvocation", "reorderArgumentsWithNoSourceAttachment", "rewrite-test"})
public interface ReorderMethodArgumentsTest
extends JavaRecipeTest {
    @Test
    public void reorderArguments(@NotNull JavaParser var1);

    @Test
    public void reorderArgumentsWithNoSourceAttachment(@NotNull JavaParser var1);

    @Test
    public void reorderArgumentsWhereOneOfTheOriginalArgumentsIsVararg(@NotNull JavaParser var1);

    @Test
    public void reorderArgumentsWhereTheLastArgumentIsVarargAndNotPresentInInvocation(@NotNull JavaParser var1);

    @Test
    public void checkValidation();

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void reorderArguments(@NotNull ReorderMethodArgumentsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            import a.*;\n            public class B {\n               A a;\n               public void test() {\n                   a.foo(\n                       2,\n                       1,\n                       \"anotherstring\"\n                   );\n               }\n            }\n        ";
            int n = 0;
            String string2 = "\n            import a.*;\n            public class B {\n               A a;\n               public void test() {\n                   a.foo(\n                       \"mystring\",\n                       1,\n                       2\n                   );\n               }\n            }\n        ";
            String[] stringArray = new String[]{"\n                package a;\n                public class A {\n                   public void foo(String s, Integer m, Integer n) {}\n                   public void foo(Integer n, Integer m, String s) {}\n                }\n            "};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, ReorderMethodArguments.builder().methodPattern("a.A foo(String, Integer, Integer)").newParameterNames(new String[]{"n", "m", "s"}).build().doNext(new Recipe(){

                @NotNull
                protected TreeVisitor<?, ExecutionContext> getVisitor() {
                    return (TreeVisitor)new JavaVisitor<ExecutionContext>(){

                        @NotNull
                        public J visitLiteral(@NotNull J.Literal literal, @NotNull ExecutionContext p) {
                            Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
                            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                            if (literal.getType() == JavaType.Primitive.String) {
                                this.doAfterVisit((TreeVisitor)new ChangeLiteral((Expression)literal, (Function)reorderArguments.getVisitor.visitLiteral.1.INSTANCE));
                            }
                            J j = super.visitLiteral(literal, (Object)p);
                            Intrinsics.checkNotNullExpressionValue((Object)j, (String)"super.visitLiteral(literal, p)");
                            return j;
                        }
                    };
                }
            }), string2, stringArray, n, string, 16, null);
        }

        @Test
        public static void reorderArgumentsWithNoSourceAttachment(@NotNull ReorderMethodArgumentsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            import a.*;\n            public class B {\n               A a;\n               public void test() {\n                   a.foo(0, 1, \"s\");\n               }\n            }\n        ";
            int n = 0;
            String string2 = "\n            import a.*;\n            public class B {\n               A a;\n               public void test() {\n                   a.foo(\"s\", 0, 1);\n               }\n            }\n        ";
            String[] stringArray = new String[]{"\n                package a;\n                public class A {\n                   public void foo(String arg0, Integer... arg1) {}\n                   public void foo(Integer arg0, Integer arg1, String arg2) {}\n                }\n            "};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, (Recipe)ReorderMethodArguments.builder().methodPattern("a.A foo(..)").oldParameterNames(new String[]{"n", "s"}).newParameterNames(new String[]{"s", "n"}).build(), string2, stringArray, n, string, 16, null);
        }

        @Test
        public static void reorderArgumentsWhereOneOfTheOriginalArgumentsIsVararg(@NotNull ReorderMethodArgumentsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            import a.*;\n            public class B {\n               A a;\n               public void test() {\n                   a.foo(\"mystring\", \"a\", \"b\", 0);\n               }\n            }\n        ";
            int n = 0;
            String string2 = "\n            import a.*;\n            public class B {\n               A a;\n               public void test() {\n                   a.foo(\"mystring\", 0, \"a\", \"b\");\n               }\n            }\n        ";
            String[] stringArray = new String[]{"\n                package a;\n                public class A {\n                   public void foo(String s, Integer n, Object... o) {}\n                   public void bar(String s, Object... o) {}\n                }\n            "};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, (Recipe)ReorderMethodArguments.builder().methodPattern("a.A foo(..)").newParameterNames(new String[]{"s", "o", "n"}).build(), string2, stringArray, n, string, 16, null);
        }

        @Test
        public static void reorderArgumentsWhereTheLastArgumentIsVarargAndNotPresentInInvocation(@NotNull ReorderMethodArgumentsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            import a.*;\n            public class B {\n               public void test() {\n                   new A().foo(\"mystring\");\n               }\n            }\n        ";
            String[] stringArray = new String[]{"\n                package a;\n                public class A {\n                   public void foo(String s, Object... o) {}\n                }\n            "};
            $this.assertUnchanged((Parser)jp, (Recipe)ReorderMethodArguments.builder().methodPattern("a.A foo(..)").newParameterNames(new String[]{"o", "s"}).build(), string, stringArray);
        }

        @Test
        public static void checkValidation(@NotNull ReorderMethodArgumentsTest $this) {
            Validated valid;
            ReorderMethodArguments cm = new ReorderMethodArguments(null, null, null);
            Validated validated = valid = cm.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated, (String)"valid");
            Assertions.assertThat((boolean)validated.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(2);
            Object e = valid.failures().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"valid.failures()[0]");
            Assertions.assertThat((String)((Validated.Invalid)e).getProperty()).isEqualTo("methodPattern");
            Object e2 = valid.failures().get(1);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"valid.failures()[1]");
            Assertions.assertThat((String)((Validated.Invalid)e2).getProperty()).isEqualTo("newParameterNames");
            cm = new ReorderMethodArguments(null, null, new String[]{"a"});
            Validated validated2 = valid = cm.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated2, (String)"valid");
            Assertions.assertThat((boolean)validated2.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(2);
            Object e3 = valid.failures().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"valid.failures()[0]");
            Assertions.assertThat((String)((Validated.Invalid)e3).getProperty()).isEqualTo("methodPattern");
            Object e4 = valid.failures().get(1);
            Intrinsics.checkNotNullExpressionValue(e4, (String)"valid.failures()[1]");
            Assertions.assertThat((String)((Validated.Invalid)e4).getProperty()).isEqualTo("newParameterNames");
            cm = new ReorderMethodArguments(null, new String[]{"a"}, null);
            Validated validated3 = valid = cm.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated3, (String)"valid");
            Assertions.assertThat((boolean)validated3.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Object e5 = valid.failures().get(0);
            Intrinsics.checkNotNullExpressionValue(e5, (String)"valid.failures()[0]");
            Assertions.assertThat((String)((Validated.Invalid)e5).getProperty()).isEqualTo("methodPattern");
            cm = new ReorderMethodArguments("b.B foo()", null, null);
            Validated validated4 = valid = cm.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated4, (String)"valid");
            Assertions.assertThat((boolean)validated4.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Object e6 = valid.failures().get(0);
            Intrinsics.checkNotNullExpressionValue(e6, (String)"valid.failures()[0]");
            Assertions.assertThat((String)((Validated.Invalid)e6).getProperty()).isEqualTo("newParameterNames");
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull ReorderMethodArgumentsTest $this) {
            return JavaRecipeTest.DefaultImpls.getTreePrinter($this);
        }

        public static void assertChanged(@NotNull ReorderMethodArgumentsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, int cycles, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, cycles, after);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull ReorderMethodArgumentsTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertChanged(@NotNull ReorderMethodArgumentsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull ReorderMethodArgumentsTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertUnchanged(@NotNull ReorderMethodArgumentsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ReorderMethodArgumentsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull ReorderMethodArgumentsTest $this) {
            return JavaRecipeTest.DefaultImpls.getRecipe($this);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull ReorderMethodArgumentsTest $this) {
            return JavaRecipeTest.DefaultImpls.getParser($this);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull ReorderMethodArgumentsTest $this, @NotNull TreeVisitor<?, ExecutionContext> $this$toRecipe) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return JavaRecipeTest.DefaultImpls.toRecipe($this, $this$toRecipe);
        }
    }
}

