/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.FindMethods;
import org.openrewrite.marker.SearchResult;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0017R\u001a\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000e"}, d2={"Lorg/openrewrite/java/search/FindMethodsTest;", "Lorg/openrewrite/RecipeTest;", "treePrinter", "Lorg/openrewrite/TreePrinter;", "getTreePrinter", "()Lorg/openrewrite/TreePrinter;", "checkValidation", "", "findStaticMethodCalls", "jp", "Lorg/openrewrite/java/JavaParser;", "findStaticallyImportedMethodCalls", "matchOnInnerClass", "matchVarargs", "rewrite-test"})
public interface FindMethodsTest
extends RecipeTest {
    @Override
    @Nullable
    public TreePrinter<?> getTreePrinter();

    @Test
    public void findStaticMethodCalls(@NotNull JavaParser var1);

    @Test
    public void findStaticallyImportedMethodCalls(@NotNull JavaParser var1);

    @Test
    public void matchVarargs(@NotNull JavaParser var1);

    @Test
    public void matchOnInnerClass(@NotNull JavaParser var1);

    @Test
    public void checkValidation();

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull FindMethodsTest $this) {
            return SearchResult.PRINTER;
        }

        @Test
        public static void findStaticMethodCalls(@NotNull FindMethodsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, (Recipe)new FindMethods("java.util.Collections emptyList()"), "\n            import java.util.Collections;\n            public class A {\n               Object o = Collections.emptyList();\n            }\n        ", null, 0, "\n            import java.util.Collections;\n            public class A {\n               Object o = ~~>Collections.emptyList();\n            }\n        ", 24, null);
        }

        @Test
        public static void findStaticallyImportedMethodCalls(@NotNull FindMethodsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, (Recipe)new FindMethods("java.util.Collections emptyList()"), "\n            import static java.util.Collections.emptyList;\n            public class A {\n               Object o = emptyList();\n            }\n        ", null, 0, "\n            import static java.util.Collections.emptyList;\n            public class A {\n               Object o = ~~>emptyList();\n            }\n        ", 24, null);
        }

        @Test
        public static void matchVarargs(@NotNull FindMethodsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            public class A {\n                public void foo(String s, Object... o) {}\n            }\n        "};
            int n = 0;
            String string = "\n            public class B {\n               public void test() {\n                   ~~>new A().foo(\"s\", \"a\", 1);\n               }\n            }\n        ";
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, (Recipe)new FindMethods("A foo(String, Object...)"), "\n            public class B {\n               public void test() {\n                   new A().foo(\"s\", \"a\", 1);\n               }\n            }\n        ", stringArray, n, string, 16, null);
        }

        @Test
        public static void matchOnInnerClass(@NotNull FindMethodsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            public class B {\n               public static class C {\n                   public void foo() {}\n               }\n            }\n        "};
            int n = 0;
            String string = "\n            public class A {\n               void test() {\n                   ~~>new B.C().foo();\n               }\n            }\n        ";
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, (Recipe)new FindMethods("B.C foo()"), "\n            public class A {\n               void test() {\n                   new B.C().foo();\n               }\n            }\n        ", stringArray, n, string, 16, null);
        }

        @Test
        public static void checkValidation(@NotNull FindMethodsTest $this) {
            Validated valid;
            FindMethods recipe2 = new FindMethods(null);
            Validated validated = valid = recipe2.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated, (String)"valid");
            Assertions.assertThat((boolean)validated.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Object e = valid.failures().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"valid.failures()[0]");
            Assertions.assertThat((String)((Validated.Invalid)e).getProperty()).isEqualTo("methodPattern");
            recipe2 = new FindMethods("com.foo.Foo bar()");
            Validated validated2 = valid = recipe2.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated2, (String)"valid");
            Assertions.assertThat((boolean)validated2.isValid()).isTrue();
        }

        @Nullable
        public static Recipe getRecipe(@NotNull FindMethodsTest $this) {
            return RecipeTest.DefaultImpls.getRecipe($this);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull FindMethodsTest $this) {
            return RecipeTest.DefaultImpls.getParser($this);
        }

        public static void assertChanged(@NotNull FindMethodsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, int cycles, @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, cycles, after);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull FindMethodsTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertChanged(@NotNull FindMethodsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull FindMethodsTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertUnchanged(@NotNull FindMethodsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RecipeTest.DefaultImpls.assertUnchanged((RecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull FindMethodsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RecipeTest.DefaultImpls.assertUnchanged((RecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull FindMethodsTest $this, @NotNull JavaVisitor<ExecutionContext> $this$toRecipe, boolean cursored) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return RecipeTest.DefaultImpls.toRecipe($this, $this$toRecipe, cursored);
        }
    }
}

