/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.cleanup.SimplifyBooleanExpression;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0013"}, d2={"Lorg/openrewrite/java/cleanup/SimplifyBooleanExpressionTest;", "Lorg/openrewrite/RecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "simplifyAndAlwaysTrue", "", "jp", "Lorg/openrewrite/java/JavaParser;", "simplifyBooleanExpressionComprehensive", "simplifyDoubleNegation", "simplifyEqualsLiteralTrue", "simplifyEqualsLiteralTrueAlwaysTrue", "simplifyInvertedBooleanLiteral", "simplifyLiteralFalseAlwaysFalse", "simplifyNotEqualsFalse", "simplifyOrAlwaysTrue", "simplifyOrLiteralTrue", "rewrite-test"})
public interface SimplifyBooleanExpressionTest
extends RecipeTest {
    @Override
    @Nullable
    public Recipe getRecipe();

    @Test
    public void simplifyBooleanExpressionComprehensive(@NotNull JavaParser var1);

    @Test
    public void simplifyInvertedBooleanLiteral(@NotNull JavaParser var1);

    @Test
    public void simplifyEqualsLiteralTrue(@NotNull JavaParser var1);

    @Test
    public void simplifyOrLiteralTrue(@NotNull JavaParser var1);

    @Test
    public void simplifyOrAlwaysTrue(@NotNull JavaParser var1);

    @Test
    public void simplifyAndAlwaysTrue(@NotNull JavaParser var1);

    @Test
    public void simplifyEqualsLiteralTrueAlwaysTrue(@NotNull JavaParser var1);

    @Test
    public void simplifyLiteralFalseAlwaysFalse(@NotNull JavaParser var1);

    @Test
    public void simplifyDoubleNegation(@NotNull JavaParser var1);

    @Test
    public void simplifyNotEqualsFalse(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Nullable
        public static Recipe getRecipe(@NotNull SimplifyBooleanExpressionTest $this) {
            return (Recipe)new SimplifyBooleanExpression();
        }

        @Test
        public static void simplifyBooleanExpressionComprehensive(@NotNull SimplifyBooleanExpressionTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                {\n                    boolean a = !false;\n                    boolean b = (a == true);\n                    boolean c = b || true;\n                    boolean d = c || c;\n                    boolean e = d && d;\n                    boolean f = (e == true) || e;\n                    boolean g = f && false;\n                    boolean h = !!g;\n                    boolean i = (a != false);\n                }\n            }\n        ", null, 0, "\n            public class A {\n                {\n                    boolean a = true;\n                    boolean b = a;\n                    boolean c = true;\n                    boolean d = c;\n                    boolean e = d;\n                    boolean f = e;\n                    boolean g = false;\n                    boolean h = g;\n                    boolean i = a;\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void simplifyInvertedBooleanLiteral(@NotNull SimplifyBooleanExpressionTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                {\n                    boolean a = !false;\n                    boolean b = !true;\n                }\n            }\n        ", null, 0, "\n            public class A {\n                {\n                    boolean a = true;\n                    boolean b = false;\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void simplifyEqualsLiteralTrue(@NotNull SimplifyBooleanExpressionTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                {\n                    boolean a = true;\n                    boolean b = (a == true);\n                }\n            }\n        ", null, 0, "\n            public class A {\n                {\n                    boolean a = true;\n                    boolean b = a;\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void simplifyOrLiteralTrue(@NotNull SimplifyBooleanExpressionTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                {\n                    boolean b = true;\n                    boolean c = b || true;\n                }\n            }\n        ", null, 0, "\n            public class A {\n                {\n                    boolean b = true;\n                    boolean c = true;\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void simplifyOrAlwaysTrue(@NotNull SimplifyBooleanExpressionTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                {\n                    boolean c = true;\n                    boolean d = c || c;\n                }\n            }\n        ", null, 0, "\n            public class A {\n                {\n                    boolean c = true;\n                    boolean d = c;\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void simplifyAndAlwaysTrue(@NotNull SimplifyBooleanExpressionTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                {\n                    boolean d = true;\n                    boolean e = d && d;\n                }\n            }\n        ", null, 0, "\n            public class A {\n                {\n                    boolean d = true;\n                    boolean e = d;\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void simplifyEqualsLiteralTrueAlwaysTrue(@NotNull SimplifyBooleanExpressionTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                {\n                    boolean e = true;\n                    boolean f = (e == true) || e;\n                }\n            }\n        ", null, 0, "\n            public class A {\n                {\n                    boolean e = true;\n                    boolean f = e;\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void simplifyLiteralFalseAlwaysFalse(@NotNull SimplifyBooleanExpressionTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                {\n                    boolean f = true;\n                    boolean g = f && false;\n                }\n            }\n        ", null, 0, "\n            public class A {\n                {\n                    boolean f = true;\n                    boolean g = false;\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void simplifyDoubleNegation(@NotNull SimplifyBooleanExpressionTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                public void doubleNegation(boolean g) {\n                    boolean h = !!g;\n                }\n            }\n        ", null, 0, "\n            public class A {\n                public void doubleNegation(boolean g) {\n                    boolean h = g;\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void simplifyNotEqualsFalse(@NotNull SimplifyBooleanExpressionTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            public class A {\n                {\n                    boolean a = true;\n                    boolean i = (a != false);\n                }\n            }\n        ", null, 0, "\n            public class A {\n                {\n                    boolean a = true;\n                    boolean i = a;\n                }\n            }\n        ", 26, null);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull SimplifyBooleanExpressionTest $this) {
            return RecipeTest.DefaultImpls.getTreePrinter($this);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull SimplifyBooleanExpressionTest $this) {
            return RecipeTest.DefaultImpls.getParser($this);
        }

        public static void assertChanged(@NotNull SimplifyBooleanExpressionTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, int cycles, @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, cycles, after);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull SimplifyBooleanExpressionTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertChanged(@NotNull SimplifyBooleanExpressionTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull SimplifyBooleanExpressionTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertUnchanged(@NotNull SimplifyBooleanExpressionTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RecipeTest.DefaultImpls.assertUnchanged((RecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull SimplifyBooleanExpressionTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RecipeTest.DefaultImpls.assertUnchanged((RecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull SimplifyBooleanExpressionTest $this, @NotNull JavaVisitor<ExecutionContext> $this$toRecipe, boolean cursored) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return RecipeTest.DefaultImpls.toRecipe($this, $this$toRecipe, cursored);
        }
    }
}

