/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.cleanup.CovariantEquals;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0011"}, d2={"Lorg/openrewrite/java/cleanup/CovariantEqualsTest;", "Lorg/openrewrite/RecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "ignoreIfAtLeastOneExistingNonCovariantEqualsMethod", "", "jp", "Lorg/openrewrite/java/JavaParser;", "ignoreIfNoExistingEqualsMethod", "renameExistingParameterNameWhenParameterNameIsDefaultTemplateName", "replaceEqualsBasedOnTypeSignature", "replaceEqualsMaintainsExistingAnnotations", "replaceMultiStatementReturnBody", "replaceWithNonCovariantEquals", "replaceWithNonCovariantEqualsWhenNested", "rewrite-test"})
public interface CovariantEqualsTest
extends RecipeTest {
    @Override
    @Nullable
    public Recipe getRecipe();

    @Test
    public void replaceWithNonCovariantEquals(@NotNull JavaParser var1);

    @Test
    public void replaceMultiStatementReturnBody(@NotNull JavaParser var1);

    @Test
    public void replaceEqualsBasedOnTypeSignature(@NotNull JavaParser var1);

    @Test
    public void replaceEqualsMaintainsExistingAnnotations(@NotNull JavaParser var1);

    @Test
    public void replaceWithNonCovariantEqualsWhenNested(@NotNull JavaParser var1);

    @Test
    public void renameExistingParameterNameWhenParameterNameIsDefaultTemplateName(@NotNull JavaParser var1);

    @Test
    public void ignoreIfAtLeastOneExistingNonCovariantEqualsMethod(@NotNull JavaParser var1);

    @Test
    public void ignoreIfNoExistingEqualsMethod(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Nullable
        public static Recipe getRecipe(@NotNull CovariantEqualsTest $this) {
            return (Recipe)new CovariantEquals();
        }

        @Test
        public static void replaceWithNonCovariantEquals(@NotNull CovariantEqualsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            class Test {\n                int n;\n\n                public boolean equals(Test tee) {\n                    return n == tee.n;\n                }\n            }\n        ", null, 0, "\n            class Test {\n                int n;\n\n                @Override\n                public boolean equals(Object obj) {\n                    if (obj == this) return true;\n                    if (obj == null || getClass() != obj.getClass()) return false;\n                    Test tee = (Test) obj;\n                    return n == tee.n;\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void replaceMultiStatementReturnBody(@NotNull CovariantEqualsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            class A {\n                String id;\n\n                public boolean equals(A other) {\n                    boolean isEqual = id.equals(other.id);\n                    return isEqual;\n                }\n            }\n        ", null, 0, "\n            class A {\n                String id;\n\n                @Override\n                public boolean equals(Object obj) {\n                    if (obj == this) return true;\n                    if (obj == null || getClass() != obj.getClass()) return false;\n                    A other = (A) obj;\n                    boolean isEqual = id.equals(other.id);\n                    return isEqual;\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void replaceEqualsBasedOnTypeSignature(@NotNull CovariantEqualsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            class Test {\n                int n;\n                public void placeholder(Test test) {}\n                public void placeholder(Object test) {}\n\n                public boolean equals(Number test) {\n                    return false;\n                }\n\n                public boolean equals(Test test) {\n                    return n == test.n;\n                }\n\n                public boolean equals() {\n                    return false;\n                }\n\n                public boolean equals(String test) {\n                    return false;\n                }\n            }\n        ", null, 0, "\n            class Test {\n                int n;\n                public void placeholder(Test test) {}\n                public void placeholder(Object test) {}\n\n                public boolean equals(Number test) {\n                    return false;\n                }\n\n                @Override\n                public boolean equals(Object obj) {\n                    if (obj == this) return true;\n                    if (obj == null || getClass() != obj.getClass()) return false;\n                    Test test = (Test) obj;\n                    return n == test.n;\n                }\n\n                public boolean equals() {\n                    return false;\n                }\n\n                public boolean equals(String test) {\n                    return false;\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void replaceEqualsMaintainsExistingAnnotations(@NotNull CovariantEqualsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            class A {\n                String id;\n\n                @SuppressWarnings(\"all\")\n                public boolean equals(A other) {\n                    boolean isEqual = id.equals(other.id);\n                    return isEqual;\n                }\n            }\n        ", null, 0, "\n            class A {\n                String id;\n\n                @Override\n                @SuppressWarnings(\"all\")\n                public boolean equals(Object obj) {\n                    if (obj == this) return true;\n                    if (obj == null || getClass() != obj.getClass()) return false;\n                    A other = (A) obj;\n                    boolean isEqual = id.equals(other.id);\n                    return isEqual;\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void replaceWithNonCovariantEqualsWhenNested(@NotNull CovariantEqualsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            class A {\n                class B {\n                    int n;\n\n                    public boolean equals(B bee) {\n                        return n == bee.n;\n                    }\n                }\n            }\n        ", null, 0, "\n            class A {\n                class B {\n                    int n;\n\n                    @Override\n                    public boolean equals(Object obj) {\n                        if (obj == this) return true;\n                        if (obj == null || getClass() != obj.getClass()) return false;\n                        B bee = (B) obj;\n                        return n == bee.n;\n                    }\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void renameExistingParameterNameWhenParameterNameIsDefaultTemplateName(@NotNull CovariantEqualsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, "\n            class Test {\n                int n;\n\n                public boolean equals(Test obj) {\n                    return n == obj.n;\n                }\n            }\n        ", null, 0, "\n            class Test {\n                int n;\n\n                @Override\n                public boolean equals(Object other) {\n                    if (other == this) return true;\n                    if (other == null || getClass() != other.getClass()) return false;\n                    Test obj = (Test) other;\n                    return n == obj.n;\n                }\n            }\n        ", 26, null);
        }

        @Test
        public static void ignoreIfAtLeastOneExistingNonCovariantEqualsMethod(@NotNull CovariantEqualsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, null, "\n            class Test {\n                public boolean equals(Test t) {\n                    return false;\n                }\n\n                public boolean equals(Object i) {\n                    return false;\n                }\n                \n                public boolean equals(Object i, Test t) {\n                    return false;\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void ignoreIfNoExistingEqualsMethod(@NotNull CovariantEqualsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, null, "\n            class A {}\n            \n            class B {\n                B() {}\n                public void placeholder(B t) {}\n                public void placeholder(Object t) {}\n            }\n        ", null, 10, null);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull CovariantEqualsTest $this) {
            return RecipeTest.DefaultImpls.getTreePrinter($this);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull CovariantEqualsTest $this) {
            return RecipeTest.DefaultImpls.getParser($this);
        }

        public static void assertChanged(@NotNull CovariantEqualsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, int cycles, @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, cycles, after);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull CovariantEqualsTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertChanged(@NotNull CovariantEqualsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull CovariantEqualsTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertUnchanged(@NotNull CovariantEqualsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RecipeTest.DefaultImpls.assertUnchanged((RecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull CovariantEqualsTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RecipeTest.DefaultImpls.assertUnchanged((RecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull CovariantEqualsTest $this, @NotNull JavaVisitor<ExecutionContext> $this$toRecipe, boolean cursored) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return RecipeTest.DefaultImpls.toRecipe($this, $this$toRecipe, cursored);
        }
    }
}

