/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.UseStaticImport;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\u0018\u0010\u0004\u001a\u00020\u00032\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\bH\u0017\u00a8\u0006\t"}, d2={"Lorg/openrewrite/java/UseStaticImportTest;", "Lorg/openrewrite/RecipeTest;", "checkValidation", "", "junit5Assertions", "jp", "Lorg/openrewrite/java/JavaParser$Builder;", "replaceWithStaticImports", "Lorg/openrewrite/java/JavaParser;", "rewrite-test"})
public interface UseStaticImportTest
extends RecipeTest {
    @Test
    public void replaceWithStaticImports(@NotNull JavaParser var1);

    @Test
    public void junit5Assertions(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void checkValidation();

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void replaceWithStaticImports(@NotNull UseStaticImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            package test;\n            \n            import static asserts.Assert.*;\n            \n            class Test {\n                void test() {\n                    assertTrue(true);\n                    assertFalse(false);\n                    assertEquals(1, 2);\n                }\n            }\n        ";
            int n = 0;
            String string2 = "\n            package test;\n            \n            import asserts.Assert;\n            \n            class Test {\n                void test() {\n                    Assert.assertTrue(true);\n                    Assert.assertFalse(false);\n                    Assert.assertEquals(1, 2);\n                }\n            }\n        ";
            Recipe recipe2 = (Recipe)new UseStaticImport("asserts.Assert assert*(..)");
            String[] stringArray = new String[]{"\n                package asserts;\n                \n                public class Assert {\n                    public static void assertTrue(boolean b) {}\n                    public static void assertFalse(boolean b) {}\n                    public static void assertEquals(int m, int n) {}\n                }\n            "};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, recipe2, string2, stringArray, n, string, 16, null);
        }

        @Test
        public static void junit5Assertions(@NotNull UseStaticImportTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp.classpath((Collection)JavaParser.dependenciesFromClasspath((String[])new String[]{"junit-jupiter-api", "apiguardian-api"})).build(), (Recipe)new UseStaticImport("org.junit.jupiter.api.Assertions assert*(..)"), "\n            package org.openrewrite;\n\n            import org.junit.jupiter.api.Test;\n            import org.junit.jupiter.api.Assertions;\n\n            class Sample {\n                @Test\n                void sample() {\n                    Assertions.assertEquals(42, 21*2);\n                }\n            }\n        ", null, 0, "\n            package org.openrewrite;\n\n            import org.junit.jupiter.api.Test;\n            \n            import static org.junit.jupiter.api.Assertions.assertEquals;\n\n            class Sample {\n                @Test\n                void sample() {\n                    assertEquals(42, 21*2);\n                }\n            }\n        ", 24, null);
        }

        @Test
        public static void checkValidation(@NotNull UseStaticImportTest $this) {
            Validated valid;
            UseStaticImport recipe2 = new UseStaticImport(null);
            Validated validated = valid = recipe2.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated, (String)"valid");
            Assertions.assertThat((boolean)validated.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Object e = valid.failures().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"valid.failures()[0]");
            Assertions.assertThat((String)((Validated.Invalid)e).getProperty()).isEqualTo("methodPattern");
            recipe2 = new UseStaticImport("Foo.F foo()");
            Validated validated2 = valid = recipe2.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated2, (String)"valid");
            Assertions.assertThat((boolean)validated2.isValid()).isTrue();
        }

        @Nullable
        public static Recipe getRecipe(@NotNull UseStaticImportTest $this) {
            return RecipeTest.DefaultImpls.getRecipe($this);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull UseStaticImportTest $this) {
            return RecipeTest.DefaultImpls.getTreePrinter($this);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull UseStaticImportTest $this) {
            return RecipeTest.DefaultImpls.getParser($this);
        }

        public static void assertChanged(@NotNull UseStaticImportTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, int cycles, @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, cycles, after);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull UseStaticImportTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertChanged(@NotNull UseStaticImportTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull UseStaticImportTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertUnchanged(@NotNull UseStaticImportTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RecipeTest.DefaultImpls.assertUnchanged((RecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull UseStaticImportTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RecipeTest.DefaultImpls.assertUnchanged((RecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull UseStaticImportTest $this, @NotNull JavaVisitor<ExecutionContext> $this$toRecipe, boolean cursored) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return RecipeTest.DefaultImpls.toRecipe($this, $this$toRecipe, cursored);
        }
    }
}

