/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.Validated;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaVisitor;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\bf\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cJ\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\b\u0010\u000b\u001a\u00020\u0007H\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u001d"}, d2={"Lorg/openrewrite/java/ChangeTypeTest;", "Lorg/openrewrite/RecipeTest;", "recipe", "Lorg/openrewrite/java/ChangeType;", "getRecipe", "()Lorg/openrewrite/java/ChangeType;", "annotation", "", "jp", "Lorg/openrewrite/java/JavaParser;", "array", "checkValidation", "classDecl", "classReference", "classToPrimitive", "dontAddImportWhenNoChangesWereMade", "fullyQualifiedName", "method", "methodInvocationTypeParametersAndWildcard", "methodSelect", "multiCatch", "multiVariable", "newClass", "parameterizedType", "primitiveToClass", "simpleName", "staticImport", "typeCast", "Companion", "rewrite-test"})
public interface ChangeTypeTest
extends RecipeTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.ChangeTypeTest$Companion.$$INSTANCE;

    @NotNull
    public ChangeType getRecipe();

    @Test
    public void dontAddImportWhenNoChangesWereMade(@NotNull JavaParser var1);

    @Test
    public void simpleName(@NotNull JavaParser var1);

    @Test
    public void fullyQualifiedName(@NotNull JavaParser var1);

    @Test
    public void annotation(@NotNull JavaParser var1);

    @Test
    public void array(@NotNull JavaParser var1);

    @Test
    public void classDecl(@NotNull JavaParser var1);

    @Test
    public void method(@NotNull JavaParser var1);

    @Test
    public void methodInvocationTypeParametersAndWildcard(@NotNull JavaParser var1);

    @Test
    public void multiCatch(@NotNull JavaParser var1);

    @Test
    public void multiVariable(@NotNull JavaParser var1);

    @Test
    public void newClass(@NotNull JavaParser var1);

    @Test
    public void parameterizedType(@NotNull JavaParser var1);

    @Test
    public void typeCast(@NotNull JavaParser var1);

    @Test
    public void classReference(@NotNull JavaParser var1);

    @Test
    public void methodSelect(@NotNull JavaParser var1);

    @Test
    public void staticImport(@NotNull JavaParser var1);

    @Disabled(value="https://github.com/openrewrite/rewrite/issues/62")
    @Test
    public void primitiveToClass(@NotNull JavaParser var1);

    @Test
    public void classToPrimitive(@NotNull JavaParser var1);

    @Test
    public void checkValidation();

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static ChangeType getRecipe(@NotNull ChangeTypeTest $this) {
            return new ChangeType("a.A1", "a.A2");
        }

        @Test
        public static void dontAddImportWhenNoChangesWereMade(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)$this, (Parser)jp, null, "public class B {}", null, 10, null);
        }

        @Test
        public static void simpleName(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            import a.A2;\n            \n            public class B extends A2 {}\n        ";
            int n = 0;
            String string2 = "\n            import a.A1;\n            \n            public class B extends A1 {}\n        ";
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, string2, stringArray, n, string, 18, null);
        }

        @Test
        public static void fullyQualifiedName(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "public class B extends a.A2 {}";
            int n = 0;
            String string2 = "public class B extends a.A1 {}";
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, string2, stringArray, n, string, 18, null);
        }

        @Test
        public static void annotation(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "@a.A2 public class B {}";
            int n = 0;
            String string2 = "@a.A1 public class B {}";
            String[] stringArray = new String[]{"package a;\npublic @interface A1 {}", "package a;\npublic @interface A2 {}"};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, string2, stringArray, n, string, 18, null);
        }

        @Test
        public static void array(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            import a.A2;\n            public class B {\n               A2[] a = new A2[0];\n            }\n        ";
            int n = 0;
            String string2 = "\n            import a.A1;\n            public class B {\n               A1[] a = new A1[0];\n            }\n        ";
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, string2, stringArray, n, string, 18, null);
        }

        @Test
        public static void classDecl(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            import a.A2;\n            public class B extends A2 implements I2 {}\n        ";
            int n = 0;
            String string2 = "\n            import a.A1;\n            public class B extends A1 implements I1 {}\n        ";
            Recipe recipe2 = $this.getRecipe().doNext((Recipe)new ChangeType("I1", "I2"));
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion), "public interface I1 {}", "public interface I2 {}"};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, recipe2, string2, stringArray, n, string, 16, null);
        }

        @Test
        public static void method(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            import a.A2;\n            public class B {\n               public A2 foo() throws A2 { return null; }\n            }\n        ";
            int n = 0;
            String string2 = "\n            import a.A1;\n            public class B {\n               public A1 foo() throws A1 { return null; }\n            }\n        ";
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, string2, stringArray, n, string, 18, null);
        }

        @Test
        public static void methodInvocationTypeParametersAndWildcard(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            import a.A2;\n            public class B {\n               public <T extends A2> T generic(T n, List<? super A2> in);\n               public void test() {\n                   A2.stat();\n                   this.<A2>generic(null, null);\n               }\n            }\n        ";
            int n = 0;
            String string2 = "\n            import a.A1;\n            public class B {\n               public <T extends A1> T generic(T n, List<? super A1> in);\n               public void test() {\n                   A1.stat();\n                   this.<A1>generic(null, null);\n               }\n            }\n        ";
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, string2, stringArray, n, string, 18, null);
        }

        @Test
        public static void multiCatch(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            import a.A2;\n            public class B {\n               public void test() {\n                   try {}\n                   catch(A2 | RuntimeException e) {}\n               }\n            }\n        ";
            int n = 0;
            String string2 = "\n            import a.A1;\n            public class B {\n               public void test() {\n                   try {}\n                   catch(A1 | RuntimeException e) {}\n               }\n            }\n        ";
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, string2, stringArray, n, string, 18, null);
        }

        @Test
        public static void multiVariable(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            import a.A2;\n            public class B {\n               A2 f1, f2;\n            }\n        ";
            int n = 0;
            String string2 = "\n            import a.A1;\n            public class B {\n               A1 f1, f2;\n            }\n        ";
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, string2, stringArray, n, string, 18, null);
        }

        @Test
        public static void newClass(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            import a.A2;\n            public class B {\n               A2 a = new A2();\n            }\n        ";
            int n = 0;
            String string2 = "\n            import a.A1;\n            public class B {\n               A1 a = new A1();\n            }\n        ";
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, string2, stringArray, n, string, 18, null);
        }

        @Test
        public static void parameterizedType(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            import a.A2;\n            public class B {\n               Map<A2, A2> m;\n            }\n        ";
            int n = 0;
            String string2 = "\n            import a.A1;\n            public class B {\n               Map<A1, A1> m;\n            }\n        ";
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, string2, stringArray, n, string, 18, null);
        }

        @Test
        public static void typeCast(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            import a.A2;\n            public class B {\n               A2 a = (A2) null;\n            }\n        ";
            int n = 0;
            String string2 = "\n            import a.A1;\n            public class B {\n               A1 a = (A1) null;\n            }\n        ";
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, string2, stringArray, n, string, 18, null);
        }

        @Test
        public static void classReference(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            import a.A2;\n            public class A {\n                Class<?> clazz = A2.class;\n            }\n        ";
            int n = 0;
            String string2 = "\n            import a.A1;\n            public class A {\n                Class<?> clazz = A1.class;\n            }\n        ";
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, string2, stringArray, n, string, 18, null);
        }

        @Test
        public static void methodSelect(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            import a.A2;\n            public class B {\n               A2 a = null;\n               public void test() { a.foo(); }\n            }\n        ";
            int n = 0;
            String string2 = "\n            import a.A1;\n            public class B {\n               A1 a = null;\n               public void test() { a.foo(); }\n            }\n        ";
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, string2, stringArray, n, string, 18, null);
        }

        @Test
        public static void staticImport(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            import static a.A2.stat;\n            public class B {\n                public void test() {\n                    stat();\n                }\n            }\n        ";
            int n = 0;
            String string2 = "\n            import static a.A1.stat;\n            public class B {\n                public void test() {\n                    stat();\n                }\n            }\n        ";
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, null, string2, stringArray, n, string, 18, null);
        }

        @Disabled(value="https://github.com/openrewrite/rewrite/issues/62")
        @Test
        public static void primitiveToClass(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, (Recipe)new ChangeType("int", "java.lang.Integer"), "\n            class A {\n                int foo = 5;\n                int getFoo() {\n                    return foo;\n                }\n            }\n        ", null, 0, "\n            class A {\n                Integer foo = 5;\n                Integer getFoo() {\n                    return foo;\n                }\n            }\n        ", 24, null);
        }

        @Test
        public static void classToPrimitive(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, (Recipe)new ChangeType("java.lang.Integer", "int"), "\n            class A {\n                Integer foo = 5;\n                Integer getFoo() {\n                    return foo;\n                }\n            }\n        ", null, 0, "\n            class A {\n                int foo = 5;\n                int getFoo() {\n                    return foo;\n                }\n            }\n        ", 24, null);
        }

        @Test
        public static void checkValidation(@NotNull ChangeTypeTest $this) {
            Validated valid;
            ChangeType recipe2 = new ChangeType(null, null);
            Validated validated = valid = recipe2.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated, (String)"valid");
            Assertions.assertThat((boolean)validated.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(2);
            Object e = valid.failures().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"valid.failures()[0]");
            Assertions.assertThat((String)((Validated.Invalid)e).getProperty()).isEqualTo("newFullyQualifiedTypeName");
            Object e2 = valid.failures().get(1);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"valid.failures()[1]");
            Assertions.assertThat((String)((Validated.Invalid)e2).getProperty()).isEqualTo("oldFullyQualifiedTypeName");
            recipe2 = new ChangeType(null, "java.lang.String");
            Validated validated2 = valid = recipe2.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated2, (String)"valid");
            Assertions.assertThat((boolean)validated2.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Object e3 = valid.failures().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"valid.failures()[0]");
            Assertions.assertThat((String)((Validated.Invalid)e3).getProperty()).isEqualTo("oldFullyQualifiedTypeName");
            recipe2 = new ChangeType("java.lang.String", null);
            Validated validated3 = valid = recipe2.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated3, (String)"valid");
            Assertions.assertThat((boolean)validated3.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Object e4 = valid.failures().get(0);
            Intrinsics.checkNotNullExpressionValue(e4, (String)"valid.failures()[0]");
            Assertions.assertThat((String)((Validated.Invalid)e4).getProperty()).isEqualTo("newFullyQualifiedTypeName");
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull ChangeTypeTest $this) {
            return RecipeTest.DefaultImpls.getTreePrinter($this);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull ChangeTypeTest $this) {
            return RecipeTest.DefaultImpls.getParser($this);
        }

        public static void assertChanged(@NotNull ChangeTypeTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, int cycles, @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, cycles, after);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull ChangeTypeTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertChanged(@NotNull ChangeTypeTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull ChangeTypeTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertUnchanged(@NotNull ChangeTypeTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RecipeTest.DefaultImpls.assertUnchanged((RecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ChangeTypeTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RecipeTest.DefaultImpls.assertUnchanged((RecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull ChangeTypeTest $this, @NotNull JavaVisitor<ExecutionContext> $this$toRecipe, boolean cursored) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return RecipeTest.DefaultImpls.toRecipe($this, $this$toRecipe, cursored);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/openrewrite/java/ChangeTypeTest$Companion;", "", "()V", "a1", "", "a2", "rewrite-test"})
    public static final class Companion {
        private static final String a1;
        private static final String a2;
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            a1 = "package a;\npublic class A1 extends Exception {\n    public static void stat() {}\n    public void foo() {}\n}";
            a2 = "package a;\npublic class A2 extends Exception {\n    public static void stat() {}\n    public void foo() {}\n}";
        }

        public static final /* synthetic */ String access$getA1$p(Companion $this) {
            Companion companion = $this;
            return a1;
        }

        public static final /* synthetic */ String access$getA2$p(Companion $this) {
            Companion companion = $this;
            return a2;
        }
    }
}

