/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.Validated;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.ChangeMethodTargetToStatic;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaVisitor;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/ChangeMethodTargetToStaticTest;", "Lorg/openrewrite/RecipeTest;", "checkValidation", "", "staticTargetToStatic", "jp", "Lorg/openrewrite/java/JavaParser;", "targetToStatic", "rewrite-test"})
public interface ChangeMethodTargetToStaticTest
extends RecipeTest {
    @Test
    public void targetToStatic(@NotNull JavaParser var1);

    @Test
    public void staticTargetToStatic(@NotNull JavaParser var1);

    @Test
    public void checkValidation();

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void targetToStatic(@NotNull ChangeMethodTargetToStaticTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            import b.B;\n            \n            class C {\n               public void test() {\n                   B.foo();\n               }\n            }\n        ";
            int n = 0;
            String string2 = "\n            import a.*;\n            class C {\n               public void test() {\n                   new A().nonStatic();\n               }\n            }\n        ";
            Recipe recipe2 = new ChangeMethodTargetToStatic("a.A nonStatic()", "b.B").doNext((Recipe)new ChangeMethodName("b.B nonStatic()", "foo"));
            String[] stringArray = new String[]{"\n                    package a;\n                    public class A {\n                       public void nonStatic() {}\n                    }\n                ", "\n                    package b;\n                    public class B {\n                       public static void foo() {}\n                    }\n                "};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, recipe2, string2, stringArray, n, string, 16, null);
        }

        @Test
        public static void staticTargetToStatic(@NotNull ChangeMethodTargetToStaticTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            import b.B;\n            \n            class C {\n               public void test() {\n                   B.foo();\n               }\n            }\n        ";
            int n = 0;
            String string2 = "\n            import static a.A.*;\n            class C {\n               public void test() {\n                   foo();\n               }\n            }\n        ";
            Recipe recipe2 = (Recipe)new ChangeMethodTargetToStatic("a.A foo()", "b.B");
            String[] stringArray = new String[]{"\n                package b;\n                public class B {\n                   public static void foo() {}\n                }\n            ", "\n                package a;\n                public class A {\n                   public static void foo() {}\n                }\n            "};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, recipe2, string2, stringArray, n, string, 16, null);
        }

        @Test
        public static void checkValidation(@NotNull ChangeMethodTargetToStaticTest $this) {
            Validated valid;
            ChangeMethodTargetToStatic recipe2 = new ChangeMethodTargetToStatic(null, null);
            Validated validated = valid = recipe2.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated, (String)"valid");
            Assertions.assertThat((boolean)validated.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(2);
            Object e = valid.failures().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"valid.failures()[0]");
            Assertions.assertThat((String)((Validated.Invalid)e).getProperty()).isEqualTo("fullyQualifiedTargetTypeName");
            Object e2 = valid.failures().get(1);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"valid.failures()[1]");
            Assertions.assertThat((String)((Validated.Invalid)e2).getProperty()).isEqualTo("methodPattern");
            recipe2 = new ChangeMethodTargetToStatic(null, "java.lang.String");
            Validated validated2 = valid = recipe2.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated2, (String)"valid");
            Assertions.assertThat((boolean)validated2.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Object e3 = valid.failures().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"valid.failures()[0]");
            Assertions.assertThat((String)((Validated.Invalid)e3).getProperty()).isEqualTo("methodPattern");
            recipe2 = new ChangeMethodTargetToStatic("java.lang.String emptyString(..)", null);
            Validated validated3 = valid = recipe2.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated3, (String)"valid");
            Assertions.assertThat((boolean)validated3.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Object e4 = valid.failures().get(0);
            Intrinsics.checkNotNullExpressionValue(e4, (String)"valid.failures()[0]");
            Assertions.assertThat((String)((Validated.Invalid)e4).getProperty()).isEqualTo("fullyQualifiedTargetTypeName");
        }

        @Nullable
        public static Recipe getRecipe(@NotNull ChangeMethodTargetToStaticTest $this) {
            return RecipeTest.DefaultImpls.getRecipe($this);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull ChangeMethodTargetToStaticTest $this) {
            return RecipeTest.DefaultImpls.getTreePrinter($this);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull ChangeMethodTargetToStaticTest $this) {
            return RecipeTest.DefaultImpls.getParser($this);
        }

        public static void assertChanged(@NotNull ChangeMethodTargetToStaticTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, int cycles, @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, cycles, after);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull ChangeMethodTargetToStaticTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertChanged(@NotNull ChangeMethodTargetToStaticTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull ChangeMethodTargetToStaticTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertUnchanged(@NotNull ChangeMethodTargetToStaticTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RecipeTest.DefaultImpls.assertUnchanged((RecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ChangeMethodTargetToStaticTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RecipeTest.DefaultImpls.assertUnchanged((RecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull ChangeMethodTargetToStaticTest $this, @NotNull JavaVisitor<ExecutionContext> $this$toRecipe, boolean cursored) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return RecipeTest.DefaultImpls.toRecipe($this, $this$toRecipe, cursored);
        }
    }
}

