/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.Validated;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaVisitor;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\bf\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017\u00a8\u0006\u000f"}, d2={"Lorg/openrewrite/java/ChangeMethodNameTest;", "Lorg/openrewrite/RecipeTest;", "changeMethodDeclarationForMethodWithSingleArg", "", "jp", "Lorg/openrewrite/java/JavaParser;", "changeMethodNameForMethodWithArrayArg", "changeMethodNameForMethodWithSingleArg", "changeMethodNameForMethodWithSingleArgDeclarative", "changeMethodNameForMethodWithVarargArg", "changeMethodNameWhenMatchingAgainstMethodWithNameThatIsAnAspectjToken", "changeStaticImportTest", "changeStaticMethodTest", "checkValidation", "Companion", "rewrite-test"})
public interface ChangeMethodNameTest
extends RecipeTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.ChangeMethodNameTest$Companion.$$INSTANCE;

    @Test
    public void changeMethodNameForMethodWithSingleArgDeclarative(@NotNull JavaParser var1);

    @Test
    public void changeMethodNameForMethodWithSingleArg(@NotNull JavaParser var1);

    @Test
    public void changeMethodNameForMethodWithArrayArg(@NotNull JavaParser var1);

    @Test
    public void changeMethodNameForMethodWithVarargArg(@NotNull JavaParser var1);

    @Test
    public void changeMethodNameWhenMatchingAgainstMethodWithNameThatIsAnAspectjToken(@NotNull JavaParser var1);

    @Test
    public void changeMethodDeclarationForMethodWithSingleArg(@NotNull JavaParser var1);

    @Test
    public void changeStaticMethodTest(@NotNull JavaParser var1);

    @Test
    public void changeStaticImportTest(@NotNull JavaParser var1);

    @Test
    public void checkValidation();

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void changeMethodNameForMethodWithSingleArgDeclarative(@NotNull ChangeMethodNameTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            package com.abc;\n            class A {\n               public void test() {\n                   new B().bar(\"boo\");\n               }\n            }\n        ";
            int n = 0;
            String string2 = "\n            package com.abc;\n            class A {\n               public void test() {\n                   new B().singleArg(\"boo\");\n               }\n            }\n        ";
            Recipe recipe2 = (Recipe)new ChangeMethodName("com.abc.B singleArg(String)", "bar");
            String[] stringArray = new String[]{"\n            package com.abc;\n            class B {\n               public void singleArg(String s) {}\n               public void arrArg(String[] s) {}\n               public void varargArg(String... s) {}\n               public static void static1(String s) {}\n               public static void static2(String s) {}\n            }\n        "};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, recipe2, string2, stringArray, n, string, 16, null);
        }

        @Test
        public static void changeMethodNameForMethodWithSingleArg(@NotNull ChangeMethodNameTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            package com.abc;\n            class A {\n               public void test() {\n                   new B().bar(\"boo\");\n               }\n            }\n        ";
            int n = 0;
            String string2 = "\n            package com.abc;\n            class A {\n               public void test() {\n                   new B().singleArg(\"boo\");\n               }\n            }\n        ";
            Recipe recipe2 = (Recipe)new ChangeMethodName("com.abc.B singleArg(String)", "bar");
            String[] stringArray = new String[]{"\n            package com.abc;\n            class B {\n               public void singleArg(String s) {}\n               public void arrArg(String[] s) {}\n               public void varargArg(String... s) {}\n               public static void static1(String s) {}\n               public static void static2(String s) {}\n            }\n        "};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, recipe2, string2, stringArray, n, string, 16, null);
        }

        @Test
        public static void changeMethodNameForMethodWithArrayArg(@NotNull ChangeMethodNameTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            package com.abc;\n            class A {\n               public void test() {\n                   new B().bar(new String[] {\"boo\"});\n               }\n            }\n        ";
            int n = 0;
            String string2 = "\n            package com.abc;\n            class A {\n               public void test() {\n                   new B().arrArg(new String[] {\"boo\"});\n               }\n            }\n        ";
            Recipe recipe2 = (Recipe)new ChangeMethodName("com.abc.B arrArg(String[])", "bar");
            String[] stringArray = new String[]{"\n            package com.abc;\n            class B {\n               public void singleArg(String s) {}\n               public void arrArg(String[] s) {}\n               public void varargArg(String... s) {}\n               public static void static1(String s) {}\n               public static void static2(String s) {}\n            }\n        "};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, recipe2, string2, stringArray, n, string, 16, null);
        }

        @Test
        public static void changeMethodNameForMethodWithVarargArg(@NotNull ChangeMethodNameTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            package com.abc;\n            class A {\n               public void test() {\n                   new B().bar(\"boo\", \"again\");\n               }\n            }\n        ";
            int n = 0;
            String string2 = "\n            package com.abc;\n            class A {\n               public void test() {\n                   new B().varargArg(\"boo\", \"again\");\n               }\n            }\n        ";
            Recipe recipe2 = (Recipe)new ChangeMethodName("com.abc.B varargArg(String...)", "bar");
            String[] stringArray = new String[]{"\n            package com.abc;\n            class B {\n               public void singleArg(String s) {}\n               public void arrArg(String[] s) {}\n               public void varargArg(String... s) {}\n               public static void static1(String s) {}\n               public static void static2(String s) {}\n            }\n        "};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, recipe2, string2, stringArray, n, string, 16, null);
        }

        @Test
        public static void changeMethodNameWhenMatchingAgainstMethodWithNameThatIsAnAspectjToken(@NotNull ChangeMethodNameTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            package com.abc;\n            class A {\n               public void test() {\n                   new B().foo();\n               }\n            }\n        ";
            int n = 0;
            String string2 = "\n            package com.abc;\n            class A {\n               public void test() {\n                   new B().error();\n               }\n            }\n        ";
            Recipe recipe2 = (Recipe)new ChangeMethodName("com.abc.B error()", "foo");
            String[] stringArray = new String[]{"\n                package com.abc;\n                class B {\n                   public void error() {}\n                   public void foo() {}\n                }\n            "};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, recipe2, string2, stringArray, n, string, 16, null);
        }

        @Test
        public static void changeMethodDeclarationForMethodWithSingleArg(@NotNull ChangeMethodNameTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            package com.abc;\n            class A {\n               public void bar(String s) {\n               }\n            }\n        ";
            int n = 0;
            String string2 = "\n            package com.abc;\n            class A {\n               public void foo(String s) {\n               }\n            }\n        ";
            Recipe recipe2 = (Recipe)new ChangeMethodName("com.abc.A foo(String)", "bar");
            String[] stringArray = new String[]{"\n            package com.abc;\n            class B {\n               public void singleArg(String s) {}\n               public void arrArg(String[] s) {}\n               public void varargArg(String... s) {}\n               public static void static1(String s) {}\n               public static void static2(String s) {}\n            }\n        "};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, recipe2, string2, stringArray, n, string, 16, null);
        }

        @Test
        public static void changeStaticMethodTest(@NotNull ChangeMethodNameTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            package com.abc;\n            class A {\n               public void test() {\n                   B.static2(\"boo\");\n               }\n            }\n        ";
            int n = 0;
            String string2 = "\n            package com.abc;\n            class A {\n               public void test() {\n                   B.static1(\"boo\");\n               }\n            }\n        ";
            Recipe recipe2 = (Recipe)new ChangeMethodName("com.abc.B static1(String)", "static2");
            String[] stringArray = new String[]{"\n            package com.abc;\n            class B {\n               public void singleArg(String s) {}\n               public void arrArg(String[] s) {}\n               public void varargArg(String... s) {}\n               public static void static1(String s) {}\n               public static void static2(String s) {}\n            }\n        "};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, recipe2, string2, stringArray, n, string, 16, null);
        }

        @Test
        public static void changeStaticImportTest(@NotNull ChangeMethodNameTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String string = "\n            package com.abc;\n            import static com.abc.B.static2;\n            class A {\n               public void test() {\n                   static2(\"boo\");\n               }\n            }\n        ";
            int n = 0;
            String string2 = "\n            package com.abc;\n            import static com.abc.B.static1;\n            class A {\n               public void test() {\n                   static1(\"boo\");\n               }\n            }\n        ";
            Recipe recipe2 = (Recipe)new ChangeMethodName("com.abc.B static1(String)", "static2");
            String[] stringArray = new String[]{"\n            package com.abc;\n            class B {\n               public void singleArg(String s) {}\n               public void arrArg(String[] s) {}\n               public void varargArg(String... s) {}\n               public static void static1(String s) {}\n               public static void static2(String s) {}\n            }\n        "};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)$this, (Parser)jp, recipe2, string2, stringArray, n, string, 16, null);
        }

        @Test
        public static void checkValidation(@NotNull ChangeMethodNameTest $this) {
            Validated valid;
            ChangeMethodName recipe2 = new ChangeMethodName(null, null);
            Validated validated = valid = recipe2.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated, (String)"valid");
            Assertions.assertThat((boolean)validated.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(2);
            Object e = valid.failures().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"valid.failures()[0]");
            Assertions.assertThat((String)((Validated.Invalid)e).getProperty()).isEqualTo("methodPattern");
            Object e2 = valid.failures().get(1);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"valid.failures()[1]");
            Assertions.assertThat((String)((Validated.Invalid)e2).getProperty()).isEqualTo("newMethodName");
            recipe2 = new ChangeMethodName(null, "hello");
            Validated validated2 = valid = recipe2.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated2, (String)"valid");
            Assertions.assertThat((boolean)validated2.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Object e3 = valid.failures().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"valid.failures()[0]");
            Assertions.assertThat((String)((Validated.Invalid)e3).getProperty()).isEqualTo("methodPattern");
            recipe2 = new ChangeMethodName("java.util.String emptyString(..)", null);
            Validated validated3 = valid = recipe2.validate();
            Intrinsics.checkNotNullExpressionValue((Object)validated3, (String)"valid");
            Assertions.assertThat((boolean)validated3.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Object e4 = valid.failures().get(0);
            Intrinsics.checkNotNullExpressionValue(e4, (String)"valid.failures()[0]");
            Assertions.assertThat((String)((Validated.Invalid)e4).getProperty()).isEqualTo("newMethodName");
        }

        @Nullable
        public static Recipe getRecipe(@NotNull ChangeMethodNameTest $this) {
            return RecipeTest.DefaultImpls.getRecipe($this);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull ChangeMethodNameTest $this) {
            return RecipeTest.DefaultImpls.getTreePrinter($this);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull ChangeMethodNameTest $this) {
            return RecipeTest.DefaultImpls.getParser($this);
        }

        public static void assertChanged(@NotNull ChangeMethodNameTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, int cycles, @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, cycles, after);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull ChangeMethodNameTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertChanged(@NotNull ChangeMethodNameTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull ChangeMethodNameTest $this, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            RecipeTest.DefaultImpls.assertChanged((RecipeTest)$this, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static void assertUnchanged(@NotNull ChangeMethodNameTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RecipeTest.DefaultImpls.assertUnchanged((RecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ChangeMethodNameTest $this, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            RecipeTest.DefaultImpls.assertUnchanged((RecipeTest)$this, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull ChangeMethodNameTest $this, @NotNull JavaVisitor<ExecutionContext> $this$toRecipe, boolean cursored) {
            Intrinsics.checkNotNullParameter($this$toRecipe, (String)"$this$toRecipe");
            return RecipeTest.DefaultImpls.toRecipe($this, $this$toRecipe, cursored);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/openrewrite/java/ChangeMethodNameTest$Companion;", "", "()V", "b", "", "rewrite-test"})
    public static final class Companion {
        private static final String b = "\n            package com.abc;\n            class B {\n               public void singleArg(String s) {}\n               public void arrArg(String[] s) {}\n               public void varargArg(String... s) {}\n               public static void static1(String s) {}\n               public static void static2(String s) {}\n            }\n        ";
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

