/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.openrewrite.Change;
import org.openrewrite.Formatting;
import org.openrewrite.Refactor;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.RefactorTest;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007*\u0002\u0004\u000b\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0007J\b\u0010\u0010\u001a\u00020\u000eH\u0007J\b\u0010\u0011\u001a\u00020\u000eH\u0007J\b\u0010\u0012\u001a\u00020\u000eH\u0007J\b\u0010\u0013\u001a\u00020\u000eH\u0007R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/openrewrite/java/RefactorTest;", "", "()V", "addClassDecl", "org/openrewrite/java/RefactorTest$addClassDecl$1", "Lorg/openrewrite/java/RefactorTest$addClassDecl$1;", "cu", "Lorg/openrewrite/java/tree/J$CompilationUnit;", "getCu", "()Lorg/openrewrite/java/tree/J$CompilationUnit;", "throwingVisitor", "org/openrewrite/java/RefactorTest$throwingVisitor$1", "Lorg/openrewrite/java/RefactorTest$throwingVisitor$1;", "canDelete", "", "canGenerate", "generateDiff", "multipleVisitorsHaveCumulativeEffects", "suppressesExceptions", "throwsEagerly", "RefactorTestException", "rewrite-test"})
public final class RefactorTest {
    @NotNull
    private final J.CompilationUnit cu;
    private final throwingVisitor.1 throwingVisitor;
    private final addClassDecl.1 addClassDecl;

    @NotNull
    public final J.CompilationUnit getCu() {
        return this.cu;
    }

    @Test
    public final void throwsEagerly() {
        org.junit.jupiter.api.Assertions.assertThrows(RefactorTestException.class, (Executable)new Executable(this){
            final /* synthetic */ RefactorTest this$0;

            public final void execute() {
                new Refactor(true).visit(new RefactorVisitor[]{(RefactorVisitor)RefactorTest.access$getThrowingVisitor$p(this.this$0)}).fix((Iterable)CollectionsKt.listOf((Object)this.this$0.getCu()));
            }
            {
                this.this$0 = refactorTest;
            }
        });
    }

    @Test
    public final void suppressesExceptions() {
        new Refactor().visit(new RefactorVisitor[]{(RefactorVisitor)this.throwingVisitor}).fix((Iterable)CollectionsKt.listOf((Object)this.cu));
    }

    @Disabled(value="https://github.com/openrewrite/rewrite/issues/60")
    @Test
    public final void canDelete() {
        Change result;
        JavaIsoRefactorVisitor deletingVisitor2 = new JavaIsoRefactorVisitor(){

            @Nullable
            public J.CompilationUnit visitCompilationUnit(@Nullable J.CompilationUnit cu) {
                return null;
            }
        };
        Collection results = new Refactor().visit(new RefactorVisitor[]{(RefactorVisitor)deletingVisitor2}).fix((Iterable)CollectionsKt.listOf((Object)this.cu));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)results.size());
        Collection collection = results;
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"results");
        Change change = result = (Change)CollectionsKt.first((Iterable)collection);
        Intrinsics.checkNotNullExpressionValue((Object)change, (String)"result");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)change.getOriginal());
        org.junit.jupiter.api.Assertions.assertNull((Object)result.getFixed());
    }

    @Test
    public final void canGenerate() {
        Change result;
        boolean bl = false;
        bl = false;
        bl = false;
        bl = false;
        J.CompilationUnit cuToGenerate = new J.CompilationUnit(Tree.randomId(), "A.java", (Collection)CollectionsKt.emptyList(), null, CollectionsKt.emptyList(), CollectionsKt.emptyList(), Formatting.EMPTY, (Collection)CollectionsKt.emptyList());
        JavaIsoRefactorVisitor generatingVisitor2 = new JavaIsoRefactorVisitor(cuToGenerate){
            private boolean generationComplete;
            final /* synthetic */ J.CompilationUnit $cuToGenerate;

            public final boolean getGenerationComplete() {
                return this.generationComplete;
            }

            public final void setGenerationComplete(boolean bl) {
                this.generationComplete = bl;
            }

            @NotNull
            public Collection<SourceFile> generate() {
                Collection collection;
                if (this.generationComplete) {
                    boolean bl = false;
                    collection = new ArrayList<E>();
                } else {
                    this.generationComplete = true;
                    collection = CollectionsKt.mutableListOf((Object[])new SourceFile[]{(SourceFile)this.$cuToGenerate});
                }
                return collection;
            }
            {
                this.$cuToGenerate = $captured_local_variable$0;
            }
        };
        Collection results = new Refactor().visit(new RefactorVisitor[]{(RefactorVisitor)generatingVisitor2}).fix((Iterable)CollectionsKt.listOf((Object)this.cu));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)results.size(), (String)"The only change returned should be the generated file");
        Collection collection = results;
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"results");
        Change change = result = (Change)CollectionsKt.first((Iterable)collection);
        Intrinsics.checkNotNullExpressionValue((Object)change, (String)"result");
        org.junit.jupiter.api.Assertions.assertNull((Object)change.getOriginal(), (String)"The generated file should have no \"original\"");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result.getFixed());
        SourceFile sourceFile = result.getFixed();
        if (sourceFile == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.CompilationUnit");
        }
        J.CompilationUnit resultCu = (J.CompilationUnit)sourceFile;
        org.junit.jupiter.api.Assertions.assertEquals((Object)cuToGenerate.getId(), (Object)resultCu.getId());
    }

    @Test
    public final void multipleVisitorsHaveCumulativeEffects() {
        JavaIsoRefactorVisitor addMethod2 = new JavaIsoRefactorVisitor(){

            @NotNull
            public J.ClassDecl visitClassDecl(@Nullable J.ClassDecl classDecl) {
                J.ClassDecl cd;
                J.ClassDecl classDecl2 = cd = super.visitClassDecl(classDecl);
                Intrinsics.checkNotNullExpressionValue((Object)classDecl2, (String)"cd");
                if (classDecl2.getMethods().size() == 0) {
                    cd = cd.withBody(cd.getBody().withStatements(CollectionsKt.listOf((Object)new J.MethodDecl(Tree.randomId(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, JavaType.Primitive.Void.toTypeTree(), J.Ident.build((UUID)Tree.randomId(), (String)"bar", null, (Formatting)Formatting.format((String)" ")), new J.MethodDecl.Parameters(Tree.randomId(), CollectionsKt.emptyList(), Formatting.EMPTY), null, new J.Block(Tree.randomId(), null, CollectionsKt.emptyList(), Formatting.EMPTY, new J.Block.End(Tree.randomId(), Formatting.EMPTY)), null, Formatting.EMPTY))));
                }
                J.ClassDecl classDecl3 = cd;
                Intrinsics.checkNotNullExpressionValue((Object)classDecl3, (String)"cd");
                return classDecl3;
            }
        };
        Collection results = new Refactor(true).visit(new RefactorVisitor[]{(RefactorVisitor)this.addClassDecl, (RefactorVisitor)addMethod2}).fix((Iterable)CollectionsKt.listOf((Object)this.cu));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)results.size());
        Collection collection = results;
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"results");
        Object object = CollectionsKt.first((Iterable)collection);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"results.first()");
        SourceFile sourceFile = ((Change)object).getFixed();
        if (sourceFile == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.CompilationUnit");
        }
        J.CompilationUnit result = (J.CompilationUnit)sourceFile;
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)result.getClasses().size(), (String)"addClassDecl should have added a class declaration");
        List list = result.getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"result.classes");
        Object object2 = CollectionsKt.first((List)list);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"result.classes.first()");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((J.ClassDecl)object2).getMethods().size(), (String)"addMethod should have added a method declaration");
    }

    @Test
    public final void generateDiff() {
        Collection results = new Refactor(true).visit(new RefactorVisitor[]{(RefactorVisitor)this.addClassDecl}).fix((Iterable)CollectionsKt.listOf((Object)this.cu));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)results.size());
        Collection collection = results;
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"results");
        Assertions.assertThat((String)((Change)CollectionsKt.first((Iterable)collection)).diff()).isEqualTo("diff --git a/A.java b/A.java\nindex e69de29..aaaae2e 100644\n--- a/A.java\n+++ b/A.java\n@@ -0,0 +1 @@ AddClassDecl\n+class Foo{}" + "\n");
    }

    public RefactorTest() {
        boolean bl = false;
        bl = false;
        bl = false;
        bl = false;
        this.cu = new J.CompilationUnit(Tree.randomId(), "A.java", (Collection)CollectionsKt.emptyList(), null, CollectionsKt.emptyList(), CollectionsKt.emptyList(), Formatting.EMPTY, (Collection)CollectionsKt.emptyList());
        this.throwingVisitor = new JavaRefactorVisitor(){

            @NotNull
            public J visitCompilationUnit(@Nullable J.CompilationUnit cu) {
                throw (Throwable)new RefactorTestException();
            }
        };
        this.addClassDecl = new JavaIsoRefactorVisitor(){

            @NotNull
            public String getName() {
                return "AddClassDecl";
            }

            @NotNull
            public J.CompilationUnit visitCompilationUnit(@Nullable J.CompilationUnit compilationUnit) {
                J.CompilationUnit cu;
                J.CompilationUnit compilationUnit2 = cu = super.visitCompilationUnit(compilationUnit);
                Intrinsics.checkNotNullExpressionValue((Object)compilationUnit2, (String)"cu");
                if (compilationUnit2.getClasses().size() == 0) {
                    cu = cu.withClasses(CollectionsKt.listOf((Object)new J.ClassDecl(Tree.randomId(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), (J.ClassDecl.Kind)new J.ClassDecl.Kind.Class(Tree.randomId(), Formatting.EMPTY), (J.Ident)J.Ident.buildClassName((String)"Foo").withPrefix(" "), null, null, null, new J.Block(Tree.randomId(), null, CollectionsKt.emptyList(), Formatting.EMPTY, new J.Block.End(Tree.randomId(), Formatting.EMPTY)), JavaType.Class.build((String)"Foo"), Formatting.format((String)"", (String)"\n"))));
                }
                J.CompilationUnit compilationUnit3 = cu;
                Intrinsics.checkNotNullExpressionValue((Object)compilationUnit3, (String)"cu");
                return compilationUnit3;
            }
        };
    }

    public static final /* synthetic */ throwingVisitor.1 access$getThrowingVisitor$p(RefactorTest $this) {
        return $this.throwingVisitor;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/openrewrite/java/RefactorTest$RefactorTestException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "()V", "rewrite-test"})
    public static final class RefactorTestException
    extends RuntimeException {
        public RefactorTestException() {
            super("");
        }
    }
}

