/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000b"}, d2={"Lorg/openrewrite/java/tree/NewArrayTest;", "", "formatWithDimensions", "", "jp", "Lorg/openrewrite/java/JavaParser;", "formatWithEmptyDimension", "formatWithInitializers", "newArray", "newArrayShortcut", "newArrayWithInitializers", "rewrite-test"})
public interface NewArrayTest {
    @Test
    public void newArray(@NotNull JavaParser var1);

    @Test
    public void newArrayWithInitializers(@NotNull JavaParser var1);

    @Test
    public void formatWithDimensions(@NotNull JavaParser var1);

    @Test
    public void formatWithEmptyDimension(@NotNull JavaParser var1);

    @Test
    public void formatWithInitializers(@NotNull JavaParser var1);

    @Test
    public void newArrayShortcut(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void newArray(@NotNull NewArrayTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                int[] n = new int[0];\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"a.classes[0].fields[0].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            if (expression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.NewArray");
            }
            J.NewArray newArr = (J.NewArray)expression;
            Assertions.assertNull((Object)newArr.getInitializer());
            Assertions.assertTrue((boolean)(newArr.getType() instanceof JavaType.Array));
            JavaType.Array array = TestKt.asArray(newArr.getType());
            Assertions.assertTrue((boolean)((array != null ? array.getElemType() : null) instanceof JavaType.Primitive));
            Assertions.assertEquals((int)1, (int)newArr.getDimensions().size());
            Object e4 = newArr.getDimensions().get(0);
            Intrinsics.checkNotNullExpressionValue(e4, (String)"newArr.dimensions[0]");
            Assertions.assertTrue((boolean)(((J.NewArray.Dimension)e4).getSize() instanceof J.Literal));
        }

        @Test
        public static void newArrayWithInitializers(@NotNull NewArrayTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String aSrc = "public class A {\n    int[] n = new int[] { 0, 1, 2 };\n}";
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{aSrc}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"a.classes[0].fields[0].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            if (expression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.NewArray");
            }
            J.NewArray newArr = (J.NewArray)expression;
            Object e4 = newArr.getDimensions().get(0);
            Intrinsics.checkNotNullExpressionValue(e4, (String)"newArr.dimensions[0]");
            Assertions.assertTrue((boolean)(((J.NewArray.Dimension)e4).getSize() instanceof J.Empty));
            Assertions.assertTrue((boolean)(newArr.getType() instanceof JavaType.Array));
            JavaType.Array array = TestKt.asArray(newArr.getType());
            Assertions.assertTrue((boolean)((array != null ? array.getElemType() : null) instanceof JavaType.Primitive));
            Object object = newArr.getInitializer();
            Assertions.assertEquals((int)3, object != null && (object = object.getElements()) != null ? Integer.valueOf(object.size()) : null);
            Assertions.assertEquals((Object)a.print(), (Object)aSrc);
        }

        @Test
        public static void formatWithDimensions(@NotNull NewArrayTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                int[][] n = new int [ 0 ] [ 1 ];\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"a.classes[0].fields[0].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            if (expression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.NewArray");
            }
            J.NewArray newArr = (J.NewArray)expression;
            Assertions.assertEquals((Object)"new int [ 0 ] [ 1 ]", (Object)newArr.printTrimmed());
        }

        @Test
        public static void formatWithEmptyDimension(@NotNull NewArrayTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String aSrc = "public class A {\n    int[][] n = new int [ 0 ] [ ];\n}";
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{aSrc}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"a.classes[0].fields[0].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            if (expression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.NewArray");
            }
            J.NewArray newArr = (J.NewArray)expression;
            Assertions.assertEquals((Object)"new int [ 0 ] [ ]", (Object)newArr.printTrimmed());
            Assertions.assertEquals((Object)a.print(), (Object)aSrc);
        }

        @Test
        public static void formatWithInitializers(@NotNull NewArrayTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                int[] m = new int[] { 0 };\n                int[][] n = new int [ ] [ ] { m, m, m };\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(1);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0].fields[1]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"a.classes[0].fields[1].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            if (expression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.NewArray");
            }
            J.NewArray newArr = (J.NewArray)expression;
            Assertions.assertEquals((Object)"new int [ ] [ ] { m, m, m }", (Object)newArr.printTrimmed());
        }

        @Test
        public static void newArrayShortcut(@NotNull NewArrayTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String produces = "\n            import java.lang.annotation.*;\n            @Target({ElementType.TYPE})\n            public @interface Produces {\n                String[] value() default \"*/*\";\n            }\n        ";
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"@Produces({\"something\"}) class A {}", produces}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getAnnotations().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0].annotations[0]");
            J.Annotation.Arguments arguments = ((J.Annotation)e2).getArgs();
            Intrinsics.checkNotNull((Object)arguments);
            Object e3 = arguments.getArgs().get(0);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.NewArray");
            }
            J.NewArray arr = (J.NewArray)e3;
            Assertions.assertNull((Object)arr.getTypeExpr());
            Assertions.assertEquals((Object)"{\"something\"}", (Object)arr.printTrimmed());
        }
    }
}

