/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.Cursor;
import org.openrewrite.Formatting;
import org.openrewrite.Parser;
import org.openrewrite.TestKt;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.RetrieveCursor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TreeBuilder;
import org.openrewrite.java.tree.TreeBuilderTest;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0013"}, d2={"Lorg/openrewrite/java/tree/TreeBuilderTest;", "", "buildFullyQualifiedClassName", "", "jp", "Lorg/openrewrite/java/JavaParser;", "buildFullyQualifiedInnerClassName", "buildInnerClass", "buildMethodDeclaration", "buildSnippet", "buildSnippetLocalMethodReference", "buildSnippetLocalVariableReference", "buildSnippetMethodReferenceArrays", "buildSnippetMethodReferenceGenerics", "buildSnippetStaticMethodReference", "buildSnippetWithClassInstanceCreation", "buildStaticImport", "buildStaticInit", "injectSnippetIntoMethod", "rewrite-test"})
public interface TreeBuilderTest {
    @Test
    public void buildSnippet(@NotNull JavaParser var1);

    @Test
    public void buildSnippetLocalVariableReference(@NotNull JavaParser var1);

    @Test
    public void buildSnippetLocalMethodReference(@NotNull JavaParser var1);

    @Test
    public void buildSnippetMethodReferenceGenerics(@NotNull JavaParser var1);

    @Test
    public void buildSnippetMethodReferenceArrays(@NotNull JavaParser var1);

    @Test
    public void buildSnippetStaticMethodReference(@NotNull JavaParser var1);

    @Test
    public void buildSnippetWithClassInstanceCreation(@NotNull JavaParser var1);

    @Test
    public void injectSnippetIntoMethod(@NotNull JavaParser var1);

    @Test
    @Disabled(value="https://github.com/openrewrite/rewrite/issues/38")
    public void buildStaticInit(@NotNull JavaParser var1);

    @Test
    public void buildMethodDeclaration(@NotNull JavaParser var1);

    @Test
    public void buildFullyQualifiedClassName(@NotNull JavaParser var1);

    @Test
    public void buildFullyQualifiedInnerClassName(@NotNull JavaParser var1);

    @Test
    public void buildStaticImport(@NotNull JavaParser var1);

    @Test
    public void buildInnerClass(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void buildSnippet(@NotNull TreeBuilderTest $this, @NotNull JavaParser jp) {
            J.MethodDecl method;
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"import java.util.List;\npublic class A {\n    int n = 0;\n    \n    void foo(String m, List<String> others) {\n    }\n}"}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            J.MethodDecl methodDecl = method = (J.MethodDecl)((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)methodDecl, (String)"method");
            Cursor methodBodyCursor = (Cursor)new RetrieveCursor((Tree)methodDecl.getBody()).visit((Tree)a);
            J.MethodDecl.Parameters parameters = method.getParams();
            Intrinsics.checkNotNullExpressionValue((Object)parameters, (String)"method.params");
            Object e2 = parameters.getParams().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"(method.params.params[0]\u2026 J.VariableDecls).vars[0]");
            J.Ident paramName = ((J.VariableDecls.NamedVar)e3).getName();
            List snippets = new TreeBuilder(a).buildSnippet(methodBodyCursor, "others.add(" + paramName.printTrimmed() + ");", new JavaType[0]);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(snippets.get(0) instanceof J.MethodInvocation));
        }

        @Test
        public static void buildSnippetLocalVariableReference(@NotNull TreeBuilderTest $this, @NotNull JavaParser jp) {
            J.MethodDecl method;
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"import java.util.List;\npublic class A {\n    int n = 0;\n    \n    void foo(String m, List<String> others) {\n        n++;\n    }\n}"}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            J.MethodDecl methodDecl = method = (J.MethodDecl)((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)methodDecl, (String)"method");
            Cursor methodBodyCursor = (Cursor)new RetrieveCursor((Tree)methodDecl.getBody()).visit((Tree)a);
            J.MethodDecl.Parameters parameters = method.getParams();
            Intrinsics.checkNotNullExpressionValue((Object)parameters, (String)"method.params");
            Object e2 = parameters.getParams().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"(method.params.params[0]\u2026 J.VariableDecls).vars[0]");
            J.Ident paramName = ((J.VariableDecls.NamedVar)e3).getName();
            List snippets = new TreeBuilder(a).buildSnippet(methodBodyCursor, "\n                    n++;\n                    others.add(" + paramName.printTrimmed() + ");\n                 ", new JavaType[0]);
            Object e4 = snippets.get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.Expression");
            }
            Expression unary = (Expression)e4;
            org.junit.jupiter.api.Assertions.assertEquals((Object)unary.getType(), (Object)JavaType.Primitive.Int, (String)"The unary should have a type of int.");
            Object e5 = snippets.get(1);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.Expression");
            }
            Expression methodInv = (Expression)e5;
            org.junit.jupiter.api.Assertions.assertNotNull((Object)methodInv.getType(), (String)"The type information should be populated");
        }

        @Test
        public static void buildSnippetLocalMethodReference(@NotNull TreeBuilderTest $this, @NotNull JavaParser jp) {
            J.MethodDecl method;
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"import java.util.List;\nimport static java.util.Collections.emptyList;\n\npublic class A {\n    int n = 0;\n    void foo(String m, List<String> others) {\n        incrementCounterByListSize(others);\n        others.add(m);\n    }\n    void incrementCounterByListSize(List<String> list) {\n        n =+ list.size();\n    }\n}"}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            J.MethodDecl methodDecl = method = (J.MethodDecl)((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)methodDecl, (String)"method");
            J.Block block = methodDecl.getBody();
            Intrinsics.checkNotNull((Object)block);
            Cursor methodBodyCursor = (Cursor)new RetrieveCursor((Tree)block.getStatements().get(0)).visit((Tree)a);
            J.MethodDecl.Parameters parameters = method.getParams();
            Intrinsics.checkNotNullExpressionValue((Object)parameters, (String)"method.params");
            Object e2 = parameters.getParams().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"(method.params.params[0]\u2026 J.VariableDecls).vars[0]");
            J.Ident paramName = ((J.VariableDecls.NamedVar)e3).getName();
            List snippets = new TreeBuilder(a).buildSnippet(methodBodyCursor, "\n                    others.add(" + paramName.printTrimmed() + ");\n                    incrementCounterByListSize(others);\n                 ", new JavaType[0]);
            Object e4 = snippets.get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.Expression");
            }
            Expression methodInv1 = (Expression)e4;
            org.junit.jupiter.api.Assertions.assertNotNull((Object)methodInv1.getType(), (String)"The type information should be populated");
            Object e5 = snippets.get(1);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.Expression");
            }
            Expression methodInv2 = (Expression)e5;
            org.junit.jupiter.api.Assertions.assertNotNull((Object)methodInv2.getType(), (String)"The type information should be populated");
        }

        @Test
        public static void buildSnippetMethodReferenceGenerics(@NotNull TreeBuilderTest $this, @NotNull JavaParser jp) {
            J.MethodDecl method;
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"import java.util.List;\nimport java.util.ArrayList;\nimport static java.util.Collections.emptyList;\n\npublic class A {\n    int n = 0;\n    void foo(String m, List<String> others) {\n        List<String> clone = cloneList(others);\n        clone.add(m);\n    }\n    List<String> cloneList(List<String> list) {\n        return new ArrayList<>(list);\n    }\n}"}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            J.MethodDecl methodDecl = method = (J.MethodDecl)((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)methodDecl, (String)"method");
            J.Block block = methodDecl.getBody();
            Intrinsics.checkNotNull((Object)block);
            Cursor methodBodyCursor = (Cursor)new RetrieveCursor((Tree)block.getStatements().get(0)).visit((Tree)a);
            J.MethodDecl.Parameters parameters = method.getParams();
            Intrinsics.checkNotNullExpressionValue((Object)parameters, (String)"method.params");
            Object e2 = parameters.getParams().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"(method.params.params[0]\u2026 J.VariableDecls).vars[0]");
            J.Ident paramName = ((J.VariableDecls.NamedVar)e3).getName();
            List snippets = new TreeBuilder(a).buildSnippet(methodBodyCursor, "\n                    others.add(" + paramName.printTrimmed() + ");\n                    List<String> clone = cloneList(others);\n                 ", new JavaType[0]);
            Object e4 = snippets.get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.Expression");
            }
            Expression methodInv1 = (Expression)e4;
            org.junit.jupiter.api.Assertions.assertNotNull((Object)methodInv1.getType(), (String)"The type information should be populated");
            Object e5 = snippets.get(1);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            J.VariableDecls variableDeclarations = (J.VariableDecls)e5;
            org.junit.jupiter.api.Assertions.assertEquals((Object)"List<String>", (Object)variableDeclarations.getTypeExpr().printTrimmed());
        }

        @Test
        public static void buildSnippetMethodReferenceArrays(@NotNull TreeBuilderTest $this, @NotNull JavaParser jp) {
            J.MethodDecl method;
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"import java.util.Arrays;\n\npublic class A {\n    void foo(String[] others, String m) {\n        String[] clone = resizeAndCopyArray(others, 1);\n        clone[others.length] = m;\n    }\n    \n    String[] resizeAndCopyArray(String[] array, int resizeBy) {\n        return Arrays.copyOf(array, array.length + resizeBy);\n    }\n}"}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            J.MethodDecl methodDecl = method = (J.MethodDecl)((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)methodDecl, (String)"method");
            J.Block block = methodDecl.getBody();
            Intrinsics.checkNotNull((Object)block);
            Cursor methodBodyCursor = (Cursor)new RetrieveCursor((Tree)block.getStatements().get(0)).visit((Tree)a);
            J.MethodDecl.Parameters parameters = method.getParams();
            Intrinsics.checkNotNullExpressionValue((Object)parameters, (String)"method.params");
            Object e2 = parameters.getParams().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"(method.params.params[0]\u2026 J.VariableDecls).vars[0]");
            J.Ident paramName = ((J.VariableDecls.NamedVar)e3).getName();
            List snippets = new TreeBuilder(a).buildSnippet(methodBodyCursor, "\n                    String[] clone = resizeAndCopyArray(" + paramName.printTrimmed() + ", 1);\n                    clone[clone.length-1] = m;\n                 ", new JavaType[0]);
            Object e4 = snippets.get(1);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Assign");
            }
            J.Assign assignment = (J.Assign)e4;
            Expression expression = assignment.getVariable();
            Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"assignment.variable");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isString((JavaType)expression.getType()));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(assignment.getVariable() instanceof J.ArrayAccess));
        }

        @Test
        public static void buildSnippetStaticMethodReference(@NotNull TreeBuilderTest $this, @NotNull JavaParser jp) {
            J.MethodDecl method;
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"import java.util.List;\n\nimport static java.util.Arrays.asList;\n\npublic class A {\n    int n = 0;\n    List<String> bucket;\n    \n    void foo(String... m) {\n        bucket.addAll(asList(m));\n        incrementCounterByListSize(bucket);\n    }\n    void incrementCounterByListSize(List<String> list) {\n        n =+ list.size();\n    }\n}"}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            J.MethodDecl methodDecl = method = (J.MethodDecl)((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)methodDecl, (String)"method");
            J.Block block = methodDecl.getBody();
            Intrinsics.checkNotNull((Object)block);
            Cursor methodBodyCursor = (Cursor)new RetrieveCursor((Tree)block.getStatements().get(0)).visit((Tree)a);
            J.MethodDecl.Parameters parameters = method.getParams();
            Intrinsics.checkNotNullExpressionValue((Object)parameters, (String)"method.params");
            Object e2 = parameters.getParams().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"(method.params.params[0]\u2026 J.VariableDecls).vars[0]");
            J.Ident paramName = ((J.VariableDecls.NamedVar)e3).getName();
            List snippets = new TreeBuilder(a).buildSnippet(methodBodyCursor, "\n                    if(bucket == null) {\n                        bucket = asList(" + paramName.printTrimmed() + ");\n                    } else {\n                        bucket.addAll(asList(" + paramName.printTrimmed() + "));\n                    }\n                    incrementCounterByListSize(bucket);\n                 ", new JavaType[0]);
            Object e4 = snippets.get(0);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            }
            J.If ifStatement = (J.If)e4;
            Statement statement = ifStatement.getThenPart();
            if (statement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block<*>");
            }
            J.Block thenPart = (J.Block)statement;
            Object e5 = thenPart.getStatements().get(0);
            if (e5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Assign");
            }
            J.Assign assign = (J.Assign)e5;
            Expression expression = assign.getAssignment();
            if (expression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.Expression");
            }
            Expression methodInv1 = expression;
            org.junit.jupiter.api.Assertions.assertNotNull((Object)methodInv1.getType(), (String)"The type information for the static method asList() should be populated");
            Object e6 = snippets.get(1);
            if (e6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.Expression");
            }
            Expression methodInv2 = (Expression)e6;
            org.junit.jupiter.api.Assertions.assertNotNull((Object)methodInv2.getType(), (String)"The type information should be populated");
        }

        @Test
        public static void buildSnippetWithClassInstanceCreation(@NotNull TreeBuilderTest $this, @NotNull JavaParser jp) {
            J.MethodDecl method;
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"import java.util.List;\n\nimport java.io.File;\n\npublic class A {\n    int n = 0;\n    List<Object> bucket;\n    \n    void foo(String... m) {\n        bucket.add(new File(\"a file\"));\n    }\n}"}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            J.MethodDecl methodDecl = method = (J.MethodDecl)((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)methodDecl, (String)"method");
            J.Block block = methodDecl.getBody();
            Intrinsics.checkNotNull((Object)block);
            Cursor methodBodyCursor = (Cursor)new RetrieveCursor((Tree)block.getStatements().get(0)).visit((Tree)a);
            List snippets = new TreeBuilder(a).buildSnippet(methodBodyCursor, "\n                    bucket.add(new File(\"some other file\"));\n                 ", new JavaType[0]);
            Object e2 = snippets.get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.Expression");
            }
            Expression methodInv1 = (Expression)e2;
            org.junit.jupiter.api.Assertions.assertNotNull((Object)methodInv1.getType(), (String)"The type information for the static method asList() should be populated");
        }

        @Test
        public static void injectSnippetIntoMethod(@NotNull TreeBuilderTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TestKt.whenParsedBy("\n            import java.util.List;\n            public class A {\n                int n = 0;\n                \n                void foo(String m, List<String> others) {\n                }\n            }\n        ", (Parser)jp).whenVisitedByMapped(injectSnippetIntoMethod.1.INSTANCE).isRefactoredTo("\n                    import java.util.List;\n                    public class A {\n                        int n = 0;\n                        \n                        void foo(String m, List<String> others) {\n                            others.add(m);\n                            if(others.contains(m)) {\n                                others.remove(m);\n                            }\n                        }\n                    }\n                ");
        }

        @Test
        @Disabled(value="https://github.com/openrewrite/rewrite/issues/38")
        public static void buildStaticInit(@NotNull TreeBuilderTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit a = (J.CompilationUnit)jp.parse(new String[]{"import java.util.ArrayList;\nimport java.util.Collection;\n\npublic class A {\n    static Collection<String> list;\n}"}).get(0);
            TreeBuilder treeBuilder = new TreeBuilder(a);
            J.CompilationUnit compilationUnit = a;
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            J j = treeBuilder.buildDeclaration((J.ClassDecl)compilationUnit.getClasses().get(0), "static {\n    list = new ArrayList<>();\n}", new JavaType[]{(JavaType)JavaType.Class.build((String)"java.util.ArrayList")});
            if (j == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block<org.openrewrite.java.tree.J>");
            }
            J.Block init = (J.Block)j;
            Object e = init.getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Assign");
            }
            Assertions.assertThat((Object)((J.Assign)e).getType()).isEqualTo((Object)JavaType.Class.build((String)"java.util.Collection"));
        }

        @Test
        public static void buildMethodDeclaration(@NotNull TreeBuilderTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit a = (J.CompilationUnit)jp.parse(new String[]{"import java.util.ArrayList;\nimport java.util.Collection;\n\npublic class A {\n    Collection<String> list = new ArrayList<>();\n}"}).get(0);
            TreeBuilder treeBuilder = new TreeBuilder(a);
            J.CompilationUnit compilationUnit = a;
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            J.MethodDecl methodDecl = treeBuilder.buildMethodDeclaration((J.ClassDecl)compilationUnit.getClasses().get(0), "B build() {\n    return new B();\n}", new JavaType[]{(JavaType)JavaType.Class.build((String)"b.B")});
            Assertions.assertThat((String)methodDecl.printTrimmed()).isEqualTo("B build() {\n    return new B();\n}");
            J.MethodDecl methodDecl2 = methodDecl;
            Intrinsics.checkNotNullExpressionValue((Object)methodDecl2, (String)"methodDecl");
            TypeTree typeTree = methodDecl2.getReturnTypeExpr();
            Assertions.assertThat((Object)(typeTree != null ? typeTree.getType() : null)).isEqualTo((Object)JavaType.Class.build((String)"b.B"));
        }

        @Test
        public static void buildFullyQualifiedClassName(@NotNull TreeBuilderTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TypeTree typeTree = TreeBuilder.buildName((String)"java.util.List", (Formatting)Formatting.EMPTY);
            if (typeTree == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.FieldAccess");
            }
            J.FieldAccess name = (J.FieldAccess)typeTree;
            org.junit.jupiter.api.Assertions.assertEquals((Object)"java.util.List", (Object)name.printTrimmed());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"List", (Object)name.getSimpleName());
        }

        @Test
        public static void buildFullyQualifiedInnerClassName(@NotNull TreeBuilderTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TypeTree typeTree = TreeBuilder.buildName((String)"a.Outer.Inner", (Formatting)Formatting.EMPTY);
            if (typeTree == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.FieldAccess");
            }
            J.FieldAccess name = (J.FieldAccess)typeTree;
            org.junit.jupiter.api.Assertions.assertEquals((Object)"a.Outer.Inner", (Object)name.printTrimmed());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"Inner", (Object)name.getSimpleName());
            JavaType.Class clazz = org.openrewrite.java.TestKt.asClass(name.getType());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"a.Outer.Inner", (Object)(clazz != null ? clazz.getFullyQualifiedName() : null));
            Expression expression = name.getTarget();
            if (expression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.FieldAccess");
            }
            J.FieldAccess outer = (J.FieldAccess)expression;
            org.junit.jupiter.api.Assertions.assertEquals((Object)"Outer", (Object)outer.getSimpleName());
            JavaType.Class clazz2 = org.openrewrite.java.TestKt.asClass(outer.getType());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"a.Outer", (Object)(clazz2 != null ? clazz2.getFullyQualifiedName() : null));
        }

        @Test
        public static void buildStaticImport(@NotNull TreeBuilderTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TypeTree typeTree = TreeBuilder.buildName((String)"a.A.*", (Formatting)Formatting.EMPTY);
            if (typeTree == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.FieldAccess");
            }
            J.FieldAccess name = (J.FieldAccess)typeTree;
            org.junit.jupiter.api.Assertions.assertEquals((Object)"a.A.*", (Object)name.printTrimmed());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"*", (Object)name.getSimpleName());
        }

        @Test
        public static void buildInnerClass(@NotNull TreeBuilderTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            List list = jp.parse(new String[]{"\n            import java.util.Arrays;\n            import java.util.List;\n            \n            class A {\n                List<String> foo = Arrays.asList(\"Hello\", \"World\");\n            }\n        "});
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jp.parse(\"\"\"\n           \u2026           }\n        \"\"\")");
            J.CompilationUnit a = (J.CompilationUnit)CollectionsKt.first((List)list);
            String innerClassSnippet = "class B {\n    String hello = foo.get(0);\n}";
            TreeBuilder treeBuilder = new TreeBuilder(a);
            J.CompilationUnit compilationUnit = a;
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            List list2 = compilationUnit.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"a.classes");
            J result = treeBuilder.buildDeclaration((J.ClassDecl)CollectionsKt.first((List)list2), innerClassSnippet, new JavaType[]{(JavaType)JavaType.Class.build((String)"java.util.List")});
            Assertions.assertThat((Object)result).isExactlyInstanceOf(J.ClassDecl.class);
            Assertions.assertThat((String)result.printTrimmed()).isEqualTo(innerClassSnippet);
        }
    }
}

