/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/tree/BlockTest;", "", "format", "", "jp", "Lorg/openrewrite/java/JavaParser;", "methodBlock", "staticInitBlock", "rewrite-test"})
public interface BlockTest {
    @Test
    public void methodBlock(@NotNull JavaParser var1);

    @Test
    public void format(@NotNull JavaParser var1);

    @Test
    public void staticInitBlock(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void methodBlock(@NotNull BlockTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                public void foo() {\n                    System.out.println(\"foo\");\n                }\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0].methods[0]");
            J.Block block = ((J.MethodDecl)e2).getBody();
            Intrinsics.checkNotNull((Object)block);
            Assertions.assertEquals((int)1, (int)block.getStatements().size());
        }

        @Test
        public static void format(@NotNull BlockTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                public void foo() {  }\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0].methods[0]");
            J.Block block = ((J.MethodDecl)e2).getBody();
            Intrinsics.checkNotNull((Object)block);
            Assertions.assertEquals((Object)"{  }", (Object)block.printTrimmed());
        }

        @Test
        public static void staticInitBlock(@NotNull BlockTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                static {}\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            J.Block block = ((J.ClassDecl)e).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"a.classes[0].body");
            Assertions.assertEquals((Object)"static {}", (Object)((J)block.getStatements().get(0)).printTrimmed());
        }
    }
}

