/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0007"}, d2={"Lorg/openrewrite/java/tree/AssignTest;", "", "assignmentToField", "", "jp", "Lorg/openrewrite/java/JavaParser;", "format", "rewrite-test"})
public interface AssignTest {
    @Test
    public void assignmentToField(@NotNull JavaParser var1);

    @Test
    public void format(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void assignmentToField(AssignTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                String s;\n                public void test() {\n                    s = \"foo\";\n                }\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Assign");
            }
            J.Assign assign = (J.Assign)statement;
            Expression expression = assign.getVariable();
            if (expression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Ident");
            }
            Assertions.assertEquals((Object)"s", (Object)((J.Ident)expression).getSimpleName());
            Assertions.assertTrue((boolean)(assign.getAssignment() instanceof J.Literal));
        }

        @Test
        public static void format(AssignTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            @SuppressWarnings(value = \"ALL\")\n            public class A {}\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getAnnotations().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0].annotations[0]");
            J.Annotation.Arguments arguments = ((J.Annotation)e2).getArgs();
            if (arguments == null) {
                Intrinsics.throwNpe();
            }
            Object e3 = arguments.getArgs().get(0);
            if (e3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Assign");
            }
            J.Assign assign = (J.Assign)e3;
            Assertions.assertEquals((Object)"value = \"ALL\"", (Object)assign.printTrimmed());
        }
    }
}

