/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/search/FindFieldsTest;", "", "findArrayOfType", "", "jp", "Lorg/openrewrite/java/JavaParser;", "findPrivateNonInheritedField", "skipsMultiCatches", "rewrite-test"})
public interface FindFieldsTest {
    @Test
    public void findPrivateNonInheritedField(@NotNull JavaParser var1);

    @Test
    public void findArrayOfType(@NotNull JavaParser var1);

    @Test
    public void skipsMultiCatches(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void findPrivateNonInheritedField(FindFieldsTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            import java.util.*;\n            public class A {\n               private List list;\n               private Set set;\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            List fields = ((J.ClassDecl)compilationUnit.getClasses().get(0)).findFields("java.util.List");
            Assertions.assertEquals((int)1, (int)fields.size());
            Object e = fields.get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"fields[0]");
            Object e2 = ((J.VariableDecls)e).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"fields[0].vars[0]");
            Assertions.assertEquals((Object)"list", (Object)((J.VariableDecls.NamedVar)e2).getName().printTrimmed());
            Object e3 = fields.get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"fields[0]");
            TypeTree typeTree = ((J.VariableDecls)e3).getTypeExpr();
            Assertions.assertTrue((boolean)TestKt.hasElementType((JavaType)(typeTree != null ? typeTree.getType() : null), "java.util.List"));
        }

        @Test
        public static void findArrayOfType(FindFieldsTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            import java.util.*;\n            public class A {\n               private String[] s;\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            List fields = ((J.ClassDecl)compilationUnit.getClasses().get(0)).findFields("java.lang.String");
            Assertions.assertEquals((int)1, (int)fields.size());
            Object e = fields.get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"fields[0]");
            Object e2 = ((J.VariableDecls)e).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"fields[0].vars[0]");
            Assertions.assertEquals((Object)"s", (Object)((J.VariableDecls.NamedVar)e2).getName().printTrimmed());
            Object e3 = fields.get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"fields[0]");
            TypeTree typeTree = ((J.VariableDecls)e3).getTypeExpr();
            Assertions.assertTrue((boolean)TestKt.hasElementType((JavaType)(typeTree != null ? typeTree.getType() : null), "java.lang.String"));
        }

        @Test
        public static void skipsMultiCatches(FindFieldsTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            import java.io.*;\n            public class A {\n                File f;\n                public void test() {\n                    try(FileInputStream fis = new FileInputStream(f)) {}\n                    catch(FileNotFoundException | RuntimeException e) {}\n                }\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Assertions.assertEquals((int)1, (int)((J.ClassDecl)compilationUnit.getClasses().get(0)).findFields("java.io.File").size());
        }
    }
}

