/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\f"}, d2={"Lorg/openrewrite/java/tree/MethodDeclTest;", "", "constructor", "", "jp", "Lorg/openrewrite/java/JavaParser;", "format", "formatConstructor", "formatDefaultMethod", "interfaceMethodDecl", "methodDecl", "nativeModifier", "rewrite-test"})
public interface MethodDeclTest {
    @Test
    public void constructor(@NotNull JavaParser var1);

    @Test
    public void methodDecl(@NotNull JavaParser var1);

    @Test
    public void interfaceMethodDecl(@NotNull JavaParser var1);

    @Test
    public void format(@NotNull JavaParser var1);

    @Test
    public void formatDefaultMethod(@NotNull JavaParser var1);

    @Test
    public void formatConstructor(@NotNull JavaParser var1);

    @Test
    public void nativeModifier(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void constructor(MethodDeclTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            package a;\n            public class A {\n                public A() { }\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0].methods[0]");
            Assertions.assertNull((Object)((J.MethodDecl)e2).getReturnTypeExpr());
        }

        @Test
        public static void methodDecl(MethodDeclTest $this, @NotNull JavaParser jp) {
            J.MethodDecl meth;
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                public <P, R> R foo(P p, String s, String... args) {\n                    return null;\n                }\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            J.MethodDecl methodDecl = meth = (J.MethodDecl)((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)methodDecl, (String)"meth");
            Assertions.assertEquals((Object)"foo", (Object)methodDecl.getSimpleName());
            J.MethodDecl.Parameters parameters = meth.getParams();
            Intrinsics.checkExpressionValueIsNotNull((Object)parameters, (String)"meth.params");
            Assertions.assertEquals((int)3, (int)parameters.getParams().size());
            J.Block block = meth.getBody();
            if (block == null) {
                Intrinsics.throwNpe();
            }
            Assertions.assertEquals((int)1, (int)block.getStatements().size());
            TypeTree typeTree = meth.getReturnTypeExpr();
            if (typeTree == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Ident");
            }
            JavaType javaType = ((J.Ident)typeTree).getType();
            if (javaType == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.GenericTypeVariable");
            }
            Assertions.assertEquals((Object)"R", (Object)((JavaType.GenericTypeVariable)javaType).getFullyQualifiedName());
            Assertions.assertTrue((boolean)meth.hasModifier("public"));
        }

        @Test
        public static void interfaceMethodDecl(MethodDeclTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String aSrc = "public interface A {\n    String getName() ;\n}";
            Assertions.assertEquals((Object)aSrc, (Object)jp.parse(aSrc, new String[0]).printTrimmed());
        }

        @Test
        public static void format(MethodDeclTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                public < P > P foo(P p, String s, String ... args)  throws Exception { return p; }\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            J.MethodDecl meth = (J.MethodDecl)((J.ClassDecl)e).getMethods().get(0);
            Assertions.assertEquals((Object)"public < P > P foo(P p, String s, String ... args)  throws Exception { return p; }", (Object)meth.printTrimmed());
        }

        @Test
        public static void formatDefaultMethod(MethodDeclTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public interface A {\n                default int foo() { return 0; }\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            J.MethodDecl meth = (J.MethodDecl)((J.ClassDecl)e).getMethods().get(0);
            Assertions.assertEquals((Object)"default int foo() { return 0; }", (Object)meth.printTrimmed());
        }

        @Test
        public static void formatConstructor(MethodDeclTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            package a;\n            public class A {\n                public A() { }\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            J.MethodDecl meth = (J.MethodDecl)((J.ClassDecl)e).getMethods().get(0);
            Assertions.assertEquals((Object)"public A() { }", (Object)meth.printTrimmed());
        }

        @Test
        public static void nativeModifier(MethodDeclTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                public native void foo();\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            J.MethodDecl meth = (J.MethodDecl)((J.ClassDecl)e).getMethods().get(0);
            Assertions.assertEquals((Object)"public native void foo()", (Object)meth.printTrimmed());
        }
    }
}

