/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaSourceVisitor;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0007"}, d2={"Lorg/openrewrite/java/tree/MemberReferenceTest;", "", "constructorMethodReference", "", "jp", "Lorg/openrewrite/java/JavaParser;", "staticFunctionReference", "rewrite-test"})
public interface MemberReferenceTest {
    @Test
    public void staticFunctionReference(@NotNull JavaParser var1);

    @Test
    public void constructorMethodReference(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void staticFunctionReference(MemberReferenceTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("\n            import java.util.stream.Stream;\n\n            public class StaticLambdaRef {\n                void test() {\n                    Stream.of(\"s\").forEach(A :: func);\n                }\n            }\n\n            class A {\n                static void func(String s) {}\n            }\n        ", new String[0]);
            CountDownLatch memberRefLatch = new CountDownLatch(1);
            new JavaSourceVisitor<Unit>(memberRefLatch){
                final /* synthetic */ CountDownLatch $memberRefLatch;

                @Nullable
                public Void defaultTo(@Nullable Tree t) {
                    return null;
                }

                @Nullable
                public Unit visitMemberReference(@NotNull J.MemberReference memberRef) {
                    Intrinsics.checkParameterIsNotNull((Object)memberRef, (String)"memberRef");
                    this.$memberRefLatch.countDown();
                    JavaType.Class clazz = TestKt.asClass(memberRef.getType());
                    Assertions.assertEquals((Object)"java.util.function.Consumer", (Object)(clazz != null ? clazz.getFullyQualifiedName() : null));
                    Assertions.assertEquals((Object)"A :: func", (Object)memberRef.printTrimmed());
                    return null;
                }
                {
                    this.$memberRefLatch = $captured_local_variable$0;
                }
            }.visit((Tree)a);
            Assertions.assertEquals((long)0L, (long)memberRefLatch.getCount());
        }

        @Test
        public static void constructorMethodReference(MemberReferenceTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            import java.util.*;\n            import java.util.stream.*;\n            public class A {\n                Stream<Integer> n = Stream.of(1, 2);\n                Set<Integer> n2 = n.collect(HashSet<Integer>::new, HashSet::add);\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(1);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0].fields[1]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"a.classes[0].fields[1].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            if (expression == null) {
                Intrinsics.throwNpe();
            }
            Expression collect = expression;
            Assertions.assertEquals((Object)"n.collect(HashSet<Integer>::new, HashSet::add)", (Object)collect.printTrimmed());
        }
    }
}

