/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.Change;
import org.openrewrite.Refactor;
import org.openrewrite.SourceVisitor;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.ChangeMethodTargetToStatic;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0007"}, d2={"Lorg/openrewrite/java/ChangeMethodTargetToStaticTest;", "", "refactorStaticTargetToStatic", "", "jp", "Lorg/openrewrite/java/JavaParser;", "refactorTargetToStatic", "rewrite-test"})
public interface ChangeMethodTargetToStaticTest {
    @Test
    public void refactorTargetToStatic(@NotNull JavaParser var1);

    @Test
    public void refactorStaticTargetToStatic(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void refactorTargetToStatic(ChangeMethodTargetToStaticTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "package a;\npublic class A {\n   public void nonStatic() {}\n}";
            String b = "package b;\npublic class B {\n   public static void foo() {}\n}";
            String c = "import a.*;\nclass C {\n   public void test() {\n       new A().nonStatic();\n   }\n}";
            J.CompilationUnit cu = jp.parse(c, new String[]{a, b});
            ChangeMethodTargetToStatic changeMethodTargetToStatic = new ChangeMethodTargetToStatic();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = cu.refactor();
            boolean bl = false;
            boolean bl2 = false;
            ChangeMethodTargetToStatic $this$apply = changeMethodTargetToStatic;
            boolean bl3 = false;
            $this$apply.setMethod("a.A nonStatic()");
            $this$apply.setTargetType("b.B");
            ChangeMethodTargetToStatic changeMethodTargetToStatic2 = changeMethodTargetToStatic;
            sourceVisitorArray[n] = (SourceVisitor)changeMethodTargetToStatic2;
            Refactor refactor2 = refactor.visit(sourceVisitorArray2);
            changeMethodTargetToStatic = new ChangeMethodName();
            n = 0;
            sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            refactor = refactor2;
            bl = false;
            bl2 = false;
            $this$apply = changeMethodTargetToStatic;
            boolean bl4 = false;
            $this$apply.setMethod("b.B nonStatic()");
            $this$apply.setName("foo");
            changeMethodTargetToStatic2 = changeMethodTargetToStatic;
            sourceVisitorArray[n] = (SourceVisitor)changeMethodTargetToStatic2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"cu.refactor()\n          \u2026})\n                .fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            import b.B;\n            \n            class C {\n               public void test() {\n                   B.foo();\n               }\n            }\n        ");
            Object e = fixed2.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"fixed.classes[0]");
            Object e2 = ((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"fixed.classes[0].methods[0]");
            J.Block block = ((J.MethodDecl)e2).getBody();
            if (block == null) {
                Intrinsics.throwNpe();
            }
            Object e3 = block.getStatements().get(0);
            if (e3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            J.MethodInvocation refactoredInv = (J.MethodInvocation)e3;
            JavaType.Method method = refactoredInv.getType();
            Assertions.assertTrue((boolean)(method != null ? method.hasFlags(new Flag[]{Flag.Static}) : false));
        }

        @Test
        public static void refactorStaticTargetToStatic(ChangeMethodTargetToStaticTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "package a;\npublic class A {\n   public static void foo() {}\n}";
            String b = "package b;\npublic class B {\n   public static void foo() {}\n}";
            String c = "import static a.A.*;\nclass C {\n   public void test() {\n       foo();\n   }\n}";
            J.CompilationUnit cu = jp.parse(c, new String[]{a, b});
            ChangeMethodTargetToStatic changeMethodTargetToStatic = new ChangeMethodTargetToStatic();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = cu.refactor();
            boolean bl = false;
            boolean bl2 = false;
            ChangeMethodTargetToStatic $this$apply = changeMethodTargetToStatic;
            boolean bl3 = false;
            $this$apply.setMethod("a.A foo()");
            $this$apply.setTargetType("b.B");
            ChangeMethodTargetToStatic changeMethodTargetToStatic2 = changeMethodTargetToStatic;
            sourceVisitorArray[n] = (SourceVisitor)changeMethodTargetToStatic2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"cu.refactor()\n          \u2026})\n                .fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\n            import b.B;\n            \n            class C {\n               public void test() {\n                   B.foo();\n               }\n            }\n        ");
        }
    }
}

