/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0006"}, d2={"Lorg/openrewrite/java/tree/TernaryTest;", "", "ternary", "", "jp", "Lorg/openrewrite/java/JavaParser;", "rewrite-test"})
public interface TernaryTest {
    @Test
    public void ternary(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void ternary(TernaryTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                int n;\n                public void test() {\n                    String evenOrOdd = n % 2 == 0 ? \"even\" : \"odd\";\n                }\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            J.VariableDecls evenOrOdd = (J.VariableDecls)statement;
            Object e = evenOrOdd.getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"evenOrOdd.vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e).getInitializer();
            if (expression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Ternary");
            }
            J.Ternary ternary = (J.Ternary)expression;
            JavaType.Class clazz = TestKt.asClass(ternary.getType());
            Assertions.assertEquals((Object)"java.lang.String", (Object)(clazz != null ? clazz.getFullyQualifiedName() : null));
            Assertions.assertTrue((boolean)(ternary.getCondition() instanceof J.Binary));
            Assertions.assertTrue((boolean)(ternary.getTruePart() instanceof J.Literal));
            Assertions.assertTrue((boolean)(ternary.getFalsePart() instanceof J.Literal));
            Assertions.assertEquals((Object)"n % 2 == 0 ? \"even\" : \"odd\"", (Object)ternary.printTrimmed());
        }
    }
}

