/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.Change;
import org.openrewrite.Cursor;
import org.openrewrite.Formatting;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.RetrieveCursor;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TreeBuilder;
import org.openrewrite.java.tree.TypeTree;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\n"}, d2={"Lorg/openrewrite/java/tree/TreeBuilderTest;", "", "buildFullyQualifiedClassName", "", "jp", "Lorg/openrewrite/java/JavaParser;", "buildFullyQualifiedInnerClassName", "buildSnippet", "buildStaticImport", "injectSnippetIntoMethod", "rewrite-test"})
public interface TreeBuilderTest {
    @Test
    public void buildSnippet(@NotNull JavaParser var1);

    @Test
    public void injectSnippetIntoMethod(@NotNull JavaParser var1);

    @Test
    public void buildFullyQualifiedClassName(@NotNull JavaParser var1);

    @Test
    public void buildFullyQualifiedInnerClassName(@NotNull JavaParser var1);

    @Test
    public void buildStaticImport(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void buildSnippet(TreeBuilderTest $this, @NotNull JavaParser jp) {
            J.MethodDecl method;
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("import java.util.List;\npublic class A {\n    int n = 0;\n    \n    void foo(String m, List<String> others) {\n    }\n}", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            J.MethodDecl methodDecl = method = (J.MethodDecl)((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)methodDecl, (String)"method");
            Cursor methodBodyCursor = (Cursor)new RetrieveCursor((Tree)methodDecl.getBody()).visit((Tree)a);
            J.MethodDecl.Parameters parameters = method.getParams();
            Intrinsics.checkExpressionValueIsNotNull((Object)parameters, (String)"method.params");
            Object e2 = parameters.getParams().get(0);
            if (e2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"(method.params.params[0]\u2026 J.VariableDecls).vars[0]");
            J.Ident paramName = ((J.VariableDecls.NamedVar)e3).getName();
            List snippets = TreeBuilder.buildSnippet((JavaParser)jp, (J.CompilationUnit)a, (Cursor)methodBodyCursor, (String)("others.add(" + paramName.printTrimmed() + ");"), (JavaType.Class[])new JavaType.Class[0]);
            Assertions.assertTrue((boolean)(snippets.get(0) instanceof J.MethodInvocation));
        }

        @Test
        public static void injectSnippetIntoMethod(TreeBuilderTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            J.MethodDecl method;
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("import java.util.List;\npublic class A {\n    int n = 0;\n    \n    void foo(String m, List<String> others) {\n    }\n}", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            J.MethodDecl methodDecl = method = (J.MethodDecl)((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)methodDecl, (String)"method");
            Cursor methodBodyCursor = (Cursor)new RetrieveCursor((Tree)methodDecl.getBody()).visit((Tree)a);
            J.MethodDecl.Parameters parameters = method.getParams();
            Intrinsics.checkExpressionValueIsNotNull((Object)parameters, (String)"method.params");
            Object e2 = parameters.getParams().get(0);
            if (e2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"(method.params.params[0]\u2026 J.VariableDecls).vars[0]");
            String paramName = ((J.VariableDecls.NamedVar)e3).getName().printTrimmed();
            List snippets = TreeBuilder.buildSnippet((JavaParser)jp, (J.CompilationUnit)a, (Cursor)methodBodyCursor, (String)StringsKt.trimIndent((String)("\n                    others.add(" + paramName + ");\n                    if(others.contains(" + paramName + ")) {\n                        others.remove(" + paramName + ");\n                    }\n                ")), (JavaType.Class[])new JavaType.Class[0]);
            Change change = a.refactor().visit(new SourceVisitor[]{(SourceVisitor)new JavaRefactorVisitor(snippets){
                final /* synthetic */ List $snippets;

                @NotNull
                public J visitMethod(@NotNull J.MethodDecl method) {
                    Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
                    J.Block block = method.getBody();
                    if (block == null) {
                        Intrinsics.throwNpe();
                    }
                    J.MethodDecl methodDecl = method.withBody(block.withStatements(this.$snippets));
                    Intrinsics.checkExpressionValueIsNotNull((Object)methodDecl, (String)"method.withBody(method.b\u2026withStatements(snippets))");
                    return (J)methodDecl;
                }
                {
                    this.$snippets = $captured_local_variable$0;
                }
            }}).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor().visit(objec\u2026ippets))\n        }).fix()");
            J.CompilationUnit compilationUnit2 = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit2, (String)"fixed");
            TestKt.assertRefactored(compilationUnit2, "\n            import java.util.List;\n            public class A {\n                int n = 0;\n                \n                void foo(String m, List<String> others) {\n                    others.add(m);\n                    if(others.contains(m)) {\n                        others.remove(m);\n                    }\n                }\n            }\n        ");
        }

        @Test
        public static void buildFullyQualifiedClassName(TreeBuilderTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            TypeTree typeTree = TreeBuilder.buildName((String)"java.util.List", (Formatting)Formatting.EMPTY);
            if (typeTree == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.FieldAccess");
            }
            J.FieldAccess name = (J.FieldAccess)typeTree;
            Assertions.assertEquals((Object)"java.util.List", (Object)name.printTrimmed());
            Assertions.assertEquals((Object)"List", (Object)name.getSimpleName());
        }

        @Test
        public static void buildFullyQualifiedInnerClassName(TreeBuilderTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            TypeTree typeTree = TreeBuilder.buildName((String)"a.Outer.Inner", (Formatting)Formatting.EMPTY);
            if (typeTree == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.FieldAccess");
            }
            J.FieldAccess name = (J.FieldAccess)typeTree;
            Assertions.assertEquals((Object)"a.Outer.Inner", (Object)name.printTrimmed());
            Assertions.assertEquals((Object)"Inner", (Object)name.getSimpleName());
            JavaType.Class clazz = TestKt.asClass(name.getType());
            Assertions.assertEquals((Object)"a.Outer.Inner", (Object)(clazz != null ? clazz.getFullyQualifiedName() : null));
            Expression expression = name.getTarget();
            if (expression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.FieldAccess");
            }
            J.FieldAccess outer = (J.FieldAccess)expression;
            Assertions.assertEquals((Object)"Outer", (Object)outer.getSimpleName());
            JavaType.Class clazz2 = TestKt.asClass(outer.getType());
            Assertions.assertEquals((Object)"a.Outer", (Object)(clazz2 != null ? clazz2.getFullyQualifiedName() : null));
        }

        @Test
        public static void buildStaticImport(TreeBuilderTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            TypeTree typeTree = TreeBuilder.buildName((String)"a.A.*", (Formatting)Formatting.EMPTY);
            if (typeTree == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.FieldAccess");
            }
            J.FieldAccess name = (J.FieldAccess)typeTree;
            Assertions.assertEquals((Object)"a.A.*", (Object)name.printTrimmed());
            Assertions.assertEquals((Object)"*", (Object)name.getSimpleName());
        }
    }
}

