/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.template.processor;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;
import org.jspecify.annotations.Nullable;
import org.openrewrite.java.template.internal.ImportDetector;
import org.openrewrite.java.template.internal.StringUtils;
import org.openrewrite.java.template.processor.Precondition;
import org.openrewrite.java.template.processor.RefasterTemplateProcessor;
import org.openrewrite.java.template.processor.RuleDescriptor;
import org.openrewrite.java.template.processor.TemplateDescriptor;

class RecipeWriter {
    private static final String GENERATOR_NAME = RefasterTemplateProcessor.class.getName();
    private static final String USE_IMPORT_POLICY = "com.google.errorprone.refaster.annotation.UseImportPolicy";
    private final JavacProcessingEnvironment processingEnv;
    private final JCTree.JCCompilationUnit cu;
    private boolean anySearchRecipe;
    private final Map<TemplateDescriptor, Set<String>> imports = new HashMap<TemplateDescriptor, Set<String>>();
    private final Map<TemplateDescriptor, Set<String>> staticImports = new HashMap<TemplateDescriptor, Set<String>>();
    private final Map<String, String> recipes = new LinkedHashMap<String, String>();

    public RecipeWriter(JavacProcessingEnvironment processingEnv, JCTree.JCCompilationUnit cu) {
        this.processingEnv = processingEnv;
        this.cu = cu;
    }

    private String escapeTemplate(JCTree.JCClassDecl classDecl) {
        TreeMaker treeMaker = TreeMaker.instance(this.processingEnv.getContext()).forToplevel(this.cu);
        java.util.List membersWithoutConstructor = classDecl.getMembers().stream().filter(m -> !(m instanceof JCTree.JCMethodDecl) || !((JCTree.JCMethodDecl)m).name.contentEquals("<init>")).collect(Collectors.toList());
        return treeMaker.ClassDef(classDecl.mods, classDecl.name, classDecl.typarams, classDecl.extending, classDecl.implementing, List.from(membersWithoutConstructor)).toString().trim().replace("@BeforeTemplate()", "@BeforeTemplate").replace("@AfterTemplate()", "@AfterTemplate").replace("\\", "\\\\").replace("\"", "\\\"").replaceAll("\\R", "\\\\n");
    }

    private static String escapeJava(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\n", "\\n").replace("\t", "\\t").replace("\f", "\\f").replace("\r", "\\r");
    }

    private static String matchParameters(Map<Name, Integer> beforeParameters, Map<Name, Integer> afterParameters) {
        return afterParameters.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(e -> (Integer)beforeParameters.get(e.getKey())).map(e -> "matcher.parameter(" + e + ")").collect(Collectors.joining(", "));
    }

    public void writeRecipeForClassDeclaration(JCTree.JCClassDecl classDecl, @Nullable RuleDescriptor descriptor) {
        if (descriptor != null) {
            this.collectRecipes(classDecl, descriptor);
        }
        if (classDecl.sym != null && classDecl.sym.getNestingKind() == NestingKind.TOP_LEVEL && !this.recipes.isEmpty()) {
            boolean outerClassRequired = descriptor == null;
            this.writeRecipeClass(classDecl, outerClassRequired, descriptor);
        }
    }

    private void collectRecipes(JCTree.JCClassDecl classDecl, RuleDescriptor descriptor) {
        for (TemplateDescriptor templateDescriptor : descriptor.beforeTemplates) {
            for (Symbol anImport : ImportDetector.imports(templateDescriptor.method)) {
                if (anImport instanceof Symbol.ClassSymbol) {
                    this.imports.computeIfAbsent(templateDescriptor, k -> new TreeSet()).add(anImport.getQualifiedName().toString().replace('$', '.'));
                    continue;
                }
                if (anImport instanceof Symbol.VarSymbol || anImport instanceof Symbol.MethodSymbol) {
                    this.staticImports.computeIfAbsent(templateDescriptor, k -> new TreeSet()).add(anImport.owner.getQualifiedName().toString().replace('$', '.') + '.' + anImport.flatName().toString());
                    continue;
                }
                throw new AssertionError(anImport.getClass());
            }
        }
        if (descriptor.afterTemplate == null) {
            this.anySearchRecipe = true;
        } else {
            for (Symbol symbol : ImportDetector.imports(descriptor.afterTemplate.method)) {
                if (symbol instanceof Symbol.ClassSymbol) {
                    this.imports.computeIfAbsent(descriptor.afterTemplate, k -> new TreeSet()).add(symbol.getQualifiedName().toString().replace('$', '.'));
                    continue;
                }
                if (symbol instanceof Symbol.VarSymbol || symbol instanceof Symbol.MethodSymbol) {
                    this.staticImports.computeIfAbsent(descriptor.afterTemplate, k -> new TreeSet()).add(symbol.owner.getQualifiedName().toString().replace('$', '.') + '.' + symbol.flatName().toString());
                    continue;
                }
                throw new AssertionError(symbol.getClass());
            }
        }
        for (Set set : this.imports.values()) {
            set.removeIf(i -> {
                int endIndex = i.lastIndexOf(46);
                return endIndex < 0 || "java.lang".equals(i.substring(0, endIndex)) || i.startsWith("com.google.errorprone.refaster");
            });
        }
        for (Set set : this.staticImports.values()) {
            set.removeIf(i -> i.startsWith("java.lang.") || i.startsWith("com.google.errorprone.refaster."));
        }
        LinkedHashMap<String, TemplateDescriptor> beforeTemplates = new LinkedHashMap<String, TemplateDescriptor>();
        for (TemplateDescriptor templ : descriptor.beforeTemplates) {
            String name = templ.method.name.toString();
            if (beforeTemplates.containsKey(name)) {
                String base = name;
                int i2 = 0;
                while (beforeTemplates.containsKey(name = base + i2)) {
                    ++i2;
                }
            }
            beforeTemplates.put(name, templ);
        }
        String string = classDecl.sym.fullname.toString() + "Recipe";
        String escapedTemplateCode = this.escapeTemplate(classDecl);
        StringBuilder recipe = new StringBuilder();
        Symbol.PackageSymbol pkg = classDecl.sym.packge();
        String typeName = classDecl.sym.fullname.toString();
        String refasterRuleClassName = pkg.isUnnamed() ? typeName : typeName.substring(pkg.fullname.length() + 1);
        recipe.append("/**\n * OpenRewrite recipe created for Refaster template {@code ").append(refasterRuleClassName).append("}.\n */\n");
        String recipeName = string.substring(string.lastIndexOf(46) + 1);
        recipe.append("@SuppressWarnings(\"all\")\n");
        recipe.append("@NullMarked\n");
        if (descriptor.classDecl.sym.outermostClass() == classDecl.sym) {
            recipe.append("@Generated(\"").append(GENERATOR_NAME).append("\")\n");
            recipe.append("public class ");
        } else {
            recipe.append("public static class ");
        }
        recipe.append(recipeName).append(" extends Recipe {\n\n");
        recipe.append("    /**\n");
        recipe.append("     * Instantiates a new instance.\n");
        recipe.append("     */\n");
        recipe.append("    public ").append(recipeName).append("() {}\n\n");
        recipe.append(this.recipeDescriptor(classDecl, descriptor, "Refaster template `" + refasterRuleClassName + '`', "Recipe created for the following Refaster template:\\n```java\\n" + escapedTemplateCode + "\\n```\\n."));
        recipe.append("    @Override\n");
        recipe.append("    public TreeVisitor<?, ExecutionContext> getVisitor() {\n");
        String javaVisitor = this.newAbstractRefasterJavaVisitor(beforeTemplates, descriptor);
        Precondition preconditions = RecipeWriter.generatePreconditions(descriptor.beforeTemplates);
        if (preconditions == null) {
            recipe.append(String.format("        return %s;\n", javaVisitor));
        } else {
            recipe.append(String.format("        JavaVisitor<ExecutionContext> javaVisitor = %s;\n", javaVisitor));
            recipe.append("        return Preconditions.check(\n");
            recipe.append(StringUtils.indent(preconditions.toString(), 16)).append(",\n");
            recipe.append("                javaVisitor\n");
            recipe.append("        );\n");
        }
        recipe.append("    }\n");
        recipe.append("}\n");
        this.recipes.put(recipeName, recipe.toString());
    }

    private void writeRecipeClass(JCTree.JCClassDecl classDecl, boolean outerClassRequired, @Nullable RuleDescriptor descriptor) {
        try {
            Symbol.PackageSymbol pkg = classDecl.sym.packge();
            String inputOuterFQN = outerClassRequired ? classDecl.sym.fullname.toString() : descriptor.classDecl.sym.fullname.toString();
            String className = inputOuterFQN + (outerClassRequired ? "Recipes" : "Recipe");
            JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(className, new Element[0]);
            try (BufferedWriter out = new BufferedWriter(builderFile.openWriter());){
                if (!pkg.isUnnamed()) {
                    out.write("package " + pkg.fullname + ";\n");
                    out.write("\n");
                }
                this.writeImports(out);
                if (outerClassRequired) {
                    out.write("/**\n * OpenRewrite recipes created for Refaster template {@code " + inputOuterFQN + "}.\n */\n");
                    String outerClassName = className.substring(className.lastIndexOf(46) + 1);
                    out.write("@SuppressWarnings(\"all\")\n");
                    out.write("@Generated(\"" + GENERATOR_NAME + "\")\n");
                    out.write("public class " + outerClassName + " extends Recipe {\n");
                    out.write("    /**\n");
                    out.write("     * Instantiates a new instance.\n");
                    out.write("     */\n");
                    out.write("    public " + outerClassName + "() {}\n\n");
                    out.write(this.recipeDescriptor(classDecl, descriptor, String.format("`%s` Refaster recipes", inputOuterFQN.substring(inputOuterFQN.lastIndexOf(46) + 1)), String.format("Refaster template recipes for `%s`.", inputOuterFQN)));
                    String recipesAsList = this.recipes.keySet().stream().map(r -> "                new " + r.substring(r.lastIndexOf(46) + 1) + "()").collect(Collectors.joining(",\n"));
                    out.write("    @Override\n    public List<Recipe> getRecipeList() {\n        return Arrays.asList(\n" + recipesAsList + '\n' + "        );\n    }\n\n");
                    for (String r2 : this.recipes.values()) {
                        out.write(r2.replaceAll("(?m)^(.+)$", "    $1"));
                        ((Writer)out).write(10);
                    }
                    out.write("}\n");
                } else {
                    for (String r3 : this.recipes.values()) {
                        out.write(r3);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeImports(Writer out) throws IOException {
        String generatedAnnotation = this.processingEnv.getOptions().get("rewrite.generatedAnnotation");
        if (generatedAnnotation == null) {
            generatedAnnotation = "javax.annotation.Generated";
        }
        out.write("import org.jspecify.annotations.NullMarked;\n");
        out.write("import org.openrewrite.ExecutionContext;\n");
        out.write("import org.openrewrite.Preconditions;\n");
        out.write("import org.openrewrite.Recipe;\n");
        out.write("import org.openrewrite.TreeVisitor;\n");
        out.write("import org.openrewrite.java.JavaParser;\n");
        out.write("import org.openrewrite.java.JavaTemplate;\n");
        out.write("import org.openrewrite.java.JavaVisitor;\n");
        out.write("import org.openrewrite.java.search.*;\n");
        out.write("import org.openrewrite.java.template.Primitive;\n");
        out.write("import org.openrewrite.java.template.function.*;\n");
        out.write("import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;\n");
        out.write("import org.openrewrite.java.tree.*;\n");
        if (this.anySearchRecipe) {
            out.write("import org.openrewrite.marker.SearchResult;\n");
        }
        out.write("\n");
        out.write("import " + generatedAnnotation + ";\n");
        out.write("import java.util.*;\n");
        out.write("\n");
        out.write("import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;\n");
        out.write("\n");
    }

    private String newAbstractRefasterJavaVisitor(Map<String, TemplateDescriptor> beforeTemplates, RuleDescriptor descriptor) {
        StringBuilder visitor = new StringBuilder();
        visitor.append("new AbstractRefasterJavaVisitor() {\n");
        for (Map.Entry<String, TemplateDescriptor> entry : beforeTemplates.entrySet()) {
            int arity = entry.getValue().getArity();
            for (int i = 0; i < arity; ++i) {
                visitor.append("            JavaTemplate ").append(entry.getKey()).append(arity > 1 ? "$" + i : "").append(";\n");
            }
        }
        if (descriptor.afterTemplate != null && !descriptor.afterTemplate.method.body.stats.isEmpty()) {
            visitor.append("            JavaTemplate after;\n\n");
        }
        TreeMap<String, Map> templatesByLstType = new TreeMap<String, Map>();
        for (Map.Entry<String, TemplateDescriptor> entry : beforeTemplates.entrySet()) {
            for (String lstType2 : entry.getValue().getTypes()) {
                templatesByLstType.computeIfAbsent(lstType2, k -> new TreeMap()).put(entry.getKey(), entry.getValue());
            }
        }
        templatesByLstType.forEach((lstType, typeBeforeTemplates) -> visitor.append(this.generateVisitMethod((Map<String, TemplateDescriptor>)typeBeforeTemplates, descriptor, (String)lstType)));
        visitor.append("        }");
        return visitor.toString();
    }

    private String generateVisitMethod(Map<String, TemplateDescriptor> beforeTemplates, RuleDescriptor descriptor, String lstType) {
        StringBuilder visitMethod = new StringBuilder();
        String methodSuffix = lstType.startsWith("J.") ? lstType.substring(2) : lstType;
        visitMethod.append("            @Override\n");
        visitMethod.append("            public J visit").append(methodSuffix).append("(").append(lstType).append(" elem, ExecutionContext ctx) {\n");
        if ("Statement".equals(lstType)) {
            visitMethod.append("                if (elem instanceof J.Block) {\n");
            visitMethod.append("                    // FIXME workaround\n");
            visitMethod.append("                    return elem;\n");
            visitMethod.append("                }\n");
        }
        visitMethod.append("                JavaTemplate.Matcher matcher;\n");
        for (Map.Entry<String, TemplateDescriptor> entry : beforeTemplates.entrySet()) {
            int arity = entry.getValue().getArity();
            for (int i = 0; i < arity; ++i) {
                String variableName = entry.getKey() + (arity > 1 ? "$" + i : "");
                visitMethod.append("                if (").append(variableName).append(" == null) {\n").append("                    ").append(variableName).append(" = ").append(StringUtils.indentNewLine(entry.getValue().toJavaTemplateBuilder(i), 20)).append(".build();\n").append("                }\n").append("                if ((matcher = ").append(variableName).append(".matcher(getCursor())).find()) {\n");
                Map<Name, Integer> beforeParameters = RefasterTemplateProcessor.findParameterOrder(entry.getValue().method, i);
                for (JCTree.JCVariableDecl param : entry.getValue().method.getParameters()) {
                    java.util.List annotations = param.getModifiers().getAnnotations();
                    for (JCTree.JCAnnotation jcAnnotation : annotations) {
                        String matcher;
                        String annotationType = jcAnnotation.attribute.type.tsym.getQualifiedName().toString();
                        if (!beforeParameters.containsKey(param.name) && annotationType.startsWith("org.openrewrite.java.template")) {
                            RefasterTemplateProcessor.printNoteOnce(this.processingEnv, "Ignoring annotation " + annotationType + " on unused parameter " + param.name, entry.getValue().classDecl.sym);
                            continue;
                        }
                        if ("org.openrewrite.java.template.NotMatches".equals(annotationType)) {
                            matcher = ((Type.ClassType)((Attribute)jcAnnotation.attribute.getValue().values.get((int)0).snd).getValue()).tsym.getQualifiedName().toString();
                            visitMethod.append("                    if (new ").append(matcher).append("().matches((Expression) matcher.parameter(").append(beforeParameters.get(param.name)).append("))) {\n");
                            visitMethod.append("                        return super.visit").append(methodSuffix).append("(elem, ctx);\n");
                            visitMethod.append("                    }\n");
                            continue;
                        }
                        if (!"org.openrewrite.java.template.Matches".equals(annotationType)) continue;
                        matcher = ((Type.ClassType)((Attribute)jcAnnotation.attribute.getValue().values.get((int)0).snd).getValue()).tsym.getQualifiedName().toString();
                        visitMethod.append("                    if (!new ").append(matcher).append("().matches((Expression) matcher.parameter(").append(beforeParameters.get(param.name)).append("))) {\n");
                        visitMethod.append("                        return super.visit").append(methodSuffix).append("(elem, ctx);\n");
                        visitMethod.append("                    }\n");
                    }
                }
                if (descriptor.afterTemplate == null) {
                    visitMethod.append("                    return SearchResult.found(elem);\n");
                } else {
                    RecipeWriter.maybeRemoveImports(this.imports, visitMethod, entry.getValue(), i, descriptor.afterTemplate);
                    RecipeWriter.maybeRemoveStaticImports(this.staticImports, visitMethod, entry.getValue(), i, descriptor.afterTemplate);
                    ArrayList<String> embedOptions = new ArrayList<String>();
                    JCTree.JCExpression afterReturn = RefasterTemplateProcessor.getReturnExpression(descriptor.afterTemplate.method);
                    if (afterReturn instanceof JCTree.JCParens || afterReturn instanceof JCTree.JCUnary && ((JCTree.JCUnary)afterReturn).getExpression() instanceof JCTree.JCParens) {
                        embedOptions.add("REMOVE_PARENS");
                    }
                    embedOptions.add("SHORTEN_NAMES");
                    if (RecipeWriter.simplifyBooleans(descriptor.afterTemplate.method)) {
                        embedOptions.add("SIMPLIFY_BOOLEANS");
                    }
                    if (!RefasterTemplateProcessor.getMethodTreeAnnotations(descriptor.afterTemplate.method, USE_IMPORT_POLICY::equals).isEmpty()) {
                        embedOptions.add("STATIC_IMPORT_ALWAYS");
                    }
                    if (descriptor.afterTemplate.method.body.stats.isEmpty()) {
                        visitMethod.append("                    return null;\n");
                    } else {
                        visitMethod.append("                    if (after == null) {\n").append("                        after = ").append(StringUtils.indentNewLine(descriptor.afterTemplate.toJavaTemplateBuilder(0), 24)).append(".build();\n").append("                    }\n").append("                    return embed(\n").append("                            after.apply(getCursor(), elem.getCoordinates().replace()");
                        Map<Name, Integer> afterParameters = RefasterTemplateProcessor.findParameterOrder(descriptor.afterTemplate.method, 0);
                        String parameters = RecipeWriter.matchParameters(beforeParameters, afterParameters);
                        if (!parameters.isEmpty()) {
                            visitMethod.append(", ").append(parameters);
                        }
                        visitMethod.append("),\n");
                        visitMethod.append("                            getCursor(),\n");
                        visitMethod.append("                            ctx,\n");
                        visitMethod.append("                            ").append(String.join((CharSequence)", ", embedOptions)).append("\n");
                        visitMethod.append("                    );\n");
                    }
                }
                visitMethod.append("                }\n");
            }
        }
        visitMethod.append("                return super.visit").append(methodSuffix).append("(elem, ctx);\n");
        visitMethod.append("            }\n");
        visitMethod.append("\n");
        return visitMethod.toString();
    }

    private static boolean simplifyBooleans(JCTree.JCMethodDecl template) {
        if (template.getReturnType().type.getTag() == TypeTag.BOOLEAN) {
            return true;
        }
        return new TreeScanner(){
            boolean found;

            boolean find(JCTree tree) {
                this.scan(tree);
                return this.found;
            }

            @Override
            public void visitBinary(JCTree.JCBinary jcBinary) {
                this.found |= jcBinary.type.getTag() == TypeTag.BOOLEAN;
                super.visitBinary(jcBinary);
            }

            @Override
            public void visitConditional(JCTree.JCConditional jcConditional) {
                this.found = true;
            }

            @Override
            public void visitUnary(JCTree.JCUnary jcUnary) {
                this.found |= jcUnary.type.getTag() == TypeTag.BOOLEAN;
                super.visitUnary(jcUnary);
            }
        }.find(template.getBody());
    }

    private String recipeDescriptor(JCTree.JCClassDecl classDecl, RuleDescriptor descriptor, String defaultDisplayName, String defaultDescription) {
        String displayName = defaultDisplayName;
        StringBuilder description = new StringBuilder(defaultDescription);
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        Tokens.Comment comment = this.cu.docComments.getComment(classDecl);
        if (comment != null && comment.getText() != null && !comment.getText().isEmpty()) {
            String firstLine;
            String commentText = comment.getText().replace("<p>", "").replace("<pre>{@code", "```java").replace("}</pre>", "```\n").replaceAll("(?s)\\{@\\S+\\s+(.*?)}", "`$1`").replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\t", "\\t").replace("\f", "\\f").replace("\r", "\\r");
            String[] lines = commentText.split("\\.\\R+", 2);
            if (lines.length == 1 || lines[1].trim().isEmpty()) {
                firstLine = lines[0].trim().replace("\n", "");
                description = firstLine.endsWith(".") ? new StringBuilder(firstLine) : new StringBuilder(firstLine).append('.');
            } else {
                firstLine = lines[0].trim().replace("\n", "");
                displayName = firstLine.endsWith(".") ? firstLine.substring(0, firstLine.length() - 1) : firstLine;
                description = new StringBuilder(lines[1].trim().replace("\n", "\\n"));
                if (!description.toString().endsWith(".")) {
                    if (description.toString().endsWith("```")) {
                        description.append("\\n");
                    }
                    description.append('.');
                }
            }
        }
        for (JCTree.JCAnnotation annotation : classDecl.getModifiers().getAnnotations()) {
            String annotationFqn = annotation.type.toString();
            if ("org.openrewrite.java.template.RecipeDescriptor".equals(annotationFqn)) {
                for (JCTree.JCExpression argExpr : annotation.getArguments()) {
                    JCTree.JCAssign arg = (JCTree.JCAssign)argExpr;
                    switch (arg.lhs.toString()) {
                        case "name": {
                            displayName = RecipeWriter.escapeJava(((JCTree.JCLiteral)arg.rhs).getValue().toString());
                            break;
                        }
                        case "description": {
                            description = new StringBuilder(RecipeWriter.escapeJava(((JCTree.JCLiteral)arg.rhs).getValue().toString()));
                            break;
                        }
                        case "tags": {
                            if (arg.rhs instanceof JCTree.JCLiteral) {
                                tags.add(RecipeWriter.escapeJava(((JCTree.JCLiteral)arg.rhs).getValue().toString()));
                                break;
                            }
                            if (!(arg.rhs instanceof JCTree.JCNewArray)) break;
                            for (JCTree.JCExpression e : ((JCTree.JCNewArray)arg.rhs).elems) {
                                tags.add(RecipeWriter.escapeJava(((JCTree.JCLiteral)e).getValue().toString()));
                            }
                            break;
                        }
                    }
                }
                break;
            }
            if ("tech.picnic.errorprone.refaster.annotation.OnlineDocumentation".equals(annotationFqn)) {
                if (!((List)annotation.getArguments()).isEmpty()) continue;
                description.append("\\n[Source](https://error-prone.picnic.tech/refasterrules/").append(classDecl.name.toString()).append(").");
                continue;
            }
            if (!"java.lang.SuppressWarnings".equals(annotationFqn)) continue;
            RecipeWriter.addRspecTags(annotation, tags);
        }
        if (descriptor != null) {
            for (TemplateDescriptor beforeTemplate : descriptor.beforeTemplates) {
                for (JCTree.JCAnnotation annotation : beforeTemplate.method.getModifiers().getAnnotations()) {
                    if (!"SuppressWarnings".equals(((JCTree.JCIdent)annotation.annotationType).getName().toString())) continue;
                    RecipeWriter.addRspecTags(annotation, tags);
                }
            }
        }
        String recipeDescriptor = "    @Override\n    public String getDisplayName() {\n        //language=markdown\n        return \"" + displayName + "\";\n    }\n\n    @Override\n    public String getDescription() {\n        //language=markdown\n        return \"" + description + "\";\n    }\n\n";
        if (tags.size() == 1) {
            recipeDescriptor = recipeDescriptor + "    @Override\n    public Set<String> getTags() {\n        return Collections.singleton(\"" + String.join((CharSequence)"\", \"", tags) + "\");\n    }\n\n";
        } else if (tags.size() > 1) {
            recipeDescriptor = recipeDescriptor + "    @Override\n    public Set<String> getTags() {\n        return new HashSet<>(Arrays.asList(\"" + String.join((CharSequence)"\", \"", tags) + "\"));\n    }\n\n";
        }
        return recipeDescriptor;
    }

    private static void addRspecTags(JCTree.JCAnnotation annotation, Set<String> tags) {
        for (JCTree.JCExpression argExpr : annotation.getArguments()) {
            if (!(argExpr instanceof JCTree.JCAssign)) continue;
            Consumer<JCTree.JCExpression> addTag = expr -> {
                String value;
                if (expr instanceof JCTree.JCLiteral && (value = ((JCTree.JCLiteral)expr).getValue().toString()).startsWith("java:")) {
                    tags.add("RSPEC-" + value.substring("java:".length()));
                }
            };
            JCTree.JCExpression rhs = ((JCTree.JCAssign)argExpr).rhs;
            if (rhs instanceof JCTree.JCNewArray) {
                ((JCTree.JCNewArray)rhs).elems.forEach(addTag);
                continue;
            }
            addTag.accept(rhs);
        }
    }

    private static void maybeRemoveImports(Map<TemplateDescriptor, Set<String>> importsByTemplate, StringBuilder recipe, TemplateDescriptor beforeTemplate, int pos, TemplateDescriptor afterTemplate) {
        Set beforeImports = beforeTemplate.usedTypes(pos).stream().map(sym -> sym.fullname.toString()).collect(Collectors.toCollection(LinkedHashSet::new));
        beforeImports.removeAll(RecipeWriter.getImportsAsStrings(importsByTemplate, afterTemplate));
        beforeImports.removeIf(i -> i.startsWith("java.lang.") || i.startsWith("com.google.errorprone.refaster."));
        beforeImports.forEach(anImport -> recipe.append("                    maybeRemoveImport(\"").append((String)anImport).append("\");\n"));
    }

    private static void maybeRemoveStaticImports(Map<TemplateDescriptor, Set<String>> importsByTemplate, StringBuilder recipe, TemplateDescriptor beforeTemplate, int pos, TemplateDescriptor afterTemplate) {
        Set beforeImports = beforeTemplate.usedMembers(pos).stream().map(symbol -> symbol.owner.getQualifiedName() + "." + symbol.name).collect(Collectors.toCollection(LinkedHashSet::new));
        beforeImports.removeAll(RecipeWriter.getImportsAsStrings(importsByTemplate, afterTemplate));
        beforeImports.removeIf(i -> i.startsWith("java.lang.") || i.startsWith("com.google.errorprone.refaster."));
        beforeImports.forEach(anImport -> recipe.append("                    maybeRemoveImport(\"").append((CharSequence)anImport, 0, anImport.lastIndexOf(46)).append("\");\n"));
        beforeImports.forEach(anImport -> recipe.append("                    maybeRemoveImport(\"").append((String)anImport).append("\");\n"));
    }

    private static Set<String> getImportsAsStrings(Map<TemplateDescriptor, Set<String>> importsByTemplate, TemplateDescriptor templateMethod) {
        return importsByTemplate.entrySet().stream().filter(e -> templateMethod == e.getKey()).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static @Nullable Precondition generatePreconditions(java.util.List<TemplateDescriptor> beforeTemplates) {
        HashSet preconditions = new HashSet();
        for (TemplateDescriptor beforeTemplate : beforeTemplates) {
            int arity = beforeTemplate.getArity();
            for (int i = 0; i < arity; ++i) {
                LinkedHashSet<Precondition.Rule> usesVisitors = new LinkedHashSet<Precondition.Rule>();
                for (Symbol.ClassSymbol usedType : beforeTemplate.usedTypes(i)) {
                    String name = usedType.getQualifiedName().toString().replace('$', '.');
                    if (name.startsWith("java.lang.") || name.startsWith("com.google.errorprone.refaster.")) continue;
                    usesVisitors.add(new Precondition.Rule("new UsesType<>(\"" + name + "\", true)"));
                }
                for (Symbol.MethodSymbol method : beforeTemplate.usedMethods(i)) {
                    if (method.owner.getQualifiedName().toString().startsWith("com.google.errorprone.refaster.")) continue;
                    String methodName = method.name.toString();
                    usesVisitors.add(new Precondition.Rule(String.format("new UsesMethod<>(\"%s %s(..)\", true)", method.owner.getQualifiedName().toString(), methodName)));
                }
                if (usesVisitors.isEmpty()) {
                    return null;
                }
                preconditions.add(usesVisitors);
            }
        }
        if (preconditions.isEmpty()) {
            return null;
        }
        return new Precondition.Or(preconditions.stream().map(Precondition.And::new).collect(Collectors.toSet())).prune();
    }
}

