/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.template.internal;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.lang.model.element.ElementKind;

public class ImportDetector {
    public static List<Symbol> imports(JCTree.JCMethodDecl methodDecl) {
        return ImportDetector.imports(methodDecl, t -> true);
    }

    public static List<Symbol> imports(JCTree.JCMethodDecl methodDecl, Predicate<JCTree> scopePredicate) {
        ImportScanner importScanner = new ImportScanner(scopePredicate);
        importScanner.scan(methodDecl.getBody());
        importScanner.scan(methodDecl.getReturnType());
        for (JCTree param : methodDecl.getParameters()) {
            importScanner.scan(param);
        }
        for (JCTree param : methodDecl.getTypeParameters()) {
            importScanner.scan(param);
        }
        return new ArrayList<Symbol>(importScanner.imports);
    }

    public static List<Symbol> imports(JCTree tree) {
        ImportScanner importScanner = new ImportScanner(t -> true);
        importScanner.scan(tree);
        return new ArrayList<Symbol>(importScanner.imports);
    }

    private static class ImportScanner
    extends TreeScanner {
        final Set<Symbol> imports = new LinkedHashSet<Symbol>();
        private final Predicate<JCTree> scopePredicate;

        public ImportScanner(Predicate<JCTree> scopePredicate) {
            this.scopePredicate = scopePredicate;
        }

        @Override
        public void scan(JCTree tree) {
            if (!this.scopePredicate.test(tree)) {
                return;
            }
            JCTree maybeFieldAccess = tree;
            if (maybeFieldAccess instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)maybeFieldAccess).sym instanceof Symbol.ClassSymbol && Character.isUpperCase(((JCTree.JCFieldAccess)maybeFieldAccess).getIdentifier().toString().charAt(0))) {
                while (maybeFieldAccess instanceof JCTree.JCFieldAccess) {
                    if (!((maybeFieldAccess = ((JCTree.JCFieldAccess)maybeFieldAccess).getExpression()) instanceof JCTree.JCIdent) || !Character.isUpperCase(((JCTree.JCIdent)maybeFieldAccess).getName().toString().charAt(0))) continue;
                    return;
                }
            }
            if (tree instanceof JCTree.JCAnnotation) {
                return;
            }
            if (tree instanceof JCTree.JCIdent) {
                if (tree.type == null || !(tree.type.tsym instanceof Symbol.ClassSymbol)) {
                    return;
                }
                if (((JCTree.JCIdent)tree).sym.getKind() == ElementKind.CLASS || ((JCTree.JCIdent)tree).sym.getKind() == ElementKind.INTERFACE) {
                    this.imports.add(tree.type.tsym);
                } else if (((JCTree.JCIdent)tree).sym.getKind() == ElementKind.FIELD) {
                    this.imports.add(((JCTree.JCIdent)tree).sym);
                } else if (((JCTree.JCIdent)tree).sym.getKind() == ElementKind.METHOD) {
                    this.imports.add(((JCTree.JCIdent)tree).sym);
                } else if (((JCTree.JCIdent)tree).sym.getKind() == ElementKind.ENUM_CONSTANT) {
                    this.imports.add(((JCTree.JCIdent)tree).sym);
                }
            } else if (tree instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)tree).sym instanceof Symbol.VarSymbol && ((JCTree.JCFieldAccess)tree).selected instanceof JCTree.JCIdent && ((JCTree.JCIdent)((JCTree.JCFieldAccess)tree).selected).sym instanceof Symbol.ClassSymbol) {
                this.imports.add(((JCTree.JCIdent)((JCTree.JCFieldAccess)tree).selected).sym);
            } else if (tree instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)tree).sym instanceof Symbol.MethodSymbol && ((JCTree.JCFieldAccess)tree).selected instanceof JCTree.JCIdent && ((JCTree.JCIdent)((JCTree.JCFieldAccess)tree).selected).sym instanceof Symbol.ClassSymbol) {
                this.imports.add(((JCTree.JCIdent)((JCTree.JCFieldAccess)tree).selected).sym);
            } else if (tree instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)tree).sym instanceof Symbol.ClassSymbol && ((JCTree.JCFieldAccess)tree).selected instanceof JCTree.JCIdent && ((JCTree.JCIdent)((JCTree.JCFieldAccess)tree).selected).sym instanceof Symbol.ClassSymbol && !(((JCTree.JCIdent)((JCTree.JCFieldAccess)tree).selected).sym.type instanceof Type.ErrorType)) {
                this.imports.add(((JCTree.JCIdent)((JCTree.JCFieldAccess)tree).selected).sym);
            } else if (tree instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)tree).sym instanceof Symbol.ClassSymbol && tree.toString().equals(((JCTree.JCFieldAccess)tree).sym.toString())) {
                this.imports.add(((JCTree.JCFieldAccess)tree).sym);
            }
            super.scan(tree);
        }
    }
}

