/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.template.processor;

import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.openrewrite.java.template.internal.ClasspathJarNameDetector;
import org.openrewrite.java.template.internal.ImportDetector;
import org.openrewrite.java.template.internal.JavacResolution;
import org.openrewrite.java.template.processor.TypeAwareProcessor;

@SupportedAnnotationTypes(value={"*"})
public class TemplateProcessor
extends TypeAwareProcessor {
    private static final String PRIMITIVE_ANNOTATION = "org.openrewrite.java.template.Primitive";
    private final String javaFileContent;

    public TemplateProcessor(String javaFileContent) {
        this.javaFileContent = javaFileContent;
    }

    public TemplateProcessor() {
        this(null);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getRootElements()) {
            JCTree.JCCompilationUnit jcCompilationUnit = this.toUnit(element);
            if (jcCompilationUnit == null) continue;
            this.maybeGenerateTemplateSources(jcCompilationUnit);
        }
        return true;
    }

    void maybeGenerateTemplateSources(final JCTree.JCCompilationUnit cu) {
        final Context context = this.javacProcessingEnv.getContext();
        final JavacResolution res = new JavacResolution(context);
        new TreeScanner(){

            @Override
            public void visitApply(JCTree.JCMethodInvocation tree) {
                String name;
                JCTree.JCExpression jcSelect = tree.getMethodSelect();
                String string = name = jcSelect instanceof JCTree.JCFieldAccess ? ((JCTree.JCFieldAccess)jcSelect).name.toString() : ((JCTree.JCIdent)jcSelect).getName().toString();
                if (("expression".equals(name) || "statement".equals(name)) && ((List)tree.getArguments()).size() == 3) {
                    JCTree.JCMethodInvocation resolvedMethod;
                    Map<JCTree, JCTree> resolved;
                    try {
                        resolved = res.resolveAll(context, cu, Collections.singletonList(tree));
                        resolvedMethod = (JCTree.JCMethodInvocation)resolved.get(tree);
                    }
                    catch (Throwable t) {
                        TemplateProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Had trouble type attributing the template.");
                        return;
                    }
                    JCTree.JCExpression arg2 = (JCTree.JCExpression)((List)tree.getArguments()).get(2);
                    if (TemplateProcessor.this.isOfClassType(resolvedMethod.type, "org.openrewrite.java.JavaTemplate.Builder") && (arg2 instanceof JCTree.JCLambda || arg2 instanceof JCTree.JCTypeCast && ((JCTree.JCTypeCast)arg2).getExpression() instanceof JCTree.JCLambda)) {
                        java.util.List<JCTree.JCVariableDecl> parameters;
                        NavigableMap parameterPositions;
                        JCTree.JCLambda template;
                        JCTree.JCLambda jCLambda = template = arg2 instanceof JCTree.JCLambda ? (JCTree.JCLambda)arg2 : (JCTree.JCLambda)((JCTree.JCTypeCast)arg2).getExpression();
                        if (template.getParameters().isEmpty()) {
                            parameterPositions = Collections.emptyNavigableMap();
                            parameters = Collections.emptyList();
                        } else {
                            parameterPositions = new TreeMap();
                            Map<JCTree, JCTree> parameterResolution = res.resolveAll(context, cu, template.getParameters());
                            parameters = new ArrayList<JCTree.JCVariableDecl>(template.getParameters().size());
                            for (VariableTree variableTree : template.getParameters()) {
                                parameters.add((JCTree.JCVariableDecl)parameterResolution.get((JCTree)((Object)variableTree)));
                            }
                            JCTree.JCLambda resolvedTemplate = (JCTree.JCLambda)parameterResolution.get(template);
                            new TreeScanner(){

                                @Override
                                public void visitIdent(JCTree.JCIdent ident) {
                                    for (JCTree.JCVariableDecl parameter : parameters) {
                                        if (parameter.sym != ident.sym) continue;
                                        parameterPositions.put(ident.getStartPosition(), parameter);
                                    }
                                }
                            }.scan(resolvedTemplate.getBody());
                        }
                        try {
                            InputStream inputStream = TemplateProcessor.this.javaFileContent == null ? cu.getSourceFile().openInputStream() : new ByteArrayInputStream(TemplateProcessor.this.javaFileContent.getBytes());
                            Object object = null;
                            try {
                                String templateFqn;
                                inputStream.skip(template.getBody().getStartPosition());
                                byte[] byArray = new byte[template.getBody().getEndPosition(cu.endPositions) - template.getBody().getStartPosition()];
                                inputStream.read(byArray);
                                String templateSource = new String(byArray);
                                templateSource = templateSource.replace("\\", "\\\\").replace("\"", "\\\"");
                                for (Map.Entry paramPos : parameterPositions.descendingMap().entrySet()) {
                                    JCTree.JCVariableDecl param = (JCTree.JCVariableDecl)paramPos.getValue();
                                    String typeDef = "";
                                    if (Objects.equals(parameterPositions.entrySet().stream().filter(p -> p.getValue() == param).map(Map.Entry::getKey).findFirst().orElse(null), paramPos.getKey())) {
                                        String type = param.type.toString();
                                        for (Object annotation : param.getModifiers().getAnnotations()) {
                                            if (!((JCTree.JCAnnotation)annotation).type.tsym.getQualifiedName().contentEquals(TemplateProcessor.PRIMITIVE_ANNOTATION)) continue;
                                            type = TemplateProcessor.this.getUnboxedPrimitive(param.type.toString());
                                            param.mods.annotations = List.filter(param.mods.annotations, annotation);
                                        }
                                        typeDef = ":any(" + type + ")";
                                    }
                                    templateSource = templateSource.substring(0, (Integer)paramPos.getKey() - template.getBody().getStartPosition()) + "#{" + param.getName().toString() + typeDef + "}" + templateSource.substring((Integer)paramPos.getKey() - template.getBody().getStartPosition() + param.name.length());
                                }
                                JCTree.JCLiteral templateName = (JCTree.JCLiteral)((List)tree.getArguments()).get(1);
                                if (templateName.value == null) {
                                    TemplateProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Can't compile a template with a null name.");
                                    return;
                                }
                                JCTree.JCClassDecl classDecl = TemplateProcessor.this.cursor(cu, template).stream().filter(JCTree.JCClassDecl.class::isInstance).map(JCTree.JCClassDecl.class::cast).reduce((next, acc) -> next).orElseThrow(() -> new IllegalStateException("Expected to find an enclosing class"));
                                if (TemplateProcessor.this.isOfClassType(classDecl.type, "org.openrewrite.java.JavaVisitor")) {
                                    templateFqn = classDecl.sym.fullname.toString() + "_" + templateName.getValue().toString();
                                } else {
                                    JCTree.JCNewClass visitorClass = TemplateProcessor.this.cursor(cu, template).stream().filter(JCTree.JCNewClass.class::isInstance).map(JCTree.JCNewClass.class::cast).reduce((next, acc) -> next).orElse(null);
                                    JCTree.JCNewClass resolvedVisitorClass = (JCTree.JCNewClass)resolved.get(visitorClass);
                                    if (resolvedVisitorClass != null && TemplateProcessor.this.isOfClassType(resolvedVisitorClass.clazz.type, "org.openrewrite.java.JavaVisitor")) {
                                        templateFqn = ((Symbol.ClassSymbol)resolvedVisitorClass.type.tsym).flatname.toString() + "_" + templateName.getValue().toString();
                                    } else {
                                        TemplateProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Can't compile a template outside of a visitor or recipe.");
                                        return;
                                    }
                                }
                                JavaFileObject builderFile = TemplateProcessor.this.processingEnv.getFiler().createSourceFile(templateFqn, new Element[0]);
                                BufferedWriter out = new BufferedWriter(builderFile.openWriter());
                                Object object2 = null;
                                try {
                                    out.write("package " + classDecl.sym.packge().toString() + ";\n");
                                    out.write("import org.openrewrite.java.*;\n");
                                    for (JCTree.JCVariableDecl parameter : parameters) {
                                        String paramType;
                                        if (!(parameter.type.tsym instanceof Symbol.ClassSymbol) || (paramType = parameter.type.tsym.getQualifiedName().toString()).startsWith("java.lang")) continue;
                                        out.write("import " + paramType + ";\n");
                                    }
                                    out.write("\n");
                                    out.write("class " + templateFqn.substring(templateFqn.lastIndexOf(46) + 1) + " {\n");
                                    out.write("    static JavaTemplate.Builder getTemplate() {\n");
                                    out.write("        return JavaTemplate\n");
                                    out.write("                .builder(\"" + templateSource + "\")");
                                    java.util.List<Symbol> imports = ImportDetector.imports(resolved.get(template));
                                    String classpath = ClasspathJarNameDetector.classpathFor(resolved.get(template), imports);
                                    if (!classpath.isEmpty()) {
                                        out.write("\n                .javaParser(JavaParser.fromJavaVersion().classpath(" + classpath + "))");
                                    }
                                    for (Symbol anImport : imports) {
                                        if (anImport instanceof Symbol.ClassSymbol && !anImport.getQualifiedName().toString().startsWith("java.lang.")) {
                                            out.write("\n                .imports(\"" + ((Symbol.ClassSymbol)anImport).fullname.toString().replace('$', '.') + "\")");
                                            continue;
                                        }
                                        if (!(anImport instanceof Symbol.VarSymbol) && !(anImport instanceof Symbol.MethodSymbol)) continue;
                                        out.write("\n                .staticImports(\"" + anImport.owner.getQualifiedName().toString().replace('$', '.') + '.' + anImport.flatName().toString() + "\")");
                                    }
                                    out.write(";\n");
                                    out.write("    }\n");
                                    out.write("}\n");
                                    ((Writer)out).flush();
                                }
                                catch (Throwable throwable) {
                                    object2 = throwable;
                                    throw throwable;
                                }
                                finally {
                                    if (out != null) {
                                        if (object2 != null) {
                                            try {
                                                ((Writer)out).close();
                                            }
                                            catch (Throwable throwable) {
                                                ((Throwable)object2).addSuppressed(throwable);
                                            }
                                        } else {
                                            ((Writer)out).close();
                                        }
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                object = throwable;
                                throw throwable;
                            }
                            finally {
                                if (inputStream != null) {
                                    if (object != null) {
                                        try {
                                            inputStream.close();
                                        }
                                        catch (Throwable paramPos) {
                                            ((Throwable)object).addSuppressed(paramPos);
                                        }
                                    } else {
                                        inputStream.close();
                                    }
                                }
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                super.visitApply(tree);
            }
        }.scan(cu);
    }

    private boolean isOfClassType(Type type, String fqn) {
        return type instanceof Type.ClassType && (((Symbol.ClassSymbol)type.tsym).fullname.contentEquals(fqn) || this.isOfClassType(((Type.ClassType)type).supertype_field, fqn));
    }

    private Stack<Tree> cursor(JCTree.JCCompilationUnit cu, final Tree t) {
        final AtomicReference matching = new AtomicReference();
        new TreePathScanner<Stack<Tree>, Stack<Tree>>(){

            @Override
            public Stack<Tree> scan(Tree tree, Stack<Tree> parent) {
                Stack<Tree> cursor = new Stack<Tree>();
                cursor.addAll(parent);
                cursor.push(tree);
                if (tree == t) {
                    matching.set(cursor);
                    return cursor;
                }
                return (Stack)super.scan(tree, cursor);
            }
        }.scan((Tree)cu, new Stack<Tree>());
        return (Stack)matching.get();
    }
}

