/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.template.processor;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.jspecify.annotations.Nullable;
import org.openrewrite.java.template.internal.ImportDetector;
import org.openrewrite.java.template.internal.JavacResolution;
import org.openrewrite.java.template.internal.StringUtils;
import org.openrewrite.java.template.internal.TemplateCode;
import org.openrewrite.java.template.internal.UsedMethodDetector;
import org.openrewrite.java.template.processor.Precondition;
import org.openrewrite.java.template.processor.TypeAwareProcessor;

@SupportedAnnotationTypes(value={"com.google.errorprone.refaster.annotation.BeforeTemplate", "com.google.errorprone.refaster.annotation.AfterTemplate"})
public class RefasterTemplateProcessor
extends TypeAwareProcessor {
    static final String BEFORE_TEMPLATE = "com.google.errorprone.refaster.annotation.BeforeTemplate";
    static final String AFTER_TEMPLATE = "com.google.errorprone.refaster.annotation.AfterTemplate";
    static Set<String> UNSUPPORTED_ANNOTATIONS = Stream.of("com.google.errorprone.refaster.annotation.AllowCodeBetweenLines", "com.google.errorprone.refaster.annotation.Matches", "com.google.errorprone.refaster.annotation.MayOptionallyUse", "com.google.errorprone.refaster.annotation.NoAutoboxing", "com.google.errorprone.refaster.annotation.NotMatches", "com.google.errorprone.refaster.annotation.OfKind", "com.google.errorprone.refaster.annotation.Placeholder", "com.google.errorprone.refaster.annotation.Repeated").collect(Collectors.toSet());
    static ClassValue<java.util.List<String>> LST_TYPE_MAP = new ClassValue<java.util.List<String>>(){

        @Override
        protected java.util.List<String> computeValue(Class<?> type) {
            if (JCTree.JCUnary.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.Unary");
            }
            if (JCTree.JCBinary.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.Binary");
            }
            if (JCTree.JCMethodInvocation.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.MethodInvocation");
            }
            if (JCTree.JCFieldAccess.class.isAssignableFrom(type)) {
                return Arrays.asList("J.FieldAccess", "J.Identifier");
            }
            if (JCTree.JCConditional.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.Ternary");
            }
            if (JCTree.JCNewClass.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.NewClass");
            }
            if (JCTree.JCLambda.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.Lambda");
            }
            if (JCTree.JCExpression.class.isAssignableFrom(type)) {
                return Collections.singletonList("Expression");
            }
            if (JCTree.JCStatement.class.isAssignableFrom(type)) {
                return Collections.singletonList("Statement");
            }
            throw new IllegalArgumentException(type.toString());
        }
    };
    private static final String GENERATOR_NAME = RefasterTemplateProcessor.class.getName();
    private final Map<String, Integer> printedMessages = new TreeMap<String, Integer>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getRootElements()) {
            JCTree.JCCompilationUnit jcCompilationUnit = this.toUnit(element);
            if (jcCompilationUnit == null) continue;
            Context context = this.javacProcessingEnv.getContext();
            new RecipeWriter(context, jcCompilationUnit).scan(jcCompilationUnit);
        }
        return false;
    }

    private String escape(String string) {
        return string.replace("\\", "\\\\").replace("\"", "\\\"").replaceAll("\\R", "\\\\n");
    }

    private Map<Name, Integer> findParameterOrder(JCTree.JCMethodDecl method, final int arity) {
        final AtomicInteger parameterOccurrence = new AtomicInteger();
        final HashMap<Name, Integer> parameterOrder = new HashMap<Name, Integer>();
        new TreeScanner(){

            @Override
            public void scan(JCTree jcTree) {
                JCTree.JCMethodInvocation jcMethodInvocation;
                if (jcTree instanceof JCTree.JCIdent) {
                    JCTree.JCIdent jcIdent = (JCTree.JCIdent)jcTree;
                    if (jcIdent.sym instanceof Symbol.VarSymbol && jcIdent.sym.owner instanceof Symbol.MethodSymbol && ((Symbol.MethodSymbol)jcIdent.sym.owner).params.contains(jcIdent.sym) && !parameterOrder.containsKey(jcIdent.sym.name)) {
                        parameterOrder.put(jcIdent.sym.name, parameterOccurrence.getAndIncrement());
                    }
                } else if (jcTree instanceof JCTree.JCMethodInvocation && RefasterTemplateProcessor.this.isAnyOfCall(jcMethodInvocation = (JCTree.JCMethodInvocation)jcTree)) {
                    super.scan((JCTree)((List)jcMethodInvocation.getArguments()).get(arity));
                    return;
                }
                super.scan(jcTree);
            }
        }.scan(method);
        return parameterOrder;
    }

    private String matchParameters(Map<Name, Integer> beforeParameters, Map<Name, Integer> afterParameters) {
        return afterParameters.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(e -> (Integer)beforeParameters.get(e.getKey())).map(e -> "matcher.parameter(" + e + ")").collect(Collectors.joining(", "));
    }

    private @Nullable JCTree.JCExpression getReturnExpression(JCTree.JCMethodDecl method) {
        JCTree.JCStatement statement = (JCTree.JCStatement)((List)method.getBody().getStatements()).last();
        if (statement instanceof JCTree.JCReturn) {
            return ((JCTree.JCReturn)statement).expr;
        }
        if (statement instanceof JCTree.JCExpressionStatement) {
            return ((JCTree.JCExpressionStatement)statement).expr;
        }
        return null;
    }

    private @Nullable RuleDescriptor getRuleDescriptor(JCTree.JCClassDecl tree, Context context, JCTree.JCCompilationUnit cu) {
        RuleDescriptor result = new RuleDescriptor(tree, cu, context);
        for (JCTree member : tree.getMembers()) {
            if (!(member instanceof JCTree.JCMethodDecl)) continue;
            JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)member;
            java.util.List<JCTree.JCAnnotation> annotations = RefasterTemplateProcessor.getTemplateAnnotations(method, BEFORE_TEMPLATE::equals);
            if (!annotations.isEmpty()) {
                result.beforeTemplate(method);
            }
            if ((annotations = RefasterTemplateProcessor.getTemplateAnnotations(method, AFTER_TEMPLATE::equals)).isEmpty()) continue;
            result.afterTemplate(method);
        }
        return result.validate();
    }

    private boolean isAnyOfCall(JCTree.JCMethodInvocation call) {
        JCTree.JCExpression meth = call.meth;
        if (meth instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)meth;
            return fieldAccess.name.toString().equals("anyOf") && ((JCTree.JCIdent)fieldAccess.selected).name.toString().equals("Refaster");
        }
        return false;
    }

    private void printNoteOnce(String message, Symbol.ClassSymbol symbol) {
        if (this.printedMessages.compute(message, (k, v) -> v == null ? 1 : v + 1) == 1) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message, symbol);
        }
    }

    private static java.util.List<JCTree.JCAnnotation> getTemplateAnnotations(MethodTree method, Predicate<String> typePredicate) {
        ArrayList<JCTree.JCAnnotation> result = new ArrayList<JCTree.JCAnnotation>();
        for (AnnotationTree annotationTree : method.getModifiers().getAnnotations()) {
            Tree type = annotationTree.getAnnotationType();
            if (type.getKind() == Tree.Kind.IDENTIFIER && ((JCTree.JCIdent)type).sym != null && typePredicate.test(((JCTree.JCIdent)type).sym.getQualifiedName().toString())) {
                result.add((JCTree.JCAnnotation)annotationTree);
                continue;
            }
            if (type.getKind() == Tree.Kind.IDENTIFIER && ((JCTree.JCAnnotation)annotationTree).attribute != null && ((JCTree.JCAnnotation)annotationTree).attribute.type instanceof Type.ClassType && ((JCTree.JCAnnotation)annotationTree).attribute.type.tsym != null && typePredicate.test(((JCTree.JCAnnotation)annotationTree).attribute.type.tsym.getQualifiedName().toString())) {
                result.add((JCTree.JCAnnotation)annotationTree);
                continue;
            }
            if (type.getKind() != Tree.Kind.MEMBER_SELECT || !(type instanceof JCTree.JCFieldAccess) || ((JCTree.JCFieldAccess)type).sym == null || !typePredicate.test(((JCTree.JCFieldAccess)type).sym.getQualifiedName().toString())) continue;
            result.add((JCTree.JCAnnotation)annotationTree);
        }
        return result;
    }

    private static java.util.List<JCTree.JCAnnotation> getTemplateAnnotations(VariableTree parameter, Predicate<String> typePredicate) {
        ArrayList<JCTree.JCAnnotation> result = new ArrayList<JCTree.JCAnnotation>();
        for (AnnotationTree annotationTree : parameter.getModifiers().getAnnotations()) {
            Tree type = annotationTree.getAnnotationType();
            if (type.getKind() == Tree.Kind.IDENTIFIER && ((JCTree.JCIdent)type).sym != null && typePredicate.test(((JCTree.JCIdent)type).sym.getQualifiedName().toString())) {
                result.add((JCTree.JCAnnotation)annotationTree);
                continue;
            }
            if (type.getKind() != Tree.Kind.MEMBER_SELECT || !(type instanceof JCTree.JCFieldAccess) || ((JCTree.JCFieldAccess)type).sym == null || !typePredicate.test(((JCTree.JCFieldAccess)type).sym.getQualifiedName().toString())) continue;
            result.add((JCTree.JCAnnotation)annotationTree);
        }
        return result;
    }

    private static String escapeJava(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\n", "\\n").replace("\t", "\\t").replace("\f", "\\f").replace("\r", "\\r");
    }

    class TemplateDescriptor {
        JCTree.JCMethodDecl method;
        private final JCTree.JCClassDecl classDecl;
        private final JCTree.JCCompilationUnit cu;
        private final Context context;

        public TemplateDescriptor(JCTree.JCMethodDecl method, JCTree.JCClassDecl classDecl, JCTree.JCCompilationUnit cu, Context context) {
            this.classDecl = classDecl;
            this.method = method;
            this.cu = cu;
            this.context = context;
        }

        public int getArity() {
            final AtomicReference anyOfCall = new AtomicReference();
            new TreeScanner(){

                @Override
                public void visitApply(JCTree.JCMethodInvocation jcMethodInvocation) {
                    if (RefasterTemplateProcessor.this.isAnyOfCall(jcMethodInvocation)) {
                        anyOfCall.set(jcMethodInvocation);
                        return;
                    }
                    super.visitApply(jcMethodInvocation);
                }
            }.scan(this.method);
            return Optional.ofNullable(anyOfCall.get()).map(call -> call.args.size()).orElse(1);
        }

        public Collection<String> getTypes() {
            if (this.getArity() == 1) {
                JCTree.JCExpression returnExpression = RefasterTemplateProcessor.this.getReturnExpression(this.method);
                Class<?> clazz = returnExpression != null ? returnExpression.getClass() : ((JCTree.JCStatement)((List)this.method.getBody().getStatements()).last()).getClass();
                return LST_TYPE_MAP.get(clazz);
            }
            final HashSet<String> types = new HashSet<String>();
            new TreeScanner(){

                @Override
                public void visitApply(JCTree.JCMethodInvocation jcMethodInvocation) {
                    if (RefasterTemplateProcessor.this.isAnyOfCall(jcMethodInvocation)) {
                        for (JCTree.JCExpression argument : jcMethodInvocation.getArguments()) {
                            types.addAll((Collection)LST_TYPE_MAP.get(argument.getClass()));
                        }
                        return;
                    }
                    super.visitApply(jcMethodInvocation);
                }
            }.scan(this.method);
            return types;
        }

        private String toJavaTemplateBuilder(int pos) {
            JCTree tree = (JCTree)((List)this.method.getBody().getStatements()).get(0);
            if (tree instanceof JCTree.JCReturn) {
                tree = ((JCTree.JCReturn)tree).getExpression();
            }
            java.util.List<JCTree.JCTypeParameter> typeParameters = this.classDecl.typarams == null ? Collections.emptyList() : this.classDecl.typarams;
            String javaTemplateBuilder = TemplateCode.process(tree, this.method.getParameters(), typeParameters, pos, this.method.restype.type instanceof Type.JCVoidType, true);
            return TemplateCode.indent(javaTemplateBuilder, 16);
        }

        boolean validate() {
            if (this.method.typarams != null && !this.method.typarams.isEmpty()) {
                RefasterTemplateProcessor.this.printNoteOnce("Generic type parameters are only allowed at class level", this.classDecl.sym);
                return false;
            }
            Iterator<Object> iterator = RefasterTemplateProcessor.getTemplateAnnotations(this.method, (Predicate<String>)UNSUPPORTED_ANNOTATIONS::contains).iterator();
            if (iterator.hasNext()) {
                JCTree.JCAnnotation annotation = (JCTree.JCAnnotation)iterator.next();
                RefasterTemplateProcessor.this.printNoteOnce("@" + annotation.annotationType + " is currently not supported", this.classDecl.sym);
                return false;
            }
            for (JCTree.JCVariableDecl parameter : this.method.getParameters()) {
                Iterator iterator2 = RefasterTemplateProcessor.getTemplateAnnotations(parameter, (Predicate<String>)UNSUPPORTED_ANNOTATIONS::contains).iterator();
                if (!iterator2.hasNext()) continue;
                JCTree.JCAnnotation annotation = (JCTree.JCAnnotation)iterator2.next();
                RefasterTemplateProcessor.this.printNoteOnce("@" + annotation.annotationType + " is currently not supported", this.classDecl.sym);
                return false;
            }
            if (this.method.body.stats.get(0) instanceof JCTree.JCIf) {
                RefasterTemplateProcessor.this.printNoteOnce("If statements are currently not supported", this.classDecl.sym);
                return false;
            }
            if (this.method.body.stats.get(0) instanceof JCTree.JCReturn) {
                JCTree.JCExpression expr = ((JCTree.JCReturn)this.method.body.stats.get((int)0)).expr;
                if (expr instanceof JCTree.JCLambda) {
                    RefasterTemplateProcessor.this.printNoteOnce("Lambdas are currently not supported", this.classDecl.sym);
                    return false;
                }
                if (expr instanceof JCTree.JCMemberReference) {
                    RefasterTemplateProcessor.this.printNoteOnce("Method references are currently not supported", this.classDecl.sym);
                    return false;
                }
            }
            return new TreeScanner(){
                boolean valid = true;
                int anyOfCount = 0;

                boolean validate(JCTree tree) {
                    this.scan(tree);
                    return this.valid;
                }

                @Override
                public void visitSelect(JCTree.JCFieldAccess jcFieldAccess) {
                    if (jcFieldAccess.selected.type.tsym.toString().equals("com.google.errorprone.refaster.Refaster") && jcFieldAccess.name.toString().equals("anyOf")) {
                        if (++this.anyOfCount > 1) {
                            RefasterTemplateProcessor.this.printNoteOnce("Refaster.anyOf() can only be used once per template", ((TemplateDescriptor)TemplateDescriptor.this).classDecl.sym);
                            this.valid = false;
                        }
                        return;
                    }
                    super.visitSelect(jcFieldAccess);
                }

                @Override
                public void visitIdent(JCTree.JCIdent jcIdent) {
                    if (this.valid && jcIdent.sym != null && jcIdent.sym.packge().getQualifiedName().contentEquals("com.google.errorprone.refaster")) {
                        RefasterTemplateProcessor.this.printNoteOnce(jcIdent.type.tsym.getQualifiedName() + " is currently not supported", ((TemplateDescriptor)TemplateDescriptor.this).classDecl.sym);
                        this.valid = false;
                    }
                }
            }.validate(this.method.getBody());
        }

        private boolean resolve() {
            this.method = this.resolve(this.method);
            return this.method != null;
        }

        private @Nullable JCTree.JCMethodDecl resolve(JCTree.JCMethodDecl method) {
            JavacResolution res = new JavacResolution(this.context);
            try {
                this.classDecl.defs = this.classDecl.defs.prepend(method);
                JCTree.JCMethodDecl resolvedMethod = (JCTree.JCMethodDecl)Objects.requireNonNull(res.resolveAll(this.context, this.cu, Collections.singletonList(method))).get(method);
                this.classDecl.defs = this.classDecl.defs.tail;
                resolvedMethod.params = method.params;
                method = resolvedMethod;
                return method;
            }
            catch (Throwable t) {
                RefasterTemplateProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Had trouble type attributing the template method: " + method.name);
                return null;
            }
        }

        public java.util.List<Symbol.ClassSymbol> usedTypes(final int i) {
            java.util.List<Symbol> imports;
            if (this.getArity() == 1) {
                imports = ImportDetector.imports(this.method);
            } else {
                final HashSet skip = new HashSet();
                new TreeScanner(){

                    @Override
                    public void visitApply(JCTree.JCMethodInvocation jcMethodInvocation) {
                        if (RefasterTemplateProcessor.this.isAnyOfCall(jcMethodInvocation)) {
                            for (int j = 0; j < jcMethodInvocation.args.size(); ++j) {
                                if (j == i) continue;
                                skip.add(jcMethodInvocation.args.get(j));
                            }
                            return;
                        }
                        super.visitApply(jcMethodInvocation);
                    }
                }.scan(this.method);
                imports = ImportDetector.imports(this.method, t -> !skip.contains(t));
            }
            return imports.stream().filter(Symbol.ClassSymbol.class::isInstance).map(Symbol.ClassSymbol.class::cast).collect(Collectors.toList());
        }

        public java.util.List<Symbol> usedMembers(final int i) {
            java.util.List<Symbol> imports;
            if (this.getArity() == 1) {
                imports = ImportDetector.imports(this.method);
            } else {
                final HashSet skip = new HashSet();
                new TreeScanner(){

                    @Override
                    public void visitApply(JCTree.JCMethodInvocation jcMethodInvocation) {
                        if (RefasterTemplateProcessor.this.isAnyOfCall(jcMethodInvocation)) {
                            for (int j = 0; j < jcMethodInvocation.args.size(); ++j) {
                                if (j == i) continue;
                                skip.add(jcMethodInvocation.args.get(j));
                            }
                            return;
                        }
                        super.visitApply(jcMethodInvocation);
                    }
                }.scan(this.method);
                imports = ImportDetector.imports(this.method, t -> !skip.contains(t));
            }
            return imports.stream().filter(sym -> sym instanceof Symbol.VarSymbol || sym instanceof Symbol.MethodSymbol).collect(Collectors.toList());
        }

        public java.util.List<Symbol.MethodSymbol> usedMethods(final int i) {
            if (this.getArity() == 1) {
                return UsedMethodDetector.usedMethods(this.method);
            }
            final HashSet skip = new HashSet();
            new TreeScanner(){

                @Override
                public void visitApply(JCTree.JCMethodInvocation jcMethodInvocation) {
                    if (RefasterTemplateProcessor.this.isAnyOfCall(jcMethodInvocation)) {
                        for (int j = 0; j < jcMethodInvocation.args.size(); ++j) {
                            if (j == i) continue;
                            skip.add(jcMethodInvocation.args.get(j));
                        }
                        return;
                    }
                    super.visitApply(jcMethodInvocation);
                }
            }.scan(this.method);
            return UsedMethodDetector.usedMethods(this.method, t -> !skip.contains(t));
        }
    }

    class RuleDescriptor {
        final JCTree.JCClassDecl classDecl;
        private final JCTree.JCCompilationUnit cu;
        private final Context context;
        final java.util.List<TemplateDescriptor> beforeTemplates = new ArrayList<TemplateDescriptor>();
        @Nullable TemplateDescriptor afterTemplate;

        public RuleDescriptor(JCTree.JCClassDecl classDecl, JCTree.JCCompilationUnit cu, Context context) {
            this.classDecl = classDecl;
            this.cu = cu;
            this.context = context;
        }

        private @Nullable RuleDescriptor validate() {
            if (this.beforeTemplates.isEmpty()) {
                return null;
            }
            for (Object member : this.classDecl.getMembers()) {
                Iterator<TemplateDescriptor> iterator;
                if (!(member instanceof JCTree.JCMethodDecl) || !this.beforeTemplates.stream().noneMatch(arg_0 -> RuleDescriptor.lambda$validate$0((JCTree)member, arg_0))) continue;
                if (this.afterTemplate != null) {
                    if (member == this.afterTemplate.method) continue;
                }
                if (!(iterator = RefasterTemplateProcessor.getTemplateAnnotations((JCTree.JCMethodDecl)member, (Predicate<String>)UNSUPPORTED_ANNOTATIONS::contains).iterator()).hasNext()) continue;
                JCTree.JCAnnotation annotation = (JCTree.JCAnnotation)((Object)iterator.next());
                RefasterTemplateProcessor.this.printNoteOnce("@" + annotation.annotationType + " is currently not supported", this.classDecl.sym);
                return null;
            }
            boolean valid = this.resolve();
            if (valid) {
                for (TemplateDescriptor template : this.beforeTemplates) {
                    valid &= template.validate();
                }
                if (this.afterTemplate != null) {
                    valid &= this.afterTemplate.validate();
                }
            }
            if (valid && this.afterTemplate != null) {
                Set requiredParameters = RefasterTemplateProcessor.this.findParameterOrder(this.afterTemplate.method, 0).keySet();
                for (TemplateDescriptor beforeTemplate : this.beforeTemplates) {
                    for (int i = 0; i < beforeTemplate.getArity(); ++i) {
                        Set providedParameters = RefasterTemplateProcessor.this.findParameterOrder(beforeTemplate.method, i).keySet();
                        if (providedParameters.containsAll(requiredParameters)) continue;
                        RefasterTemplateProcessor.this.printNoteOnce("@AfterTemplate defines arguments that are not present in all @BeforeTemplate methods", this.classDecl.sym);
                        return null;
                    }
                }
            }
            return valid ? this : null;
        }

        public void beforeTemplate(JCTree.JCMethodDecl method) {
            this.beforeTemplates.add(new TemplateDescriptor(method, this.classDecl, this.cu, this.context));
        }

        public void afterTemplate(JCTree.JCMethodDecl method) {
            this.afterTemplate = new TemplateDescriptor(method, this.classDecl, this.cu, this.context);
        }

        private boolean resolve() {
            boolean valid = true;
            try {
                for (TemplateDescriptor beforeTemplate : this.beforeTemplates) {
                    valid &= beforeTemplate.resolve();
                }
                if (this.afterTemplate != null) {
                    valid &= this.afterTemplate.resolve();
                }
            }
            catch (Throwable t) {
                RefasterTemplateProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Had trouble type attributing the template.");
                valid = false;
            }
            return valid;
        }

        private static /* synthetic */ boolean lambda$validate$0(JCTree member, TemplateDescriptor t) {
            return t.method == member;
        }
    }

    private class RecipeWriter
    extends TreeScanner {
        private final Context context;
        private final JCTree.JCCompilationUnit cu;
        boolean anySearchRecipe;
        final Map<TemplateDescriptor, Set<String>> imports;
        final Map<TemplateDescriptor, Set<String>> staticImports;
        final Map<String, String> recipes;

        public RecipeWriter(Context context, JCTree.JCCompilationUnit cu) {
            this.context = context;
            this.cu = cu;
            this.imports = new HashMap<TemplateDescriptor, Set<String>>();
            this.staticImports = new HashMap<TemplateDescriptor, Set<String>>();
            this.recipes = new LinkedHashMap<String, String>();
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl classDecl) {
            super.visitClassDef(classDecl);
            RuleDescriptor descriptor = RefasterTemplateProcessor.this.getRuleDescriptor(classDecl, this.context, this.cu);
            if (descriptor != null) {
                this.anySearchRecipe |= descriptor.afterTemplate == null;
                TreeMaker treeMaker = TreeMaker.instance(this.context).forToplevel(this.cu);
                java.util.List membersWithoutConstructor = classDecl.getMembers().stream().filter(m -> !(m instanceof JCTree.JCMethodDecl) || !((JCTree.JCMethodDecl)m).name.contentEquals("<init>")).collect(Collectors.toList());
                JCTree.JCClassDecl copy = treeMaker.ClassDef(classDecl.mods, classDecl.name, classDecl.typarams, classDecl.extending, classDecl.implementing, List.from(membersWithoutConstructor));
                String templateFqn = classDecl.sym.fullname.toString() + "Recipe";
                String templateCode = copy.toString().trim();
                for (TemplateDescriptor templateDescriptor : descriptor.beforeTemplates) {
                    for (Symbol anImport : ImportDetector.imports(templateDescriptor.method)) {
                        if (anImport instanceof Symbol.ClassSymbol) {
                            this.imports.computeIfAbsent(templateDescriptor, k -> new TreeSet()).add(anImport.getQualifiedName().toString().replace('$', '.'));
                            continue;
                        }
                        if (anImport instanceof Symbol.VarSymbol || anImport instanceof Symbol.MethodSymbol) {
                            this.staticImports.computeIfAbsent(templateDescriptor, k -> new TreeSet()).add(anImport.owner.getQualifiedName().toString().replace('$', '.') + '.' + anImport.flatName().toString());
                            continue;
                        }
                        throw new AssertionError(anImport.getClass());
                    }
                }
                if (descriptor.afterTemplate != null) {
                    for (Symbol symbol : ImportDetector.imports(descriptor.afterTemplate.method)) {
                        if (symbol instanceof Symbol.ClassSymbol) {
                            this.imports.computeIfAbsent(descriptor.afterTemplate, k -> new TreeSet()).add(symbol.getQualifiedName().toString().replace('$', '.'));
                            continue;
                        }
                        if (symbol instanceof Symbol.VarSymbol || symbol instanceof Symbol.MethodSymbol) {
                            this.staticImports.computeIfAbsent(descriptor.afterTemplate, k -> new TreeSet()).add(symbol.owner.getQualifiedName().toString().replace('$', '.') + '.' + symbol.flatName().toString());
                            continue;
                        }
                        throw new AssertionError(symbol.getClass());
                    }
                }
                for (Set set : this.imports.values()) {
                    set.removeIf(i -> {
                        int endIndex = i.lastIndexOf(46);
                        return endIndex < 0 || "java.lang".equals(i.substring(0, endIndex)) || "com.google.errorprone.refaster".equals(i.substring(0, endIndex));
                    });
                }
                for (Set set : this.staticImports.values()) {
                    set.removeIf(i -> i.startsWith("java.lang.") || i.startsWith("com.google.errorprone.refaster."));
                }
                LinkedHashMap<String, TemplateDescriptor> beforeTemplates = new LinkedHashMap<String, TemplateDescriptor>();
                for (TemplateDescriptor templ : descriptor.beforeTemplates) {
                    String name = templ.method.name.toString();
                    if (beforeTemplates.containsKey(name)) {
                        String base = name;
                        int i2 = 0;
                        while (beforeTemplates.containsKey(name = base + i2)) {
                            ++i2;
                        }
                    }
                    beforeTemplates.put(name, templ);
                }
                String string = descriptor.afterTemplate == null ? null : descriptor.afterTemplate.method.name.toString();
                StringBuilder recipe = new StringBuilder();
                Symbol.PackageSymbol pkg = classDecl.sym.packge();
                String typeName = classDecl.sym.fullname.toString();
                String refasterRuleClassName = pkg.isUnnamed() ? typeName : typeName.substring(pkg.fullname.length() + 1);
                recipe.append("/**\n * OpenRewrite recipe created for Refaster template {@code ").append(refasterRuleClassName).append("}.\n */\n");
                String recipeName = templateFqn.substring(templateFqn.lastIndexOf(46) + 1);
                recipe.append("@SuppressWarnings(\"all\")\n");
                recipe.append("@NullMarked\n");
                recipe.append("@Generated(\"").append(GENERATOR_NAME).append("\")\n");
                recipe.append(descriptor.classDecl.sym.outermostClass() == descriptor.classDecl.sym ? "public class " : "public static class ").append(recipeName).append(" extends Recipe {\n\n");
                recipe.append("    /**\n");
                recipe.append("     * Instantiates a new instance.\n");
                recipe.append("     */\n");
                recipe.append("    public ").append(recipeName).append("() {}\n\n");
                recipe.append(this.recipeDescriptor(classDecl, descriptor, "Refaster template `" + refasterRuleClassName + '`', "Recipe created for the following Refaster template:\\n```java\\n" + RefasterTemplateProcessor.this.escape(templateCode) + "\\n```\\n."));
                recipe.append("    @Override\n");
                recipe.append("    public TreeVisitor<?, ExecutionContext> getVisitor() {\n");
                String javaVisitor = this.newAbstractRefasterJavaVisitor(beforeTemplates, string, descriptor);
                Precondition preconditions = this.generatePreconditions(descriptor.beforeTemplates, 16);
                if (preconditions == null) {
                    recipe.append(String.format("        return %s;\n", javaVisitor));
                } else {
                    recipe.append(String.format("        JavaVisitor<ExecutionContext> javaVisitor = %s;\n", javaVisitor));
                    recipe.append("        return Preconditions.check(\n");
                    recipe.append(StringUtils.indent(preconditions.toString(), 16)).append(",\n");
                    recipe.append("                javaVisitor\n");
                    recipe.append("        );\n");
                }
                recipe.append("    }\n");
                recipe.append("}\n");
                this.recipes.put(recipeName, recipe.toString());
            }
            if (classDecl.sym != null && classDecl.sym.getNestingKind() == NestingKind.TOP_LEVEL && !this.recipes.isEmpty()) {
                boolean outerClassRequired = descriptor == null;
                this.writeRecipeClass(classDecl, outerClassRequired, descriptor);
            }
        }

        private void writeRecipeClass(JCTree.JCClassDecl classDecl, boolean outerClassRequired, RuleDescriptor descriptor) {
            try {
                Symbol.PackageSymbol pkg = classDecl.sym.packge();
                String inputOuterFQN = outerClassRequired ? classDecl.sym.fullname.toString() : descriptor.classDecl.sym.fullname.toString();
                String className = inputOuterFQN + (outerClassRequired ? "Recipes" : "Recipe");
                JavaFileObject builderFile = RefasterTemplateProcessor.this.processingEnv.getFiler().createSourceFile(className, new Element[0]);
                String generatedAnnotation = RefasterTemplateProcessor.this.processingEnv.getOptions().get("rewrite.generatedAnnotation");
                if (generatedAnnotation == null) {
                    generatedAnnotation = "javax.annotation.Generated";
                }
                try (BufferedWriter out = new BufferedWriter(builderFile.openWriter());){
                    if (!pkg.isUnnamed()) {
                        out.write("package " + pkg.fullname + ";\n");
                        out.write("\n");
                    }
                    out.write("import org.jspecify.annotations.NullMarked;\n");
                    out.write("import org.openrewrite.ExecutionContext;\n");
                    out.write("import org.openrewrite.Preconditions;\n");
                    out.write("import org.openrewrite.Recipe;\n");
                    out.write("import org.openrewrite.TreeVisitor;\n");
                    out.write("import org.openrewrite.java.JavaParser;\n");
                    out.write("import org.openrewrite.java.JavaTemplate;\n");
                    out.write("import org.openrewrite.java.JavaVisitor;\n");
                    out.write("import org.openrewrite.java.search.*;\n");
                    out.write("import org.openrewrite.java.template.Primitive;\n");
                    out.write("import org.openrewrite.java.template.function.*;\n");
                    out.write("import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;\n");
                    out.write("import org.openrewrite.java.tree.*;\n");
                    if (this.anySearchRecipe) {
                        out.write("import org.openrewrite.marker.SearchResult;\n");
                    }
                    out.write("\n");
                    out.write("import " + generatedAnnotation + ";\n");
                    out.write("import java.util.*;\n");
                    out.write("\n");
                    out.write("import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;\n");
                    out.write("\n");
                    if (outerClassRequired) {
                        out.write("/**\n * OpenRewrite recipes created for Refaster template {@code " + inputOuterFQN + "}.\n */\n");
                        String outerClassName = className.substring(className.lastIndexOf(46) + 1);
                        out.write("@SuppressWarnings(\"all\")\n");
                        out.write("@Generated(\"" + GENERATOR_NAME + "\")\n");
                        out.write("public class " + outerClassName + " extends Recipe {\n");
                        out.write("    /**\n");
                        out.write("     * Instantiates a new instance.\n");
                        out.write("     */\n");
                        out.write("    public " + outerClassName + "() {}\n\n");
                        out.write(this.recipeDescriptor(classDecl, descriptor, String.format("`%s` Refaster recipes", inputOuterFQN.substring(inputOuterFQN.lastIndexOf(46) + 1)), String.format("Refaster template recipes for `%s`.", inputOuterFQN)));
                        String recipesAsList = this.recipes.keySet().stream().map(r -> "                new " + r.substring(r.lastIndexOf(46) + 1) + "()").collect(Collectors.joining(",\n"));
                        out.write("    @Override\n    public List<Recipe> getRecipeList() {\n        return Arrays.asList(\n" + recipesAsList + '\n' + "        );\n    }\n\n");
                        for (String r2 : this.recipes.values()) {
                            out.write(r2.replaceAll("(?m)^(.+)$", "    $1"));
                            ((Writer)out).write(10);
                        }
                        out.write("}\n");
                    } else {
                        for (String r3 : this.recipes.values()) {
                            out.write(r3);
                            ((Writer)out).write(10);
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private String newAbstractRefasterJavaVisitor(Map<String, TemplateDescriptor> beforeTemplates, String after, RuleDescriptor descriptor) {
            StringBuilder visitor = new StringBuilder();
            visitor.append("new AbstractRefasterJavaVisitor() {\n");
            for (Map.Entry<String, TemplateDescriptor> entry : beforeTemplates.entrySet()) {
                int arity = entry.getValue().getArity();
                for (int i = 0; i < arity; ++i) {
                    visitor.append("            final JavaTemplate ").append(entry.getKey()).append(arity > 1 ? "$" + i : "").append(" = ").append(entry.getValue().toJavaTemplateBuilder(i)).append("\n                    .build();\n");
                }
            }
            if (after != null) {
                visitor.append("            final JavaTemplate ").append(after).append(" = ").append(descriptor.afterTemplate.toJavaTemplateBuilder(0)).append("\n                    .build();\n");
            }
            visitor.append("\n");
            TreeMap<String, Map> templatesByLstType = new TreeMap<String, Map>();
            for (Map.Entry<String, TemplateDescriptor> entry : beforeTemplates.entrySet()) {
                for (String lstType2 : entry.getValue().getTypes()) {
                    templatesByLstType.computeIfAbsent(lstType2, k -> new TreeMap()).put(entry.getKey(), entry.getValue());
                }
            }
            templatesByLstType.forEach((lstType, typeBeforeTemplates) -> visitor.append(this.generateVisitMethod((Map<String, TemplateDescriptor>)typeBeforeTemplates, after, descriptor, (String)lstType)));
            visitor.append("        }");
            return visitor.toString();
        }

        private String generateVisitMethod(Map<String, TemplateDescriptor> beforeTemplates, String after, RuleDescriptor descriptor, String lstType) {
            StringBuilder visitMethod = new StringBuilder();
            String methodSuffix = lstType.startsWith("J.") ? lstType.substring(2) : lstType;
            visitMethod.append("            @Override\n");
            visitMethod.append("            public J visit").append(methodSuffix).append("(").append(lstType).append(" elem, ExecutionContext ctx) {\n");
            if (lstType.equals("Statement")) {
                visitMethod.append("                if (elem instanceof J.Block) {\n");
                visitMethod.append("                    // FIXME workaround\n");
                visitMethod.append("                    return elem;\n");
                visitMethod.append("                }\n");
            }
            visitMethod.append("                JavaTemplate.Matcher matcher;\n");
            for (Map.Entry<String, TemplateDescriptor> entry : beforeTemplates.entrySet()) {
                int arity = entry.getValue().getArity();
                for (int i = 0; i < arity; ++i) {
                    Map beforeParameters = RefasterTemplateProcessor.this.findParameterOrder(entry.getValue().method, i);
                    visitMethod.append("                if ((matcher = ").append(entry.getKey()).append(arity > 1 ? "$" + i : "").append(".matcher(getCursor())).find()").append(") {\n");
                    java.util.List jcVariableDecls = entry.getValue().method.getParameters();
                    for (JCTree.JCVariableDecl param : jcVariableDecls) {
                        java.util.List annotations = param.getModifiers().getAnnotations();
                        for (JCTree.JCAnnotation jcAnnotation : annotations) {
                            String matcher;
                            String annotationType = jcAnnotation.attribute.type.tsym.getQualifiedName().toString();
                            if (!beforeParameters.containsKey(param.name) && annotationType.startsWith("org.openrewrite.java.template")) {
                                RefasterTemplateProcessor.this.printNoteOnce("Ignoring annotation " + annotationType + " on unused parameter " + param.name, ((TemplateDescriptor)entry.getValue()).classDecl.sym);
                                continue;
                            }
                            if (annotationType.equals("org.openrewrite.java.template.NotMatches")) {
                                matcher = ((Type.ClassType)((Attribute)jcAnnotation.attribute.getValue().values.get((int)0).snd).getValue()).tsym.getQualifiedName().toString();
                                visitMethod.append("                    if (new ").append(matcher).append("().matches((Expression) matcher.parameter(").append(beforeParameters.get(param.name)).append("))) {\n");
                                visitMethod.append("                        return super.visit").append(methodSuffix).append("(elem, ctx);\n");
                                visitMethod.append("                    }\n");
                                continue;
                            }
                            if (!annotationType.equals("org.openrewrite.java.template.Matches")) continue;
                            matcher = ((Type.ClassType)((Attribute)jcAnnotation.attribute.getValue().values.get((int)0).snd).getValue()).tsym.getQualifiedName().toString();
                            visitMethod.append("                    if (!new ").append(matcher).append("().matches((Expression) matcher.parameter(").append(beforeParameters.get(param.name)).append("))) {\n");
                            visitMethod.append("                        return super.visit").append(methodSuffix).append("(elem, ctx);\n");
                            visitMethod.append("                    }\n");
                        }
                    }
                    if (descriptor.afterTemplate == null) {
                        visitMethod.append("                    return SearchResult.found(elem);\n");
                    } else {
                        this.maybeRemoveImports(this.imports, visitMethod, entry.getValue(), i, descriptor.afterTemplate);
                        this.maybeRemoveStaticImports(this.staticImports, visitMethod, entry.getValue(), i, descriptor.afterTemplate);
                        ArrayList<String> embedOptions = new ArrayList<String>();
                        JCTree.JCExpression afterReturn = RefasterTemplateProcessor.this.getReturnExpression(descriptor.afterTemplate.method);
                        if (afterReturn instanceof JCTree.JCParens || afterReturn instanceof JCTree.JCUnary && ((JCTree.JCUnary)afterReturn).getExpression() instanceof JCTree.JCParens) {
                            embedOptions.add("REMOVE_PARENS");
                        }
                        embedOptions.add("SHORTEN_NAMES");
                        if (this.simplifyBooleans(descriptor.afterTemplate.method)) {
                            embedOptions.add("SIMPLIFY_BOOLEANS");
                        }
                        visitMethod.append("                    return embed(\n");
                        visitMethod.append("                            ").append(after).append(".apply(getCursor(), elem.getCoordinates().replace()");
                        Map afterParameters = RefasterTemplateProcessor.this.findParameterOrder(descriptor.afterTemplate.method, 0);
                        String parameters = RefasterTemplateProcessor.this.matchParameters(beforeParameters, afterParameters);
                        if (!parameters.isEmpty()) {
                            visitMethod.append(", ").append(parameters);
                        }
                        visitMethod.append("),\n");
                        visitMethod.append("                            getCursor(),\n");
                        visitMethod.append("                            ctx,\n");
                        visitMethod.append("                            ").append(String.join((CharSequence)", ", embedOptions)).append("\n");
                        visitMethod.append("                    );\n");
                    }
                    visitMethod.append("                }\n");
                }
            }
            visitMethod.append("                return super.visit").append(methodSuffix).append("(elem, ctx);\n");
            visitMethod.append("            }\n");
            visitMethod.append("\n");
            return visitMethod.toString();
        }

        private boolean simplifyBooleans(JCTree.JCMethodDecl template) {
            if (template.getReturnType().type.getTag() == TypeTag.BOOLEAN) {
                return true;
            }
            return new TreeScanner(){
                boolean found;

                boolean find(JCTree tree) {
                    this.scan(tree);
                    return this.found;
                }

                @Override
                public void visitBinary(JCTree.JCBinary jcBinary) {
                    this.found |= jcBinary.type.getTag() == TypeTag.BOOLEAN;
                    super.visitBinary(jcBinary);
                }

                @Override
                public void visitConditional(JCTree.JCConditional jcConditional) {
                    this.found = true;
                }

                @Override
                public void visitUnary(JCTree.JCUnary jcUnary) {
                    this.found |= jcUnary.type.getTag() == TypeTag.BOOLEAN;
                    super.visitUnary(jcUnary);
                }
            }.find(template.getBody());
        }

        private String recipeDescriptor(JCTree.JCClassDecl classDecl, @Nullable RuleDescriptor descriptor, String defaultDisplayName, String defaultDescription) {
            String displayName = defaultDisplayName;
            StringBuilder description = new StringBuilder(defaultDescription);
            LinkedHashSet<String> tags = new LinkedHashSet<String>();
            Tokens.Comment comment = this.cu.docComments.getComment(classDecl);
            if (comment != null && comment.getText() != null && !comment.getText().isEmpty()) {
                String firstLine;
                String commentText = comment.getText().replace("<p>", "").replace("<pre>{@code", "```java").replace("}</pre>", "```\n").replaceAll("(?s)\\{@\\S+\\s+(.*?)}", "`$1`").replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\t", "\\t").replace("\f", "\\f").replace("\r", "\\r");
                String[] lines = commentText.split("\\.\\R+", 2);
                if (lines.length == 1 || lines[1].trim().isEmpty()) {
                    firstLine = lines[0].trim().replace("\n", "");
                    description = firstLine.endsWith(".") ? new StringBuilder(firstLine) : new StringBuilder(firstLine).append('.');
                } else {
                    firstLine = lines[0].trim().replace("\n", "");
                    displayName = firstLine.endsWith(".") ? firstLine.substring(0, firstLine.length() - 1) : firstLine;
                    description = new StringBuilder(lines[1].trim().replace("\n", "\\n"));
                    if (!description.toString().endsWith(".")) {
                        if (description.toString().endsWith("```")) {
                            description.append("\\n");
                        }
                        description.append('.');
                    }
                }
            }
            for (JCTree.JCAnnotation annotation : classDecl.getModifiers().getAnnotations()) {
                String annotationFqn = annotation.type.toString();
                if ("org.openrewrite.java.template.RecipeDescriptor".equals(annotationFqn)) {
                    for (JCTree.JCExpression argExpr : annotation.getArguments()) {
                        JCTree.JCAssign arg = (JCTree.JCAssign)argExpr;
                        switch (arg.lhs.toString()) {
                            case "name": {
                                displayName = RefasterTemplateProcessor.escapeJava(((JCTree.JCLiteral)arg.rhs).getValue().toString());
                                break;
                            }
                            case "description": {
                                description = new StringBuilder(RefasterTemplateProcessor.escapeJava(((JCTree.JCLiteral)arg.rhs).getValue().toString()));
                                break;
                            }
                            case "tags": {
                                if (arg.rhs instanceof JCTree.JCLiteral) {
                                    tags.add(RefasterTemplateProcessor.escapeJava(((JCTree.JCLiteral)arg.rhs).getValue().toString()));
                                    break;
                                }
                                if (!(arg.rhs instanceof JCTree.JCNewArray)) break;
                                for (JCTree.JCExpression e : ((JCTree.JCNewArray)arg.rhs).elems) {
                                    tags.add(RefasterTemplateProcessor.escapeJava(((JCTree.JCLiteral)e).getValue().toString()));
                                }
                                break;
                            }
                        }
                    }
                    break;
                }
                if ("tech.picnic.errorprone.refaster.annotation.OnlineDocumentation".equals(annotationFqn)) {
                    if (!((List)annotation.getArguments()).isEmpty()) continue;
                    description.append("\\n[Source](https://error-prone.picnic.tech/refasterrules/").append(classDecl.name.toString()).append(").");
                    continue;
                }
                if (!"java.lang.SuppressWarnings".equals(annotationFqn)) continue;
                this.addRspecTags(annotation, tags);
            }
            if (descriptor != null) {
                for (TemplateDescriptor beforeTemplate : descriptor.beforeTemplates) {
                    for (JCTree.JCAnnotation annotation : beforeTemplate.method.getModifiers().getAnnotations()) {
                        if (!"SuppressWarnings".equals(((JCTree.JCIdent)annotation.annotationType).getName().toString())) continue;
                        this.addRspecTags(annotation, tags);
                    }
                }
            }
            String recipeDescriptor = "    @Override\n    public String getDisplayName() {\n        //language=markdown\n        return \"" + displayName + "\";\n    }\n\n    @Override\n    public String getDescription() {\n        //language=markdown\n        return \"" + description + "\";\n    }\n\n";
            if (tags.size() == 1) {
                recipeDescriptor = recipeDescriptor + "    @Override\n    public Set<String> getTags() {\n        return Collections.singleton(\"" + String.join((CharSequence)"\", \"", tags) + "\");\n    }\n\n";
            } else if (tags.size() > 1) {
                recipeDescriptor = recipeDescriptor + "    @Override\n    public Set<String> getTags() {\n        return new HashSet<>(Arrays.asList(\"" + String.join((CharSequence)"\", \"", tags) + "\"));\n    }\n\n";
            }
            return recipeDescriptor;
        }

        private void addRspecTags(JCTree.JCAnnotation annotation, Set<String> tags) {
            for (JCTree.JCExpression argExpr : annotation.getArguments()) {
                if (!(argExpr instanceof JCTree.JCAssign)) continue;
                Consumer<JCTree.JCExpression> addTag = expr -> {
                    String value;
                    if (expr instanceof JCTree.JCLiteral && (value = ((JCTree.JCLiteral)expr).getValue().toString()).startsWith("java:")) {
                        tags.add("RSPEC-" + value.substring("java:".length()));
                    }
                };
                JCTree.JCExpression rhs = ((JCTree.JCAssign)argExpr).rhs;
                if (rhs instanceof JCTree.JCNewArray) {
                    ((JCTree.JCNewArray)rhs).elems.forEach(addTag);
                    continue;
                }
                addTag.accept(rhs);
            }
        }

        private void maybeRemoveImports(Map<TemplateDescriptor, Set<String>> importsByTemplate, StringBuilder recipe, TemplateDescriptor beforeTemplate, int pos, TemplateDescriptor afterTemplate) {
            Set beforeImports = beforeTemplate.usedTypes(pos).stream().map(sym -> sym.fullname.toString()).collect(Collectors.toCollection(LinkedHashSet::new));
            beforeImports.removeAll(this.getImportsAsStrings(importsByTemplate, afterTemplate));
            beforeImports.removeIf(i -> i.startsWith("java.lang.") || i.startsWith("com.google.errorprone.refaster."));
            beforeImports.forEach(anImport -> recipe.append("                    maybeRemoveImport(\"").append((String)anImport).append("\");\n"));
        }

        private void maybeRemoveStaticImports(Map<TemplateDescriptor, Set<String>> importsByTemplate, StringBuilder recipe, TemplateDescriptor beforeTemplate, int pos, TemplateDescriptor afterTemplate) {
            Set beforeImports = beforeTemplate.usedMembers(pos).stream().map(symbol -> symbol.owner.getQualifiedName() + "." + symbol.name).collect(Collectors.toCollection(LinkedHashSet::new));
            beforeImports.removeAll(this.getImportsAsStrings(importsByTemplate, afterTemplate));
            beforeImports.removeIf(i -> i.startsWith("java.lang.") || i.startsWith("com.google.errorprone.refaster."));
            beforeImports.forEach(anImport -> recipe.append("                    maybeRemoveImport(\"").append((String)anImport).append("\");\n"));
        }

        private Set<String> getImportsAsStrings(Map<TemplateDescriptor, Set<String>> importsByTemplate, TemplateDescriptor templateMethod) {
            return importsByTemplate.entrySet().stream().filter(e -> templateMethod == e.getKey()).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
        }

        private @Nullable Precondition generatePreconditions(java.util.List<TemplateDescriptor> beforeTemplates, int indent) {
            HashSet preconditions = new HashSet();
            for (TemplateDescriptor beforeTemplate : beforeTemplates) {
                int arity = beforeTemplate.getArity();
                for (int i = 0; i < arity; ++i) {
                    LinkedHashSet<Precondition.Rule> usesVisitors = new LinkedHashSet<Precondition.Rule>();
                    for (Symbol.ClassSymbol usedType : beforeTemplate.usedTypes(i)) {
                        String name = usedType.getQualifiedName().toString().replace('$', '.');
                        if (name.startsWith("java.lang.") || name.startsWith("com.google.errorprone.refaster.")) continue;
                        usesVisitors.add(new Precondition.Rule("new UsesType<>(\"" + name + "\", true)"));
                    }
                    for (Symbol.MethodSymbol method : beforeTemplate.usedMethods(i)) {
                        if (method.owner.getQualifiedName().toString().startsWith("com.google.errorprone.refaster.")) continue;
                        String methodName = method.name.toString();
                        methodName = methodName.equals("<init>") ? "<constructor>" : methodName;
                        usesVisitors.add(new Precondition.Rule(String.format("new UsesMethod<>(\"%s %s(..)\", true)", method.owner.getQualifiedName().toString(), methodName)));
                    }
                    if (usesVisitors.isEmpty()) {
                        return null;
                    }
                    preconditions.add(usesVisitors);
                }
            }
            if (preconditions.isEmpty()) {
                return null;
            }
            return new Precondition.Or(preconditions.stream().map(Precondition.And::new).collect(Collectors.toSet())).prune();
        }
    }
}

