/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.template.internal;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openrewrite.java.template.internal.ClasspathJarNameDetector;
import org.openrewrite.java.template.internal.ImportDetector;

public class TemplateCode {
    public static <T extends JCTree> String process(T tree, List<JCTree.JCVariableDecl> parameters, boolean asStatement, boolean fullyQualified) {
        StringWriter writer = new StringWriter();
        TemplateCodePrinter printer = new TemplateCodePrinter(writer, parameters, fullyQualified);
        try {
            if (asStatement) {
                printer.printStat(tree);
            } else {
                printer.printExpr(tree);
            }
            StringBuilder builder = new StringBuilder("JavaTemplate\n");
            builder.append("    .builder(\"").append(writer.toString().replace("\\", "\\\\").replace("\"", "\\\"").replaceAll("\\R", "\\\\n")).append("\")");
            if (!printer.imports.isEmpty()) {
                builder.append("\n    .imports(").append(printer.imports.stream().map(i -> '\"' + i + '\"').collect(Collectors.joining(", "))).append(")");
            }
            if (!printer.staticImports.isEmpty()) {
                builder.append("\n    .staticImports(").append(printer.staticImports.stream().map(i -> '\"' + i + '\"').collect(Collectors.joining(", "))).append(")");
            }
            List<Symbol> imports = ImportDetector.imports(tree);
            Set<String> jarNames = ClasspathJarNameDetector.classpathFor(tree, imports);
            for (JCTree.JCVariableDecl parameter : parameters) {
                jarNames.addAll(ClasspathJarNameDetector.classpathFor(parameter, ImportDetector.imports(parameter)));
            }
            if (!jarNames.isEmpty()) {
                builder.append("\n    .javaParser(JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))");
            }
            return builder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String indent(String code, int width) {
        char[] indent = new char[width];
        Arrays.fill(indent, ' ');
        String replacement = "$1" + new String(indent);
        return code.replaceAll("(?m)(\\R)", replacement);
    }

    private static class TemplateCodePrinter
    extends Pretty {
        private static final String PRIMITIVE_ANNOTATION = "org.openrewrite.java.template.Primitive";
        private final List<JCTree.JCVariableDecl> declaredParameters;
        private final boolean fullyQualified;
        private final Set<JCTree.JCVariableDecl> seenParameters = new HashSet<JCTree.JCVariableDecl>();
        private final TreeSet<String> imports = new TreeSet();
        private final TreeSet<String> staticImports = new TreeSet();

        public TemplateCodePrinter(Writer writer, List<JCTree.JCVariableDecl> declaredParameters, boolean fullyQualified) {
            super(writer, true);
            this.declaredParameters = declaredParameters;
            this.fullyQualified = fullyQualified;
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            if ((0x1000000000L & tree.getModifiers().flags) == 0L) {
                super.visitMethodDef(tree);
            }
        }

        @Override
        public void visitIdent(JCTree.JCIdent jcIdent) {
            try {
                Symbol sym = jcIdent.sym;
                Optional<JCTree.JCVariableDecl> param = this.declaredParameters.stream().filter(p -> p.sym == sym).findFirst();
                if (param.isPresent()) {
                    boolean isPrimitive = param.get().getModifiers().getAnnotations().stream().anyMatch(a -> a.attribute.type.tsym.getQualifiedName().toString().equals(PRIMITIVE_ANNOTATION));
                    this.print("#{" + sym.name);
                    if (this.seenParameters.add(param.get())) {
                        Type type = param.get().sym.type;
                        String typeString = isPrimitive ? this.getUnboxedPrimitive(type.toString()) : this.templateTypeString(type);
                        this.print(":any(" + typeString + ")");
                    }
                    this.print("}");
                } else if (sym != null) {
                    this.print(sym);
                } else {
                    this.print(jcIdent.name);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private String templateTypeString(Type type) {
            if (type instanceof Type.ArrayType) {
                Type elemtype = ((Type.ArrayType)type).elemtype;
                return this.templateTypeString(elemtype) + "[]";
            }
            if (type instanceof Type.WildcardType) {
                Type.WildcardType wildcardType = (Type.WildcardType)type;
                return wildcardType.toString();
            }
            if (type.isParameterized()) {
                return type.tsym.getQualifiedName().toString() + '<' + type.allparams().stream().map(this::templateTypeString).collect(Collectors.joining(",")) + '>';
            }
            return type.tsym.getQualifiedName().toString();
        }

        void print(Symbol sym) throws IOException {
            if (sym instanceof Symbol.ClassSymbol) {
                if (this.fullyQualified) {
                    this.print(sym.packge().fullname.contentEquals("java.lang") ? sym.name : sym.getQualifiedName());
                } else {
                    this.print(sym.name);
                    if (!sym.packge().fullname.contentEquals("java.lang")) {
                        this.imports.add(sym.getQualifiedName().toString());
                    }
                }
            } else if (sym instanceof Symbol.VarSymbol) {
                if (this.fullyQualified) {
                    if (sym.owner instanceof Symbol.ClassSymbol) {
                        this.print(sym.owner);
                        this.print(Character.valueOf('.'));
                    }
                    this.print(sym.name);
                } else {
                    this.print(sym.name);
                    if (!sym.packge().fullname.contentEquals("java.lang")) {
                        this.staticImports.add(sym.owner.getQualifiedName() + "." + sym.name);
                    }
                }
            } else if (sym instanceof Symbol.MethodSymbol) {
                if (this.fullyQualified) {
                    this.print(sym.owner);
                    this.print(Character.valueOf('.'));
                    this.print(sym.name);
                } else {
                    this.print(sym.name);
                    if (!sym.packge().fullname.contentEquals("java.lang")) {
                        this.staticImports.add(sym.owner.getQualifiedName() + "." + sym.name);
                    }
                }
            } else if (sym instanceof Symbol.PackageSymbol) {
                this.print(sym.getQualifiedName());
            }
        }

        private String getUnboxedPrimitive(String paramType) {
            switch (paramType) {
                case "java.lang.Boolean": {
                    return "boolean";
                }
                case "java.lang.Byte": {
                    return "byte";
                }
                case "java.lang.Character": {
                    return "char";
                }
                case "java.lang.Double": {
                    return "double";
                }
                case "java.lang.Float": {
                    return "float";
                }
                case "java.lang.Integer": {
                    return "int";
                }
                case "java.lang.Long": {
                    return "long";
                }
                case "java.lang.Short": {
                    return "short";
                }
                case "java.lang.Void": {
                    return "void";
                }
            }
            return paramType;
        }
    }
}

