/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.template;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.Nullable;
import org.openrewrite.java.template.internal.ImportDetector;
import org.openrewrite.java.template.internal.JavacResolution;
import org.openrewrite.java.template.internal.Permit;
import org.openrewrite.java.template.internal.permit.Parent;
import sun.misc.Unsafe;

@SupportedAnnotationTypes(value={"com.google.errorprone.refaster.annotation.BeforeTemplate", "com.google.errorprone.refaster.annotation.AfterTemplate"})
public class RefasterTemplateProcessor
extends AbstractProcessor {
    static final String BEFORE_TEMPLATE = "com.google.errorprone.refaster.annotation.BeforeTemplate";
    static final String AFTER_TEMPLATE = "com.google.errorprone.refaster.annotation.AfterTemplate";
    static Set<String> UNSUPPORTED_ANNOTATIONS = Stream.of("com.google.errorprone.refaster.annotation.AlsoNegation", "com.google.errorprone.refaster.annotation.AllowCodeBetweenLines", "com.google.errorprone.refaster.annotation.Matches", "com.google.errorprone.refaster.annotation.MayOptionallyUse", "com.google.errorprone.refaster.annotation.NoAutoboxing", "com.google.errorprone.refaster.annotation.NotMatches", "com.google.errorprone.refaster.annotation.OfKind", "com.google.errorprone.refaster.annotation.Placeholder", "com.google.errorprone.refaster.annotation.Repeated", "com.google.errorprone.refaster.annotation.UseImportPolicy", "com.google.errorprone.annotations.DoNotCall").collect(Collectors.toSet());
    static final String PRIMITIVE_ANNOTATION = "@Primitive";
    static final Map<String, String> PRIMITIVE_TYPE_MAP = new HashMap<String, String>();
    static Set<String> DO_AFTER_VISIT;
    static ClassValue<java.util.List<String>> LST_TYPE_MAP;
    private ProcessingEnvironment processingEnv;
    private JavacProcessingEnvironment javacProcessingEnv;
    private Trees trees;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.processingEnv = processingEnv;
        this.javacProcessingEnv = this.getJavacProcessingEnvironment(processingEnv);
        if (this.javacProcessingEnv == null) {
            return;
        }
        this.trees = Trees.instance(this.javacProcessingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getRootElements()) {
            JCTree.JCCompilationUnit jcCompilationUnit = this.toUnit(element);
            if (jcCompilationUnit == null) continue;
            this.maybeGenerateTemplateSources(jcCompilationUnit);
        }
        return true;
    }

    void maybeGenerateTemplateSources(final JCTree.JCCompilationUnit cu) {
        final Context context = this.javacProcessingEnv.getContext();
        new TreeScanner(){
            final Map<JCTree.JCMethodDecl, Set<String>> imports = new HashMap<JCTree.JCMethodDecl, Set<String>>();
            final Map<JCTree.JCMethodDecl, Set<String>> staticImports = new HashMap<JCTree.JCMethodDecl, Set<String>>();
            final Map<String, String> recipes = new LinkedHashMap<String, String>();

            @Override
            public void visitClassDef(JCTree.JCClassDecl classDecl) {
                super.visitClassDef(classDecl);
                TemplateDescriptor descriptor = RefasterTemplateProcessor.this.getTemplateDescriptor(classDecl, context, cu);
                if (descriptor != null) {
                    Iterator displayName;
                    TreeMaker treeMaker = TreeMaker.instance(context).forToplevel(cu);
                    java.util.List membersWithoutConstructor = classDecl.getMembers().stream().filter(m -> !(m instanceof JCTree.JCMethodDecl) || !((JCTree.JCMethodDecl)m).name.contentEquals("<init>")).collect(Collectors.toList());
                    JCTree.JCClassDecl copy = treeMaker.ClassDef(classDecl.mods, classDecl.name, classDecl.typarams, classDecl.extending, classDecl.implementing, List.from(membersWithoutConstructor));
                    RefasterTemplateProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generating template for " + descriptor.classDecl.getSimpleName());
                    String templateName = classDecl.sym.fullname.toString().substring(classDecl.sym.packge().fullname.length() + 1);
                    String templateFqn = classDecl.sym.fullname.toString() + "Recipe";
                    String templateCode = copy.toString().trim();
                    Iterator iterator = displayName = cu.docComments.getComment(classDecl) != null ? cu.docComments.getComment(classDecl).getText().trim() : "Refaster template `" + templateName + '`';
                    if (((String)((Object)displayName)).endsWith(".")) {
                        displayName = ((String)((Object)displayName)).substring(0, ((String)((Object)displayName)).length() - 1);
                    }
                    for (JCTree.JCMethodDecl jCMethodDecl : descriptor.beforeTemplates) {
                        for (Symbol anImport : ImportDetector.imports(jCMethodDecl)) {
                            if (anImport instanceof Symbol.ClassSymbol) {
                                this.imports.computeIfAbsent(jCMethodDecl, k -> new TreeSet()).add(anImport.getQualifiedName().toString().replace('$', '.'));
                                continue;
                            }
                            if (anImport instanceof Symbol.VarSymbol || anImport instanceof Symbol.MethodSymbol) {
                                this.staticImports.computeIfAbsent(jCMethodDecl, k -> new TreeSet()).add(anImport.owner.getQualifiedName().toString().replace('$', '.') + '.' + anImport.flatName().toString());
                                continue;
                            }
                            throw new AssertionError(anImport.getClass());
                        }
                    }
                    for (Symbol symbol : ImportDetector.imports(descriptor.afterTemplate)) {
                        if (symbol instanceof Symbol.ClassSymbol) {
                            this.imports.computeIfAbsent(descriptor.afterTemplate, k -> new TreeSet()).add(symbol.getQualifiedName().toString().replace('$', '.'));
                            continue;
                        }
                        if (symbol instanceof Symbol.VarSymbol || symbol instanceof Symbol.MethodSymbol) {
                            this.staticImports.computeIfAbsent(descriptor.afterTemplate, k -> new TreeSet()).add(symbol.owner.getQualifiedName().toString().replace('$', '.') + '.' + symbol.flatName().toString());
                            continue;
                        }
                        throw new AssertionError(symbol.getClass());
                    }
                    for (Set set : this.imports.values()) {
                        set.removeIf(i -> "java.lang".equals(i.substring(0, i.lastIndexOf(46))));
                        set.remove(RefasterTemplateProcessor.BEFORE_TEMPLATE);
                        set.remove(RefasterTemplateProcessor.AFTER_TEMPLATE);
                    }
                    LinkedHashMap<String, JCTree.JCMethodDecl> befores = new LinkedHashMap<String, JCTree.JCMethodDecl>();
                    for (JCTree.JCMethodDecl templ : descriptor.beforeTemplates) {
                        String name = templ.getName().toString();
                        if (befores.containsKey(name)) {
                            String base = name;
                            int i2 = 0;
                            while (befores.containsKey(name = base + i2)) {
                                ++i2;
                            }
                        }
                        befores.put(name, templ);
                    }
                    String string = descriptor.afterTemplate.getName().toString();
                    StringBuilder recipe = new StringBuilder();
                    String recipeName = templateFqn.substring(templateFqn.lastIndexOf(46) + 1);
                    String modifiers = classDecl.getModifiers().getFlags().stream().map(m -> m.toString()).collect(Collectors.joining(" "));
                    recipe.append(modifiers + " class " + recipeName + " extends Recipe {\n");
                    recipe.append("\n");
                    recipe.append("    @Override\n");
                    recipe.append("    public String getDisplayName() {\n");
                    recipe.append("        return \"" + RefasterTemplateProcessor.this.escape(displayName) + "\";\n");
                    recipe.append("    }\n");
                    recipe.append("\n");
                    recipe.append("    @Override\n");
                    recipe.append("    public String getDescription() {\n");
                    recipe.append("        return \"Recipe created for the following Refaster template:\\n```java\\n" + RefasterTemplateProcessor.this.escape(templateCode) + "\\n```\\n.\";\n");
                    recipe.append("    }\n");
                    recipe.append("\n");
                    recipe.append("    @Override\n");
                    recipe.append("    public TreeVisitor<?, ExecutionContext> getVisitor() {\n");
                    recipe.append("        JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>() {\n");
                    for (Map.Entry entry : befores.entrySet()) {
                        recipe.append("            final JavaTemplate " + (String)entry.getKey() + " = JavaTemplate.compile(this, \"" + (String)entry.getKey() + "\", " + RefasterTemplateProcessor.this.toLambda((JCTree.JCMethodDecl)entry.getValue()) + ").build();\n");
                    }
                    recipe.append("            final JavaTemplate " + string + " = JavaTemplate.compile(this, \"" + string + "\", " + RefasterTemplateProcessor.this.toLambda(descriptor.afterTemplate) + ").build();\n");
                    recipe.append("\n");
                    java.util.List<String> lstTypes = LST_TYPE_MAP.get(RefasterTemplateProcessor.this.getType(descriptor.beforeTemplates.get(0)));
                    String parameters = RefasterTemplateProcessor.this.parameters(descriptor);
                    for (String lstType : lstTypes) {
                        String methodSuffix = lstType.startsWith("J.") ? lstType.substring(2) : lstType;
                        recipe.append("            @Override\n");
                        recipe.append("            public J visit" + methodSuffix + "(" + lstType + " elem, ExecutionContext ctx) {\n");
                        if (lstType.equals("Statement")) {
                            recipe.append("                if (elem instanceof J.Block) {;\n");
                            recipe.append("                    // FIXME workaround\n");
                            recipe.append("                    return elem;\n");
                            recipe.append("                }\n");
                        }
                        recipe.append("                JavaTemplate.Matcher matcher;\n");
                        for (Map.Entry entry : befores.entrySet()) {
                            recipe.append("                if ((matcher = " + (String)entry.getKey() + ".matcher(getCursor())).find()) {\n");
                            for (JCTree.JCVariableDecl param : ((JCTree.JCMethodDecl)entry.getValue()).getParameters()) {
                                java.util.List annotations = param.getModifiers().getAnnotations();
                                for (int i3 = 0; i3 < ((List)annotations).size(); ++i3) {
                                    String matcher;
                                    JCTree.JCAnnotation jcAnnotation = (JCTree.JCAnnotation)((List)annotations).get(i3);
                                    String annotationType = jcAnnotation.attribute.type.tsym.getQualifiedName().toString();
                                    if (annotationType.equals("org.openrewrite.java.template.NotMatches")) {
                                        matcher = ((Type.ClassType)((Attribute)jcAnnotation.attribute.getValue().values.get((int)0).snd).getValue()).tsym.getQualifiedName().toString();
                                        recipe.append("                    if (new " + matcher + "().matches((Expression) matcher.parameter(" + i3 + "))) {\n");
                                        recipe.append("                        return super.visit" + methodSuffix + "(elem, ctx);\n");
                                        recipe.append("                    }\n");
                                        continue;
                                    }
                                    if (!annotationType.equals("org.openrewrite.java.template.Matches")) continue;
                                    matcher = ((Type.ClassType)((Attribute)jcAnnotation.attribute.getValue().values.get((int)0).snd).getValue()).tsym.getQualifiedName().toString();
                                    recipe.append("                    if (!new " + matcher + "().matches((Expression) matcher.parameter(" + i3 + "))) {\n");
                                    recipe.append("                        return super.visit" + methodSuffix + "(elem, ctx);\n");
                                    recipe.append("                    }\n");
                                }
                            }
                            Set beforeImports = this.imports.entrySet().stream().filter(e -> ((JCTree.JCMethodDecl)entry.getValue()).equals(e.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
                            Set afterImports = this.imports.entrySet().stream().filter(e -> descriptor.afterTemplate == e.getKey()).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
                            for (String import_ : this.imports.values().stream().flatMap(Collection::stream).collect(Collectors.toSet())) {
                                if (import_.startsWith("java.lang.") || beforeImports.contains(import_) && afterImports.contains(import_)) continue;
                                if (beforeImports.contains(import_)) {
                                    recipe.append("                    maybeRemoveImport(\"" + import_ + "\");\n");
                                    continue;
                                }
                                if (!afterImports.contains(import_)) continue;
                                recipe.append("                    maybeAddImport(\"" + import_ + "\");\n");
                            }
                            beforeImports = this.staticImports.entrySet().stream().filter(e -> ((JCTree.JCMethodDecl)entry.getValue()).equals(e.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
                            afterImports = this.staticImports.entrySet().stream().filter(e -> descriptor.afterTemplate == e.getKey()).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
                            for (String import_ : this.staticImports.values().stream().flatMap(Collection::stream).collect(Collectors.toSet())) {
                                int dot = import_.lastIndexOf(46);
                                if (import_.startsWith("java.lang.") || beforeImports.contains(import_) && afterImports.contains(import_)) continue;
                                if (beforeImports.contains(import_)) {
                                    recipe.append("                    maybeRemoveImport(\"" + import_ + "\");\n");
                                    continue;
                                }
                                if (!afterImports.contains(import_)) continue;
                                recipe.append("                    maybeAddImport(\"" + import_.substring(0, dot) + "\", \"" + import_.substring(dot + 1) + "\");\n");
                            }
                            for (String doAfterVisit : DO_AFTER_VISIT) {
                                recipe.append("                    doAfterVisit(" + doAfterVisit + ");\n");
                            }
                            if (parameters.isEmpty()) {
                                recipe.append("                    return " + string + ".apply(getCursor(), elem.getCoordinates().replace());\n");
                            } else {
                                recipe.append("                    return " + string + ".apply(getCursor(), elem.getCoordinates().replace(), " + parameters + ");\n");
                            }
                            recipe.append("                }\n");
                        }
                        recipe.append("                return super.visit" + methodSuffix + "(elem, ctx);\n");
                        recipe.append("            }\n");
                        recipe.append("\n");
                    }
                    recipe.append("        };\n");
                    String preconditions = this.generatePreconditions(descriptor.beforeTemplates, this.imports, this.staticImports);
                    if (preconditions == null) {
                        recipe.append("        return javaVisitor;\n");
                    } else {
                        recipe.append("        return Preconditions.check(\n");
                        recipe.append("                " + preconditions + ",\n");
                        recipe.append("                javaVisitor);\n");
                    }
                    recipe.append("    }\n");
                    recipe.append("}\n");
                    this.recipes.put(recipeName, recipe.toString());
                }
                if (classDecl.sym != null && classDecl.sym.getNestingKind() == NestingKind.TOP_LEVEL && !this.recipes.isEmpty()) {
                    boolean outerClassRequired = descriptor == null;
                    try {
                        String inputOuterFQN = outerClassRequired ? classDecl.sym.fullname.toString() : descriptor.classDecl.sym.fullname.toString();
                        String className = inputOuterFQN + (outerClassRequired ? "Recipes" : "Recipe");
                        JavaFileObject builderFile = RefasterTemplateProcessor.this.processingEnv.getFiler().createSourceFile(className, new Element[0]);
                        try (BufferedWriter out = new BufferedWriter(builderFile.openWriter());){
                            out.write("package " + classDecl.sym.packge().toString() + ";\n");
                            out.write("\n");
                            out.write("import org.openrewrite.ExecutionContext;\n");
                            out.write("import org.openrewrite.Preconditions;\n");
                            out.write("import org.openrewrite.Recipe;\n");
                            out.write("import org.openrewrite.TreeVisitor;\n");
                            out.write("import org.openrewrite.java.JavaTemplate;\n");
                            out.write("import org.openrewrite.java.JavaVisitor;\n");
                            out.write("import org.openrewrite.java.search.*;\n");
                            out.write("import org.openrewrite.java.template.Primitive;\n");
                            out.write("import org.openrewrite.java.tree.*;\n");
                            if (outerClassRequired) {
                                out.write("\n");
                                out.write("import java.util.Arrays;\n");
                                out.write("import java.util.List;\n");
                            }
                            out.write("\n");
                            if (!this.imports.isEmpty()) {
                                for (String anImport : this.imports.values().stream().flatMap(Collection::stream).collect(Collectors.toSet())) {
                                    out.write("import " + anImport + ";\n");
                                }
                                out.write("\n");
                            }
                            if (!this.staticImports.isEmpty()) {
                                for (String anImport : this.staticImports.values().stream().flatMap(Collection::stream).collect(Collectors.toSet())) {
                                    out.write("import static " + anImport + ";\n");
                                }
                                out.write("\n");
                            }
                            if (outerClassRequired) {
                                String outerClassName = className.substring(className.lastIndexOf(46) + 1);
                                out.write("public final class " + outerClassName + " extends Recipe {\n");
                                String simpleInputOuterFQN = inputOuterFQN.substring(inputOuterFQN.lastIndexOf(46) + 1);
                                out.write("\n    @Override\n    public String getDisplayName() {\n        return \"`" + simpleInputOuterFQN + "` Refaster recipes\";\n    }\n\n    @Override\n    public String getDescription() {\n        return \"Refaster template recipes for `" + inputOuterFQN + "`.\";\n    }\n\n\n");
                                String string = this.recipes.keySet().stream().map(r -> "                new " + r.substring(r.lastIndexOf(46) + 1, r.length()) + "()").collect(Collectors.joining(",\n"));
                                out.write("    @Override\n    public List<Recipe> getRecipeList() {\n        return Arrays.asList(\n" + string + '\n' + "        );\n    }\n\n");
                                for (String r2 : this.recipes.values()) {
                                    out.write(r2.replaceAll("(?m)^(.+)$", "    $1"));
                                    ((Writer)out).write(10);
                                }
                                out.write("}\n");
                            } else {
                                for (String r3 : this.recipes.values()) {
                                    out.write(r3);
                                    ((Writer)out).write(10);
                                }
                            }
                        }
                    }
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }

            private String generatePreconditions(java.util.List<JCTree.JCMethodDecl> beforeTemplates, Map<JCTree.JCMethodDecl, Set<String>> imports, Map<JCTree.JCMethodDecl, Set<String>> staticImports) {
                LinkedHashSet preconditions = new LinkedHashSet();
                for (JCTree.JCMethodDecl beforeTemplate : beforeTemplates) {
                    LinkedHashSet<String> usesVisitors = new LinkedHashSet<String>();
                    Set localImports = imports.getOrDefault(beforeTemplate, Collections.emptySet());
                    for (String import_ : localImports) {
                        usesVisitors.add("new UsesType<>(\"" + import_ + "\", true)");
                    }
                    Set localStaticImports = staticImports.getOrDefault(beforeTemplate, Collections.emptySet());
                    for (String import_ : localStaticImports) {
                        int dot = import_.lastIndexOf(46);
                        usesVisitors.add("new UsesMethod<>(\"" + import_.substring(0, dot) + ' ' + import_.substring(dot + 1) + "(..)\")");
                    }
                    if (usesVisitors.size() == 1) {
                        preconditions.add(usesVisitors.iterator().next());
                        continue;
                    }
                    if (1 >= usesVisitors.size()) continue;
                    preconditions.add("Preconditions.and(" + String.join((CharSequence)", ", usesVisitors) + ')');
                }
                if (preconditions.size() == 1) {
                    return (String)preconditions.iterator().next();
                }
                if (1 < preconditions.size()) {
                    return "Preconditions.or(" + String.join((CharSequence)", ", preconditions) + ')';
                }
                return null;
            }
        }.scan(cu);
    }

    private static String lambdaCastType(Class<? extends JCTree> type, JCTree.JCMethodDecl method) {
        if (type == JCTree.JCMethodInvocation.class && ((List)method.getBody().getStatements()).last() instanceof JCTree.JCExpressionStatement) {
            return "";
        }
        int paramCount = method.params.size();
        boolean asFunction = !(method.restype.type instanceof Type.JCVoidType) && JCTree.JCExpression.class.isAssignableFrom(type);
        StringJoiner joiner = new StringJoiner(", ", "<", ">").setEmptyValue("");
        for (int i = 0; i < (asFunction ? paramCount + 1 : paramCount); ++i) {
            joiner.add("?");
        }
        return "(JavaTemplate." + (asFunction ? (char)'F' : 'P') + paramCount + joiner + ") ";
    }

    private String escape(String string) {
        return string.replace("\"", "\\\"").replaceAll("\\R", "\\\\n");
    }

    private String parameters(TemplateDescriptor descriptor) {
        final ArrayList afterParams = new ArrayList();
        new TreeScanner(){

            @Override
            public void scan(JCTree jcTree) {
                if (jcTree instanceof JCTree.JCIdent) {
                    JCTree.JCIdent jcIdent = (JCTree.JCIdent)jcTree;
                    if (jcIdent.sym instanceof Symbol.VarSymbol && jcIdent.sym.owner instanceof Symbol.MethodSymbol && ((Symbol.MethodSymbol)jcIdent.sym.owner).params.contains(jcIdent.sym)) {
                        afterParams.add(((Symbol.MethodSymbol)jcIdent.sym.owner).params.indexOf(jcIdent.sym));
                    }
                }
                super.scan(jcTree);
            }
        }.scan(descriptor.afterTemplate.body);
        StringJoiner joiner = new StringJoiner(", ");
        for (Integer param : afterParams) {
            joiner.add("matcher.parameter(" + param + ")");
        }
        return joiner.toString();
    }

    private Class<? extends JCTree> getType(JCTree.JCMethodDecl method) {
        JCTree.JCStatement statement = (JCTree.JCStatement)((List)method.getBody().getStatements()).get(0);
        Class<?> type = statement.getClass();
        if (statement instanceof JCTree.JCReturn) {
            type = ((JCTree.JCReturn)statement).expr.getClass();
        } else if (statement instanceof JCTree.JCExpressionStatement) {
            type = ((JCTree.JCExpressionStatement)statement).expr.getClass();
        }
        return type;
    }

    private String toLambda(JCTree.JCMethodDecl method) {
        String string;
        Class<? extends JCTree> type;
        StringBuilder builder = new StringBuilder();
        Set expressionStatementTypes = Stream.of(JCTree.JCMethodInvocation.class, JCTree.JCNewClass.class).collect(Collectors.toSet());
        if (expressionStatementTypes.contains(type = this.getType(method))) {
            builder.append(RefasterTemplateProcessor.lambdaCastType(type, method));
        }
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        for (JCTree.JCVariableDecl parameter : method.getParameters()) {
            String paramType = parameter.getType().type.tsym.getQualifiedName().toString();
            if (PRIMITIVE_TYPE_MAP.containsKey(paramType)) {
                paramType = "@Primitive " + PRIMITIVE_TYPE_MAP.get(paramType);
            } else if (paramType.startsWith("java.lang.")) {
                paramType = paramType.substring("java.lang.".length());
            }
            joiner.add(paramType + " " + parameter.getName());
        }
        builder.append(joiner);
        builder.append(" -> ");
        JCTree.JCStatement statement = (JCTree.JCStatement)((List)method.getBody().getStatements()).get(0);
        if (statement instanceof JCTree.JCReturn) {
            builder.append(((JCTree.JCReturn)statement).getExpression().toString());
        } else if (statement instanceof JCTree.JCThrow) {
            string = statement.toString();
            builder.append("{ ").append(string).append(" }");
        } else {
            string = statement.toString();
            builder.append(string, 0, string.length() - 1);
        }
        return builder.toString();
    }

    @Nullable
    private TemplateDescriptor getTemplateDescriptor(JCTree.JCClassDecl tree, Context context, JCTree.JCCompilationUnit cu) {
        TemplateDescriptor result = new TemplateDescriptor(tree);
        for (JCTree member : tree.getMembers()) {
            if (!(member instanceof JCTree.JCMethodDecl)) continue;
            JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)member;
            java.util.List<JCTree.JCAnnotation> annotations = RefasterTemplateProcessor.getTemplateAnnotations(method, BEFORE_TEMPLATE::equals);
            if (!annotations.isEmpty()) {
                result.beforeTemplate(method);
            }
            if ((annotations = RefasterTemplateProcessor.getTemplateAnnotations(method, AFTER_TEMPLATE::equals)).isEmpty()) continue;
            result.afterTemplate(method);
        }
        return result.validate(context, cu);
    }

    private static java.util.List<JCTree.JCAnnotation> getTemplateAnnotations(MethodTree method, Predicate<String> typePredicate) {
        ArrayList<JCTree.JCAnnotation> result = new ArrayList<JCTree.JCAnnotation>();
        for (AnnotationTree annotationTree : method.getModifiers().getAnnotations()) {
            Tree type = annotationTree.getAnnotationType();
            if (type.getKind() == Tree.Kind.IDENTIFIER && ((JCTree.JCIdent)type).sym != null && typePredicate.test(((JCTree.JCIdent)type).sym.getQualifiedName().toString())) {
                result.add((JCTree.JCAnnotation)annotationTree);
                continue;
            }
            if (type.getKind() == Tree.Kind.IDENTIFIER && ((JCTree.JCAnnotation)annotationTree).attribute != null && ((JCTree.JCAnnotation)annotationTree).attribute.type instanceof Type.ClassType && ((JCTree.JCAnnotation)annotationTree).attribute.type.tsym != null && typePredicate.test(((JCTree.JCAnnotation)annotationTree).attribute.type.tsym.getQualifiedName().toString())) {
                result.add((JCTree.JCAnnotation)annotationTree);
                continue;
            }
            if (type.getKind() != Tree.Kind.MEMBER_SELECT || !(type instanceof JCTree.JCFieldAccess) || ((JCTree.JCFieldAccess)type).sym == null || !typePredicate.test(((JCTree.JCFieldAccess)type).sym.getQualifiedName().toString())) continue;
            result.add((JCTree.JCAnnotation)annotationTree);
        }
        return result;
    }

    private static java.util.List<JCTree.JCAnnotation> getTemplateAnnotations(VariableTree parameter, Predicate<String> typePredicate) {
        ArrayList<JCTree.JCAnnotation> result = new ArrayList<JCTree.JCAnnotation>();
        for (AnnotationTree annotationTree : parameter.getModifiers().getAnnotations()) {
            Tree type = annotationTree.getAnnotationType();
            if (type.getKind() == Tree.Kind.IDENTIFIER && ((JCTree.JCIdent)type).sym != null && typePredicate.test(((JCTree.JCIdent)type).sym.getQualifiedName().toString())) {
                result.add((JCTree.JCAnnotation)annotationTree);
                continue;
            }
            if (type.getKind() != Tree.Kind.MEMBER_SELECT || !(type instanceof JCTree.JCFieldAccess) || ((JCTree.JCFieldAccess)type).sym == null || !typePredicate.test(((JCTree.JCFieldAccess)type).sym.getQualifiedName().toString())) continue;
            result.add((JCTree.JCAnnotation)annotationTree);
        }
        return result;
    }

    private JCTree.JCCompilationUnit toUnit(Element element) {
        TreePath path = null;
        if (this.trees != null) {
            try {
                path = this.trees.getPath(element);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (path == null) {
            return null;
        }
        return (JCTree.JCCompilationUnit)path.getCompilationUnit();
    }

    public JavacProcessingEnvironment getJavacProcessingEnvironment(Object procEnv) {
        RefasterTemplateProcessor.addOpens();
        if (procEnv instanceof JavacProcessingEnvironment) {
            return (JavacProcessingEnvironment)procEnv;
        }
        for (Class<?> procEnvClass = procEnv.getClass(); procEnvClass != null; procEnvClass = procEnvClass.getSuperclass()) {
            Object delegate = this.tryGetDelegateField(procEnvClass, procEnv);
            if (delegate == null) {
                delegate = this.tryGetProxyDelegateToField(procEnv);
            }
            if (delegate == null) {
                delegate = this.tryGetProcessingEnvField(procEnvClass, procEnv);
            }
            if (delegate == null) continue;
            return this.getJavacProcessingEnvironment(delegate);
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Can't get the delegate of the gradle IncrementalProcessingEnvironment. OpenRewrite's template processor won't work.");
        return null;
    }

    private static void addOpens() {
        Class<?> cModule;
        try {
            cModule = Class.forName("java.lang.Module");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        Unsafe unsafe = RefasterTemplateProcessor.getUnsafe();
        Object jdkCompilerModule = RefasterTemplateProcessor.getJdkCompilerModule();
        Object ownModule = RefasterTemplateProcessor.getOwnModule();
        String[] allPkgs = new String[]{"com.sun.tools.javac.code", "com.sun.tools.javac.comp", "com.sun.tools.javac.file", "com.sun.tools.javac.main", "com.sun.tools.javac.model", "com.sun.tools.javac.parser", "com.sun.tools.javac.processing", "com.sun.tools.javac.tree", "com.sun.tools.javac.util", "com.sun.tools.javac.jvm"};
        try {
            Method m = cModule.getDeclaredMethod("implAddOpens", String.class, cModule);
            long firstFieldOffset = RefasterTemplateProcessor.getFirstFieldOffset(unsafe);
            unsafe.putBooleanVolatile(m, firstFieldOffset, true);
            for (String p : allPkgs) {
                m.invoke(jdkCompilerModule, p, ownModule);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static long getFirstFieldOffset(Unsafe unsafe) {
        try {
            return unsafe.objectFieldOffset(Parent.class.getDeclaredField("first"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static Unsafe getUnsafe() {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            return (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object getOwnModule() {
        try {
            Method m = Permit.getMethod(Class.class, "getModule", new Class[0]);
            return m.invoke(RefasterTemplateProcessor.class, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object getJdkCompilerModule() {
        try {
            Class<?> cModuleLayer = Class.forName("java.lang.ModuleLayer");
            Method mBoot = cModuleLayer.getDeclaredMethod("boot", new Class[0]);
            Object bootLayer = mBoot.invoke(null, new Object[0]);
            Class<?> cOptional = Class.forName("java.util.Optional");
            Method mFindModule = cModuleLayer.getDeclaredMethod("findModule", String.class);
            Object oCompilerO = mFindModule.invoke(bootLayer, "jdk.compiler");
            return cOptional.getDeclaredMethod("get", new Class[0]).invoke(oCompilerO, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object tryGetDelegateField(Class<?> delegateClass, Object instance) {
        try {
            return Permit.getField(delegateClass, "delegate").get(instance);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object tryGetProcessingEnvField(Class<?> delegateClass, Object instance) {
        try {
            return Permit.getField(delegateClass, "processingEnv").get(instance);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object tryGetProxyDelegateToField(Object instance) {
        try {
            InvocationHandler handler = Proxy.getInvocationHandler(instance);
            return Permit.getField(handler.getClass(), "val$delegateTo").get(handler);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        PRIMITIVE_TYPE_MAP.put(Boolean.TYPE.getName(), Boolean.class.getSimpleName());
        PRIMITIVE_TYPE_MAP.put(Byte.TYPE.getName(), Byte.class.getSimpleName());
        PRIMITIVE_TYPE_MAP.put(Character.TYPE.getName(), Character.class.getSimpleName());
        PRIMITIVE_TYPE_MAP.put(Short.TYPE.getName(), Short.class.getSimpleName());
        PRIMITIVE_TYPE_MAP.put(Integer.TYPE.getName(), Integer.class.getSimpleName());
        PRIMITIVE_TYPE_MAP.put(Long.TYPE.getName(), Long.class.getSimpleName());
        PRIMITIVE_TYPE_MAP.put(Float.TYPE.getName(), Float.class.getSimpleName());
        PRIMITIVE_TYPE_MAP.put(Double.TYPE.getName(), Double.class.getSimpleName());
        PRIMITIVE_TYPE_MAP.put(Void.TYPE.getName(), Void.class.getSimpleName());
        DO_AFTER_VISIT = Stream.of("new org.openrewrite.java.ShortenFullyQualifiedTypeReferences().getVisitor()", "new org.openrewrite.java.cleanup.UnnecessaryParenthesesVisitor()", "new org.openrewrite.java.cleanup.SimplifyBooleanExpressionVisitor()").collect(Collectors.toCollection(LinkedHashSet::new));
        LST_TYPE_MAP = new ClassValue<java.util.List<String>>(){

            @Override
            protected java.util.List<String> computeValue(Class<?> type) {
                if (JCTree.JCUnary.class.isAssignableFrom(type)) {
                    return Collections.singletonList("J.Unary");
                }
                if (JCTree.JCBinary.class.isAssignableFrom(type)) {
                    return Collections.singletonList("J.Binary");
                }
                if (JCTree.JCMethodInvocation.class.isAssignableFrom(type)) {
                    return Collections.singletonList("J.MethodInvocation");
                }
                if (JCTree.JCFieldAccess.class.isAssignableFrom(type)) {
                    return Arrays.asList("J.FieldAccess", "J.Identifier");
                }
                if (JCTree.JCExpression.class.isAssignableFrom(type)) {
                    return Collections.singletonList("Expression");
                }
                if (JCTree.JCStatement.class.isAssignableFrom(type)) {
                    return Collections.singletonList("Statement");
                }
                throw new IllegalArgumentException(type.toString());
            }
        };
    }

    class TemplateDescriptor {
        final JCTree.JCClassDecl classDecl;
        final java.util.List<JCTree.JCMethodDecl> beforeTemplates = new ArrayList<JCTree.JCMethodDecl>();
        JCTree.JCMethodDecl afterTemplate;

        public TemplateDescriptor(JCTree.JCClassDecl classDecl) {
            this.classDecl = classDecl;
        }

        @Nullable
        private TemplateDescriptor validate(Context context, JCTree.JCCompilationUnit cu) {
            if (this.beforeTemplates.isEmpty() || this.afterTemplate == null) {
                return null;
            }
            boolean valid = true;
            for (JCTree member : this.classDecl.getMembers()) {
                if (!(member instanceof JCTree.JCMethodDecl) || this.beforeTemplates.contains(member) || member == this.afterTemplate) continue;
                for (JCTree.JCAnnotation annotation : RefasterTemplateProcessor.getTemplateAnnotations((JCTree.JCMethodDecl)member, (Predicate<String>)UNSUPPORTED_ANNOTATIONS::contains)) {
                    RefasterTemplateProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "The @" + annotation.annotationType + " is currently not supported", ((JCTree.JCMethodDecl)member).sym);
                    valid = false;
                }
            }
            if (valid &= this.resolve(context, cu)) {
                for (JCTree.JCMethodDecl template : this.beforeTemplates) {
                    valid &= this.validateTemplateMethod(template);
                }
                valid &= this.validateTemplateMethod(this.afterTemplate);
            }
            return valid ? this : null;
        }

        private boolean validateTemplateMethod(final JCTree.JCMethodDecl template) {
            boolean valid = true;
            for (JCTree.JCAnnotation annotation : RefasterTemplateProcessor.getTemplateAnnotations(template, (Predicate<String>)UNSUPPORTED_ANNOTATIONS::contains)) {
                RefasterTemplateProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "The @" + annotation.annotationType + " is currently not supported", template.sym);
                valid = false;
            }
            for (JCTree.JCVariableDecl parameter : template.getParameters()) {
                for (JCTree.JCAnnotation annotation : RefasterTemplateProcessor.getTemplateAnnotations(parameter, (Predicate<String>)UNSUPPORTED_ANNOTATIONS::contains)) {
                    RefasterTemplateProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "The @" + annotation.annotationType + " annotation is currently not supported", template.sym);
                    valid = false;
                }
                if (!(parameter.vartype instanceof ParameterizedTypeTree) && !(parameter.vartype.type instanceof Type.TypeVar)) continue;
                RefasterTemplateProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generics are currently not supported", template.sym);
                valid = false;
            }
            if (template.restype instanceof ParameterizedTypeTree || template.restype.type instanceof Type.TypeVar) {
                RefasterTemplateProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generics are currently not supported", template.sym);
                valid = false;
            }
            return valid &= new TreeScanner(){
                boolean valid = true;

                boolean validate(JCTree tree) {
                    this.scan(tree);
                    return this.valid;
                }

                @Override
                public void visitIdent(JCTree.JCIdent jcIdent) {
                    if (jcIdent.sym != null && jcIdent.sym.packge().getQualifiedName().contentEquals("com.google.errorprone.refaster")) {
                        RefasterTemplateProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, jcIdent.type.tsym.getQualifiedName() + " is not supported", template.sym);
                        this.valid = false;
                    }
                }
            }.validate(template.getBody());
        }

        public void beforeTemplate(JCTree.JCMethodDecl method) {
            this.beforeTemplates.add(method);
        }

        public void afterTemplate(JCTree.JCMethodDecl method) {
            this.afterTemplate = method;
        }

        private boolean resolve(Context context, JCTree.JCCompilationUnit cu) {
            try {
                JavacResolution res = new JavacResolution(context);
                this.beforeTemplates.replaceAll(key -> {
                    Map<JCTree, JCTree> resolved = res.resolveAll(context, cu, Collections.singletonList(key));
                    return (JCTree.JCMethodDecl)resolved.get(key);
                });
                Map<JCTree, JCTree> resolved = res.resolveAll(context, cu, Collections.singletonList(this.afterTemplate));
                this.afterTemplate = (JCTree.JCMethodDecl)resolved.get(this.afterTemplate);
            }
            catch (Throwable t) {
                RefasterTemplateProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Had trouble type attributing the template.");
                return false;
            }
            return true;
        }
    }
}

