/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.protobuf;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.protobuf.tree.Proto;
import org.openrewrite.protobuf.tree.ProtoContainer;
import org.openrewrite.protobuf.tree.ProtoLeftPadded;
import org.openrewrite.protobuf.tree.ProtoRightPadded;
import org.openrewrite.protobuf.tree.Space;
import org.openrewrite.protobuf.tree.TypeTree;

public class ProtoVisitor<P>
extends TreeVisitor<Proto, P> {
    public Proto visitBlock(Proto.Block block, P p) {
        Proto.Block b = block;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), p));
        b = b.withMarkers(this.visitMarkers(b.getMarkers(), p));
        b = b.getPadding().withStatements(ListUtils.map(b.getPadding().getStatements(), s -> this.visitRightPadded((ProtoRightPadded)s, p)));
        return b;
    }

    public Proto visitConstant(Proto.Constant constant, P p) {
        Proto.Constant c = constant;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        return c;
    }

    public Proto visitDocument(Proto.Document document, P p) {
        Proto.Document d = document;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), p));
        d = d.withMarkers(this.visitMarkers(d.getMarkers(), p));
        d = d.withSyntax((Proto.Syntax)this.visitSyntax(d.getSyntax(), p));
        d = d.getPadding().withBody(ListUtils.map(d.getPadding().getBody(), it -> this.visitRightPadded((ProtoRightPadded)it, p)));
        return d;
    }

    public Proto visitEmpty(Proto.Empty empty, P p) {
        Proto.Empty e = empty;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), p));
        e = e.withMarkers(this.visitMarkers(e.getMarkers(), p));
        return e;
    }

    public Proto visitEnum(Proto.Enum anEnum, P p) {
        Proto.Enum e = anEnum;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), p));
        e = e.withMarkers(this.visitMarkers(e.getMarkers(), p));
        e = e.withName((Proto.Identifier)this.visit(e.getName(), p));
        e = e.withBody((Proto.Block)this.visit(e.getBody(), p));
        return e;
    }

    public Proto visitEnumField(Proto.EnumField enumField, P p) {
        Proto.EnumField f = enumField;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), p));
        f = f.withMarkers(this.visitMarkers(f.getMarkers(), p));
        f = f.getPadding().withName(this.visitRightPadded(f.getPadding().getName(), p));
        f = f.withNumber((Proto.Constant)this.visit(f.getNumber(), p));
        f = f.getPadding().withOptions(this.visitContainer(f.getPadding().getOptions(), p));
        return f;
    }

    public Proto visitExtend(Proto.Extend extend, P p) {
        Proto.Extend e = extend;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), p));
        e = e.withMarkers(this.visitMarkers(e.getMarkers(), p));
        e = e.withName((Proto.FullIdentifier)this.visitFullIdentifier(e.getName(), p));
        e = e.withBody((Proto.Block)this.visit(e.getBody(), p));
        return e;
    }

    public Proto visitExtensionName(Proto.ExtensionName extensionName, P p) {
        Proto.ExtensionName e = extensionName;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), p));
        e = e.withMarkers(this.visitMarkers(e.getMarkers(), p));
        e = e.getPadding().withExtension(this.visitRightPadded(e.getPadding().getExtension(), p));
        return e;
    }

    public Proto visitField(Proto.Field field, P p) {
        Proto.Field f = field;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), p));
        f = f.withMarkers(this.visitMarkers(f.getMarkers(), p));
        f = f.withLabel((Proto.Keyword)this.visit(f.getLabel(), p));
        f = f.withType((TypeTree)this.visit(f.getType(), p));
        f = f.getPadding().withName(this.visitRightPadded(f.getPadding().getName(), p));
        f = f.withNumber((Proto.Constant)this.visit(f.getNumber(), p));
        f = f.getPadding().withOptions(this.visitContainer(f.getPadding().getOptions(), p));
        return f;
    }

    public Proto visitFullIdentifier(Proto.FullIdentifier fullIdentifier, P p) {
        Proto.FullIdentifier i = fullIdentifier;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), p));
        i = i.withMarkers(this.visitMarkers(i.getMarkers(), p));
        i = i.getPadding().withTarget(this.visitRightPadded(i.getPadding().getTarget(), p));
        i = i.withName((Proto.Identifier)this.visit(i.getName(), p));
        return i;
    }

    public Proto visitIdentifier(Proto.Identifier identifier, P p) {
        Proto.Identifier i = identifier;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), p));
        i = i.withMarkers(this.visitMarkers(i.getMarkers(), p));
        return i;
    }

    public Proto visitImport(Proto.Import anImport, P p) {
        Proto.Import i = anImport;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), p));
        i = i.withMarkers(this.visitMarkers(i.getMarkers(), p));
        i = i.withModifier((Proto.Keyword)this.visit(i.getModifier(), p));
        i = i.getPadding().withName(this.visitRightPadded(i.getPadding().getName(), p));
        return i;
    }

    public Proto visitKeyword(Proto.Keyword keyword, P p) {
        Proto.Keyword k = keyword;
        k = k.withPrefix(this.visitSpace(k.getPrefix(), p));
        k = k.withMarkers(this.visitMarkers(k.getMarkers(), p));
        return k;
    }

    public Proto visitMapField(Proto.MapField mapField, P p) {
        Proto.MapField m = mapField;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), p));
        m = m.withMarkers(this.visitMarkers(m.getMarkers(), p));
        m = m.getPadding().withMap(this.visitRightPadded(m.getPadding().getMap(), p));
        m = m.getPadding().withKeyType(this.visitRightPadded(m.getPadding().getKeyType(), p));
        m = m.getPadding().withValueType(this.visitRightPadded(m.getPadding().getValueType(), p));
        m = m.getPadding().withName(this.visitRightPadded(m.getPadding().getName(), p));
        m = m.getPadding().withOptions(this.visitContainer(m.getPadding().getOptions(), p));
        return m;
    }

    public Proto visitMessage(Proto.Message message, P p) {
        Proto.Message m = message;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), p));
        m = m.withMarkers(this.visitMarkers(m.getMarkers(), p));
        m = m.withName((Proto.Identifier)this.visit(m.getName(), p));
        m = m.withBody((Proto.Block)this.visit(m.getBody(), p));
        return m;
    }

    public Proto visitOneOf(Proto.OneOf oneOf, P p) {
        Proto.OneOf o = oneOf;
        o = o.withPrefix(this.visitSpace(o.getPrefix(), p));
        o = o.withMarkers(this.visitMarkers(o.getMarkers(), p));
        o = o.withName((Proto.Identifier)this.visit(o.getName(), p));
        o = o.withFields((Proto.Block)this.visit(o.getFields(), p));
        return o;
    }

    public Proto visitOption(Proto.Option option, P p) {
        Proto.Option o = option;
        o = o.withPrefix(this.visitSpace(o.getPrefix(), p));
        o = o.withMarkers(this.visitMarkers(o.getMarkers(), p));
        o = o.getPadding().withName(this.visitRightPadded(o.getPadding().getName(), p));
        o = o.withAssignment((Proto.Constant)this.visit(o.getAssignment(), p));
        return o;
    }

    public Proto visitOptionDeclaration(Proto.OptionDeclaration optionDeclaration, P p) {
        Proto.OptionDeclaration o = optionDeclaration;
        o = o.withPrefix(this.visitSpace(o.getPrefix(), p));
        o = o.withMarkers(this.visitMarkers(o.getMarkers(), p));
        o = o.getPadding().withName(this.visitRightPadded(o.getPadding().getName(), p));
        o = o.withAssignment((Proto.Constant)this.visit(o.getAssignment(), p));
        return o;
    }

    public Proto visitPackage(Proto.Package aPackage, P p) {
        Proto.Package pkg = aPackage;
        pkg = pkg.withPrefix(this.visitSpace(pkg.getPrefix(), p));
        pkg = pkg.withMarkers(this.visitMarkers(pkg.getMarkers(), p));
        pkg = pkg.withName((Proto.FullIdentifier)this.visit(pkg.getName(), p));
        return pkg;
    }

    public Proto visitPrimitive(Proto.Primitive primitive, P p) {
        Proto.Primitive pr = primitive;
        pr = pr.withPrefix(this.visitSpace(pr.getPrefix(), p));
        pr = pr.withMarkers(this.visitMarkers(pr.getMarkers(), p));
        return pr;
    }

    public Proto visitRange(Proto.Range range, P p) {
        Proto.Range r = range;
        r = r.withPrefix(this.visitSpace(r.getPrefix(), p));
        r = r.withMarkers(this.visitMarkers(r.getMarkers(), p));
        r = r.getPadding().withFrom(this.visitRightPadded(r.getPadding().getFrom(), p));
        r = r.withTo((Proto.Constant)this.visit(r.getTo(), p));
        return r;
    }

    public Proto visitReserved(Proto.Reserved reserved, P p) {
        Proto.Reserved r = reserved;
        r = r.withPrefix(this.visitSpace(r.getPrefix(), p));
        r = r.withMarkers(this.visitMarkers(r.getMarkers(), p));
        r = r.getPadding().withReservations(this.visitContainer(r.getPadding().getReservations(), p));
        return r;
    }

    public Proto visitRpc(Proto.Rpc rpc, P p) {
        Proto.Rpc r = rpc;
        r = r.withPrefix(this.visitSpace(r.getPrefix(), p));
        r = r.withMarkers(this.visitMarkers(r.getMarkers(), p));
        r = r.withName((Proto.Identifier)this.visit(r.getName(), p));
        r = r.withRequest((Proto.RpcInOut)this.visit(r.getRequest(), p));
        r = r.withReturns((Proto.Keyword)this.visit(r.getReturns(), p));
        r = r.withResponse((Proto.RpcInOut)this.visit(r.getResponse(), p));
        r = r.withBody((Proto.Block)this.visit(r.getBody(), p));
        return r;
    }

    public Proto visitRpcInOut(Proto.RpcInOut rpcInOut, P p) {
        Proto.RpcInOut r = rpcInOut;
        r = r.withPrefix(this.visitSpace(r.getPrefix(), p));
        r = r.withMarkers(this.visitMarkers(r.getMarkers(), p));
        r = r.withStream((Proto.Keyword)this.visit(r.getStream(), p));
        r = r.getPadding().withType(this.visitRightPadded(r.getPadding().getType(), p));
        return r;
    }

    public Proto visitService(Proto.Service service, P p) {
        Proto.Service s = service;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), p));
        s = s.withMarkers(this.visitMarkers(s.getMarkers(), p));
        s = s.withName((Proto.Identifier)this.visit(s.getName(), p));
        s = s.withBody((Proto.Block)this.visit(s.getBody(), p));
        return s;
    }

    public Proto visitStringLiteral(Proto.StringLiteral stringLiteral, P p) {
        Proto.StringLiteral s = stringLiteral;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), p));
        s = s.withMarkers(this.visitMarkers(s.getMarkers(), p));
        return s;
    }

    public Proto visitSyntax(Proto.Syntax syntax, P p) {
        Proto.Syntax s = syntax;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), p));
        s = s.withMarkers(this.visitMarkers(s.getMarkers(), p));
        s = s.withKeywordSuffix(this.visitSpace(s.getKeywordSuffix(), p));
        s = s.getPadding().withLevel(this.visitRightPadded(s.getPadding().getLevel(), p));
        return s;
    }

    public Space visitSpace(Space space, P p) {
        return space;
    }

    public <P2 extends Proto> @Nullable ProtoContainer<P2> visitContainer(@Nullable ProtoContainer<P2> container, P p) {
        if (container == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), container));
        Space before = this.visitSpace(container.getBefore(), p);
        List ps = ListUtils.map(container.getPadding().getElements(), t -> this.visitRightPadded((ProtoRightPadded)t, p));
        this.setCursor(this.getCursor().getParent());
        return ps == container.getPadding().getElements() && before == container.getBefore() ? container : ProtoContainer.build(before, ps, container.getMarkers());
    }

    public <T> @Nullable ProtoLeftPadded<T> visitLeftPadded(ProtoLeftPadded<T> left, P p) {
        this.setCursor(new Cursor(this.getCursor(), left));
        Space before = this.visitSpace(left.getBefore(), p);
        Object t = left.getElement();
        if (t instanceof Proto) {
            t = this.visitAndCast((Proto)left.getElement(), p);
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            return null;
        }
        return before == left.getBefore() && t == left.getElement() ? left : new ProtoLeftPadded<T>(before, t, left.getMarkers());
    }

    public <T> @Nullable ProtoRightPadded<T> visitRightPadded(@Nullable ProtoRightPadded<T> right, P p) {
        if (right == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), right));
        Object t = right.getElement();
        if (t instanceof Proto) {
            t = this.visit((Proto)right.getElement(), p);
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            return null;
        }
        Space after = this.visitSpace(right.getAfter(), p);
        return after == right.getAfter() && t == right.getElement() ? right : new ProtoRightPadded<T>(t, after, right.getMarkers());
    }
}

