/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.protobuf;

import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.ParseError;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.protobuf.ProtoParsingException;
import org.openrewrite.protobuf.internal.ProtoParserVisitor;
import org.openrewrite.protobuf.internal.grammar.Protobuf2Lexer;
import org.openrewrite.protobuf.internal.grammar.Protobuf2Parser;
import org.openrewrite.protobuf.tree.Proto;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class ProtoParser
implements Parser {
    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingEventListener parsingListener = ParsingExecutionContextView.view((ExecutionContext)ctx).getParsingListener();
        return this.acceptedInputs(sourceFiles).map(sourceFile -> {
            Path path = sourceFile.getRelativePath(relativeTo);
            try {
                EncodingDetectingInputStream is = sourceFile.getSource(ctx);
                String sourceStr = is.readFully();
                Protobuf2Parser parser = new Protobuf2Parser((TokenStream)new CommonTokenStream((TokenSource)new Protobuf2Lexer((CharStream)CharStreams.fromString((String)sourceStr))));
                parser.removeErrorListeners();
                parser.addErrorListener((ANTLRErrorListener)new ForwardingErrorListener(sourceFile.getPath(), ctx));
                if (sourceStr.contains("proto3")) {
                    return null;
                }
                Proto.Document document = new ProtoParserVisitor(path, sourceFile.getFileAttributes(), sourceStr, is.getCharset(), is.isCharsetBomMarked()).visitProto(parser.proto());
                parsingListener.parsed(sourceFile, (SourceFile)document);
                return document;
            }
            catch (Throwable t) {
                ctx.getOnError().accept(t);
                return ParseError.build((Parser)this, (Parser.Input)sourceFile, (Path)relativeTo, (ExecutionContext)ctx, (Throwable)t);
            }
        }).filter(Objects::nonNull);
    }

    public Stream<SourceFile> parse(String ... sources) {
        return this.parse((ExecutionContext)new InMemoryExecutionContext(), sources);
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".proto");
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.proto");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Parser.Builder {
        public Builder() {
            super(Proto.Document.class);
        }

        public ProtoParser build() {
            return new ProtoParser();
        }

        public String getDslName() {
            return "proto";
        }
    }

    private static class ForwardingErrorListener
    extends BaseErrorListener {
        private final Path sourcePath;
        private final ExecutionContext ctx;

        private ForwardingErrorListener(Path sourcePath, ExecutionContext ctx) {
            this.sourcePath = sourcePath;
            this.ctx = ctx;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.ctx.getOnError().accept(new ProtoParsingException(this.sourcePath, String.format("Syntax error in %s at line %d:%d %s.", this.sourcePath, line, charPositionInLine, msg), (Throwable)e));
        }
    }
}

