/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.protobuf.internal;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.protobuf.internal.grammar.Protobuf2Parser;
import org.openrewrite.protobuf.internal.grammar.Protobuf2ParserBaseVisitor;
import org.openrewrite.protobuf.tree.FullName;
import org.openrewrite.protobuf.tree.Proto;
import org.openrewrite.protobuf.tree.ProtoContainer;
import org.openrewrite.protobuf.tree.ProtoRightPadded;
import org.openrewrite.protobuf.tree.Space;
import org.openrewrite.protobuf.tree.TypeTree;

public class ProtoParserVisitor
extends Protobuf2ParserBaseVisitor<Proto> {
    private final Path path;
    private final String source;
    private final Charset charset;
    private final boolean charsetBomMarked;
    private int cursor = 0;

    public ProtoParserVisitor(Path path, String source, Charset charset, boolean charsetBomMarked) {
        this.path = path;
        this.source = source;
        this.charset = charset;
        this.charsetBomMarked = charsetBomMarked;
    }

    public Proto.Block visitBlock(List<ParseTree> statementTrees) {
        Space bodyPrefix = this.sourceBefore("{");
        ArrayList<ProtoRightPadded<Proto>> statements = new ArrayList<ProtoRightPadded<Proto>>(statementTrees.size() - 2);
        for (int i = 1; i < statementTrees.size() - 1; ++i) {
            Proto s = (Proto)this.visit(statementTrees.get(i));
            statements.add(ProtoRightPadded.build(s).withAfter(s instanceof Proto.Empty || s instanceof Proto.Field || s instanceof Proto.Import || s instanceof Proto.MapField || s instanceof Proto.OptionDeclaration || s instanceof Proto.Package || s instanceof Proto.Reserved || s instanceof Proto.Rpc && ((Proto.Rpc)s).getBody() == null || s instanceof Proto.Syntax ? this.sourceBefore(";") : Space.EMPTY));
        }
        return new Proto.Block(Tree.randomId(), bodyPrefix, Markers.EMPTY, statements, this.sourceBefore("}"));
    }

    @Override
    public Proto.Constant visitConstant(Protobuf2Parser.ConstantContext ctx) {
        String sourceValue;
        String source = sourceValue = ctx.getChild(0).getText();
        if (ctx.StringLiteral() != null) {
            source = source.substring(1, source.length() - 1);
        }
        return new Proto.Constant(Tree.randomId(), this.sourceBefore(sourceValue), Markers.EMPTY, source, sourceValue);
    }

    @Override
    public Proto.Empty visitEmptyStatement(Protobuf2Parser.EmptyStatementContext ctx) {
        return new Proto.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY);
    }

    @Override
    public Proto.Enum visitEnumDefinition(Protobuf2Parser.EnumDefinitionContext ctx) {
        return new Proto.Enum(Tree.randomId(), this.sourceBefore("enum"), Markers.EMPTY, this.visitIdent(ctx.ident()), this.visitBlock(ctx.enumBody().children));
    }

    @Override
    public Proto.EnumField visitEnumField(Protobuf2Parser.EnumFieldContext ctx) {
        Proto.Identifier name = this.visitIdent(ctx.ident());
        return new Proto.EnumField(Tree.randomId(), name.getPrefix(), Markers.EMPTY, ProtoRightPadded.build(name.withPrefix(Space.EMPTY)).withAfter(this.sourceBefore("=")), this.mapConstant(ctx.IntegerLiteral()), this.mapOptionList(ctx.optionList()));
    }

    @Override
    public Proto.Extend visitExtend(Protobuf2Parser.ExtendContext ctx) {
        Space prefix = this.sourceBefore("extend");
        Proto.FullIdentifier name = this.visitFullIdent(ctx.fullIdent());
        Space blockPrefix = this.sourceBefore("{");
        ArrayList<ProtoRightPadded<Proto>> statements = new ArrayList<ProtoRightPadded<Proto>>(ctx.messageField().size());
        for (Protobuf2Parser.MessageFieldContext mfc : ctx.messageField()) {
            statements.add(new ProtoRightPadded<Proto.Field>(this.visitMessageField(mfc), this.sourceBefore(";"), Markers.EMPTY));
        }
        return new Proto.Extend(Tree.randomId(), prefix, Markers.EMPTY, name, new Proto.Block(Tree.randomId(), blockPrefix, Markers.EMPTY, statements, this.sourceBefore("}")));
    }

    @Override
    public Proto.Field visitField(Protobuf2Parser.FieldContext ctx) {
        TypeTree type = (TypeTree)this.visit((ParseTree)ctx.type());
        return new Proto.Field(Tree.randomId(), type.getPrefix(), Markers.EMPTY, null, (TypeTree)type.withPrefix(Space.EMPTY), ProtoRightPadded.build(this.visitIdentOrReserved(ctx.fieldName)).withAfter(this.sourceBefore("=")), this.mapConstant(ctx.IntegerLiteral()), this.mapOptionList(ctx.optionList()));
    }

    @Override
    public Proto visitFullyQualifiedType(Protobuf2Parser.FullyQualifiedTypeContext ctx) {
        return this.visitFullIdent(ctx.fullIdent());
    }

    @Override
    public Proto.Import visitImportStatement(Protobuf2Parser.ImportStatementContext ctx) {
        Space prefix = this.sourceBefore("import");
        Proto.Keyword modifier = null;
        if (ctx.WEAK() != null) {
            modifier = new Proto.Keyword(Tree.randomId(), this.sourceBefore(ctx.WEAK().getText()), Markers.EMPTY, ctx.WEAK().getText());
        } else if (ctx.PUBLIC() != null) {
            modifier = new Proto.Keyword(Tree.randomId(), this.sourceBefore(ctx.PUBLIC().getText()), Markers.EMPTY, ctx.PUBLIC().getText());
        }
        Protobuf2Parser.StringLiteralContext s = ctx.stringLiteral();
        String lit = s.getText();
        return new Proto.Import(Tree.randomId(), prefix, Markers.EMPTY, modifier, ProtoRightPadded.build(new Proto.StringLiteral(Tree.randomId(), this.sourceBefore(lit), Markers.EMPTY, lit.startsWith("'"), lit.substring(1, lit.length() - 1))));
    }

    @Override
    public Proto.Primitive visitPrimitiveType(Protobuf2Parser.PrimitiveTypeContext ctx) {
        return new Proto.Primitive(Tree.randomId(), this.sourceBefore(ctx.getText()), Markers.EMPTY, Proto.Primitive.Type.valueOf(ctx.getText().toUpperCase()));
    }

    @Override
    public Proto.FullIdentifier visitFullIdent(Protobuf2Parser.FullIdentContext ctx) {
        Space prefix = this.prefix(ctx.identOrReserved(0));
        return (Proto.FullIdentifier)this.visitFullIdent(ctx.identOrReserved(), 0, null).withPrefix(prefix);
    }

    private FullName visitFullIdent(List<? extends ParseTree> idents, int start, @Nullable FullName prefix) {
        FullName fi = prefix;
        for (int j = start; j < idents.size(); ++j) {
            ParseTree i = idents.get(j);
            if (!(i instanceof Protobuf2Parser.IdentOrReservedContext) && !(i instanceof Protobuf2Parser.ReservedWordContext)) continue;
            ProtoRightPadded<FullName> previous = fi == null ? null : ProtoRightPadded.build(fi).withAfter(this.sourceBefore("."));
            fi = new Proto.FullIdentifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, previous, (Proto.Identifier)this.visit(i));
        }
        assert (fi != null);
        return fi;
    }

    @Override
    public Proto.Identifier visitIdentOrReserved(Protobuf2Parser.IdentOrReservedContext ctx) {
        String name = ctx.ident() == null ? ctx.reservedWord().getText() : ctx.ident().getText();
        return new Proto.Identifier(Tree.randomId(), this.sourceBefore(name), Markers.EMPTY, name);
    }

    @Override
    public Proto.Identifier visitIdent(Protobuf2Parser.IdentContext ctx) {
        String name = ctx.Ident().getText();
        return new Proto.Identifier(Tree.randomId(), this.sourceBefore(name), Markers.EMPTY, name);
    }

    @Override
    public Proto.MapField visitMapField(Protobuf2Parser.MapFieldContext ctx) {
        return new Proto.MapField(Tree.randomId(), this.sourceBefore("map"), Markers.EMPTY, ProtoRightPadded.build(new Proto.Keyword(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "map")).withAfter(this.sourceBefore("<")), ProtoRightPadded.build(new Proto.Keyword(Tree.randomId(), this.sourceBefore(ctx.keyType().getText()), Markers.EMPTY, ctx.keyType().getText())).withAfter(this.sourceBefore(",")), ProtoRightPadded.build((TypeTree)this.visit((ParseTree)ctx.type())).withAfter(this.sourceBefore(">")), ProtoRightPadded.build(this.visitIdent(ctx.ident())).withAfter(this.sourceBefore("=")), this.mapConstant(ctx.IntegerLiteral()), this.mapOptionList(ctx.optionList()));
    }

    private Proto.Constant mapConstant(TerminalNode integerLiteral) {
        String number = integerLiteral.getText();
        Integer numberValue = number.contains("x") ? Integer.parseInt(number, 16) : (number.startsWith("0") ? Integer.parseInt(number, 8) : Integer.parseInt(number));
        return new Proto.Constant(Tree.randomId(), this.sourceBefore(number), Markers.EMPTY, numberValue, number);
    }

    @Override
    public Proto.Message visitMessage(Protobuf2Parser.MessageContext ctx) {
        return new Proto.Message(Tree.randomId(), this.sourceBefore("message"), Markers.EMPTY, this.visitIdent(ctx.ident()), this.visitBlock(ctx.messageBody().children));
    }

    @Override
    public Proto.Field visitMessageField(Protobuf2Parser.MessageFieldContext ctx) {
        String label = ctx.getChild(0).getText();
        Space labelPrefix = this.sourceBefore(label);
        Proto.Field field = this.visitField(ctx.field());
        return field.withType((TypeTree)field.getType().withPrefix(field.getPrefix())).withLabel(new Proto.Keyword(Tree.randomId(), Space.EMPTY, Markers.EMPTY, label)).withPrefix(labelPrefix);
    }

    @Override
    public Proto visitOneOf(Protobuf2Parser.OneOfContext ctx) {
        Space prefix = this.sourceBefore("oneof");
        Proto.Identifier ident = this.visitIdent(ctx.ident());
        Space fieldsPrefix = this.sourceBefore("{");
        ArrayList<ProtoRightPadded<Proto>> fields = new ArrayList<ProtoRightPadded<Proto>>(ctx.field().size());
        List<Protobuf2Parser.FieldContext> fieldContexts = ctx.field();
        for (Protobuf2Parser.FieldContext field : fieldContexts) {
            fields.add(new ProtoRightPadded<Proto.Field>(this.visitField(field), this.sourceBefore(";"), Markers.EMPTY));
        }
        return new Proto.OneOf(Tree.randomId(), prefix, Markers.EMPTY, ident, new Proto.Block(Tree.randomId(), fieldsPrefix, Markers.EMPTY, fields, this.sourceBefore("}")));
    }

    @Override
    public Proto visitOptionDef(Protobuf2Parser.OptionDefContext ctx) {
        return new Proto.OptionDeclaration(Tree.randomId(), this.sourceBefore("option"), Markers.EMPTY, ProtoRightPadded.build(this.visitOptionName(ctx.option().optionName())).withAfter(this.sourceBefore("=")), this.visitConstant(ctx.option().constant()));
    }

    @Override
    public Proto.Option visitOption(Protobuf2Parser.OptionContext ctx) {
        ProtoRightPadded<FullName> name = ProtoRightPadded.build(this.visitOptionName(ctx.optionName())).withAfter(this.sourceBefore("="));
        return new Proto.Option(Tree.randomId(), name.getElement().getPrefix(), Markers.EMPTY, name.withElement((FullName)name.getElement().withPrefix(Space.EMPTY)), this.visitConstant(ctx.constant()));
    }

    @Override
    public FullName visitOptionName(Protobuf2Parser.OptionNameContext ctx) {
        FullName name;
        if (ctx.fullIdent() != null) {
            name = new Proto.ExtensionName(Tree.randomId(), this.sourceBefore("("), Markers.EMPTY, ProtoRightPadded.build(this.visitFullIdent(ctx.fullIdent())).withAfter(this.sourceBefore(")")));
        } else {
            Proto.Identifier ident = this.visitIdent(ctx.ident());
            name = new Proto.FullIdentifier(Tree.randomId(), ident.getPrefix(), Markers.EMPTY, null, ident.withPrefix(Space.EMPTY));
        }
        if (ctx.children.size() > 1) {
            return this.visitFullIdent(ctx.children, 1, name);
        }
        return name;
    }

    @Nullable
    private ProtoContainer<Proto.Option> mapOptionList(@Nullable Protobuf2Parser.OptionListContext ctx) {
        if (ctx == null) {
            return null;
        }
        Space optionsPrefix = this.sourceBefore("[");
        ArrayList fieldOptions = new ArrayList(ctx.option().size());
        List<Protobuf2Parser.OptionContext> fieldOption = ctx.option();
        for (int i = 0; i < fieldOption.size(); ++i) {
            Protobuf2Parser.OptionContext o = fieldOption.get(i);
            FullName name = this.visitOptionName(o.optionName());
            Proto.Option opt = new Proto.Option(Tree.randomId(), name.getPrefix(), Markers.EMPTY, ProtoRightPadded.build((FullName)name.withPrefix(Space.EMPTY)).withAfter(this.sourceBefore("=")), this.visitConstant(o.constant()));
            fieldOptions.add(ProtoRightPadded.build(opt).withAfter(this.sourceBefore(i == fieldOption.size() - 1 ? "]" : ",")));
        }
        return ProtoContainer.build(fieldOptions).withBefore(optionsPrefix);
    }

    @Override
    public Proto visitPackageStatement(Protobuf2Parser.PackageStatementContext ctx) {
        return new Proto.Package(Tree.randomId(), this.sourceBefore("package"), Markers.EMPTY, this.visitFullIdent(ctx.fullIdent()));
    }

    @Override
    public Proto.Document visitProto(Protobuf2Parser.ProtoContext ctx) {
        Proto.Syntax syntax = this.visitSyntax(ctx.syntax());
        ArrayList<ProtoRightPadded<Proto>> list = new ArrayList<ProtoRightPadded<Proto>>();
        for (int i = 1; i < ctx.children.size() - 1; ++i) {
            Proto s = (Proto)this.visit((ParseTree)ctx.children.get(i));
            ProtoRightPadded<Proto> protoProtoRightPadded = ProtoRightPadded.build(s).withAfter(s instanceof Proto.Empty || s instanceof Proto.Import || s instanceof Proto.MapField || s instanceof Proto.OptionDeclaration || s instanceof Proto.Package || s instanceof Proto.Syntax ? this.sourceBefore(";") : Space.EMPTY);
            list.add(protoProtoRightPadded);
        }
        return new Proto.Document(Tree.randomId(), this.path, this.charset.name(), this.charsetBomMarked, syntax.getPrefix(), Markers.EMPTY, syntax.withPrefix(Space.EMPTY), list, Space.format(this.source.substring(this.cursor)));
    }

    @Override
    public Proto.Range visitRange(Protobuf2Parser.RangeContext ctx) {
        Proto.Constant to = this.mapConstant(ctx.IntegerLiteral(0));
        return new Proto.Range(Tree.randomId(), to.getPrefix(), Markers.EMPTY, ProtoRightPadded.build(to.withPrefix(Space.EMPTY)).withAfter(this.sourceBefore("to")), this.mapConstant(ctx.IntegerLiteral(1)));
    }

    @Override
    public Proto.Reserved visitReserved(Protobuf2Parser.ReservedContext ctx) {
        ArrayList reservations;
        Space prefix = this.sourceBefore("reserved");
        if (ctx.fieldNames() != null) {
            List<Protobuf2Parser.StringLiteralContext> stringLiterals = ctx.fieldNames().stringLiteral();
            reservations = new ArrayList(stringLiterals.size());
            for (int i = 0; i < stringLiterals.size(); ++i) {
                Protobuf2Parser.StringLiteralContext s = stringLiterals.get(i);
                String lit = s.getText();
                reservations.add(ProtoRightPadded.build(new Proto.Constant(Tree.randomId(), this.sourceBefore(lit), Markers.EMPTY, lit.substring(1, lit.length() - 1), lit)).withAfter(i == stringLiterals.size() - 1 ? Space.EMPTY : this.sourceBefore(",")));
            }
        } else {
            List<Protobuf2Parser.RangeContext> ranges = ctx.ranges().range();
            reservations = new ArrayList(ranges.size());
            for (int i = 0; i < ranges.size(); ++i) {
                Protobuf2Parser.RangeContext r = ranges.get(i);
                reservations.add(ProtoRightPadded.build(this.visitRange(r)).withAfter(i == ranges.size() - 1 ? Space.EMPTY : this.sourceBefore(",")));
            }
        }
        return new Proto.Reserved(Tree.randomId(), prefix, Markers.EMPTY, ProtoContainer.build(reservations));
    }

    @Override
    public Proto visitReservedWord(Protobuf2Parser.ReservedWordContext ctx) {
        String word = ctx.getChild(0).getText();
        return new Proto.Identifier(Tree.randomId(), this.sourceBefore(word), Markers.EMPTY, word);
    }

    @Override
    public Proto visitRpc(Protobuf2Parser.RpcContext ctx) {
        return new Proto.Rpc(Tree.randomId(), this.sourceBefore("rpc"), Markers.EMPTY, this.visitIdent(ctx.ident()), this.visitRpcInOut(ctx.rpcInOut(0)), new Proto.Keyword(Tree.randomId(), this.sourceBefore("returns"), Markers.EMPTY, "returns"), this.visitRpcInOut(ctx.rpcInOut(1)), ctx.rpcBody() == null ? null : this.visitBlock(ctx.rpcBody().children));
    }

    @Override
    public Proto.RpcInOut visitRpcInOut(Protobuf2Parser.RpcInOutContext ctx) {
        return new Proto.RpcInOut(Tree.randomId(), this.sourceBefore("("), Markers.EMPTY, ctx.STREAM() == null ? null : new Proto.Keyword(Tree.randomId(), this.sourceBefore("stream"), Markers.EMPTY, "stream"), ProtoRightPadded.build((FullName)this.visit((ParseTree)ctx.fullIdent())).withAfter(this.sourceBefore(")")));
    }

    @Override
    public Proto visitService(Protobuf2Parser.ServiceContext ctx) {
        return new Proto.Service(Tree.randomId(), this.sourceBefore("service"), Markers.EMPTY, this.visitIdent(ctx.ident()), this.visitBlock(ctx.serviceBody().children));
    }

    @Override
    public Proto.Syntax visitSyntax(Protobuf2Parser.SyntaxContext ctx) {
        String level = ctx.stringLiteral().StringLiteral().getText();
        return new Proto.Syntax(Tree.randomId(), this.sourceBefore("syntax"), Markers.EMPTY, this.sourceBefore("="), ProtoRightPadded.build(new Proto.Constant(Tree.randomId(), this.sourceBefore(level), Markers.EMPTY, level.substring(1, level.length() - 1), level)).withAfter(this.sourceBefore(";")));
    }

    private Space prefix(ParserRuleContext ctx) {
        return this.prefix(ctx.getStart());
    }

    private Space prefix(@Nullable TerminalNode terminalNode) {
        return terminalNode == null ? Space.EMPTY : this.prefix(terminalNode.getSymbol());
    }

    private Space prefix(Token token) {
        int start = token.getStartIndex();
        if (start < this.cursor) {
            return Space.EMPTY;
        }
        String prefix = this.source.substring(this.cursor, start);
        this.cursor = start;
        return Space.format(prefix);
    }

    @Nullable
    private <C extends ParserRuleContext, T> T convert(C ctx, BiFunction<C, Space, T> conversion) {
        if (ctx == null) {
            return null;
        }
        T t = conversion.apply(ctx, this.prefix(ctx));
        if (ctx.getStop() != null) {
            this.cursor = ctx.getStop().getStopIndex() + (Character.isWhitespace(this.source.charAt(ctx.getStop().getStopIndex())) ? 0 : 1);
        }
        return t;
    }

    private <T> T convert(TerminalNode node, BiFunction<TerminalNode, Space, T> conversion) {
        T t = conversion.apply(node, this.prefix(node));
        this.cursor = node.getSymbol().getStopIndex() + 1;
        return t;
    }

    private void skip(TerminalNode node) {
        this.cursor = node.getSymbol().getStopIndex() + 1;
    }

    private Space sourceBefore(String untilDelim) {
        int delimIndex = this.positionOfNext(untilDelim, null);
        if (delimIndex < 0) {
            return Space.EMPTY;
        }
        String prefix = this.source.substring(this.cursor, delimIndex);
        this.cursor += prefix.length() + untilDelim.length();
        return Space.format(prefix);
    }

    private int positionOfNext(String untilDelim, @Nullable Character stop) {
        int delimIndex;
        boolean inMultiLineComment = false;
        boolean inSingleLineComment = false;
        for (delimIndex = this.cursor; delimIndex < this.source.length() - untilDelim.length() + 1; ++delimIndex) {
            if (inSingleLineComment) {
                if (this.source.charAt(delimIndex) != '\n') continue;
                inSingleLineComment = false;
                continue;
            }
            if (this.source.length() - untilDelim.length() > delimIndex + 1) {
                switch (this.source.substring(delimIndex, delimIndex + 2)) {
                    case "//": {
                        inSingleLineComment = true;
                        ++delimIndex;
                        break;
                    }
                    case "/*": {
                        inMultiLineComment = true;
                        ++delimIndex;
                        break;
                    }
                    case "*/": {
                        inMultiLineComment = false;
                        delimIndex += 2;
                    }
                }
            }
            if (inMultiLineComment || inSingleLineComment) continue;
            if (stop != null && this.source.charAt(delimIndex) == stop.charValue()) {
                return -1;
            }
            if (this.source.startsWith(untilDelim, delimIndex)) break;
        }
        return delimIndex > this.source.length() - untilDelim.length() ? -1 : delimIndex;
    }
}

