/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.protobuf;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.protobuf.ProtoParsingException;
import org.openrewrite.protobuf.internal.ProtoParserVisitor;
import org.openrewrite.protobuf.internal.grammar.Protobuf2Lexer;
import org.openrewrite.protobuf.internal.grammar.Protobuf2Parser;
import org.openrewrite.protobuf.tree.Proto;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class ProtoParser
implements Parser<Proto.Document> {
    public List<Proto.Document> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingEventListener parsingListener = ParsingExecutionContextView.view((ExecutionContext)ctx).getParsingListener();
        return this.acceptedInputs(sourceFiles).stream().map(sourceFile -> {
            Timer.Builder timer = Timer.builder((String)"rewrite.parse").description("The time spent parsing a Protobuf file").tag("file.type", "Proto");
            Timer.Sample sample = Timer.start();
            try (InputStream sourceStream = sourceFile.getSource();){
                Protobuf2Parser parser = new Protobuf2Parser((TokenStream)new CommonTokenStream((TokenSource)new Protobuf2Lexer(CharStreams.fromStream((InputStream)sourceStream))));
                parser.removeErrorListeners();
                parser.addErrorListener((ANTLRErrorListener)new ForwardingErrorListener(sourceFile.getPath(), ctx));
                String source = StringUtils.readFully((InputStream)sourceFile.getSource());
                if (source.contains("proto3")) {
                    Proto.Document document2 = null;
                    return document2;
                }
                Proto.Document document3 = new ProtoParserVisitor(sourceFile.getRelativePath(relativeTo), source).visitProto(parser.proto());
                sample.stop(MetricsHelper.successTags((Timer.Builder)timer).register((MeterRegistry)Metrics.globalRegistry));
                parsingListener.parsed(sourceFile, (SourceFile)document3);
                Proto.Document document = document3;
                return document;
            }
            catch (Throwable t) {
                sample.stop(MetricsHelper.errorTags((Timer.Builder)timer, (Throwable)t).register((MeterRegistry)Metrics.globalRegistry));
                ctx.getOnError().accept(new IllegalStateException(sourceFile.getPath() + " " + t.getMessage(), t));
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Proto.Document> parse(String ... sources) {
        return this.parse((ExecutionContext)new InMemoryExecutionContext(), sources);
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".proto");
    }

    private static class ForwardingErrorListener
    extends BaseErrorListener {
        private final Path sourcePath;
        private final ExecutionContext ctx;

        private ForwardingErrorListener(Path sourcePath, ExecutionContext ctx) {
            this.sourcePath = sourcePath;
            this.ctx = ctx;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.ctx.getOnError().accept(new ProtoParsingException(this.sourcePath, String.format("Syntax error in %s at line %d:%d %s.", this.sourcePath, line, charPositionInLine, msg), (Throwable)e));
        }
    }
}

