/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties.trait;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.trait.Reference;
import org.openrewrite.trait.SimpleTraitMatcher;

public final class PropertiesReference
implements Reference {
    private final Cursor cursor;
    private final Reference.Kind kind;

    public String getValue() {
        if (this.getTree() instanceof Properties.Entry) {
            return ((Properties.Entry)this.getTree()).getValue().getText();
        }
        throw new IllegalArgumentException("getTree() must be an Properties.Entry: " + this.getTree().getClass());
    }

    public boolean supportsRename() {
        return true;
    }

    public Tree rename(Reference.Renamer renamer, Cursor cursor, ExecutionContext ctx) {
        Tree tree = (Tree)cursor.getValue();
        if (tree instanceof Properties.Entry) {
            Properties.Entry entry = (Properties.Entry)tree;
            String newValueText = renamer.rename((Reference)this);
            return entry.withValue(entry.getValue().withText(newValueText));
        }
        return tree;
    }

    @Generated
    public PropertiesReference(Cursor cursor, Reference.Kind kind) {
        this.cursor = cursor;
        this.kind = kind;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    @Generated
    public Reference.Kind getKind() {
        return this.kind;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertiesReference)) {
            return false;
        }
        PropertiesReference other = (PropertiesReference)o;
        Cursor this$cursor = this.getCursor();
        Cursor other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        Reference.Kind this$kind = this.getKind();
        Reference.Kind other$kind = other.getKind();
        return !(this$kind == null ? other$kind != null : !this$kind.equals(other$kind));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cursor $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        Reference.Kind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "PropertiesReference(cursor=" + this.getCursor() + ", kind=" + this.getKind() + ")";
    }

    public static class Provider
    extends Reference.AbstractProvider<PropertiesReference> {
        private static final Predicate<String> applicationPropertiesMatcher = Pattern.compile("^application(-\\w+)?\\.properties$").asPredicate();
        private static final SimpleTraitMatcher<PropertiesReference> matcher = new SimpleTraitMatcher<PropertiesReference>(){
            private final Predicate<String> javaFullyQualifiedTypeMatcher = Pattern.compile("^\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*$").asPredicate();

            protected @Nullable PropertiesReference test(Cursor cursor) {
                Object value = cursor.getValue();
                if (value instanceof Properties.Entry && this.javaFullyQualifiedTypeMatcher.test(((Properties.Entry)value).getValue().getText())) {
                    return new PropertiesReference(cursor, this.determineKind(((Properties.Entry)value).getValue().getText()));
                }
                return null;
            }

            private Reference.Kind determineKind(String value) {
                return Character.isUpperCase(value.charAt(value.lastIndexOf(46) + 1)) ? Reference.Kind.TYPE : Reference.Kind.PACKAGE;
            }
        };

        public boolean isAcceptable(SourceFile sourceFile) {
            return sourceFile instanceof Properties.File && applicationPropertiesMatcher.test(sourceFile.getSourcePath().getFileName().toString());
        }

        public SimpleTraitMatcher<PropertiesReference> getMatcher() {
            return matcher;
        }
    }
}

