/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;

public final class DeleteProperty
extends Recipe {
    @Option(displayName="Property key matcher", description="The key(s) to be deleted. This is a glob expression.", example="management.metrics.binders.files.enabled or management.metrics.*")
    private final String propertyKey;
    @Option(displayName="Use relaxed binding", description="Whether to match the `propertyKey` using [relaxed binding](https://docs.spring.io/spring-boot/docs/2.5.6/reference/html/features.html#features.external-config.typesafe-configuration-properties.relaxed-binding) rules. Default is `true`. Set to `false`  to use exact matching.", required=false)
    @Nullable
    private final Boolean relaxedBinding;

    public String getDisplayName() {
        return "Delete Property";
    }

    public String getDescription() {
        return "Deletes key/value pairs from properties files.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new PropertiesVisitor<ExecutionContext>(){

            @Override
            public Properties visitFile(Properties.File file, ExecutionContext ctx) {
                Properties.File f = (Properties.File)super.visitFile(file, ctx);
                String prefix = null;
                List<Properties.Content> contents = f.getContent();
                ArrayList<Properties.Content> newContents = new ArrayList<Properties.Content>();
                for (int i = 0; i < contents.size(); ++i) {
                    Properties.Content content = contents.get(i);
                    if (content instanceof Properties.Entry && this.isMatch(((Properties.Entry)content).getKey())) {
                        if (i != 0) continue;
                        prefix = ((Properties.Entry)content).getPrefix();
                        continue;
                    }
                    if (prefix != null) {
                        content = (Properties.Content)content.withPrefix(prefix);
                        prefix = null;
                    }
                    newContents.add(content);
                }
                return contents.size() == newContents.size() ? f : f.withContent(newContents);
            }

            private boolean isMatch(String key) {
                if (!Boolean.FALSE.equals(DeleteProperty.this.relaxedBinding)) {
                    return StringUtils.matchesGlob((String)NameCaseConvention.LOWER_CAMEL.format(key), (String)NameCaseConvention.LOWER_CAMEL.format(DeleteProperty.this.propertyKey));
                }
                return StringUtils.matchesGlob((String)key, (String)DeleteProperty.this.propertyKey);
            }
        };
    }

    @Generated
    public DeleteProperty(String propertyKey, @Nullable Boolean relaxedBinding) {
        this.propertyKey = propertyKey;
        this.relaxedBinding = relaxedBinding;
    }

    @Generated
    public String getPropertyKey() {
        return this.propertyKey;
    }

    @Nullable
    @Generated
    public Boolean getRelaxedBinding() {
        return this.relaxedBinding;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DeleteProperty(propertyKey=" + this.getPropertyKey() + ", relaxedBinding=" + this.getRelaxedBinding() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteProperty)) {
            return false;
        }
        DeleteProperty other = (DeleteProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$relaxedBinding = this.getRelaxedBinding();
        Boolean other$relaxedBinding = other.getRelaxedBinding();
        if (this$relaxedBinding == null ? other$relaxedBinding != null : !((Object)this$relaxedBinding).equals(other$relaxedBinding)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        return !(this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeleteProperty;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $relaxedBinding = this.getRelaxedBinding();
        result = result * 59 + ($relaxedBinding == null ? 43 : ((Object)$relaxedBinding).hashCode());
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        return result;
    }
}

