/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties;

import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.properties.PropertiesIsoVisitor;
import org.openrewrite.properties.search.FindProperties;
import org.openrewrite.properties.tree.Properties;

public final class AddProperty
extends Recipe {
    @Option(displayName="Property key", description="The property key to add.", example="management.metrics.enable.process.files")
    private final String property;
    @Option(displayName="Property value", description="The value of the new property key.")
    private final String value;
    @Option(displayName="Optional comment to be prepended to the property", description="A comment that will be added to the new property.", required=false, example="This is a comment")
    @Nullable
    private final String comment;
    @Option(displayName="Optional delimiter", description="Property entries support different delimiters (`=`, `:`, or whitespace). The default value is `=` unless provided the delimiter of the new property entry.", required=false, example=":")
    @Nullable
    private final String delimiter;

    public String getDisplayName() {
        return "Add a new property";
    }

    public String getDescription() {
        return "Adds a new property to a property file. Attempts to place the new property in alphabetical order by the property keys. Whitespace before and after the `=` must be included in the property and value.";
    }

    public Validated<Object> validate() {
        return Validated.none().and(Validated.required((String)"property", (Object)this.property)).and(Validated.required((String)"value", (Object)this.value));
    }

    public PropertiesIsoVisitor<ExecutionContext> getVisitor() {
        return new PropertiesIsoVisitor<ExecutionContext>(){

            @Override
            public Properties.File visitFile(Properties.File file, ExecutionContext ctx) {
                Properties p = super.visitFile(file, ctx);
                if (StringUtils.isBlank((String)AddProperty.this.property) || StringUtils.isBlank((String)AddProperty.this.value)) {
                    return p;
                }
                Set<Properties.Entry> properties = FindProperties.find(p, AddProperty.this.property, false);
                if (!properties.isEmpty()) {
                    return p;
                }
                Properties.Value propertyValue = new Properties.Value(Tree.randomId(), "", Markers.EMPTY, AddProperty.this.value);
                Properties.Entry.Delimiter delimitedBy = StringUtils.isNotEmpty((String)AddProperty.this.delimiter) ? Properties.Entry.Delimiter.getDelimiter(AddProperty.this.delimiter) : Properties.Entry.Delimiter.EQUALS;
                String beforeEquals = delimitedBy == Properties.Entry.Delimiter.NONE ? AddProperty.this.delimiter : "";
                Properties.Entry entry = new Properties.Entry(Tree.randomId(), "\n", Markers.EMPTY, AddProperty.this.property, beforeEquals, delimitedBy, propertyValue);
                List contentList = ListUtils.insertInOrder(((Properties.File)p).getContent(), (Object)entry, (o1, o2) -> {
                    if (o1 instanceof Properties.Entry && o2 instanceof Properties.Entry) {
                        return ((Properties.Entry)o1).getKey().compareTo(((Properties.Entry)o2).getKey());
                    }
                    return -1;
                });
                int insertionIndex = contentList.indexOf(entry);
                boolean addingComment = StringUtils.isNotEmpty((String)AddProperty.this.comment);
                contentList = ListUtils.map((List)contentList, (i, it) -> {
                    if ((i == 0 || addingComment) && it == entry) {
                        return (Properties.Content)it.withPrefix("");
                    }
                    if (insertionIndex == 0 && i == 1 && !it.getPrefix().contains("\n")) {
                        return (Properties.Content)it.withPrefix(it.getPrefix() + "\n");
                    }
                    return it;
                });
                if (addingComment) {
                    String commentPrefix = "\n";
                    if (insertionIndex == 0) {
                        commentPrefix = "";
                    }
                    Properties.Comment comment = new Properties.Comment(Tree.randomId(), commentPrefix, Markers.EMPTY, Properties.Comment.Delimiter.HASH_TAG, ' ' + AddProperty.this.comment + '\n');
                    contentList = ListUtils.insert((List)contentList, (Object)comment, (int)insertionIndex);
                }
                p = ((Properties.File)p).withContent(contentList);
                return p;
            }
        };
    }

    public AddProperty(String property, String value, @Nullable String comment, @Nullable String delimiter) {
        this.property = property;
        this.value = value;
        this.comment = comment;
        this.delimiter = delimiter;
    }

    public String getProperty() {
        return this.property;
    }

    public String getValue() {
        return this.value;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Nullable
    public String getDelimiter() {
        return this.delimiter;
    }

    @NonNull
    public String toString() {
        return "AddProperty(property=" + this.getProperty() + ", value=" + this.getValue() + ", comment=" + this.getComment() + ", delimiter=" + this.getDelimiter() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddProperty)) {
            return false;
        }
        AddProperty other = (AddProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$property = this.getProperty();
        String other$property = other.getProperty();
        if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$delimiter = this.getDelimiter();
        String other$delimiter = other.getDelimiter();
        return !(this$delimiter == null ? other$delimiter != null : !this$delimiter.equals(other$delimiter));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $property = this.getProperty();
        result = result * 59 + ($property == null ? 43 : $property.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $delimiter = this.getDelimiter();
        result = result * 59 + ($delimiter == null ? 43 : $delimiter.hashCode());
        return result;
    }
}

