/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.junit.platform.commons.util.StringUtils;
import org.openrewrite.CreateFileVisitor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;

public final class CreatePropertiesFile
extends ScanningRecipe<AtomicBoolean> {
    @Option(displayName="Relative file path", description="File path of new file.", example="foo/bar/baz.properties")
    private final String relativeFileName;
    @Option(displayName="File contents", description="Multiline text content for the file.", example="a.property=value\nanother.property=value", required=false)
    @Nullable
    @Language(value="properties")
    private final String fileContents;
    @Option(displayName="Overwrite existing file", description="If there is an existing file, should it be overwritten.", required=false)
    @Nullable
    private final Boolean overwriteExisting;

    public String getDisplayName() {
        return "Create Properties file";
    }

    public String getDescription() {
        return "Create a new Properties file.";
    }

    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean(true);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(AtomicBoolean shouldCreate) {
        return new CreateFileVisitor(Paths.get(this.relativeFileName, new String[0]), shouldCreate);
    }

    public Collection<SourceFile> generate(AtomicBoolean shouldCreate, ExecutionContext ctx) {
        if (shouldCreate.get()) {
            return PropertiesParser.builder().build().parse(StringUtils.isNotBlank((String)this.fileContents) ? this.fileContents : "").map(brandNewFile -> brandNewFile.withSourcePath(Paths.get(this.relativeFileName, new String[0]))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final AtomicBoolean created) {
        final Path path = Paths.get(this.relativeFileName, new String[0]);
        return new PropertiesVisitor<ExecutionContext>(){

            @Override
            public Properties visitFile(Properties.File file, ExecutionContext executionContext) {
                if ((created.get() || Boolean.TRUE.equals(CreatePropertiesFile.this.overwriteExisting)) && path.equals(file.getSourcePath())) {
                    SourceFile sourceFile;
                    if (StringUtils.isBlank((String)CreatePropertiesFile.this.fileContents)) {
                        return file.withContent(Collections.emptyList());
                    }
                    Optional<SourceFile> sourceFiles = PropertiesParser.builder().build().parse(CreatePropertiesFile.this.fileContents).findFirst();
                    if (sourceFiles.isPresent() && (sourceFile = sourceFiles.get()) instanceof Properties.File) {
                        return file.withContent(((Properties.File)sourceFile).getContent());
                    }
                }
                return file;
            }
        };
    }

    public CreatePropertiesFile(String relativeFileName, @Nullable @Language(value="properties") String fileContents, @Nullable Boolean overwriteExisting) {
        this.relativeFileName = relativeFileName;
        this.fileContents = fileContents;
        this.overwriteExisting = overwriteExisting;
    }

    public String getRelativeFileName() {
        return this.relativeFileName;
    }

    @Nullable
    @Language(value="properties")
    public String getFileContents() {
        return this.fileContents;
    }

    @Nullable
    public Boolean getOverwriteExisting() {
        return this.overwriteExisting;
    }

    @NonNull
    public String toString() {
        return "CreatePropertiesFile(relativeFileName=" + this.getRelativeFileName() + ", fileContents=" + this.getFileContents() + ", overwriteExisting=" + this.getOverwriteExisting() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreatePropertiesFile)) {
            return false;
        }
        CreatePropertiesFile other = (CreatePropertiesFile)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$overwriteExisting = this.getOverwriteExisting();
        Boolean other$overwriteExisting = other.getOverwriteExisting();
        if (this$overwriteExisting == null ? other$overwriteExisting != null : !((Object)this$overwriteExisting).equals(other$overwriteExisting)) {
            return false;
        }
        String this$relativeFileName = this.getRelativeFileName();
        String other$relativeFileName = other.getRelativeFileName();
        if (this$relativeFileName == null ? other$relativeFileName != null : !this$relativeFileName.equals(other$relativeFileName)) {
            return false;
        }
        String this$fileContents = this.getFileContents();
        String other$fileContents = other.getFileContents();
        return !(this$fileContents == null ? other$fileContents != null : !this$fileContents.equals(other$fileContents));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CreatePropertiesFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $overwriteExisting = this.getOverwriteExisting();
        result = result * 59 + ($overwriteExisting == null ? 43 : ((Object)$overwriteExisting).hashCode());
        String $relativeFileName = this.getRelativeFileName();
        result = result * 59 + ($relativeFileName == null ? 43 : $relativeFileName.hashCode());
        String $fileContents = this.getFileContents();
        result = result * 59 + ($fileContents == null ? 43 : $fileContents.hashCode());
        return result;
    }
}

