/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class PropertiesParser
implements Parser {
    public Stream<SourceFile> parse(String ... sources) {
        return this.parse((ExecutionContext)new InMemoryExecutionContext(), sources);
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingEventListener parsingListener = ParsingExecutionContextView.view((ExecutionContext)ctx).getParsingListener();
        return this.acceptedInputs(sourceFiles).map(input -> {
            SourceFile sourceFile;
            block8: {
                Path path = input.getRelativePath(relativeTo);
                EncodingDetectingInputStream is = input.getSource(ctx);
                try {
                    Properties.File file = this.parseFromInput(path, is).withFileAttributes(input.getFileAttributes());
                    parsingListener.parsed(input, (SourceFile)file);
                    sourceFile = this.requirePrintEqualsInput(file, (Parser.Input)input, relativeTo, ctx);
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        ctx.getOnError().accept(t);
                        return ParseError.build((Parser)this, (Parser.Input)input, (Path)relativeTo, (ExecutionContext)ctx, (Throwable)t);
                    }
                }
                is.close();
            }
            return sourceFile;
        });
    }

    private Properties.File parseFromInput(Path sourceFile, EncodingDetectingInputStream source) {
        ArrayList<Properties.Content> contents = new ArrayList<Properties.Content>();
        StringBuilder prefix = new StringBuilder();
        StringBuilder buff = new StringBuilder();
        String s = source.readFully();
        char prev = '$';
        boolean isEscapedNewLine = false;
        for (char c : s.toCharArray()) {
            if (isEscapedNewLine) {
                if (Character.isWhitespace(c)) continue;
                isEscapedNewLine = false;
            }
            if (c == '\n') {
                if (prev == '\\') {
                    isEscapedNewLine = true;
                    buff.deleteCharAt(buff.length() - 1);
                } else {
                    Properties.Content content = this.extractContent(buff.toString(), prefix);
                    if (content != null) {
                        contents.add(content);
                    }
                    buff = new StringBuilder();
                    prefix.append(c);
                }
            } else {
                buff.append(c);
            }
            prev = c;
        }
        Properties.Content content = this.extractContent(buff.toString(), prefix);
        if (content != null) {
            contents.add(content);
        }
        return new Properties.File(Tree.randomId(), "", Markers.EMPTY, sourceFile, contents, prefix.toString(), source.getCharset().name(), source.isCharsetBomMarked(), FileAttributes.fromPath((Path)sourceFile), null);
    }

    @Nullable
    private Properties.Content extractContent(String line, StringBuilder prefix) {
        Properties.Content content = null;
        if (line.trim().startsWith("#") || line.trim().startsWith("!")) {
            Properties.Comment.Delimiter delimiter = line.trim().startsWith("#") ? Properties.Comment.Delimiter.HASH_TAG : Properties.Comment.Delimiter.EXCLAMATION_MARK;
            content = this.commentFromLine(line, prefix.toString(), delimiter);
            prefix.delete(0, prefix.length());
        } else if (line.contains("=") || line.contains(":") || this.isDelimitedByWhitespace(line)) {
            StringBuilder trailingWhitespaceBuffer = new StringBuilder();
            content = this.entryFromLine(line, prefix.toString(), trailingWhitespaceBuffer);
            prefix.delete(0, prefix.length());
            prefix.append((CharSequence)trailingWhitespaceBuffer);
        } else {
            prefix.append(line);
        }
        return content;
    }

    private boolean isDelimitedByWhitespace(String line) {
        return line.length() >= 3 && !Character.isWhitespace(line.charAt(0)) && !Character.isWhitespace(line.length() - 1) && line.contains(" ");
    }

    private Properties.Comment commentFromLine(String line, String prefix, Properties.Comment.Delimiter delimiter) {
        StringBuilder prefixBuilder = new StringBuilder(prefix);
        StringBuilder message = new StringBuilder();
        boolean inComment = false;
        int state = 0;
        block5: for (char c : line.toCharArray()) {
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(c)) {
                        prefixBuilder.append(c);
                        continue block5;
                    }
                    ++state;
                }
                case 1: {
                    if (!(c != '#' && c != '!' || inComment)) {
                        inComment = true;
                        continue block5;
                    }
                    if (!Character.isWhitespace(c)) {
                        message.append(c);
                        continue block5;
                    }
                    ++state;
                }
                case 2: {
                    if (!Character.isWhitespace(c)) {
                        message.append(c);
                        --state;
                        continue block5;
                    }
                    message.append(c);
                }
            }
        }
        return new Properties.Comment(Tree.randomId(), prefixBuilder.toString(), Markers.EMPTY, delimiter, message.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    private Properties.Entry entryFromLine(String line, String prefix, StringBuilder trailingWhitespaceBuffer) {
        StringBuilder prefixBuilder = new StringBuilder(prefix);
        StringBuilder key = new StringBuilder();
        StringBuilder equalsPrefix = new StringBuilder();
        StringBuilder valuePrefix = new StringBuilder();
        StringBuilder value = new StringBuilder();
        Properties.Entry.Delimiter delimiter = Properties.Entry.Delimiter.NONE;
        char prev = '$';
        int state = 0;
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (true) {
            block20: {
                if (n2 >= n) {
                    return new Properties.Entry(Tree.randomId(), prefixBuilder.toString(), Markers.EMPTY, key.toString(), equalsPrefix.toString(), delimiter, new Properties.Value(Tree.randomId(), valuePrefix.toString(), Markers.EMPTY, value.toString()));
                }
                char c = cArray[n2];
                switch (state) {
                    case 0: {
                        if (Character.isWhitespace(c)) {
                            prefixBuilder.append(c);
                            break;
                        }
                        ++state;
                    }
                    case 1: {
                        if (c == '=' || c == ':') {
                            if (prev == '\\') {
                                key.append(c);
                                break;
                            }
                            delimiter = Properties.Entry.Delimiter.getDelimiter(String.valueOf(c));
                            state += 2;
                        } else {
                            if (!Character.isWhitespace(c)) {
                                key.append(c);
                                break;
                            }
                            ++state;
                        }
                    }
                    case 2: {
                        if (Character.isWhitespace(c)) {
                            equalsPrefix.append(c);
                            break;
                        }
                        if (c == '=' || c == ':') {
                            delimiter = Properties.Entry.Delimiter.getDelimiter(String.valueOf(c));
                        }
                        ++state;
                    }
                    case 3: {
                        if (c == 61 || c == ':') break block20;
                        if (Character.isWhitespace(c)) {
                            valuePrefix.append(c);
                            break;
                        }
                        ++state;
                    }
                    case 4: {
                        if (!Character.isWhitespace(c)) {
                            value.append(c);
                            break;
                        }
                        ++state;
                    }
                    case 5: {
                        if (!Character.isWhitespace(c)) {
                            value.append((CharSequence)trailingWhitespaceBuffer);
                            trailingWhitespaceBuffer.delete(0, trailingWhitespaceBuffer.length());
                            value.append(c);
                            --state;
                            break;
                        }
                        trailingWhitespaceBuffer.append(c);
                    }
                }
                prev = c;
            }
            ++n2;
        }
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".properties");
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.properties");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Parser.Builder {
        public Builder() {
            super(Properties.File.class);
        }

        public PropertiesParser build() {
            return new PropertiesParser();
        }

        public String getDslName() {
            return "properties";
        }
    }
}

