/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;

public final class ChangePropertyKey
extends Recipe {
    @Option(displayName="Old property key", example="management.metrics.binders.files.enabled")
    private final String oldPropertyKey;
    @Option(displayName="New property key", example="management.metrics.enable.process.files")
    private final String newPropertyKey;

    public String getDisplayName() {
        return "Change property key";
    }

    public String getDescription() {
        return "Change a property key, leaving the value intact.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ChangePropertyKeyVisitor<ExecutionContext>();
    }

    public ChangePropertyKey(String oldPropertyKey, String newPropertyKey) {
        this.oldPropertyKey = oldPropertyKey;
        this.newPropertyKey = newPropertyKey;
    }

    public String getOldPropertyKey() {
        return this.oldPropertyKey;
    }

    public String getNewPropertyKey() {
        return this.newPropertyKey;
    }

    @NonNull
    public String toString() {
        return "ChangePropertyKey(oldPropertyKey=" + this.getOldPropertyKey() + ", newPropertyKey=" + this.getNewPropertyKey() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePropertyKey)) {
            return false;
        }
        ChangePropertyKey other = (ChangePropertyKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldPropertyKey = this.getOldPropertyKey();
        String other$oldPropertyKey = other.getOldPropertyKey();
        if (this$oldPropertyKey == null ? other$oldPropertyKey != null : !this$oldPropertyKey.equals(other$oldPropertyKey)) {
            return false;
        }
        String this$newPropertyKey = this.getNewPropertyKey();
        String other$newPropertyKey = other.getNewPropertyKey();
        return !(this$newPropertyKey == null ? other$newPropertyKey != null : !this$newPropertyKey.equals(other$newPropertyKey));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePropertyKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldPropertyKey = this.getOldPropertyKey();
        result = result * 59 + ($oldPropertyKey == null ? 43 : $oldPropertyKey.hashCode());
        String $newPropertyKey = this.getNewPropertyKey();
        result = result * 59 + ($newPropertyKey == null ? 43 : $newPropertyKey.hashCode());
        return result;
    }

    public class ChangePropertyKeyVisitor<P>
    extends PropertiesVisitor<P> {
        @Override
        public Properties visitEntry(Properties.Entry entry, P p) {
            if (entry.getKey().equals(ChangePropertyKey.this.oldPropertyKey)) {
                entry = entry.withKey(ChangePropertyKey.this.newPropertyKey).withPrefix(entry.getPrefix());
            }
            return super.visitEntry(entry, p);
        }
    }
}

