/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties;

import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;

public final class ChangePropertyValue
extends Recipe {
    @Option(displayName="Property key", description="The name of the property key whose value is to be changed.", example="management.metrics.binders.files.enabled")
    private final String propertyKey;
    @Option(displayName="New value", description="The new value to be used for key specified by `propertyKey`.", example="false")
    private final String newValue;
    @Option(displayName="Old value", example="true", required=false, description="Only change the property value if it matches the configured `oldValue`.")
    @Nullable
    private final String oldValue;
    @Option(displayName="Use relaxed binding", description="Whether to match the `propertyKey` using [relaxed binding](https://docs.spring.io/spring-boot/docs/2.5.6/reference/html/features.html#features.external-config.typesafe-configuration-properties.relaxed-binding) rules. Default is `true`. Set to `false`  to use exact matching.", required=false)
    @Nullable
    @Incubating(since="7.17.0")
    private final Boolean relaxedBinding;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="'**/application-*.properties'")
    @Nullable
    private final String fileMatcher;

    public String getDisplayName() {
        return "Change property value";
    }

    public String getDescription() {
        return "Change a property value leaving the key intact.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (this.fileMatcher != null) {
            return new HasSourcePath(this.fileMatcher);
        }
        return null;
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ChangePropertyValueVisitor<ExecutionContext>();
    }

    public ChangePropertyValue(String propertyKey, String newValue, @Nullable String oldValue, @Nullable Boolean relaxedBinding, @Nullable String fileMatcher) {
        this.propertyKey = propertyKey;
        this.newValue = newValue;
        this.oldValue = oldValue;
        this.relaxedBinding = relaxedBinding;
        this.fileMatcher = fileMatcher;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public String getNewValue() {
        return this.newValue;
    }

    @Nullable
    public String getOldValue() {
        return this.oldValue;
    }

    @Nullable
    public Boolean getRelaxedBinding() {
        return this.relaxedBinding;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    public String toString() {
        return "ChangePropertyValue(propertyKey=" + this.getPropertyKey() + ", newValue=" + this.getNewValue() + ", oldValue=" + this.getOldValue() + ", relaxedBinding=" + this.getRelaxedBinding() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePropertyValue)) {
            return false;
        }
        ChangePropertyValue other = (ChangePropertyValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$relaxedBinding = this.getRelaxedBinding();
        Boolean other$relaxedBinding = other.getRelaxedBinding();
        if (this$relaxedBinding == null ? other$relaxedBinding != null : !((Object)this$relaxedBinding).equals(other$relaxedBinding)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        if (this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        if (this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue)) {
            return false;
        }
        String this$oldValue = this.getOldValue();
        String other$oldValue = other.getOldValue();
        if (this$oldValue == null ? other$oldValue != null : !this$oldValue.equals(other$oldValue)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePropertyValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $relaxedBinding = this.getRelaxedBinding();
        result = result * 59 + ($relaxedBinding == null ? 43 : ((Object)$relaxedBinding).hashCode());
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        String $oldValue = this.getOldValue();
        result = result * 59 + ($oldValue == null ? 43 : $oldValue.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }

    public class ChangePropertyValueVisitor<P>
    extends PropertiesVisitor<P> {
        @Override
        public Properties visitEntry(Properties.Entry entry, P p) {
            if ((!Boolean.FALSE.equals(ChangePropertyValue.this.relaxedBinding) ? NameCaseConvention.equalsRelaxedBinding((String)entry.getKey(), (String)ChangePropertyValue.this.propertyKey) : entry.getKey().equals(ChangePropertyValue.this.propertyKey)) && (ChangePropertyValue.this.oldValue == null ? !entry.getValue().getText().equals(ChangePropertyValue.this.newValue) : ChangePropertyValue.this.oldValue.equals(entry.getValue().getText()))) {
                entry = entry.withValue(entry.getValue().withText(ChangePropertyValue.this.newValue));
            }
            return super.visitEntry(entry, p);
        }
    }
}

