/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.properties.tree.Properties;

public class PropertiesParser
implements Parser<Properties.File> {
    public List<Properties.File> parse(String ... sources) {
        return this.parse((ExecutionContext)new InMemoryExecutionContext(), sources);
    }

    public List<Properties.File> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        return this.acceptedInputs(sourceFiles).stream().map(sourceFile -> {
            Properties.File file;
            block8: {
                Timer.Builder timer = Timer.builder((String)"rewrite.parse").description("The time spent parsing a properties file").tag("file.type", "Properties");
                Timer.Sample sample = Timer.start();
                InputStream is = sourceFile.getSource();
                try {
                    Properties.File file2 = this.parseFromInput(sourceFile.getRelativePath(relativeTo), is);
                    sample.stop(MetricsHelper.successTags((Timer.Builder)timer).register((MeterRegistry)Metrics.globalRegistry));
                    file = file2;
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        sample.stop(MetricsHelper.errorTags((Timer.Builder)timer, (Throwable)t).register((MeterRegistry)Metrics.globalRegistry));
                        ctx.getOnError().accept(new IllegalStateException(sourceFile.getPath() + " " + t.getMessage(), t));
                        return null;
                    }
                }
                is.close();
            }
            return file;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Properties.File parseFromInput(Path sourceFile, InputStream source) {
        ArrayList<Properties.Content> contents = new ArrayList<Properties.Content>();
        StringBuilder prefix = new StringBuilder();
        StringBuilder buff = new StringBuilder();
        try {
            int b;
            while ((b = source.read()) != -1) {
                char c = (char)b;
                if (c == '\n') {
                    Properties.Content content = this.extractContent(buff.toString(), prefix);
                    if (content != null) {
                        contents.add(content);
                    }
                    buff = new StringBuilder();
                    prefix.append(c);
                    continue;
                }
                buff.append(c);
            }
            Properties.Content content = this.extractContent(buff.toString(), prefix);
            if (content != null) {
                contents.add(content);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new Properties.File(Tree.randomId(), "", Markers.EMPTY, sourceFile, contents, prefix.toString());
    }

    @Nullable
    private Properties.Content extractContent(String line, StringBuilder prefix) {
        Properties.Content content = null;
        if (line.trim().startsWith("#")) {
            content = this.commentFromLine(line, prefix.toString());
            prefix.delete(0, prefix.length());
        } else if (line.contains("=")) {
            StringBuilder trailingWhitespaceBuffer = new StringBuilder();
            content = this.entryFromLine(line, prefix.toString(), trailingWhitespaceBuffer);
            prefix.delete(0, prefix.length());
            prefix.append((CharSequence)trailingWhitespaceBuffer);
        } else {
            prefix.append(line);
        }
        return content;
    }

    private Properties.Comment commentFromLine(String line, String prefix) {
        StringBuilder prefixBuilder = new StringBuilder(prefix);
        StringBuilder message = new StringBuilder();
        int state = 0;
        block5: for (char c : line.toCharArray()) {
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(c)) {
                        prefixBuilder.append(c);
                        continue block5;
                    }
                    ++state;
                }
                case 1: {
                    if (c == '#') continue block5;
                    if (!Character.isWhitespace(c)) {
                        message.append(c);
                        continue block5;
                    }
                    ++state;
                }
                case 2: {
                    if (!Character.isWhitespace(c)) {
                        message.append(c);
                        --state;
                        continue block5;
                    }
                    message.append(c);
                }
            }
        }
        return new Properties.Comment(Tree.randomId(), prefixBuilder.toString(), Markers.EMPTY, message.toString());
    }

    private Properties.Entry entryFromLine(String line, String prefix, StringBuilder trailingWhitespaceBuffer) {
        StringBuilder prefixBuilder = new StringBuilder(prefix);
        StringBuilder key = new StringBuilder();
        StringBuilder equalsPrefix = new StringBuilder();
        StringBuilder valuePrefix = new StringBuilder();
        StringBuilder value = new StringBuilder();
        int state = 0;
        block8: for (char c : line.toCharArray()) {
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(c)) {
                        prefixBuilder.append(c);
                        continue block8;
                    }
                    ++state;
                }
                case 1: {
                    if (c == '=') {
                        state += 2;
                    } else {
                        if (!Character.isWhitespace(c)) {
                            key.append(c);
                            continue block8;
                        }
                        ++state;
                    }
                }
                case 2: {
                    if (Character.isWhitespace(c)) {
                        equalsPrefix.append(c);
                        continue block8;
                    }
                    ++state;
                }
                case 3: {
                    if (c == '=') continue block8;
                    if (Character.isWhitespace(c)) {
                        valuePrefix.append(c);
                        continue block8;
                    }
                    ++state;
                }
                case 4: {
                    if (!Character.isWhitespace(c)) {
                        value.append(c);
                        continue block8;
                    }
                    ++state;
                }
                case 5: {
                    if (!Character.isWhitespace(c)) {
                        value.append((CharSequence)trailingWhitespaceBuffer);
                        trailingWhitespaceBuffer.delete(0, trailingWhitespaceBuffer.length());
                        value.append(c);
                        --state;
                        continue block8;
                    }
                    trailingWhitespaceBuffer.append(c);
                }
            }
        }
        return new Properties.Entry(Tree.randomId(), prefixBuilder.toString(), Markers.EMPTY, key.toString(), equalsPrefix.toString(), new Properties.Value(Tree.randomId(), valuePrefix.toString(), Markers.EMPTY, value.toString()));
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".properties");
    }
}

