/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties;

import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;

public final class DeleteProperty
extends Recipe {
    @Option(displayName="Property key", description="The key to be deleted.", example="management.metrics.binders.files.enabled")
    private final String propertyKey;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/application-*.properties")
    @Nullable
    private final String fileMatcher;

    public String getDisplayName() {
        return "Delete Property";
    }

    public String getDescription() {
        return "Deletes key/value pairs from properties files.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (this.fileMatcher != null) {
            return new HasSourcePath(this.fileMatcher);
        }
        return null;
    }

    protected PropertiesVisitor<ExecutionContext> getVisitor() {
        return new PropertiesVisitor<ExecutionContext>(){

            @Override
            public Properties visitEntry(Properties.Entry entry, ExecutionContext context) {
                if (entry.getKey().equals(DeleteProperty.this.propertyKey)) {
                    return null;
                }
                return super.visitEntry(entry, context);
            }
        };
    }

    public DeleteProperty(String propertyKey, @Nullable String fileMatcher) {
        this.propertyKey = propertyKey;
        this.fileMatcher = fileMatcher;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteProperty)) {
            return false;
        }
        DeleteProperty other = (DeleteProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        if (this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeleteProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "DeleteProperty(propertyKey=" + this.getPropertyKey() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }
}

