/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties.internal;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;

public class PropertiesPrinter<P>
extends PropertiesVisitor<P> {
    private static final String PRINTER_ACC_KEY = "printed";
    private final TreePrinter<P> treePrinter;

    public PropertiesPrinter(TreePrinter<P> treePrinter) {
        this.treePrinter = treePrinter;
    }

    @NonNull
    protected StringBuilder getPrinter() {
        StringBuilder acc = (StringBuilder)this.getCursor().getRoot().getMessage(PRINTER_ACC_KEY);
        if (acc == null) {
            acc = new StringBuilder();
            this.getCursor().getRoot().putMessage(PRINTER_ACC_KEY, (Object)acc);
        }
        return acc;
    }

    public String print(Properties properties, P p) {
        this.setCursor(new Cursor(null, (Object)"EPSILON"));
        this.visit((Tree)properties, (Object)p);
        return this.getPrinter().toString();
    }

    @Nullable
    public Properties visit(@Nullable Tree tree, P p) {
        if (tree == null) {
            return (Properties)this.defaultValue(null, p);
        }
        StringBuilder printer = this.getPrinter();
        this.treePrinter.doBefore(tree, printer, p);
        tree = super.visit(tree, p);
        if (tree != null) {
            this.treePrinter.doAfter(tree, printer, p);
        }
        return (Properties)tree;
    }

    public void visit(@Nullable List<? extends Properties> nodes, P p) {
        if (nodes != null) {
            for (Properties properties : nodes) {
                this.visit((Tree)properties, (Object)p);
            }
        }
    }

    @Override
    public Properties visitFile(Properties.File file, P p) {
        StringBuilder acc = this.getPrinter();
        acc.append(file.getPrefix());
        this.visit(file.getContent(), p);
        acc.append(file.getEof());
        return file;
    }

    @Override
    public Properties visitEntry(Properties.Entry entry, P p) {
        StringBuilder acc = this.getPrinter();
        acc.append(entry.getPrefix()).append(entry.getKey()).append(entry.getBeforeEquals()).append('=').append(entry.getValue().getPrefix()).append(entry.getValue().getText());
        return entry;
    }

    @Override
    public Properties visitComment(Properties.Comment comment, P p) {
        StringBuilder acc = this.getPrinter();
        acc.append(comment.getPrefix()).append('#').append(comment.getMessage());
        return comment;
    }

    public <M extends Marker> M visitMarker(Marker marker, P p) {
        StringBuilder acc = this.getPrinter();
        this.treePrinter.doBefore((Tree)marker, acc, p);
        acc.append(marker.print(this.treePrinter, p));
        this.treePrinter.doAfter((Tree)marker, acc, p);
        return (M)marker;
    }

    public Markers visitMarkers(Markers markers, P p) {
        StringBuilder acc = this.getPrinter();
        this.treePrinter.doBefore((Tree)markers, acc, p);
        Markers m = super.visitMarkers(markers, p);
        this.treePrinter.doAfter((Tree)markers, acc, p);
        return m;
    }
}

